/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportReceiver;
import org.apache.qpid.proton.engine.impl.TransportSender;

class TransportLink<T extends LinkImpl> {
    private UnsignedInteger _localHandle;
    private String _name;
    private UnsignedInteger _remoteHandle;
    private UnsignedInteger _deliveryCount;
    private UnsignedInteger _linkCredit = UnsignedInteger.ZERO;
    private T _link;
    private UnsignedInteger _remoteDeliveryCount;
    private UnsignedInteger _remoteLinkCredit;
    private boolean _detachReceived;
    private boolean _attachSent;
    private boolean _detachSent;

    protected TransportLink(T link) {
        this._link = link;
        this._name = ((LinkImpl)link).getName();
    }

    static <L extends LinkImpl> TransportLink<L> createTransportLink(L link) {
        if (link instanceof ReceiverImpl) {
            ReceiverImpl r = (ReceiverImpl)link;
            TransportReceiver tr = new TransportReceiver(r);
            r.setTransportLink(tr);
            return tr;
        }
        SenderImpl s = (SenderImpl)link;
        TransportSender ts = new TransportSender(s);
        s.setTransportLink(ts);
        return ts;
    }

    void unbind() {
        this.clearLocalHandle();
        this.clearRemoteHandle();
    }

    public UnsignedInteger getLocalHandle() {
        return this._localHandle;
    }

    public void setLocalHandle(UnsignedInteger localHandle) {
        if (this._localHandle == null) {
            ((EndpointImpl)this._link).incref();
        }
        this._localHandle = localHandle;
    }

    public boolean isLocalHandleSet() {
        return this._localHandle != null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void clearLocalHandle() {
        if (this._localHandle != null) {
            ((EndpointImpl)this._link).decref();
        }
        this._localHandle = null;
    }

    public UnsignedInteger getRemoteHandle() {
        return this._remoteHandle;
    }

    public void setRemoteHandle(UnsignedInteger remoteHandle) {
        if (this._remoteHandle == null) {
            ((EndpointImpl)this._link).incref();
        }
        this._remoteHandle = remoteHandle;
    }

    public void clearRemoteHandle() {
        if (this._remoteHandle != null) {
            ((EndpointImpl)this._link).decref();
        }
        this._remoteHandle = null;
    }

    public UnsignedInteger getDeliveryCount() {
        return this._deliveryCount;
    }

    public UnsignedInteger getLinkCredit() {
        return this._linkCredit;
    }

    public void addCredit(int credits) {
        this._linkCredit = UnsignedInteger.valueOf(this._linkCredit.intValue() + credits);
    }

    public boolean hasCredit() {
        return this.getLinkCredit().compareTo(UnsignedInteger.ZERO) > 0;
    }

    public T getLink() {
        return this._link;
    }

    void handleFlow(Flow flow) {
        this._remoteDeliveryCount = flow.getDeliveryCount();
        this._remoteLinkCredit = flow.getLinkCredit();
        ((LinkImpl)this._link).getConnectionImpl().put(Event.Type.LINK_FLOW, this._link);
    }

    void setLinkCredit(UnsignedInteger linkCredit) {
        this._linkCredit = linkCredit;
    }

    public void setDeliveryCount(UnsignedInteger deliveryCount) {
        this._deliveryCount = deliveryCount;
    }

    public void settled(TransportDelivery transportDelivery) {
        ((LinkImpl)this.getLink()).getSession().getTransportSession().settled(transportDelivery);
    }

    UnsignedInteger getRemoteDeliveryCount() {
        return this._remoteDeliveryCount;
    }

    UnsignedInteger getRemoteLinkCredit() {
        return this._remoteLinkCredit;
    }

    public void setRemoteLinkCredit(UnsignedInteger remoteLinkCredit) {
        this._remoteLinkCredit = remoteLinkCredit;
    }

    void decrementLinkCredit() {
        this._linkCredit = this._linkCredit.subtract(UnsignedInteger.ONE);
    }

    void incrementDeliveryCount() {
        this._deliveryCount = this._deliveryCount.add(UnsignedInteger.ONE);
    }

    public void receivedDetach() {
        this._detachReceived = true;
    }

    public boolean detachReceived() {
        return this._detachReceived;
    }

    public boolean attachSent() {
        return this._attachSent;
    }

    public void sentAttach() {
        this._attachSent = true;
    }

    public void setRemoteDeliveryCount(UnsignedInteger remoteDeliveryCount) {
        this._remoteDeliveryCount = remoteDeliveryCount;
    }

    public boolean detachSent() {
        return this._detachSent;
    }

    public void sentDetach() {
        this._detachSent = true;
    }
}

