/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiskUsage {
    private static final Logger log = LoggerFactory.getLogger(TableDiskUsage.class);
    private int nextInternalId = 0;
    private final Map<TableId, Integer> internalIds = new HashMap<TableId, Integer>();
    private final Map<Integer, TableId> externalIds = new HashMap<Integer, TableId>();
    private final Map<String, Integer[]> tableFiles = new HashMap<String, Integer[]>();
    private final Map<String, Long> fileSizes = new HashMap<String, Long>();

    void addTable(TableId tableId) {
        if (this.internalIds.containsKey(tableId)) {
            throw new IllegalArgumentException("Already added table " + String.valueOf(tableId));
        }
        int iid = this.nextInternalId++;
        this.internalIds.put(tableId, iid);
        this.externalIds.put(iid, tableId);
    }

    void linkFileAndTable(TableId tableId, String file) {
        int internalId = this.internalIds.get(tableId);
        Integer[] tables = this.tableFiles.get(file);
        if (tables == null) {
            tables = new Integer[this.internalIds.size()];
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = 0;
            }
            this.tableFiles.put(file, tables);
        }
        tables[internalId] = 1;
    }

    void addFileSize(String file, long size) {
        this.fileSizes.put(file, size);
    }

    Map<List<TableId>, Long> calculateUsage() {
        HashMap<List<Integer>, Long> usage = new HashMap<List<Integer>, Long>();
        if (log.isTraceEnabled()) {
            log.trace("fileSizes {}", this.fileSizes);
        }
        for (Map.Entry<String, Integer[]> entry : this.tableFiles.entrySet()) {
            if (log.isTraceEnabled()) {
                log.trace("file {} table bitset {}", (Object)entry.getKey(), (Object)Arrays.toString((Object[])entry.getValue()));
            }
            List<Integer> key = Arrays.asList(entry.getValue());
            Long size = this.fileSizes.get(entry.getKey());
            Long tablesUsage = (Long)usage.get(key);
            if (tablesUsage == null) {
                tablesUsage = 0L;
            }
            tablesUsage = tablesUsage + size;
            usage.put(key, tablesUsage);
        }
        HashMap<List<TableId>, Long> externalUsage = new HashMap<List<TableId>, Long>();
        for (Map.Entry entry : usage.entrySet()) {
            ArrayList<TableId> externalKey = new ArrayList<TableId>();
            List key = (List)entry.getKey();
            for (int i = 0; i < key.size(); ++i) {
                if ((Integer)key.get(i) == 0) continue;
                externalKey.add(this.externalIds.get(i));
            }
            externalUsage.put(externalKey, (Long)entry.getValue());
        }
        return externalUsage;
    }

    public static void printDiskUsage(Collection<String> tableNames, AccumuloClient client, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage.printDiskUsage(tableNames, client, System.out::println, humanReadable);
    }

    public static Map<SortedSet<String>, Long> getDiskUsage(Set<TableId> tableIds, AccumuloClient client) throws TableNotFoundException {
        TableDiskUsage tdu = new TableDiskUsage();
        for (TableId tableId : tableIds) {
            tdu.addTable(tableId);
        }
        HashSet<TableId> emptyTableIds = new HashSet<TableId>();
        for (TableId tableId : tableIds) {
            TabletsMetadata tabletsMetadata = ((ClientContext)client).getAmple().readTablets().forTable(tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();
            try {
                HashSet<StoredTabletFile> allFiles = new HashSet<StoredTabletFile>();
                for (TabletMetadata tm : tabletsMetadata) {
                    Map tmFiles = tm.getFilesMap();
                    for (Map.Entry file : tmFiles.entrySet()) {
                        StoredTabletFile stf = (StoredTabletFile)file.getKey();
                        DataFileValue dataFileValue = (DataFileValue)file.getValue();
                        TableId fileTableRef = stf.getTableId();
                        if (!fileTableRef.equals((Object)tableId) && tableIds.contains(fileTableRef)) {
                            tdu.linkFileAndTable(fileTableRef, stf.getFileName());
                        }
                        tdu.linkFileAndTable(tableId, stf.getFileName());
                        if (!allFiles.add(stf)) continue;
                        tdu.addFileSize(stf.getFileName(), dataFileValue.getSize());
                    }
                }
                if (!allFiles.isEmpty()) continue;
                emptyTableIds.add(tableId);
            }
            finally {
                if (tabletsMetadata == null) continue;
                tabletsMetadata.close();
            }
        }
        return TableDiskUsage.buildSharedUsageMap(tdu, (ClientContext)client, emptyTableIds);
    }

    protected static Map<SortedSet<String>, Long> buildSharedUsageMap(TableDiskUsage tdu, ClientContext clientContext, Set<TableId> emptyTableIds) {
        Map reverseTableIdMap = clientContext.getTableIdToNameMap();
        TreeMap<SortedSet<String>, Long> usage = new TreeMap<SortedSet<String>, Long>((o1, o2) -> {
            int len1 = o1.size();
            int len2 = o2.size();
            int min = Math.min(len1, len2);
            Iterator iter1 = o1.iterator();
            Iterator iter2 = o2.iterator();
            for (int count = 0; count < min; ++count) {
                String s2;
                String s1 = (String)iter1.next();
                int cmp = s1.compareTo(s2 = (String)iter2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            return len1 - len2;
        });
        for (Map.Entry<List<TableId>, Long> entry : tdu.calculateUsage().entrySet()) {
            TreeSet<String> tableNames = new TreeSet<String>();
            for (TableId tableId : entry.getKey()) {
                tableNames.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(tableNames, entry.getValue());
        }
        if (!emptyTableIds.isEmpty()) {
            TreeSet<String> emptyTables = new TreeSet<String>();
            for (TableId tableId : emptyTableIds) {
                emptyTables.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(emptyTables, 0L);
        }
        return usage;
    }

    public static void printDiskUsage(Collection<String> tableNames, AccumuloClient client, Printer printer, boolean humanReadable) throws TableNotFoundException, IOException {
        HashSet<TableId> tableIds = new HashSet<TableId>();
        for (String tableName : tableNames) {
            TableId tableId = ((ClientContext)client).getTableId(tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, "Table " + tableName + " not found");
            }
            tableIds.add(tableId);
        }
        Map<SortedSet<String>, Long> usage = TableDiskUsage.getDiskUsage(tableIds, client);
        String valueFormat = humanReadable ? "%9s" : "%,24d";
        for (Map.Entry<SortedSet<String>, Long> entry : usage.entrySet()) {
            Long value = humanReadable ? NumUtil.bigNumberForSize((long)entry.getValue()) : entry.getValue();
            printer.print(String.format(valueFormat + " %s", value, entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(TableDiskUsage.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(TableDiskUsage.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
                TableDiskUsage.printDiskUsage(opts.tables, client, false);
            }
            finally {
                span.end();
            }
        }
    }

    public static interface Printer {
        public void print(String var1);
    }

    static class Opts
    extends ServerUtilOpts {
        @Parameter(description=" <table> { <table> ... } ")
        List<String> tables = new ArrayList<String>();

        Opts() {
        }
    }
}

