/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.accumulo.core.spi.scan.ScanDispatch;

class ScanDispatchImpl
implements ScanDispatch,
ScanDispatch.Builder {
    private boolean built = false;
    private String executorName = "default";
    private ScanDispatch.CacheUsage indexCacheUsage = ScanDispatch.CacheUsage.TABLE;
    private ScanDispatch.CacheUsage dataCacheUsage = ScanDispatch.CacheUsage.TABLE;

    ScanDispatchImpl() {
    }

    @Override
    public String getExecutorName() {
        Preconditions.checkState((boolean)this.built);
        return this.executorName;
    }

    @Override
    public ScanDispatch.Builder setExecutorName(String name) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.executorName = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public ScanDispatch build() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.built = true;
        return this;
    }

    @Override
    public ScanDispatch.Builder setIndexCacheUsage(ScanDispatch.CacheUsage usage) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.indexCacheUsage = Objects.requireNonNull(usage);
        return this;
    }

    @Override
    public ScanDispatch.Builder setDataCacheUsage(ScanDispatch.CacheUsage usage) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.dataCacheUsage = Objects.requireNonNull(usage);
        return this;
    }

    @Override
    public ScanDispatch.CacheUsage getDataCacheUsage() {
        Preconditions.checkState((boolean)this.built);
        return this.dataCacheUsage;
    }

    @Override
    public ScanDispatch.CacheUsage getIndexCacheUsage() {
        Preconditions.checkState((boolean)this.built);
        return this.indexCacheUsage;
    }

    public String toString() {
        return "{executorName=" + this.executorName + ", indexCacheUsage=" + String.valueOf((Object)this.indexCacheUsage) + ", dataCacheUsage=" + String.valueOf((Object)this.dataCacheUsage) + ", built=" + this.built + "}";
    }
}

