/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.WritableUtils;

public class PasswordToken
implements AuthenticationToken {
    private byte[] password = null;

    public byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public PasswordToken() {
        this.password = new byte[0];
    }

    public PasswordToken(CharSequence password) {
        this.setPassword(CharBuffer.wrap(password));
    }

    public PasswordToken(byte[] password) {
        this.password = Arrays.copyOf(password, password.length);
    }

    public PasswordToken(ByteBuffer password) {
        this.password = ByteBufferUtil.toBytes(password);
    }

    public void readFields(DataInput arg0) throws IOException {
        int version = arg0.readInt();
        if (version == -1) {
            this.password = null;
        } else if (version == -2) {
            byte[] passwordTmp = new byte[arg0.readInt()];
            arg0.readFully(passwordTmp);
            this.password = passwordTmp;
        } else {
            AtomicBoolean calledFirstReadInt = new AtomicBoolean(false);
            DataInput wrapped = (DataInput)Proxy.newProxyInstance(DataInput.class.getClassLoader(), arg0.getClass().getInterfaces(), (obj, method, args) -> {
                if (!calledFirstReadInt.get() && method.getName().equals("readInt")) {
                    calledFirstReadInt.set(true);
                    return version;
                }
                try {
                    return method.invoke((Object)arg0, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
            this.password = WritableUtils.readCompressedByteArray((DataInput)wrapped);
        }
    }

    public void write(DataOutput arg0) throws IOException {
        if (this.password == null) {
            arg0.writeInt(-1);
            return;
        }
        arg0.writeInt(-2);
        arg0.writeInt(this.password.length);
        arg0.write(this.password);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Arrays.fill(this.password, (byte)0);
        this.password = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.password == null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.password);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.password, ((PasswordToken)obj).password);
    }

    @Override
    public PasswordToken clone() {
        try {
            PasswordToken clone = (PasswordToken)super.clone();
            clone.password = Arrays.copyOf(this.password, this.password.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setPassword(byte[] password) {
        this.password = Arrays.copyOf(password, password.length);
    }

    protected void setPassword(CharBuffer charBuffer) {
        ByteBuffer bb = StandardCharsets.UTF_8.encode(charBuffer);
        this.password = new byte[bb.remaining()];
        bb.get(this.password);
        if (!bb.isReadOnly()) {
            bb.rewind();
            while (bb.remaining() > 0) {
                bb.put((byte)0);
            }
        }
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
        if (!properties.containsKey("password")) {
            throw new IllegalArgumentException("Missing 'password' property");
        }
        this.setPassword(CharBuffer.wrap(properties.get("password")));
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        LinkedHashSet<AuthenticationToken.TokenProperty> internal = new LinkedHashSet<AuthenticationToken.TokenProperty>();
        internal.add(new AuthenticationToken.TokenProperty("password", "the password for the principal", true));
        return internal;
    }
}

