/****************************************************************
 * This software is Copyright (C) 1986-1998 by                  *
 *                                                              *
 * F6FBB - Jean-Paul ROUBELAT,  jpr@f6fbb.org                   *
 * 6, rue George Sand                                           *
 * 31120 - Roquettes - France                                   *
 *                                                              *
 * License to copy and use this software is granted for         *
 * non-commercial use provided that it is identified as         *
 *                                                              *
 * "FBB packet-radio BBS software by Jean-Paul ROUBELAT, F6FBB" *
 *                                                              *
 * in all material mentioning or referencing this software      *
 * or this function.                                            *
 *                                                              *
 * These notices must be retained in any copies of any part of  *
 * this documentation and/or software.                          *
 *                                                              *
 * Parts of code have been taken from many other softwares.     *
 * Thanks for the help.                                         *
 ****************************************************************/

#include <serv.h>
#undef fopen

/*
 * Writes an error message in ERROR.SYS file
 *
 * Do not Overlay !
 *
 */

static int error_type = 0;
static int erreur = 0;

void boot_prg (void)
{
	FILE *fichier;

	if ((fichier = fopen ("ERROR.SYS", "a+")) != NULL)
	{
#ifdef ENGLISH
		fprintf (fichier, "> *** System boot on %s *** \n", strdate (time (NULL)));
#else
		fprintf (fichier, "> *** Boot systeme le %s ***\n", strdate (time (NULL)));
#endif
		fclose (fichier);
	}
}

void err_alloc (unsigned numero)
{
	fbb_error (ERR_MEMORY, "malloc", numero);
}

static void fbb_w (unsigned type, char *texte, unsigned numero)
{
	FILE *fichier;
	int nbfiles = 0;

	static char *type_error[] =
	{
		"WARNING :",
		"FATAL   :",
		"EXCEPTION :",
	};

	static char *text_error[] =
	{
		"Cannot open file",
		"Cannot create file",
		"Cannot close file",
		"Cannot resynchronize TNC",
		"Not enough memory",
		"Wrong channel selection",
		"Wrong procedure level",
		"Cannot write to file",
		"Syntax error",
		"Error communication/TNC",
		"Pointer already allocated",
		"XMS/EMS error",
		"Divide by zero",
		"Memory exception",
	};

	if (error_type == 1)
		nbfiles = fbb_fcloseall ();

	if ((fichier = fopen ("ERROR.SYS", "a+")) != NULL)
	{
#ifdef BETA
		fprintf (fichier, "> %s Station %s, Ch:%d (%d-%d-%d) %s\n  Version %d.%d%c%d (%s)\n",
				 type_error[error_type], pvoie->sta.indicatif.call,
				 voiecur, pvoie->niv1, pvoie->niv2, pvoie->niv3,
			  strdate (time (NULL)), MAJEUR, MINEUR, LETTRE, BETA, date ());
#else
		fprintf (fichier, "> %s Station %s, Ch:%d (%d-%d-%d) %s\n  Version %d.%d%c (%s)\n",
				 type_error[error_type], pvoie->sta.indicatif.call,
				 voiecur, pvoie->niv1, pvoie->niv2, pvoie->niv3,
				 strdate (time (NULL)), MAJEUR, MINEUR, LETTRE, date ());
#endif
		if (error_type == 1)
			fprintf (fichier, "  %d open files\n", nbfiles);
		fbb_printfiles (fichier);
		fprintf (fichier, "  %s %u, errno %d=%s  %s\n\n",
				 texte, numero, erreur, strerror (erreur), text_error[type]);
/*
   #if FBB_DEBUG
   fbb_printfiles(fichier);
   if (error_type)
   {
   print_stack(numero, fichier);
   }
   #endif
 */
		fclose (fichier);
	}
}

void fbb_error (unsigned type, char *texte, unsigned numero)
{
	erreur = errno;

	error_type = 2;
	fbb_w (type, texte, numero);
	port_log (0, 0, 'S', "Q *** BBS Quit");
	ferme_log ();
#ifdef __WINDOWS__
	fbb_quit (10);
#else
	sleep (5);
	exit (10);
#endif
}

void fbb_except (unsigned type, char *texte, unsigned numero)
{
	erreur = errno;

	error_type = 1;
	port_log (0, 0, 'S', "Q *** BBS Quit");
	fbb_w (type, texte, numero);
	ferme_log ();
}

void fbb_warning (unsigned type, char *texte, unsigned numero)
{
	erreur = errno;

	error_type = 0;
	fbb_w (type, texte, numero);
}

void win_message (int temps, char *texte)
{
#ifdef __WINDOWS__
	WinMessage (temps, texte);
#endif
#ifdef __LINUX__
	WinMessage (temps, texte);
#endif
#ifdef __FBBDOS__
	fen *fen_ptr;

	deb_io ();
	fen_ptr = open_win (15, 7, 15 + strlen (texte) + 3, 9, INIT, "message");
	_wscroll = 0;
	cputs (texte);
	putch ('\a');
	_wscroll = 1;
	sleep_ (temps);
	close_win (fen_ptr);
	fin_io ();
#endif
}

void write_error (char *filename)
{
	int i;
	char text[256];

	sprintf (text, "Cannot access to %s", filename);

	for (i = 0; i < 5; i++)
	{
		deb_io ();
		win_message (2, text);
#ifdef __FBBDOS__
		putch ('\a');
#endif
		fin_io ();
	}
	fbb_error (ERR_WRITE, filename, 0);
}
