
/******************************************************
 *                                                    *
 * FPAC project.            FPAC PAD                  *
 *                                                    *
 * Parts of code from different sources of ax25-utils *
 *                                                    *
 * F6FBB 05-1997                                      *
 *                                                    *
 ******************************************************/

/******************************************************
 * 12/05/97 1.00 F6FBB First draft !
 *
 ******************************************************/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <linux/ax25.h>
#include <linux/rose.h>

#include "axutils.h"
#include "axconfig.h"
#include "wp.h"

int cr = 0;

/*** Prototypes *******************/
static int strmatch (char *chaine, char *masque);
static char *my_date(time_t date);

#define CR() printf( (cr) ? "\r" : "\n"); 

int main(int ac, char **av)
{
	int i;
	int p;
	int limit = -1;
	int first = 1;
	FILE *fptr;
	wp_t wp;
	wp_header wph;
	char call[20];
	char *full_call;
	char *ptr;
	char *match;

	while ((p = getopt(ac, av, "cl:")) != -1) 
	{
		switch (p)
		{
		case 'c' :
			cr = 1;
			break;
		case 'l' :
			limit = atoi(optarg);
			break;
		case '?' :
			fprintf(stderr, "usage: wpserv [-c] [-l n] [mask]\n");
			return(1);
		}
	}

	if (optind == ac)
		match = strdup("*");
	else
		match = av[optind];

	fptr = fopen(FPACWP, "r");
	if (fptr == NULL)
	{
		printf("No WP found"); CR();
		return(0);
	}

	if (fread(&wph, sizeof(wph), 1, fptr) == 0)
	{
		fclose(fptr);
		return(0);
	}

	/* Check the first record for compatibility */
	if (strcmp(wph.signature,FILE_SIGNATURE) != 0)
	{
		fprintf(stderr, "WP file is not compatible\n");
		fclose(fptr);
		return(0);
	}

	printf("%d records in database", wph.nb_record);
	CR();

	if ((ptr = strrchr(match, '-')) != NULL)
		*ptr = '\0';

	while (fread(&wp, sizeof(wp_t), 1, fptr))
	{
		full_call = ax2asc(&wp.address.srose_call);
		if (*full_call == '\0')
			continue;
		strcpy(call, full_call);
		if ((ptr = strrchr(call, '-')) != NULL)
			*ptr = '\0';

		if (strmatch(call, match))
		{
			char *add = rose2asc(&wp.address.srose_addr);
			char dnic[5];

			if (limit-- == 0)
			{
				printf("More...");
				CR();
				break;
			}

			if (first)
			{
				first = 0;
				printf("Callsign  Last update       DNIC address digis"); 
				CR();
			}
			strncpy(dnic, add, 4); dnic[4] = '\0';

			printf("%-9s %s => %s %-7s", 
				full_call,
				my_date(wp.date),
				dnic, 
				add+4);
			for (i = 0 ; i < wp.address.srose_ndigis ; i++)
			{
				if (i > 1)
					break;
				printf("%s", ax2asc(&wp.address.srose_digi));
			}
			printf(" %s %s", wp.name, wp.city);
			CR();	
		}
	}

	if (first)
	{
		printf("None found");
		CR();
	}

	printf("-- ");
	CR();

	fclose(fptr);
	return(0);
}

static int strmatch (char *chaine, char *masque)
{
	while (1)
	{
		switch (*masque)
		{
		case '\0':
			return (toupper(*masque) == toupper(*chaine));
		case '&':
			if ((*chaine == '\0') || (*chaine == '.'))
				return (1);
			break;
		case '?':
			if (!isalnum (*chaine))
				return (0);
			break;
		case '#':
			if ((*chaine != '#') && (!isdigit (*chaine)))
				return (0);
			break;
		case '@':
			if (!isalpha (*chaine))
				return (0);
			break;
		case '=':
			if (!isgraph (*chaine))
				return (0);
			break;
		case '*':
			while (*++masque == '*')
				;
			if (*masque == '\0')
				return (1);
			while (!strmatch (chaine, masque))
				if (*++chaine == '\0')
					return (0);
			break;
		default:
			if ((toupper (*chaine)) != (toupper (*masque)))
				return (0);
			break;
		}
		++chaine;
		++masque;
	}
}

static char *my_date(time_t date)
{
	static char buf[20];
	struct tm *sdate;

	sdate = localtime (&date);
	sprintf(buf, "%02d/%02d/%02d %02d:%02d", 
		sdate->tm_mday,
		sdate->tm_mon + 1, 
		sdate->tm_year%100,
		sdate->tm_hour,
		sdate->tm_min);
	return(buf);
}
