
/*
   get.c - get data from Yaesu FT-50

   Copyright (c) 1997 Riku Kalinen, OH2LWO, oh2lwo@sral.fi

   RCS $Header: /home/mole/riku/CVS/yaesu/ft50get.c,v 1.2 1997/12/11 15:01:49 riku Exp $

   */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "yaesu.h"

int main (int argc, char *argv[])
{
  int fd, fd_read, fd_write, ret;
  unsigned char b1[10], b2[17], b3[113], b4[17], b5[17], b6[1777], b7[1777];
  unsigned char b8[2];
  unsigned char cksum;
  char *device;
  char buf[4096];

  if (argc != 3) {
    printf ("Usage: get <device> <outfile>\n");
    exit (1);
  }

  device = argv[1];

  fd = open (argv[2], O_WRONLY | O_CREAT | O_TRUNC, 0666);
  if (fd < 0) {
    perror (argv[2]);
    exit (1);
  }

  fd_read = open (device, O_RDONLY);
  if (fd_read < 0) {
    perror (device);
    printf ("opening %s for reading failed\n", device);
    exit (1);
  }
  fd_write = open (device, O_WRONLY);
  if (fd_write < 0) {
    perror (device);
    printf ("opening %s for write failed\n", device);
    exit (1);
  }

  sprintf (buf, "stty 9600 -parenb cs8 -hupcl -cstopb cread clocal -crtscts ignbrk -brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl -ixon -ixoff -iuclc -ixany -imaxbel -opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill nl0 cr0 tab0 bs0 vt0 ff0 -isig -icanon -iexten -echo -echoe -echok -echonl -noflsh -xcase -tostop -echoprt -echoctl -echoke min 1 time 0 < %s > %s", device, device);
  system (buf);
  
  printf ("Ensure that the radio is in CLON mode and press PTT.\n\n");

  printf ("Reading %d bytes..", sizeof (b1)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b1, sizeof (b1), sizeof (b1))) != sizeof (b1)) {
    perror ("read b1");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b1 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b2)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b2, sizeof (b2), sizeof (b2))) != sizeof (b2)) {
    perror ("read b2");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b2 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b3)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b3, sizeof (b3), sizeof (b3))) != sizeof (b3)) {
    perror ("read b3");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b3 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b4)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b4, sizeof (b4), sizeof (b4))) != sizeof (b4)) {
    perror ("read b4");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b4 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b5)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b5, sizeof (b5), sizeof (b5))) != sizeof (b5)) {
    perror ("read b5");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b5 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b6)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b6, sizeof (b6), sizeof (b6))) != sizeof (b6)) {
    perror ("repeat_read b6");
    printf ("repeat_read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b6 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b7)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b7, sizeof (b7), sizeof (b7))) != sizeof (b7)) {
    perror ("repeat_read b7");
    printf ("repeat_read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");
  if (write (fd_write, "\006", 1) != 1) {
    perror ("write b7 ack");
    exit (1);
  }

  printf ("Reading %d bytes..", sizeof (b8)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b8, sizeof (b8), sizeof (b8))) != sizeof (b8)) {
    perror ("read b8");
    printf ("read returned %d\n", ret);
  }
  printf ("ok.\n");

  close (fd_read);
  close (fd_write);

  printf ("\nVerifying checksum.."); fflush (stdout);
  cksum = calculate_cksum (b1, b2+1, b3+1, b4+1, b5+1, b6+1, b7+1);
  if (cksum == b8[1]) {
    printf ("ok. (%02x)\n", cksum);
  } else {
    printf ("FAIL! Calculated checksum = %02x, checksum from data = %02x .\n",
	    cksum, b8[1]);
    printf ("WARNING: Data may be unusable!\n");
  }

  printf ("\nWriting out %d bytes..",
	  sizeof (b1) + sizeof (b2) + sizeof (b3) + sizeof (b4) + sizeof (b5)
	  + sizeof (b6) + sizeof (b7) + sizeof (b8) - 7); fflush (stdout);

  ret = write_save_file (fd, b1, b2+1, b3+1, b4+1, b5+1, b6+1, b7+1, b8+1);

  if (ret != 0) {
    perror ("write_save_file");
    printf ("WARNING: Data may be unusable!\n");
    exit (1);
  }
 
  close (fd);

  printf ("ok.\n");
  
  exit (0);

}
