/*
	ftl0.h

	FTL0 header file defines

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk
*/

#define PID_FILE	0xBB
#define PID_DIRECTORY	0xBD

typedef struct
{
  char fFlag			__attribute__ ((packed));
  unsigned fileId		__attribute__ ((packed));
  char nFileType		__attribute__ ((packed));
  unsigned short wOffset	__attribute__ ((packed));
  unsigned char nOffsetHigh	__attribute__ ((packed));
}
FILEHEADER;

typedef struct
{
  char flags			__attribute__ ((packed));
  unsigned fileId		__attribute__ ((packed));
  unsigned offset		__attribute__ ((packed));
  unsigned tOld			__attribute__ ((packed));
  unsigned tNew			__attribute__ ((packed));
}
DIRHEADER;

#define VERSION      0
#define VERSIONFLAG  0x0C
#define LENGTHFLAG   0x01
#define LASTBYTEFLAG 0x20
#define OFFSETFLAG   0x02

#define PFHBROADCAST    0x00
#define TYPEFLAG        0x03
#define NEWESTFLAG	0x40

typedef struct
{	
	unsigned char flags		__attribute__ ((packed));
	unsigned long fileId		__attribute__ ((packed));
	short blockSize			__attribute__ ((packed));
}
REQUESTHEADER;

typedef struct
{
	unsigned short offset		__attribute__ ((packed));
	unsigned char offset_msb	__attribute__ ((packed));
	unsigned short length		__attribute__ ((packed));
}
HOLEPAIR;


typedef struct
{
	unsigned startTime		__attribute__ ((packed));
	unsigned endTime		__attribute__ ((packed));
}
DIRHOLEPAIR;

typedef struct
{
	unsigned char flags		__attribute__ ((packed));
	short blockSize			__attribute__ ((packed));
}
DIRREQUESTHEADER;


/*
 *	connected protocols - UPLOAD only defined
 */

typedef enum
{
	DATA,				/* 0 */
	DATA_END,
	LOGIN_RESP,
	UPLOAD_CMD,
	UL_GO_RESP,
	UL_ERROR_RESP,			/* 5 */
	UL_ACK_RESP,
	UL_NAK_RESP			/* 7 */
}
PACKET_TYPE;

typedef enum
{
	ER_NONE,			/* 0 */
	ER_ILL_FORMED_CMD,
	ER_BAD_CONTINUE,
	ER_SERVER_FSYS,
	ER_NO_SUCH_FILE_NUMBER,
	ER_SELECTION_EMPTY_1,		/* 5 */
	ER_MANDATORY_FIELD_MISSING,
	ER_NO_PFH,
	ER_POORLY_FORMED_SEL,
	ER_ALREADY_LOCKED,
	ER_NO_SUCH_DESTINATION,		/* 10 */
	ER_SELECTION_EMPTY_2,
	ER_FILE_COMPLETE,
	ER_NO_ROOM,
	ER_BAD_HEADER,
	ER_HEADER_CHECK,		/* 15 */
	ER_BODY_CHECK			/* 16 */
}
ERROR_CODES;

typedef struct
{
	unsigned long file;
	unsigned long length;
}
UPLOAD_REQUEST;

typedef struct
{
	unsigned long file;
	unsigned long offset;
}
UPLOAD_RESPONSE;
