/* the structures used for area statistics */

struct area_data	{

	char 	*name;			/* area name - from areas & areas.sys files */
	struct area_data *next;		/* next in linked list */

	/* there are two 2 element arrays used:
	   xxx[0] is msgs listed, xxx[1] is msgs read
	   xxx2[0] is msgs received, xxx2[1] is number of area changes */
	long	usage[2];		/* total cumulative usage */
	long	usage2[2];		/* total cumulative usage */

	/* these are for daily and weekly stats - 2 element arrays, as before */
	long	hourly[24][2];		/* hourly usage */
	long	hourly2[24][2];		/* hourly usage */
	long	daily[7][2];		/* daily usage */
	long	daily2[7][2];		/* daily usage */
	long	monthly[31][2];		/* day/month usage */
	long	monthly2[31][2];	/* day/month usage */
	long	yearly[12][2];		/* month/year usage */
	long	yearly2[12][2];		/* month/year usage */

	/* these are the current hour and day - not updated till period is complete */
	long	hour[2];		/* current hour's usage */
	long	hour2[2];		/* current hour's usage */
	long	day[2];			/* current day's usage */
	long	day2[2];		/* current day's usage */
	long	month[2];		/* current year's usage */
	long	month2[2];		/* current year's usage */
};


struct area_stats	{
	long	days;			/* days that stats are valid for */

	/* last stats start time */
	time_t	start;

	/* last update time */
	time_t	last;

	/* the count of area records */
	short   count;

	/* the individual BBS's data records are stored in a linked list */
	struct area_data *head;
};



