/* RIP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 *
 *  Changes Copyright (c) 1993 Jeff White - N0POY, All Rights Reserved.
 *  Permission granted for non-commercial copying and use, provided
 *  this notice is retained.
 *
 * Rehack for RIP-2 (RFC1388) by N0POY 4/1993
 *
 * Beta release 11/10/93 V0.91
 *
 * 2/19/94 release V1.0
 *
 *
 * Tracing to sockets, mods April '95 by Johan. K. Reinalda, WG7J
 *
 * Rip98 support added, G4HIP - 29/3/97
 */

#include "global.h"
#ifdef RIP
#include "mbuf.h"
#include "netuser.h"
#include "rip.h"
#include "trace.h"

  
#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: ripdump.c,v 1.13 2000/05/09 16:48:28 brian Exp $";
#endif

void
rip_dump(fp,bpp)
FILE *fp;
struct mbuf **bpp;
{
struct rip_route entry;
struct rip_authenticate *ripauth;
int i;
int cmd, version;
int16 len = 0;
int entrylen = RIP_ENTRY;   
int16 domain;
char ipaddmask[25];
  
	traceprintf (fp, "RIP: ");
	cmd = PULLCHAR(bpp);
	version = PULLCHAR(bpp);
	switch (cmd)	{
		case RIPCMD_REQUEST:	traceprintf (fp, "REQUEST");
					break;
		case RIPCMD_RESPONSE:	traceprintf (fp, "RESPONSE");
					break;
		default:		traceprintf (fp, " cmd %u", cmd);
					break;
	}
  
	domain = pull16 (bpp);
  
	if (version == RIP_VERSION_98)
		entrylen = RIP98_ENTRY;
  
	if (bpp)
		len = len_p (*bpp);
	traceprintf (fp, " vers %u entries %u domain %u:\n", version, len / entrylen, domain);
  
	i = 0;
	while (len >= entrylen)	{
		/* Pull an entry off the packet */
	        if (version != RIP_VERSION_98)
	                pullentry (&entry, bpp);
	        else
	                pull98entry (&entry,bpp);
	        len -= (int16) entrylen;
  
		if (entry.rip_family == RIP_AF_AUTH) {
			ripauth = (struct rip_authenticate *)&entry;
			traceprintf (fp, "RIP: AUTHENTICATION Type %d  Password: %.16s\n",
				ripauth->rip_auth_type, ripauth->rip_auth_str);
			continue;
		}
  
		if (entry.rip_family != RIP_AF_INET) {
			/* Skip non-IP addresses */
			continue;
		}
  
		if (version >= RIP_VERSION_2) {
			sprintf (ipaddmask, "%s/%-4d", inet_ntoa (entry.rip_dest),
			mask2width (entry.rip_dest_mask));
		} else
			sprintf (ipaddmask, "%s/??", inet_ntoa (entry.rip_dest));
		traceprintf (fp, "%-20s%-3lu", ipaddmask, entry.rip_metric);
  
		if ((++i % 3) == 0)
			traceprintf (fp, "\n");
	}
	if((i % 3) != 0)
		traceprintf (fp, "\n");
}
  
#endif /* RIP */
  
