#!/usr/local/bin/tclsh

set NOSDIR "/nos"

set RELEASE "2.40"
set TAB1 16
set TAB2 8
set AUTONOSDIR 0

proc getdir {} {
	global AUTOMATIC NOSDIR
	if {$AUTOMATIC != 1} {
		set prompt "Use default installation directory of $NOSDIR (Y/n) ?"
		if {[info tclversion] > "7.4"} {
			puts "$prompt"
		} else {
			puts -nonewline "$prompt"
		}
		set ans [gets stdin]
		if {$ans != "y" && $ans != ""} {
			puts "Enter new installation base directory:"
			set NOSDIR [gets stdin]
		}
	}
}
proc tabit {flag {size 0}} {
	global fdh TAB1
	if {$size == 0} {
		set size $TAB1
	}
	set num [expr "($size - [string length $flag] + 7) / 8"]
	for {set cnt 0} {$cnt < $num} {incr cnt} {
		puts -nonewline $fdh "\t"
	}
}
proc doindent {indent} {
	for {set cnt 0} {$cnt < $indent} {incr cnt} {
		puts -nonewline "  "
	}
}
proc setbool {indent description flag value} {
	puts "* $description ($flag) $value"
	bool2 $indent "$description" "$flag" "$value"
}
proc bool2 {indent description flag value} {
	global fdh fdc $flag
	puts $fdc "set $flag $value"
	if {$value == "y"} {
		puts -nonewline $fdh "#define $flag"
	} else {
		puts -nonewline $fdh "#undef  $flag"
	}
	tabit $flag
	if {$value == "y"} {
		puts -nonewline $fdh "1"
	}
	puts $fdh "\t/* $description */"
	global $flag
	set $flag $value
}

proc bool {indent description flag {default "y"}} {
	global fdh fdc $flag help
	set choices "Y/n"
	set helpfound 0
	set new ""
	if {[info exists $flag]} {
		set default "[set $flag]"
	} else {
		set new " <NEW>"
	}
	if {$default != "y"} {
		set choices "y/N"
	}
	set done 0
	if [info exists help($flag)] {
		set choices "${choices}/?"
		set helpfound 1
	}
	while {$done == 0} {
		readln $indent "$description ($flag) \[$choices]$new " "$default"
		set ans [string tolower $ans]
		if {$helpfound && $ans == "?"} {
			puts "\n$help($flag)\n"
		} elseif {$ans == "y" || $ans == "n"} {
			set done 1
		} else	{
			puts ">> Enter either 'y' or 'n'....."
		}
	}
	bool2 $indent "$description" "$flag" "$ans"
}

proc comment {description} {
	global fdh fdc
	# output to screen
	puts "\n*\n* $description\n*"
	puts $fdc "\n#\n# $description\n#"
	puts $fdh "\n/*\n * $description\n */"
}

proc commentstart {description} {
	global fdh fdc
	# output to screen
	puts "\n*\n* $description"
	puts $fdc "\n#\n# $description"
	puts $fdh "\n/*\n * $description"
}

proc commentlocal {description} {
	# output to screen
	puts "* $description"
}

proc commentmiddle {description} {
	global fdh fdc
	# output to screen
	puts "* $description"
	puts $fdc "# $description"
	puts $fdh " * $description"
}

proc commentend {description} {
	global fdh fdc
	# output to screen
	puts "* $description\n*"
	puts $fdc "# $description\n#"
	puts $fdh " * $description\n */"
}

proc readln {indent prompt {default ""}} {
	upvar ans ans
	global AUTOMATIC
	doindent $indent
	if {[info tclversion] > "7.4"} {
		puts "$prompt"
	} else {
		puts -nonewline "$prompt"
	}
	if {$AUTOMATIC == 0} {
		set ans [gets stdin]
		if {$ans == ""} {
			set ans $default
		}
	} else {
		set ans $default
		puts "$ans"
	}
}

proc number {indent description flag {default ""}} {
	global fdh fdc $flag TAB2
	set prompt "$description ($flag) "
	set new ""
	if {[info exists $flag]} {
		set default "[set $flag]"
	} else {
		set new " <NEW>"
	}
	if {$default != ""} {
		set prompt "${prompt}\[$default] "
	}
	readln $indent "${prompt}${new}" "$default"
	puts $fdc "set ${flag} $ans"
	puts -nonewline $fdh "#define $flag"
	tabit $flag
	puts -nonewline $fdh "$ans"
	tabit $ans $TAB2
	puts $fdh "/* $description */"
	set $flag $ans
}

proc label {indent description flag {default ""}} {
	global fdh fdc $flag TAB2
	set prompt "$description ($flag) "
	if {[info exists $flag]} {
		set default "[set $flag]"
	}
	if {$default != ""} {
		set prompt "${prompt} \[$default] "
	}
	readln $indent "$prompt" "$default"
	puts $fdc "set ${flag} $ans"
	puts -nonewline $fdh "#define $flag"
	tabit $flag
	puts -nonewline $fdh "\"$ans\""
	tabit "\"$ans\"" $TAB2
	puts $fdh "/* $description */"
	set $flag $ans
}

set AUTOMATIC 0
set FORCEDOS 0
if [info exists argv] {
	set findauto [lsearch $argv auto]
	if {$findauto != -1} {
		set AUTOMATIC 1
		set temp [llength $argv]
		if {($temp - 1) > $findauto}	{
			set AUTOCONFIG [lindex $argv [expr $findauto + 1]]
			puts "Autoconfig using: $AUTOCONFIG"
		}
	}
	if {[lsearch $argv dos] != -1} {
		set FORCEDOS 1
	}
}

if [info exists env(NOSDIR)]	{
	set NOSDIR $env(NOSDIR)
	set AUTONOSDIR 1
}

if [file exists nosdir]	{
	set fd [open nosdir r]
	set NOSDIR [gets $fd]
	close $fd
	set AUTONOSDIR 1
}

if {$AUTOMATIC == 0 && [file exists $NOSDIR/etc/config.cfg] } {
	set prompt "Use previous configuration from $NOSDIR/etc/config.cfg (Y/n) ?"
	if {[info tclversion] > "7.4"} {
		puts "$prompt"
	} else {
		puts -nonewline "$prompt"
	}
	set ans [gets stdin]
	if {$ans == "y" || $ans == "Y" || $ans == ""} {
		set AUTOMATIC 1
		set AUTOCONFIG $NOSDIR/etc/config.cfg
		puts "Autoconfig using: $AUTOCONFIG"
	}
}

if {$AUTONOSDIR != 1}	{
	getdir
}

set NOSDIR "[string trimleft [string trimright $NOSDIR " \t\n\r"] " \t\n\r"]"
puts "\nmkconfig.tcl: Using installation directory of: '$NOSDIR'"

set CONFIG ${NOSDIR}/etc/config.cfg
set CONFIG_OLD ${NOSDIR}/etc/config.old
set TMPCONFIG tmpconf
set CONFIG_H config.h
set TMPCONFIG_H tmpconf.h
set CONFIG_IN config.in
set CONFIG_HLP config.hlp

#
# Open the output files
#
set fdc [open $TMPCONFIG w]
puts $fdc "#\n# Automatically generated config file: don't edit\n#"

set fdh [open $TMPCONFIG_H w]
puts $fdh "#ifndef _CONFIG_H\n#define _CONFIG_H\n"
puts $fdh "/*\n * Automatically generated C config file: don't edit\n */"

if {[info exists AUTOCONFIG] && [file exists $AUTOCONFIG]}	{
	catch {source $AUTOCONFIG}
} elseif [file exists $CONFIG] {
	catch {source $CONFIG}
}

catch {source $CONFIG_HLP}
source $CONFIG_IN

if {$FORCEDOS == 1}	{
	set ISUNIX y
}

puts $fdc "\n# configuration complete..."
close $fdc
puts $fdh "\n\n#include \"config.chk\"\n\n#endif\t/* _CONFIG_H */"
close $fdh

if {[info exists ISUNIX] == 1 && $ISUNIX == "y"} {
	catch {exec mv -f $CONFIG $CONFIG_OLD}
	exec mv -f $TMPCONFIG $CONFIG
	exec mv -f $TMPCONFIG_H $CONFIG_H
} else {
	regsub -all "/" $CONFIG "\\" temp
	set CONFIG "$temp"
	regsub -all "/" $CONFIG_OLD "\\" temp
	set CONFIG_OLD "$temp"
	if [file exists $CONFIG]	{
		catch {exec "copy $CONFIG $CONFIG_OLD"}
	}
	exec "copy $TMPCONFIG $CONFIG"
	if [file exists $CONFIG_H]	{
	        catch {exec "del $CONFIG_H"}
	}
        exec "rename $TMPCONFIG_H $CONFIG_H"
}

puts " "
puts "The building of config.h is complete!"
puts "\n"
exit
