/* make executable with the command:
   DOS:
        bcc -ms -DMSDOS buildctl.c \borlandc\lib\wildargs.obj
   LINUX:
	gcc buildctl.c -o buildctl
*/


#include <stdio.h>
#include "ctype.h"
#include <string.h>
#include <stdlib.h>
#ifdef MSDOS
#include <dir.h>
#include <io.h>
#else
#define stricmp strcasecmp
#endif
#define NULLFILE (FILE *) 0
#define NULLCHAR (char *) 0
#define	BM_READ		2

#ifndef _lint
static char rcsid[] OPTIONAL = "$Id: buildctl.c,v 1.17 2000/05/09 14:18:53 brian Exp $";
#endif

static char const *dirname = NOSDIR;

typedef unsigned short int16;

int main (int argc, char *argv[]);
static int isarea (char *name);
static void rebuild_one (char *str);

/* a mailbox entry */
struct let {
	long	start;
	long	size;
	long	bid;
	int16	status;
};


/* Returns 1 if name is in the given area file, 0 otherwise */
static int
isarea(char *name)
{
char buf[100], *cp;
FILE *fp;

	sprintf (buf, "%s/etc/areas.sys", dirname);
	if((fp = fopen(buf,"r")) == NULLFILE)
		return 0;
	while(fgets(buf,sizeof(buf),fp) != NULLCHAR) 	{
		/* The first word on each line is all that matters */
		if(isalnum(buf[0])) 	{ /* skip comments */
		        if((cp = strchr(buf,' ')) != NULLCHAR)
				*cp = '\0';
		        /*There could still be a tab before the space ! -WG7J */
			if((cp = strchr(buf,'\t')) != NULLCHAR)
				*cp = '\0';
		        /*This could be a line with just the area name,
		         *ie terminated with 'CR/LF' - WG7J
		         */
		        if((cp = strchr(buf,'\n')) != NULLCHAR)
				*cp = '\0';
		        if(stricmp(name,buf) == 0) {    /* found it */
				fclose(fp);
				return 1;
				}
			}
		}
	fclose(fp);
	return 0;
}


/*lint -save -e550 */
void
rebuild_one (char *str)
{
char *cp;
register FILE *fp, *cfp;
int nextisBID, firstIDline;
char buf[256], buf2[512];
int ispublic, lines;
long last;
struct let l;

	cp = strrchr (str, '/');
	if (!cp)
		cp = strrchr (str, '\\');
	if (!cp)	{
		sprintf (buf2, "%s/spool/mail", dirname);
		sprintf (buf, "%s/control/%s", buf2, str);
		cp = str;
	} else	{
		*cp++ = 0;			
		strcpy (buf2, str);
		sprintf (buf, "%s/control/%s", str, cp);
	}
	if (strstr (buf, ".TXT") || strstr (buf, ".txt"))
		strcpy (&buf[strlen(buf) - 3], "ctl");
	else
		strcat (buf, ".ctl");
	if((cfp = fopen(buf,"wb")) == NULLFILE)	{
		printf ("Can't create control file '%s'\n", buf);
		return;
	}
	sprintf (buf, "%s/%s", buf2, cp);

	if (!strstr (buf, ".TXT") && !strstr (buf, ".txt"))
		strcat (buf, ".txt");
	if ((fp = fopen (buf, "rt")) == NULLFILE)	{
		printf ("Can't open file '%s'\n", buf);
		return;
	}
	firstIDline = nextisBID = 0;
	printf ("Building Control Files for: '%s'\n", buf);
	if ((cp = strstr(buf, ".")) != NULLCHAR)
		*cp = 0;
	ispublic = isarea (buf);
	l.start = last = 0;
	lines = 0;
	while(fgets(buf,sizeof(buf),fp) != NULLCHAR){
		if (!strncmp(buf, "From ", 5))	{
#ifdef MSDOS
			l.size = last - l.start - lines; 
#else
			l.size = last - l.start; 
#endif
			if (l.size)
				fwrite (&l, sizeof(struct let), 1, cfp);

			lines = l.status = 0;
			l.start = last;
			firstIDline = 0;
		}
		lines++;

		/* don't think this next section is necessary. All
		   messages SHOULD have a MSGID line */
		if (!firstIDline && nextisBID && (cp=strstr(buf,"AA")) != NULLCHAR) {
			/*what follows is the message-number*/
			l.bid = atol(cp+2);
			nextisBID = 0;
			firstIDline = 1;
			}

		if (!strncmp ("Received: ", buf, 10))
			nextisBID = 1;
		if (!ispublic && !strncmp ("Status: R", buf, 9))
			l.status = BM_READ;
		last = ftell (fp);
	}
	fclose(fp);
#ifdef MSDOS
	l.size = last - l.start - lines; 
#else
	l.size = last - l.start; 
#endif
	fwrite (&l, sizeof(struct let), 1, cfp);
	fclose(cfp);
}
/*lint -restore */


int
main (int argc, char *argv[])
{
int k = 1; 

	if (argc == 1)	{
		fprintf (stderr, "usage: buildctl [-ddirname] <file> [<file> ...]\n");
		exit (1);
	}
	if (argv[1][0] == '-')	{
		switch (tolower (argv[1][1]))	{
			case 'd':	if (argv[1][2])		{
						dirname = &argv[1][2];
						k = 2;
						if (argc == 2)	{
							fprintf (stderr, "usage: buildctl [-ddirname] <file> [<file> ...]\n");
							exit (1);
						}
						break;
					}
					/* else fall through */
			default:	printf ("usage: buildctl [-ddirname] [mailfile]\n");
					exit (1);
		}
	}
	for ( ; k < argc; k++)		/*lint !e539 */
            rebuild_one (argv[k]);
    return 0;
}

