/**********************************************************************
 * RS_BTOA.C - for work as a sub-run call from ROSERVER
 **********************************************************************
 * btoa: version 2.2 for cpm/msdos on packet radio		      		  *
 *       a program to transform binary to printable ASCII at a minimal*
 *       'cost' in conversion space - ratio is about 5/4	      	  *
 *--------------------------------------------------------------------*
 * btoa: version 4.0 						      					  *
 * purpose: stream filter to change 8 bit bytes into printable ascii  *
 * computes the number of bytes, and three kinds of simple checksums  *
 * incoming bytes are collected into 32-bit words, then printed in    *
 * base 85  exp(85,5) > exp(2,32). The ASCII characters used are be-  *
 * tween '!' and 'u'. 'z' encodes 32-bit zero; 'x' is used to mark    *
 * the end of encoded data.					      					  *
 *								      								  *
 *  Paul Rutter		Joe Orost				      					  *
 *  philabs!per		petsd!joe				      					  *
 *								      								  *
 *  WARNING: this version is not compatible with the original as sent *
 *  out on the net.  The original encoded from ' ' to 't'; which      *
 *  cause problems with some mailers (stripping off trailing blanks). *
 *--------------------------------------------------------------------*
 *                                                                    *
 *  90Apr25 - modified to conform to "no args = usage" of the ROSER-  *
 *            VER program suite.
 *  89Oct05 - modified to run with ROSERVER                           *
 *  86May30 - modified progress displays and removed a debugging dis- *
 *            inadvertently left in |br| ka2bqe			      		  *
 *  86May23 - modified for '-h' or '-H', also added variable line     *
 *            length, and byte counts output to console, and fixed    *
 *            bug in ouput overwrite query |br| ka2bqe                *
 *  86May19 - modified for command line input and '-h' option to pro- *
 *            duce 62 char output lines for HF packet, and place in-  *
 *            put file name in header of output file  |br| ka2bqe     *
 *  86May05 - modified to compile/run for packet radio under cpm-80 & *
 *            msdos by Brian B. Riley ( |br| - ka2bqe) - RATS         *
 *  Hacked to work with non-UNIX machines by Brian Lloyd, 86/04/14    *
 *                                                                    *
 **********************************************************************/


#include "mb.h"
#include "rose_ver.c"
#include <dos.h>
#include <varargs.h>

#define reg register

#define MAXPERLINE 	78	/* use standard unit record line 78+2*/

#define streq(s0, s1)  strcmp(s0, s1) == 0

long int Ceor = 0;
long int Csum = 0;
long int Crot = 0;

long int ccount = 0;
long int bcount = 0;
long unsigned int word;

long int out_count;
int line_length;

FILE *		inf;
FILE *		outf;

#define EN(c)	(int) ((c) + '!')

main(argc,argv)
int argc;
char *argv[];
{

	char 		*s, *ofname;
	register	c;
	register	long int n;
	char		infile[20];
	char		outfile[20];
	char		line_buf[16];

	
	printf("\n RS_BTOA - Binary to ASCII converter");
	printf("\tver %s, %s\n",version,mbdate);
	
	if ( argc == 1) {
		fprintf(stderr," usage: rs_btoa  infile outfile\n");
		exit(1);
	}



	line_length = MAXPERLINE;	/* default to 78		*/


	if ((inf = fopen(argv[1], "rb")) == NULL) {
	    printf( " Error opening file - %s\n", argv[1]);
		exit(1);
    }
	
	if (access(outfile,0)== 0) {
	    printf("\n Target file name exists - OVERWRITING!");
	}

	if ((outf = fopen(argv[2], "wb")) == NULL) {
	    printf( " Error opening output file: %s\n", argv[2]);
	    fclose (inf);
		exit(1);
    }
	
	printf(" encoding file: %s ===> %s",argv[1], argv[2]);

	if (s = strrchr(argv[1],'\\'))
		ofname = s + 1;
	else
		ofname = argv[1];

		
	fprintf( outf, "xbtoa Begin %s\n", ofname);
	n = 0;
	while ((c = fgetc( inf )) != EOF) {
		encode(c);
		n += 1;
	}
	while (bcount != 0) {
		encode(0);
	}

	/* n is written twice as crude cross check*/

	fprintf( outf, "\nxbtoa End N %ld %lx E %lx S %lx R %lx\n", n, n, Ceor, Csum, Crot);
	putc('\n', outf);
	fclose( inf  );
	fclose( outf );
	printf("\n checksum written\n %ld bytes read, %ld bytes encoded\n\n *** done\n"
		,n, out_count);
	exit(0);
}

/************************************************************************
 * charout - output encoded character to the file and count chars to    *
 *           'break the data into manageable lines                      *
 ************************************************************************/
charout(c)
{
	fputc(c,outf);
	ccount += 1;
	out_count += 1;
	if (ccount == line_length) {
		fputc('\r',outf);	/* original function didn't have */
		fputc('\n',outf);	/* the /r - packet NEEDS returns */
		out_count += 2;
		ccount = 0;
	}
}

/************************************************************************
 * encode - stream encoding of the data flow                            *
 ************************************************************************/
encode(c)
	reg c;
{
	Ceor ^= c;
	Csum += c;
	Csum += 1;
	if ((Crot & 0x80000000L)) {
		Crot <<= 1;
		Crot += 1;
	} else {
		Crot <<= 1;
	}
	Crot += c;

	word <<= 8;
	word |= c;
	if (bcount == 3) {
		wordout(word);
		bcount = 0;
	} else {
		bcount += 1;
	}
}

/************************************************************************
 * wordout - output the encoded 4 byte stream as 5 'digit' word         *
 ************************************************************************/
wordout(word)
	reg unsigned long int word;
{
	if (word == 0) {
		charout('z');
	} else {

		/* 85^4 */

		charout(EN(word / 52200625L ));
		word %= 52200625L;

		/* 85^4 */

		charout(EN(word / 614125L ));
		word %= 614125L;

		/* 85^4 */

		charout(EN(word / 7225L ));
		word %= 7225L;

		/* 85^4 */

		charout(EN(word / 85));
		word %= 85;
		charout(EN(word));
	}
}
