/*

*/

#include "rosewind.h"                    /* windows header file */
extern char *version;

#define MAXWIN 100                      /* for 100 windows */
WINDOWPTR wins[MAXWIN];                 /* DONT INCREASE IN SMALL MODEL */
  struct mitem {                        /* menu item template */
    int r;                              /* row */
    int c;                              /* col */
    char *t;                            /* text */
    int rv;                             /* return value */
  };

  struct pmenu {                        /* popup menu structure */
    WINDOWPTR wpsave;                   /* a place for the window handle */
    int winopn;                         /* window open flag */
    int lndx;                           /* last index */
    int fm;                             /* first menu item index */
    int lm;                             /* last menu item index */
    struct mitem scrn[25];              /* a bunch of menu items */
  };
unsigned blue 		= BLUE;             /* remap for mono */
unsigned red  		= RED;
unsigned yellow  	= YELLOW;
/*
** Prototypes to keep the new ANSI Compilers Happy
*/

int nap(int ticks);
int hiber(int seconds);
int chkesc(void);
int popup(int page,
              int row,
              int col,
              int width,
              int height,
              int atrib,
              int batrib,
              struct pmenu *mx,
              int cflag);
WINDOWPTR qpopup(int page,
              int row,
              int col,
              int width,
              int height,
              int atrib,
              int batrib,
              struct pmenu *mx);
int help_init(char *help_file_name);
int help(char *subject);
void showpage(long offset);
int filbuf(long offset);

WINDOWPTR show_bannr(color, delay,dma_flag)
int color, delay, dma_flag;
{
	WINDOWPTR     ww;

	int i;                                  /* scratch integers */
	int watrib,batrib;                      /* scratch atributes */
	int rv;                                 /* for popup */
	int row,col;                            /* for 100 windows */
	char tline[256];

	if(!color || (wns_mtflg == 7)) {
  		blue	= BLACK;      					/* remap if mono */
  		red		= BLACK;
		yellow	= WHITE;
  	}
	wn_dmode(PAINT);					/* simulate CGA for fast muthers! */
	wn_init();                            /* save entry screen */
	v_cls(NORMAL);						/* clear background after saving it */
	hiber(1);                             /* wait 1 second (aprx) */

	wn_dmaflg	= dma_flag;				/* uses dma only if non-multi-user */

	watrib = v_setatr(WHITE,BLACK,0,BOLD);
	for(i=0; i<25; i++) {                 /* build the back drop */
    	v_locate(0,i,0);                    /* position cursor */
    	v_wca(0, 0xb0, watrib, 80);         /* the fast way */
	}
	v_hidec();                            /* hide the cursor */

	watrib = v_setatr(red,yellow,0,BOLD); /* window attribute */
	batrib = v_setatr(red,WHITE,0,0);    /* border attribute */
	ww = wn_open(0,1,4,70,21,watrib,batrib);
	ww->bstyle |= BOLD;                   /* toggle bold on then off */
	sprintf(tline,"< ROSErver / PRMBS v%s >",version);
	wn_title(ww,tline);
	ww->bstyle ^= BOLD;
	wn_puts(ww,1,1, "            M O R N I N G S T A R   K E E P ,    L T D .");
	wn_puts(ww,3,1, "                                and");
	wn_puts(ww,4,1, "            The Radio Amateur Telecommunications Society");
	wn_puts(ww,5,1, "                              presents");
	wn_puts(ww,7,1, "                            The ROSErver");
	wn_puts(ww,9,1, "                   A Packet Radio MailBox System");
	wn_puts(ww,11,1,"  Creator: Brian B. Riley(ka2bqe) with help from Dave Truli(nn2z)");
	wn_puts(ww,13,1,"   based partly on earlier works and ideas of w0rli,ka9q et al.:");
	wn_puts(ww,15,1," A PUBLIC SHAREWARE Release         using Window BOSS (C) by N1ADE");
	wn_puts(ww,17,1," All Sources Available               uses INT14 I/O MBBIOS or G8BPQ");
	wn_puts(ww,19,1," PO Box 188 Underhill Ctr, VT 05490         (802) 899-4527");
	hiber(delay);
	wn_clr(ww);
	return (ww);
}


WINDOWPTR io_window(color)
int color;
{

	WINDOWPTR     ww;

	int i;                                  /* scratch integers */
	int watrib,batrib;                      /* scratch atributes */
	int rv;                                 /* for popup */
	int row,col;                            /* for 100 windows */


	if(!color || (wns_mtflg == 7)) {
  		blue	= BLACK;      					/* remap if mono */
  		red		= BLACK;
		yellow	= WHITE;
  	}

	watrib = v_setatr(BLACK,yellow,0,BOLD); /* window attribute */
	batrib = v_setatr(red,WHITE,0,0);    /* border attribute */
/*
	ww = wn_open(0,10,8,62,10,watrib,batrib);
*/
	ww = wn_open(0,13,8,62,7,watrib,batrib);
	ww->bstyle |= BOLD;                   /* toggle bold on then off */
	wn_title(ww,"< SETUP from CONFIG >");
	ww->bstyle ^= BOLD;
	return (ww);

}
/************************* Miscellaneous Code *****************************/


nap(ticks)                              /* sleep a few clock ticks */
int ticks;
{
unsigned long tc;                       /* Some Compilers will */
unsigned long ts, te;                   /* incorrectly optimize this */
                                        /* function */
static unsigned long far *loc = (unsigned long far *)0x0040006c;
  ts = *loc;
  do {
    if(chkesc()) return(NULL);
    te = *loc;
    tc = te-ts;
  } while (tc < (unsigned long)ticks);
}

hiber(seconds)
int seconds;
{
  nap(seconds * 18);
  return(NULL);
}

wn_xputc(ww,c)
char c;
WINDOWPTR ww;
{
	char *cpp = "\0\0";
	*cpp = c;
	wns_wtext(ww,cpp);
/*
	wn_printf(ww,"%c",c);
*/
}



chkesc()                                /* check for ESC while napping */
{
int c;

  if(v_kstat()) {
    c=v_getch() & 0x7f;
    switch(c) {
      case ESC:
        return(TRUE);
      case ETX:
        v_cls(7);
        v_locate(0,0,0);
        exit(0);
      default:
        return(FALSE);
    }
  }
  return(FALSE);
}

/* End */
