/*****************************************************************
 *  ROSEBOOT.C - 11/12/86 - Initialize port / tnc / modem
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/
#include "mb.h"
#include <dos.h>
#include "rose_ver.c"
#include "rosewind.h"
#define CS7	2
#define CS8	3
#define NPARITY	0
#define OPARITY	(1<<3)
#define EPARITY	(0x3<<3)
#define STOP1	0
#define STOP2	(1<<2)

#define B300	(2<<5)
#define B600	(3<<5)
#define B1200	(4<<5)
#define B2400	(5<<5)
#define B4800	(6<<5)
#define B9600	(7<<5)
#define B19200		0
#define B38400	(1<<1)

#define	SETUPDRV	0x0000
#define	OUTDRVR		0x0100
#define	INPDRVR		0x0200
#define	INITDRVR	0x0400

/* MBBIOS Functions */

#define MFLOWON		0x0500
#define MFLOWOFF	0x0600
#define MSNDBRK		0x0700
#define SETOPT		0x0900
#define XMTBUF		0x0001
#define HRDSHK		0x0004

/* FOSSIL function defintions	*/

#define FFLOWOFF	0x0601
#define FFLOWON		0x0600


#define DTR_ON(x)		flow_off(x)
#define DTR_OFF(x)		flow_on(x)
#define ISCONNECTED(x)	havedcd(x)

FILE *cfl;


PORTS *port;
PORTS *porthd	= NULL;
PORTS *cport	= NULL;
PORTS *qport	= NULL;

int color = FALSE;

int multiuser = FALSE;

int flds;

char *fld[MAXFLDS];

long ibm_timer;
char *line, *cmd;

char *usfile;
FILE *ufl;
USER_HEADER *ufhs;
MAIL_HDR *mfhs;
MSG_HDR  *mmhs;

char muser[64];

main(argc,argv)
int		argc;
char	**argv;
{
	WINDOWPTR	w1, w2, show_bannr(), io_window();
	char 		*cp, *strchr(), *suffix, type, *s, io[3];
	int			pid = 0;
	int 		i, port_id;
	int			initdevc		= FALSE;
	int			nobaudset		= FALSE;
	unsigned	bauds();
	char		*ptr[6];
	char	tline[LINELEN];
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; (*s != '\0'); s++) {
			switch (toupper(*s)) {
			case 'I':
				initdevc++;
				break;
			case 'N':
				nobaudset++;
				break;
			case 'M':
				strcpy(muser,argv[0]);
				multiuser++;
				pid	= (int) (*(s+1) & 0x0f);
				break;
			case 'C':
				color++;
				break;
			}
		}
	}
	if (argc == 0) {
		printf("usage: ROSEBOOT [-cin] [-m#] {config file}\n");
		printf("       [-i]  - initialize port devices\n");
		printf("       [-n]  - do NOT set port baudrates\n");
		printf("       [-c]  - use ANSI color strings\n");
		printf("       [-m#] - multi-user optimization, # is process ID assigned\n");
		printf("       {config file} \n");
		exit(1);
	}
	if (pid) {	
			/* 
				delay start of system in multi-user based on PIDs 
			*/
			
		printf("\n\t\7Multi-user system - starting delay of 30 * PID(=%d) = %d seconds\n",
			pid, 30*pid);
		hiber(30*pid);		
	}
	
	w1 = show_bannr(color,5,(multiuser==FALSE));
	
	sprintf(tline,"ROSEBOOT - MBBIOS/G8BPQ Driver port and device init program");
	wn_puts(w1,3,5,tline);
	sprintf(tline,"           for ROSERVER ver %s, %s - KA2BQE", version, mbdate);
	wn_puts(w1,4,5,tline);
	w2 = io_window(color);
	init(argv[0],nobaudset, initdevc,w2);
	wn_clr(w2);
	wn_close(w2);
	wn_clr(w1);
	wn_close(w1);
	wn_exit();
	v_cls(NORMAL);
	
	
	for (i=3 ; i  ; i--)
		ptr[i-1] = NULL;

	if (multiuser) 
		ptr[i++] 	= muser;


	ptr[i++]		= argv[0];
	
	brkoff();
	execlp("roserver.pgm", "", ptr[0], ptr[1], ptr[2], NULL);
	exit(0);
}

pause(ticks)
unsigned ticks;
{
	unsigned sml_ticks;
	while(ticks--) {
		sml_ticks = 0xffff;
		while (sml_ticks--);
	}
}

/*********************************************************************
 * init() - actual system initialization - top level routine
 *********************************************************************/
init(cfname, nobaudset, initdevc, ww)
WINDOWPTR ww;
char *cfname;
int	nobaudset, initdevc;
{
	char tline[LINELEN];
	char tline2[LINELEN];
	char tcmd[LINELEN];
	FILE *cfl;
	PORTS *p = NULL;

	
	if ((cfl = fopen(cfname, "rt")) == NULL) {
		sprintf(tline2, "\7*** Cannot open %s",cfname);
		wn_puts(ww,1,3,tline2);
		exit(2);
	} else {
		sprintf(tline2,"Reading: %s",cfname);
		wn_puts(ww,1,3,tline2);
	}

		/* make sure config file as right header in it */

	rd_parse(tline,cfl);
	if ( atoi(version) != atoi(fld[0])) {
		wn_puts(ww,3,3,"Configuration File Mismatch");
		sprintf(tline2,"- found ver %s expecting ver %s",fld[0], version);
		wn_puts(ww,4,6,tline2);
		exit(3);
	}
		/* read port configuration information	*/
	hiber(1);
	while (TRUE) {
		if (rdport(cfl)) {
			if (port->id != 'L') {
				sprintf(tline2,"     < I/O PORT %c >     ",port->id);
				ww->bstyle |= BOLD;             /* toggle bold on then off */
				wn_title(ww,tline2);
				ww->bstyle ^= BOLD;             /* toggle bold on then off */
				wn_clr(ww);
				if (!port_xst(port,ww)) {
					wn_puts(ww,3,3,"Error during port configuration");
					exit(port->idn+11);
				}
				if (nobaudset == FALSE)
					setbaud(port->idn,port->baud);
				if (initdevc)
					outtnc(ww,port->init);
				hiber(1);
			}
			if (p == NULL)
				porthd  = port; 
			else 
				p->next = port;
			p = port;
		} else {
			break;
		}
	} 
	
	(void) fclose(cfl);		/* close CONFIG.RS file	*/
}

/*
	rd_parse() - reads a line from file with comment removal and parses
*/
rd_parse(buf,tfil)
char *buf;
FILE *tfil;
{
	char tline[LINELEN];
	if (rdline(tline, LINELEN, tfil)) {
		return (TRUE);
	}		
	parse(buf,tline);
	return (FALSE);
}
/*********************************************************************
 * rdmstr() - read a series of lines, terminated with "*** EOF"
 *********************************************************************/
char *rdmstr(tfil)
FILE *tfil;
{
  short i;
  char *t;

	char tcmd[6 * CMDLEN];	
	
	t = tcmd; 
	i = 6 * CMDLEN;
	while(i && !rdline (t, i, tfil)) {
		if(iseof(t))
			break;
		i -= strlen(t); 
		t += strlen(t);
	}
	*t = '\0';
	t = (char *) mballoc (strlen(tcmd) + 1);
	strcpy (t, tcmd);
	return (t);
}

/*********************************************************************
 * rdstr() - read in line from CONFIG, alloc space and set pointer
 *********************************************************************/
char *rdstr(tfil)
FILE *tfil;
{
	char *t;
	char tcmd[CMDLEN];
	rdline (tcmd, CMDLEN, tfil);
	t = (char *) mballoc (strlen(tcmd) + 1);
	strcpy (t, tcmd);
	return (t);
}

/*********************************************************************
 * rdstrnl() - same as rdstr() but strips new line from end
 *********************************************************************/
char *rdstrnl(tfil)
FILE *tfil;
{
	char *t;

	t = rdstr(tfil);
	remnl(t);
	return(t);
}

/*********************************************************************
 * kw() - (????) - reads a line - looks at char[0] for a 'Y'
 *********************************************************************/
kw(tfil)
FILE *tfil;
{
	char tcmd[CMDLEN];
	rd_parse(tcmd,tfil);
	return(*fld[0] == 'Y');
}
/*********************************************************************
 * rdnumb () reads in a line, tales first string as a number
 *********************************************************************/
rdnumb(tfil)
FILE *tfil;
{
	char tcmd[LINELEN];
	
	rd_parse(tcmd,tfil);
	return (atoi (fld[0]));
}

/*********************************************************************
 * rdprts() read in CONFIG.MB and set up ports 
 *********************************************************************/
rdport(tfil)
FILE *tfil;
{
	char *lp, tline[LINELEN], tcmd[LINELEN];
	int start_port = FALSE;
	
	PORTS *p;


	while(!rdline (tline, LINELEN, tfil)) {
		if (iseof(tline))
    		break; 
    	parse(tcmd, tline);
		if (!start_port) {
			if (strcmp(fld[0],"PORT") != 0)
				continue;
		} else {
			if (strcmp(fld[0],"ENDPORT") == 0)
				return(TRUE);
			else
				continue;
		}

		start_port = TRUE;

		port = (PORTS *)	mballoc(sizeof(PORTS));
		fill(port,'\0',sizeof(PORTS));
		port->user = (USER_RECORD *) mballoc(USER_RECSIZE);
	


		port->id 	= *fld[1];
		port->idn	= (int) (port->id - 'A');

		lp = fld[2];

		while(*lp) {
			switch(*lp++) {
        	case 'B': 
        		port->type |= P_BBS;		break;
        	case 'C': 
        		port->type |= P_CONSOLE; 	
        		if (cport == NULL)
        			cport = port;	
        									break;
        	case 'H': 
        		port->type |= P_HAMCAL;		break;
	        case 'N': 
	        	port->type |= P_INACTIVE;	break;
        	case 'O': 
        		port->type |= P_OSRVCAL;	break;
        	case 'Z':
        		port->type |= P_BPQ_RET;
        	case 'Q': 
        		port->type |= P_BPQ;
        		if (qport == NULL)
        			qport = port;	
        									break;
        	case 'R': 
        		port->type |= P_REG;		break;
	        case 'T': 
	        	port->type |= P_TNC;		break;
	        	
					/* - by default a Modem port will 'echo'	*/
    	    case 'M': 
        		port->type |= P_MDM;
        	case 'E': 
        		port->type |= P_ECHO;		break;
      		}
    	}

		port->mode		= IDLE;
		port->timeout 	= 60 * atoi(fld[3]);
		port->baud		= atou(fld[4]);
		port->color 	= rdstrnl(tfil);
    

		if (port->type & P_TNC) {
			port->beacon	= kw(tfil);
			rd_parse(tcmd,tfil);
/*
			port->dl_size	= atoi(fld[0]);
			strcpy(port->dl_time,fld[1]);
*/

			port->conn		= rdmstr(tfil);
			port->into_trm	= rdmstr(tfil);
			port->outof_trm	= rdmstr(tfil);
		}

		if (!(port->type & P_CONSOLE)) {
			port->init		= rdmstr(tfil);
			port->online	= rdmstr(tfil);
			rd_parse(tcmd,tfil);
/*
			port->fwsize	= atoi(fld[0]);
			strncpy(port->fwtmr,fld[1],4);
*/
		}

	}
	return(FALSE);
}
/******************************************************************
 * parse() - copy input line to cmd buffer then parse by white
 *  space setting pointers for fld's 0-12 and opt1
 ******************************************************************/

parse(out, in)
register char *out, *in;
{
	int i;

	strcpy(out,in);
	remnl(out);
	
	if (*out) {
		uc(out);
		flds = fsplit(out, ' ', fld, MAXFLDS);
	} else {
		flds = 0;
		return;
	}
	for (i = flds ; i < MAXFLDS ; i++ )
		fld[i] = "";
}

giveaway(tm)
int tm;
{
	return;
}
/****************************************************************
 * wwait() - pause, have a beer; gonna be here for 'sec's
 ****************************************************************/
wwait(sec)
int sec;
{
	settmr(sec);
	while (chktmr());
}

/****************************************************************
 *  chktmr() - Return the current value of the hardware timer.
 *      Note: MUST return zero when timer has finished counting.
 *      this means to return the number of seconds remaining until
 *      the timer expires
 ****************************************************************/

int chktmr()
{
long l;
	time(&l);
	l=ibm_timer-l;
	if (l>0) return ((int) l);
	else return (0);
}

/****************************************************************
 * settmr() - Start the hardware timer
 ****************************************************************/
settmr(cnt)
int cnt;
{
	long l;
	time(&l);		/* secs since 1970 */
	ibm_timer = (long) cnt + l;  /* compute time to expire */
}
/****************************************************************
 *  outtnc() - sends command strings to the TNC, counts \n's and 
 *	does that many waitcmd()'s.
 ****************************************************************/
outtnc(ww,cp)
WINDOWPTR ww;
char *cp;
{
	char *q, *p;

	q = cp;
	cmdtnc(ww);
	while (*q) {
		outchar(ww,*q);
		if (*q++ == '\n') {
			waitcmd(ww);
		}		
	}
}

/*******************************************************************
 * waitcmd() - wait for  cmd: prompt from TNC
 *******************************************************************/
waitcmd(ww)
WINDOWPTR ww;
{
  char *wanted = "cmd:";
  int i;
  int j = 16;

  settmr(2);
  for (i = 0; i < 4;) {
    if (instat()) 
    	if (inchar(ww) == *(wanted+i))
    		i++;
		else
		 	i = 0;
    if (--j == 0 ) {
    	j = 16;
    	if (!chktmr())
    		return;
    }
  }
}
setcolor(cp)
char *cp;
{
	if (color)
		printf("\033[1;3%c;4%cm",*cp,*(cp+2));
}
/*******************************************************************
 * cmdtnc() - issue ctrl_c to TNC to get it into "cmd:" mode
 *******************************************************************/
cmdtnc(ww)
WINDOWPTR ww;
{
	if ( port->isTNC2 )
		sendbreak(port->idn);
	else
		outchar(ww,CTL_C); 
	waitcmd(ww);
}

/**********************************************************************
 *  MBIBMIO.C - 12/29/86 - System dependent  I/O functions.
 *  (split out from MBIBM.C 12/29/86)
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *---------------------------------------------------------------------
 * Uses interrupt serial I/O routines in MBBIOS.COM by AA4RE
 * Uses brkoff and brkon to disable/enable ctrl-brk by VE3GYQ
 * Uses COMM int 14 routines from NN2Z modified by KA2BQE
 **********************************************************************
 * inchar()	- Return character from current input.
 * instat()	- Return non-zero if a character waits at current input.
 * ioinit()	- Initialize the serial I/O system.
 * iooff()	- restore break, turn off COMn interrupts
 * outchar()	- Put the character out the proper port,
 * port_stat()  - get port status via int14
 * usr_gone()   - if available checks for a hardware (this case DCD)
 *	          indication of the user having gone bye-bye.
 *
 **********************************************************************
 *		INT 14h - command 3 READ STATUS
 *
 *  BIT		Port Status - hi reg (AH)	Modem status - lo reg (AL)
 *  ----------------------------------------------------------------------
 *  bit 7	timed out			rlsd (DCD) carrier detect
 *  bit 6	xmt shift reg empty		ring indicator (RI)
 *  bit 5	xmt hold reg empty		data set ready (DSR)
 *  bit 4	break detected			clear to send (CTS)
 *  bit 3	framing error			change in rlsd
 *  bit 2	parity error			trailing edge RI
 *  bit 1	overrun error			change in DSR
 *  bit 0	data ready (input)		change in CTS
 **********************************************************************/

char comin();
int  havedcd(), comstat(), comtxrdy();
void comout();


#define CS7	2
#define CS8	3
#define NPARITY	0
#define OPARITY	(1<<3)
#define EPARITY	(0x3<<3)
#define STOP1	0
#define STOP2	(1<<2)

#define B300	(2<<5)
#define B600	(3<<5)
#define B1200	(4<<5)
#define B2400	(5<<5)
#define B4800	(6<<5)
#define B9600	(7<<5)
#define B19200		0
#define B38400	(1<<1)

#define	SETUPDRV	0x0000
#define	OUTDRVR		0x0100
#define	INPDRVR		0x0200
#define	INITDRVR	0x0400

/* MBBIOS Functions */

#define MFLOWON		0x0500
#define MFLOWOFF	0x0600
#define MSNDBRK		0x0700
#define SETOPT		0x0900
#define XMTBUF		0x0001
#define HRDSHK		0x0004

/* G8BPQ MBBIOS extensions 
   ('officially' defined in MB.H - for gloabl purposes)

#define BPQVER		0x1f00
#define BPQCALL		0x1f01
#define BPQUNACK	0x1f02
#define BPQRETNODE	0x1f10

*/

/* FOSSIL function defintions	*/

#define FFLOWOFF	0x0601
#define FFLOWON		0x0600

int alow_bell = TRUE;

/*******************************************************************
 * io_bios() - FOSSIL calls to X00 driver or MBBIOS calls
 *******************************************************************/
io_bios(port_id,biosfunc)
int port_id, biosfunc;
{
  union REGS regs;

	regs.x.dx = port_id;
	regs.x.ax = biosfunc;
	int86(0x14,&regs,&regs);
	return(regs.x.ax);

}

/*
	eatChars() - clean out active port (port->)
*/
eatChars()
{
	while(instat())
		inchar();
}


/*
	flow_off() - flow control off, raise DTR and CTS
*/
void
flow_off(portid)
int portid;
{
	io_bios(portid, MFLOWOFF);
}


/*
	flow_on() - flow control on, lower DTR and CTS
*/
void
flow_on(portid)
int portid;
{
	io_bios(portid, MFLOWON);
}

/************************************************************************
 * getchar() -  Return character from current input.
 ************************************************************************/
char pgetchar()
{
	char ch;

	if (port->id == 'L')
		ch = bdos(7,0,0);     /* same as getch */
	else
		ch = comin(port->idn) & 0x7f;

	return(ch);
}



/************************************************************************
 * inchar() -  Return character from current input w/CONSOLE Echo
 ************************************************************************/

char inchar(ww)
WINDOWPTR ww;
{
	char ch, pgetchar();

	ch = pgetchar();

	if (port->id != 'L') {
		if ((ch != BELL) || alow_bell)
			wn_xputc(ww,ch);
		if (ch == '\r') {
			wn_xputc(ww,'\n');
		}
	}

	return (ch);
}


/*******************************************************************
 * instat() - Return non-zero if a character waits at current input.
 *******************************************************************/

instat()
{

	if (port->id == 'L')
		return( kbstat());
	else
		return(comstat(port->idn));
}

/***********************************************************************
 *  charout() - Put the character out the proper port,
 *  	        Note special handling of end-of-line character.
 ***********************************************************************/
void
charout(ch)
char ch;
{

	if (port->id != 'L') { 
	
		while (!comtxrdy(port->idn)) giveaway(1);
	
		if (ch == '\n') {
			comout(port->idn, '\r');
			if (port->type & P_TNC)	/* only cr to a tnc in converse mode */
				return;
			while (!comtxrdy(port->idn)) giveaway(1);
		}
		comout(port->idn, ch);
	}

}




/***********************************************************************
 *  outchar() - Put the character out the proper port,
 *  	        echo to console if port is not the console.
 *  	        Note special handling of end-of-line character.
 ***********************************************************************/
void
outchar(ww,ch)
WINDOWPTR ww;
char ch;
{

			/* echo send all output to console */
	if (ch == '\n') 
		wn_xputc(ww,'\r');

	if (ch != BELL || alow_bell)
		wn_xputc(ww,ch);
	
	charout(ch);

}


/************************************************************************
 *	port_xst() - test if port has been initialized by X00.SYS or MBBIOS,
 *  if it has, it is set up at 1 stop, no parity, 8 data bits, and baudrate
 *  *** WARNING *** WARNING *** in the FOSSIL driver this call will clear
 *  transmit and receive buffers, use it wisely!
 ************************************************************************/
port_xst(pp,ww)
PORTS	*pp;
WINDOWPTR ww;
{
		int ret = TRUE;		
		char *cp;
		
		if (io_bios(pp->idn,INITDRVR) == 0xAA55) {
			if (pp->type & P_BPQ) {
				cp = "G8BPQ";
			} else {
				cp = "MBBIOS";
			}				

				/* init MBBIOS3.2 for XMIT buffering and hdwr handshake	*/
			io_bios(pp->idn,SETOPT+XMTBUF+HRDSHK); 
			wn_printf(ww," - COM%d port, %s Driver initialized",
				pp->idn+1, cp);
				
		} else {
			wn_printf(ww," - COM%d port, NO IO Driver found\n", pp->idn+1);
			ret = FALSE;
		}
		return (ret);
}


/*
	sendbreak() - send break out port
*/
void
sendbreak(portid)
int portid;
{
	io_bios(portid,MSNDBRK);
}


setbaud(idn,rate)
int idn;
unsigned rate;
{
	unsigned baudrate;
	
	switch(rate) {
	case 300:
		baudrate = B300;
		break;
	case 600:
		baudrate = B600;
		break;
	case 1200:
		baudrate = B1200;
		break;
	case 2400:
		baudrate = B2400;
		break;
	case 4800:
		baudrate = B4800;
		break;
	case 9600:
		baudrate = B9600;
		break;
	case 19200:
		baudrate = B19200;
		break;
	case 38400:
		baudrate = B38400;
		break;
	default:
		return(FALSE);
	}
	io_bios(idn,SETUPDRV+NPARITY+CS8+STOP1+baudrate);
	return (TRUE);
}

havedcd(pp)
PORTS *pp;
{
	union REGS regs;
	if (pp->type & P_BPQ) {
		regs.x.dx = pp->idn;	
		regs.x.ax = BPQCALL;
		int86(0x14,&regs,&regs);
		return(regs.x.si != 0);
	} else {
		return(chekdcd(pp));
	}	
}



/*******************************************************************
 * usr_gone() - if available checks for a hardware (this case DCD)
 *	indication of the user having gone bye-bye. hasDCD is set
 *      in CONFIG on port by port basis and is for TNC2 or TNC1 with
 *      DCD wired to provide CONNECT status to pin 8 of RS232C cable
 *      |br| 12/31/87
 *******************************************************************/
usr_gone()
{
    if (!(port->type & P_CONSOLE))
		if (port->mode & (REMOTE|SYSOP|FORWARD|INPROCESS))
			if (!havedcd(port))	
				return (TRUE);
    return(FALSE); /* always false unless capacity exists and configged */
}
