/*
	RMAILER [Remote Multi-Receipient Mail Exploder] 
    ver 1.00
    based upon v 2.03 RMAILER (C) 1992, 1993   Frank Warren, Jr. (KB4CYC)
    
	License granted for use by any amateur radio PBBS SYSOP.
	License granted for use by any MARS, CAP, or RACES PBBS SYSOP.
	License also granted for redistribution of the full package as recieved
	without fee (other than cost of media and postage if not provided by the
	receiving party) within the above populations.
	All other rights reserved by the author.
*/

#include        <stdio.h>
#include        <ctype.h>
#include        <string.h>
#include        <time.h>
#include		<dos.h>

/* makes sure MSC 5.1 likes its stringy stuff */
#define	lc			strlwr
#define	uc			strupr
#define strncmpi	strnicmp
#define strcmpi		stricmp


#define TRUE    1
#define FALSE   0
#define ERROR   -1

#define NARG	16

#define MAILST	0
#define RMAIL	1
#define RESEND	2

#define LNLEN	513

char	embid[20];
char *hnam;
char *rmail_ver = "1.03";

#include "rose_ver.c"

void main(int argc, char *argv[])
{
FILE    *ifp, *ofp, *lfp, *tf1, *tf2, *tf3, *ctf, *fopen();

int     opti, i, j, scnt, isbody, tcount, acount, killit, nogotit,
		notoln, nosubj, nofrm, norto, isrmail, ckcontln, complen,
		no_disp_to;

char    iline[LNLEN], toline[LNLEN], isto[LNLEN], sline[LNLEN], 
		compline[16], rhdr1[80], csign[8], sbjln[80], logfn[256], distfn[256],
		rplyfn[256], *distdir,
		*logdir, *sllist[10], *tolst[40], *ifn, *ofn,
		*whoto, *lstnam, *whofrm, *grabbs, *scratch,
		*clean_line(), *pcall(), *paddrs(), *uc(), *remnl(), *getenv();

int		confirm		= FALSE;
int		aconfirm	= FALSE;
int		no_dlist;
int		list_restrict;
int		subscribe;

char	from_line[65];
char	opt[8];

char	*IDchar_def = " $";
char	*IDchar_use = NULL;

	int isnblank(char *s);
	int parseadrln(char *iln,FILE *opf);
	int get_line(char *s,int n,FILE *ifp);

	char	*NOwrite = "Could not open %s for writing\nProcess ABORTED\n\n";
	char	*NOread  = "Could not open %s for reading\n\n";
	char	*NOappend= "Could not open %s to append\n\n";
	char	*dlist_f  = "=======< %s >=======\n~GET %s\n=======<EOF>=======";
	char	*n_dlist_f= "Access to %s is restricted";
	char	*n_subsc  = "Subscription to %s is restricted. Sysop will be notified or your request.\n";
	char	*subsc  = "Your subscription to %s has been processed.\n";

	char	mtyp;
	
	void exit(int x);

	char *arpadate(void);
	char *p, *s;
	int	msg_class, embd;
	char *to_addr, *ebid;
	char *tfn1 = "RM1XXXXX";
	char *tfn2 = "RM3XXXXX";

	mktemp(tfn1);
	mktemp(tfn2);
		
	logdir = ".";
	distdir = "sys";
	ifn = "rmailer.exp";
	ofn = "rmailer.imp";
	hnam = NULL;
	killit = TRUE;
	ckcontln = FALSE;
	complen = 6;
	strcpy(compline,"rmail@");
	for (i=0;i++ <40;) tolst[i] = NULL;

	printf("\n RMAILER - ROSERVER/PRMBS Remote Multi-Recipient Mail Exploder\n");
	printf("\tVer %s compatible with ver %s, %s\n\n",
		rmail_ver,version,mbdate);
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s ; s++) {

			switch (tolower(*s)) {
		    case 'd' :
				distdir = argv[1];
		    	argv++;
		    	argc--;
		        break;
		    case 'l' :
		        logdir = argv[1];
		    	argv++;
		    	argc--;
		        break;
		    case 'r' :
		        ifn = argv[1];
		    	argv++;
		    	argc--;
		        break;
		    case 'w' :
		        ofn = argv[1];
		    	argv++;
		    	argc--;
		        break;
		    case 's' :
		        killit = FALSE;
		        break;
		    case 'a' :
		        aconfirm = TRUE;
		        break;
		    case 'i' :
		    	IDchar_use = s+1;
		    	if (strchr("%$#",*IDchar_use) == NULL)
		    		IDchar_use = "";
		    	break;
		    }
		    	
		}
	}
	if ((p = getenv("RMO")) == NULL) {
			strcpy(opt,"");
	} else {
		strnxcat(opt,strupr(p),4);
		for (s = p ; *s ; s++) {
			switch(*s) {
		    case 'S' :
		        killit = FALSE;
		        break;
		    case 'A' :
		        aconfirm = TRUE;
		        break;
		    case 'I' :
		    	IDchar_use = s+1;
		    	if (strchr("%$#",*IDchar_use) == NULL)
		    		IDchar_use = "";
		    	break;
			}
		}
	}


	if ( argc == 0 ) {
		fprintf(stderr," usage: rmailer [-a] [-s] [-ic] [-r ifil] [-w ofil] [-d ddir] [-l ldir] hname\n");
		fprintf(stderr,"  hname   - full hierarchical name of target BBS   (required)\n");
		fprintf(stderr,"  -a      - send address correction message        (default OFF)\n");
		fprintf(stderr,"  -s      - do NOT erase (SAVE) input textfile     (default erase )\n");
		fprintf(stderr,"  -ic     - set ID character to 'c'                (default $ )\n");
		fprintf(stderr,"  -r ifil - standard export file used for input    (default RMAILER.EXP)\n");
		fprintf(stderr,"  -w ofil - standard export file created as output (default RMAILER.IMP)\n");
		fprintf(stderr,"  -d ddir - directory location for DST files       (default - SYS)\n");
		fprintf(stderr,"  -l ldir - directory location for LOG output      (default - .)\n\n");
		fprintf(stderr,"    RMAILER is a multi-recipient message remailing program created\n");
		fprintf(stderr,"    for any system cabable of producing/taking  W0RLI standard ASCII\n");
		fprintf(stderr,"    message text files in the WA7MBL import/export format. It is based\n");
		fprintf(stderr,"    upon RMAILER v2.03/2.05 (copr)1992-3 KB4CYC and enhanced for PRMBS.\n\n");
		exit(1);
	} 
	
	hnam = uc(argv[0]);
	sprintf(compline,"RMAIL@%.7s",hnam);
	pcall(&compline[6]);
	complen = strlen(compline);
	strcpy(csign,&compline[6]);


	sprintf(rplyfn,"%s/Reply-To.log",distdir);

	if (( ifp = fopen( ifn, "rt" )) == NULL ) {
		fprintf( stderr,NOread,ifn);
		exit(1);
	}

	while (fgets(iline,LNLEN,ifp) != NULL){

		*from_line = '\0';
		grabbs = "";
		
		if (strncmp(iline,"SP",2) != 0	 && 
			strncmp(iline,"SB",2) != 0   )
		    continue;
		    
		strcpy(sline,iline);

		notoln	= TRUE;
		nosubj	= TRUE;
		nofrm	= TRUE;
		norto	= TRUE;
		nogotit	= TRUE;
		
		no_disp_to = FALSE;

		to_addr= "";
		
		scnt = parse_line(sllist,sline);
		lstnam = sllist[1];
		if (*sllist[2] == '@') {
			whofrm = sllist[5];
			to_addr= sllist[3];
			ebid   = sllist[6]+1;
		} else {
			whofrm = sllist[3];
			ebid   = sllist[4]+1;
		}
			
		sprintf(distfn,"%s/%s.dst",distdir,lstnam);


		if (( ctf = fopen( tfn1, "wt+" )) == NULL ) {
		    fprintf( stderr,NOwrite,tfn1);
		    exit( 2 );
		}

		if (strncmpi("rmail",lstnam,5) != 0) {
			msg_class = MAILST;
		    tf3 = fopen( distfn, "rt" );
		}
		if (strncmpi("rmail",lstnam,5) == 0 || tf3 == NULL) {
			msg_class = RMAIL;
			if (tf3 == NULL)
				msg_class = RESEND;
		    if (( tf3 = fopen( tfn2, "w+" )) == NULL ) {
		        fprintf( stderr,NOwrite,tfn2);
		        exit( 2 );
		    }
		}

		sprintf(logfn,"%s/%s.log",
			logdir,(msg_class == RESEND) ? "RESEND" : lstnam);
		if (( lfp = fopen( logfn, "at" )) == NULL ) {
		    fprintf( stderr,NOwrite,logfn);
		    exit( 2 );
		}

		fprintf(lfp,"# Processed by RMAILER v%s on %s\n",
				rmail_ver, arpadate());
		fprintf(lfp,"%s",iline);

		isbody = FALSE;

		fgets(iline,LNLEN,ifp);
		strncpy(sbjln,iline,79);
		remnl(sbjln);
		fprintf(lfp,"%s\n",sbjln);

		if (msg_class == RESEND) {
			fprintf(tf3,"%s",lstnam);
			if (*to_addr)
				fprintf(tf3,"@%s",to_addr);
			fprintf(tf3,"\n");
			lstnam = "DAEMON";
		}					            	


		rhdr1[0] = '\0';

		while (fgets(iline,LNLEN,ifp) != NULL){

		    fprintf(lfp,"%s",iline);

		    if (nofrm) 
		    	if (strncmp("From:",iline,5) == 0) {
		    		nofrm = FALSE;
		    		if (norto)
		    			strcpy(from_line,iline+6);
		    	} else {
		    		nofrm = TRUE;
		    	}
		    if (norto) 
		    	if (strncmp("Reply-To:",iline,9) == 0) {
		    		norto = FALSE;
	    			strcpy(from_line,iline+10);
				} else {
					norto = TRUE;
				}
				
		    if (nosubj) 
		    	nosubj	= (strncmp("Subject:",iline,8) != 0);

		    if (ckcontln) {
		        if ((iline[0] == ' ') || (iline[0] == '\t'))
		            parseadrln(iline,tf3);
		        else
		            ckcontln = FALSE;
		    }
		    if (strncmpi(iline,"To:",3) == 0 			|| 
				strncmpi(iline,"To  :",5) == 0 			|| 
		    	strncmpi(iline,"Resent-To:",10) == 0	){
		        notoln = FALSE;
				if (nogotit) {
			        switch (msg_class) {

			        case RMAIL:
		            	strcpy(toline,iline);
		            	acount = parse_line(tolst,toline);
						if (acount > 2 								&& 
							strncmpi(tolst[1],compline,complen) == 0){
		                	nogotit = FALSE;
		                	parseadrln(iline,tf3);
		                	ckcontln = TRUE;
		            	}
		            	break;
		            	
					case MAILST:
					case RESEND:
	                	nogotit = FALSE;
	                	break;
			        }
				}
				prepend("X-",iline,LNLEN-1);
				fprintf(ctf,"%s",iline);

		    } else {
		        if (isbody || strncmp(iline,"R:",2)) {
		            if (isbody || isnblank(iline)) {
		                if (strncmp(iline,"Message-ID:",11) == 0) {
		                    prepend("X-",iline,LNLEN-1);
		                } else {
		                    isbody = TRUE;
						}
						fprintf(ctf,"%s",iline);
		            }
		        } else {
		            strncpy(rhdr1,iline,79);
		        }
		        if (strncmpi(iline,"/ex",3) == 0)
		            break;
		    }
		}
		if (( ofp = fopen( ofn, "at" )) == NULL ) {
		    fprintf(stderr,NOappend,ofn);
		    exit(1);
		}
		
		if (nofrm && norto) {
			if (s = strchr(rhdr1,'@')) {
				if (*(++s) == ':') 
					s++;
				grabbs = paddrs(s);
			}
			sprintf(from_line,"%s@%s",
			    	whofrm,(*grabbs == '\0') ? hnam : grabbs);
		}

		if (msg_class == MAILST) {
		    confirm = TRUE;
		} else {
			confirm = FALSE;
		    rewind(tf3);
		}

    	no_dlist		= FALSE;
    	list_restrict	= FALSE;
		subscribe		= ERROR;

		while (get_line(isto,LNLEN,tf3)) {

		    if (isto[0] == '#') 
		    	continue;
		    rewind(ctf);
		    
			embd	= FALSE;
			whoto	= clean_line(isto);

			if (*whoto == '\0')
				continue;
				
		    if (strncmpi(whoto,"*CONFI",6) == 0) {
		    	confirm = TRUE;
		    	continue;
			}
		    if (strncmpi(whoto,"*NOCON",6) == 0) {
		    	confirm = FALSE;
		    	continue;
			}

			if (msg_class == MAILST) {
			    if (strncmpi(whoto,"*NOLIS",6) == 0) {
			    	no_dlist = TRUE;
			    	continue;
			    }
			    if (strncmpi(whoto,"*RESTR",6) == 0) {
			    	list_restrict = TRUE;
			    	continue;
			    }
				
				if (strncmpi(sbjln,"SENDLIST",8) == 0	){

					sprintf(sbjln,"%s Distribution List",lstnam);
					if (no_dlist)
						sprintf(iline,n_dlist_f,sbjln);
					else
						sprintf(iline,dlist_f,sbjln,distfn);
						
					make_con_msg(ofp,lstnam,whofrm,grabbs,csign,sbjln,iline);	

					confirm = FALSE;
					break;
				}
				
				
				if (strncmpi(sbjln,"SUBSCRIBE",9) == 0	) {
					if (list_restrict) {
						make_con_msg(ofp,lstnam,"SYSOP","",
							csign,sbjln,from_line);	
						sprintf(iline,n_subsc,lstnam);
					} else {
						sprintf(iline,subsc,lstnam);
					}

					make_con_msg(ofp,lstnam,whofrm,grabbs,
						csign,sbjln,iline);	
					subscribe = TRUE;
					confirm = FALSE;
					break;
				}
				
				if (strncmpi(sbjln,"UNSUBSCRIBE",11) == 0) {
					if (list_restrict) {
						make_con_msg(ofp,lstnam,"SYSOP","",
							csign,sbjln,from_line);	
					}
					subscribe = FALSE;
					confirm = FALSE;
					break;
				}
			}

			if (strncmpi("***EOF",whoto,6) == 0)
				break;
			
			if (*whoto == '$') {
				embd = TRUE;
				whoto++;
			}
							    
			if (s = strchr(whoto,'/')) {
				mtyp = *whoto;
				whoto= s+1;
			} else {
				mtyp = ' ';
			}		    

			paddrs(whoto);

			if (*whoto == '\0')
				continue;

			if (scratch = strchr(whoto,'@')) 
				*scratch++ = '\0';
			
					/* don't send copy to sender - wasteful */

			if (msg_class == MAILST && strcmpi(whofrm,whoto) == 0)
				continue;

			if (strncmp(whoto,"RMAIL",5) == 0)
				mtyp = 'P';

	    	if (scratch == NULL) 
	    		sprintf(iline,"S%c %s < %s",mtyp,whoto,whofrm);
	    	else
	        	sprintf(iline,"S%c %s @ %s < %s",mtyp,whoto,scratch,whofrm);

			if (*embid)
				strcat(iline,embid);
			else
				if (IDchar_use == NULL)
					strcat(iline,IDchar_def);
				else
					if (*IDchar_use)
						sprintf(iline,"%s %c", iline,*IDchar_use);
									
					
				/* print SEND line, title, Resent-Sender lines */
				
		    fprintf(ofp,"%s\n%s\nResent-Sender: %.6s@%s (%s)\n",
		    	uc(iline), sbjln,lc(lstnam),lc(hnam),arpadate());


				/* print new To: line */

			fprintf(ofp,"To: %s", lc(whoto));
		    if (scratch) {
				fprintf(ofp,"@%s", lc(scratch));
		        if (strncmpi("RMAIL", whoto,5) == 0) {
					if (embd)
						fprintf(ofp,"$%s", uc(ebid));
					while (fgets(iline,LNLEN,tf3) != NULL) {
						if (iline[0] == '#') 
					       	continue;
						s = clean_line(iline);
						if (*s == '\0')
							continue;
						if (msg_class == MAILST && strcmpi(whofrm,s) == 0)
							continue;

						if (strncmpi("RMAIL", s,5) == 0) {
				            fprintf(ofp,",\n %s",lc(s));
							parse_rmail(tf3,ofp, msg_class == MAILST,whofrm);
						} else {
							if (strncmpi("***EOF",s,6)  == 0 ||
					       		strncmpi("*** EOF",s,7) == 0 ){
				        	   	break;
				        	} else {
				       	 		paddrs(s);
				           		fprintf(ofp,", %s",lc(s));
				           	}
						}
					}
		        }
			}
		    fprintf(ofp,"\n");
			*embid = '\0';

				/* take care of rest of 822 stuff */


		    if (nofrm && norto) {
		        fprintf(ofp,"Reply-To: %s@%s\n",whofrm,
		            (*grabbs == '\0') ? hnam : grabbs);
			}
				
		    if (nosubj) {
		        fprintf(ofp,"Subject: %s\n",sbjln);
			}

		    if ((msg_class != RMAIL) && nofrm && norto && nosubj && notoln)
		        fprintf(ofp,"\n");

				/* get rest of 822 header from tf1 and print */
				
		    while (fgets(iline,LNLEN,ctf) != NULL)
		        fprintf(ofp,"%s",iline);

		    fflush(ofp);
		    if (msg_class == RESEND) {
		    	if (aconfirm) {
		    	
				    sprintf(iline,"Please be advised that %s is not the\n",
				    	uc(hnam));
				    sprintf(iline,"%slisted Home BBS for %s. The above message was received\n",
				    	iline, uc(whoto));
				    sprintf(iline,"%sand re-addressed this date to %s @ %s",
				    	iline, uc(whoto), uc(scratch));
					make_con_msg(ofp,lstnam,whofrm,grabbs,csign,sbjln,iline);
				}
		    	break;
		    }
		}

		fclose(lfp);
		fclose(ctf);
		fclose(tf3);
		fclose(ofp);

		if (subscribe != ERROR)
			mod_dist(subscribe,from_line,distfn,list_restrict);
			
		if (confirm) {
			s = "The above message processed this date";
			make_con_msg(ofp,lstnam,whofrm,grabbs,csign,sbjln,s);
		}
		

		if (( lfp = fopen( rplyfn, "at" )) == NULL ) {
		    fprintf( stderr,NOappend,rplyfn);
		} else {
			if (s = strchr(paddrs(from_line),'@')) {
				*s++ = '\0';
			    fprintf(lfp,"%s %s@%s\n",from_line, from_line,s);
			}
		    fclose(lfp);
		}


	}
	fclose(ifp);
	unlink(tfn1);
	unlink(tfn2);
	if (killit) 
		unlink(ifn);
}

make_con_msg(outfl,sender,whoto,whereat, whofrom, subject,message)
FILE *outfl;
char *sender, *whoto, *whereat, *whofrom, *subject, *message;
{
	if (strncmpi(subject,"Re: ",4) != 0)
		prepend("Re: ",subject,79);
    fprintf(outfl,"SP %s @ %s < %s $\n%s\n",whoto,
        (*whereat == '\0') ? uc(hnam) : whereat,whofrom,subject);
    fprintf(outfl,"Date: %s\n",arpadate());
    fprintf(outfl,"To: %s@%s\n",lc(whoto),
    	(*whereat == '\0') ? lc(hnam) : lc(whereat));
    fprintf(outfl,"Sender: %.6s@%s\n",sender,lc(hnam));
    fprintf(outfl,"Subject: %s\n\n",subject);
    fprintf(outfl,"%s",message);
    fprintf(outfl,"\nby ROSErver/PRMBS ReMailer v%s\n/EX\n",rmail_ver);
    fflush(outfl);

}


int parseadrln(char *iline,FILE *opf)
{
	int	acount, i;
	char	*tolist[64], *ebid, wkline[2*LNLEN];

	strcpy(wkline,iline);

	acount = parse_line(tolist,wkline);
	
	if (isalpha(wkline[0])) {
		i = 2;
		if (ebid = strchr(tolist[1],'$')) {
			*ebid++ = '\0';
			sprintf(embid," $%s",ebid);
		} else {
		    *embid = '\0';
		}
	} else {
		i = 0;
	}

	for (;i < acount;i++) {

		if (strncmpi(tolist[i],"***EOF",6) != 0 &&
			strncmpi(tolist[i],"*NOCON",6) != 0 &&
			strncmpi(tolist[i],"*CONFI",6) != 0)
			paddrs(tolist[i]);

		fprintf(opf,"%s\n",tolist[i]);
	}

	return(--acount);
}

int isnblank(char *s)
{

	return(strlen(s) && (strspn(s," \t\r\n") < strlen(s)));

}
parse_rmail(fpin,fpout,is_mailst,whfrm)
int	is_mailst;
char *whfrm;
FILE *fpin, *fpout;
{
	char iline[LNLEN], *s;
	
	while (fgets(iline,LNLEN,fpin) != NULL) {
		if (iline[0] == '#') 
	       	continue;
		s = clean_line(iline);
		if (*s == '\0')
			continue;

		if (is_mailst && strcmpi(whfrm,s) == 0)
				continue;
		if (strncmpi("RMAIL", s,5) == 0) {
            fprintf(fpout,",\n %s",lc(s));
			parse_rmail(fpin,fpout,is_mailst,whfrm);
		} else {
			if (strncmpi("***EOF",s,6) == 0 ||
        		strncmpi("*** EO",s,6) == 0 ){
            	fprintf(fpout,", ***EOF");
            	break;
        	} else {
				if (strncmpi(s,"*NOCON",6) != 0 &&
					strncmpi(s,"*CONFI",6) != 0 )
		        		paddrs(s);
            	fprintf(fpout,", %s",lc(s));
			}
        }
	}
}




/*
	pcall() - 	Parse trailing ssid from call.
				store sid as small number in a character
*/
char *pcall(p)
register char *p;
{
	char *cp;
	
	cp = uc(p);

	while(*p) {
		if (!isalnum(*p)) {
			*p = '\0';
			break;
		}
		p++;
	}
	return(cp);
}
char * paddrs(p)
register char *p;
{
	char *cp;
	
	cp = uc(p);

	while(*p) {
		if (!isalnum(*p) && strchr("@_#.",*p) == NULL) {
			*p = '\0';
			break;
		}
		p++;
	}
	return(cp);
}

parse_line(argv,tlin)
char **argv, *tlin;
{
	register char *tline;
	char *cp, *tail_ptr();
	char *tline_end;
	extern char *eat_white();
	int argc;
	int	qflag	= FALSE;

	tline = tlin;		/* point to start of line		*/
	remnl(tline);		/* Remove cr/lf 				*/
	
	tline_end = tail_ptr(tline);
	

	for (argc = 0 ; argc < NARG ;) {

		argv[argc] = "";	/* initialize argument */
		if (*tline == '\0')
			break;

			/* Skip leading white space */
		tline = eat_white(tline);
			
			/* white space eaten, is anything left?? */
		if (*tline == '\0')
			break;

		qflag = FALSE;			/* clear quote flag					*/

		if (*tline == '"'){		/* Check for quoted token			*/
			tline++;			/* Suppress quote 					*/
			qflag = TRUE;
		}

		argv[argc++] = tline;	/* Beginning of token 				*/

			/*	Find terminating delimiter, if quote flag on look
				for quote, else look for 'white space' ( ' ' or '\t'
				end of line terminates in anycase
			*/
		if (qflag) {
			if (cp = strchr(tline,'"')) {	
				*cp++ = '\0';
				tline = cp;
			} else {
				tline = tline_end;
			}
		} else {
			if	((cp = strchr(tline,' ' ))	|| 
				 (cp = strchr(tline,'\t'))	){
				*cp++ = '\0';
				tline = cp;
			} else {
				tline = tline_end;
			}
			uc(argv[argc-1]);	/* upper case non-quoted arguments */
		}
	}
	return(argc);
}

char *days[7] = {
	"Sun","Mon","Tue","Wed","Thu","Fri","Sat" };

char *months[12] = { 
		"Jan","Feb","Mar","Apr","May","Jun",
		"Jul","Aug","Sep","Oct","Nov","Dec" };

/* Return Date/Time in Arpanet format in passed string */
char *arpadate()
{
	register struct tm *ltm;
	struct tm *gmtime();
	static char tz[4];
	static char str[64];
	time_t t, time();
	extern char *getenv();
	/* Print out the time and date field as
	 *		"DAY day MONTH year hh:mm:ss ZONE"
	 */

	char *p;


	/* Read the system time */

	time(&t);
	ltm = localtime(&t);

	if (*tz == '\0')
		if ((p = getenv("TZ")) == NULL)
			strcpy(tz,"GMT");
		else
			strnxcat(tz,strupr(p),3);

	/* rfc 822 format */
	sprintf(str,"%s, %.2d %s %02d %02d:%02d:%02d %s",
		days[ltm->tm_wday],
		ltm->tm_mday,
		months[ltm->tm_mon],
		ltm->tm_year,
		ltm->tm_hour,
		ltm->tm_min,
		ltm->tm_sec,
		tz);
	return(str);
}

char *EOFstr = "*** EOF\n";

/*
	prepend() - place a new string in front of an old string and leave
				in buffer of old string (maximum size LINELEN);
*/
prepend(new,old,maxlen)
char *new, *old;
int maxlen;
{
	char buf[LNLEN+32];
	
	sprintf(buf,"%s%s",new,old);
	strnxcat(old,buf,maxlen);
}


/******************************************
 * remnl() - remove CR CRLF or LF
 ******************************************/
char *remnl(cp)
char *cp;
{
	char *p, *tail_ptr();
	
	p = tail_ptr(cp) - 1;
	while (*p == '\n' || *p == '\r') 
		*p-- = '\0';
	return(cp);
}

/*
	remove_trail_char() - finds last occurrence of char in string and
		replaces with null character
*/
remove_trail_char(cp,c)
char *cp, c;
{
	char *p;
	
	if (p = strrchr(cp,c))
		*p = '\0';
}

/*
	strnxcat() - strncat with initial NULL
*/
strnxcat(dest,src,len)
char *dest, *src;
int len;
{
	*dest = '\0';
	strncat(dest,src,len);
}

/*
	strl2cmp() - strncmp-like where length is limited by length
	of cp2
*/
strl2cmp(cp1,cp2)
char *cp1,*cp2;
{
	return(strncmpi(cp1,cp2,strlen(cp2)));
}

/*
	tail_ptr() points to first char after a string 
*/
char *tail_ptr(cp)
char *cp;
{
	return(cp+strlen(cp));
}

/*
	eat_white() - eats whitespace at strat of a string
*/
char *eat_white(cp)
char *cp;
{
	while (*cp && strchr(" \t",*cp))
		cp++;
	return(cp);
}

/*
	clean_line() - removes CR-LF's and leading blanks and tabs
*/
char *clean_line(cp)
char *cp;
{
	char *p;
	
	p = remnl(cp);
	p = eat_white(p);
	return(p);
}

mod_dist(subscr,frm,dfn,restr)
char *frm, *dfn;
int subscr, restr;
{
	FILE *dfl, *tfl;
	char *msgtemp3 = "RM3XXXXX";
	
	int	match_found = FALSE;

	char tline[256];
	char tlin2[128];
	char tcall1[12];
	char tcall2[12];
	char *p, *fst, *bbs_date();
	
	mktemp(msgtemp3);
	unlink(msgtemp3);
	
	strnxcat(tcall1,frm,6);
	

	if (dfl = fopen(dfn,"rt")) {
		if (tfl = fopen(msgtemp3,"wt")) {
			while (!feof(dfl)) {
				if ((fst = fgets(tline,256,dfl)) == NULL )
					continue;
				p = clean_line(tline);
				if (*p == '\0')
					continue;
				strnxcat(tlin2,p,127);
				if (!match_found) {
					if (strcmpi(frm,paddrs(tlin2)) == 0) {
							/* if SUBSCRIBE and match, end it do nothing */	
						match_found = TRUE;
						if (subscr) {
							fclose(dfl);
							fclose(tfl);
							return;
						}
					} else {
						strnxcat(tcall2,tlin2,6);				
						if (strcmpi(pcall(tcall1),pcall(tcall2)) == 0) {
							match_found = TRUE;
							if (subscr) {
								if (restr)
									fprintf(tfl,"# %s (CR) ",bbs_date());
								fprintf(tfl,"%s\n",frm);
								if (!restr)
									fprintf(tfl,"# %s (C)  ",bbs_date());
							}
						}
					}
					if (match_found && !subscr) {
						if (restr)
							fprintf(tfl,"# %s (UR) %s\n",bbs_date(),frm);
						else
							fprintf(tfl,"# %s (U)  ",bbs_date());
					}
				}
				fprintf(tfl,"%s\n",p);
			}
			if (!match_found) {
				if (subscr) {
					if (restr)
						fprintf(tfl,"# %s (SR) ",bbs_date());
					fprintf(tfl,"%s\n",frm);
				} else {
					fprintf(tfl,"# %s (UN) %s\n",bbs_date(),frm);
				}
			}
			
			fclose(dfl);
			fclose(tfl);

			strcpy(tline,dfn);
			if (p = strchr(tline,'.'))
				*p = '\0';
			strcat(tline,".BAK");
			unlink(tline);

			rename(dfn,tline);
			rename(msgtemp3,dfn);
		}
	}	
}



char *bbs_date()
{
	static char dateline[9];
	time_t l;
	struct tm *ctim;
	
	time(&l);
	ctim = gmtime(&l);	
	
	sprintf(dateline,"%02d-%-3.3s-%02d",
			ctim->tm_mday,months[ctim->tm_mon],ctim->tm_year);
	return(dateline);
	
}	

 