/* utils.c */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#define FALSE 0
#define TRUE  1

/*
 * get_line(): takes 3 arguments arg1: array in which line is placed
 * arg2: length of line arg3: a file pointer to file from which line
 * is to be read
 */

get_line(in_line, line_len, fp)
char	*in_line;
int     line_len;
FILE    *fp;
{
    int             c, i;
    i = 0;
    /*
     * what we are doing here is reading untill we hit the line
     * length and then if we are not at the end of a line (new line)
     * we'll continue reading but disregarding those characters. if
     * we hit end of file (EOF) or a new line we break out.
     */
    while ((c = fgetc(fp)) != '\n' && i < line_len && c != EOF) {
	if (i < (line_len - 1)) {
	    in_line[i] = c;
	    i++;
	}
    }
    in_line[i] = '\0';
    if (c == EOF)
	return (FALSE);
    else
	return (TRUE);
}

void
stripper(str)
char	*str;
{
    int		idx;

    for(idx = strlen(str)-1; (idx>=0) && (str[idx]==' '); idx--)
		str[idx] = '\0';

    return;
}

