/*****************************************************************
 *  MBUTIL.C - 11/9/86 - Utility functions.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for
 *  reasonable reimbursement for expense of delivery, to include
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"
#include <varargs.h>
/*
char *malloc();
*/
char msgfile[128];
int flds;
char *fld[MAXFLDS];
char *lgfile = "";
extern char h_loc_fil[128];
extern char *msgs_fil;
extern time_t sys_time;

#define DEFAULT -2

/*
	err_string() - goes to message file and gets message to be sent
    with *'s and bell
*/
char *err_string(ndex)
int ndex;
{
	char *cp, *fmt_token(), *sys_name();
	
	FILE *errmfil;

	char tline[LINELEN];
	char tlin2[3*CMDLEN];
	
	
	if (errmfil = fopen(sys_name(msgs_fil,""),"rt")) {
		while(!rdline(tline,LINELEN,errmfil)) {
			cp = NULL;
			if (*tline != '&') {
				cp = tline+4;
				*(cp-1) = '\0';
				if (atoi(tline) == ndex)
					break;
			}
		}
	}
	if ( cp == NULL ) {
		(void) sprintf(tlin2,"$B$V message # %d\n",ndex);
	} else {
		(void) strnxcat(tlin2,cp,127);
		while (!rdline(tline,LINELEN,errmfil)) {
			if ((*tline != '&') || (strlen(tlin2) > ((3*CMDLEN) - 82)))
				break;
			strcat(tlin2,tline+1);
		}
	}
	fclose(errmfil);
	return(fmt_token(tlin2));
}


/*******************************************************************
 * addfwd() - add call to forward list
 *******************************************************************/
addfwd(cp, lp, n, m)
char *cp, *lp;
short n, m;

{
	register i;

	for (i = 0; i < n; i++, lp += (CALLLEN+1)) {
		if (stricmp(lp, cp) == 0)
			return(n);
	}
	
	if (n < m) {
		strcpy(lp, cp);
		return(n+1);
	}
	return(n);
}


chk_adr(argc,argv)
int argc;
char **argv;
{
	char tline[LINELEN];
	int i;
	
	for (i=1 ; i < argc ; i++) {	
		strcpy(tline,argv[i]);
		check_BBS(tline);
		tprintf("  Routing for %-32s is %s\n", tline,set_route(tline,rt_edit));
	}
}

/*

	check_BBS() - checks for string in file, if no file or no match
	returns FALSE, if match returns TRUE
*/
check_BBS(cp)
char *cp;
{
	FILE *strngfl;
	char tline[LINELEN];
	char *p;

		/* 
			this cleans up for da dipshit who enters @wb2ibo-4.#nli.ny.usa 
			this cleans up the stray SSID and  ===>  @wb2ibo.#nli.ny.usa
			brute force, does it regardless whether '-4' is there or not
		*/
	
	if (*cp && (p = strchr(cp,'.'))) {
		*p++ = '\0';
		sprintf(cp,"%s.%s",pcall(cp),p);

		/* 
		   if its not null and has no '.' in it, at least it gets u-cased
		   and pcall()'ed since pointer 'cp' is acted upon directly
		*/
	} else {	
		pcall(cp);
		if (strngfl = sys_open(h_loc_fil,"rt")) {
			while (!rdline(tline,LINELEN,strngfl)) {
				if (p = strchr(tline,'.')) {
					*p = '\0';
					if (stricmp(cp,tline) == 0) {
						*p = '.';
						strnxcat(cp,remnl(tline),MTOLEN);
						break;
					}
				}
			}
			fclose(strngfl);
		}
	}
	

}

/*******************************************************************
 * check_pwd() - generate password and see if correct
 *******************************************************************/
check_pwd(pwd_str,pwd_len)
char *pwd_str;
short pwd_len;
{
	int slen, i, j, x;
	int no_match;
	static int nums[16];
	int rand();
	static unsigned count = 0;
	char tline[LINELEN];
	slen  = strlen(pwd_str);

	(void) srand(atoi(l_time)+(count++));

	for ( i = 0 ; i < pwd_len ; i++) {
		while (TRUE) {
			x = (rand() % slen);
			no_match = TRUE;
			for (j=0 ; j < pwd_len ; j++) {
				if ( x == nums[j] )
					no_match = FALSE;
			}
			if (no_match) {
				nums[i] = x;
				break;
			}
		}

		tprintf(" %03d", nums[i]);
		printf(" %c",pwd_str[nums[i]]);
	}
	sendnl();
	if (getdat(tline, sizeof(tline)-1, port->timeout)) {
    	uc(tline);
		for (i=0 ; i < pwd_len ; i++)
			if (tline[i] != pwd_str[nums[i]] )
				return (FALSE);

		return (TRUE);
	} else {
		return (FALSE);
	}
}

/*******************************************************************
 * chktime() - see if time is in specified range of hours
 *******************************************************************/
chktime(cp)
char *cp;
{
	short en, st, c;
	short is_odd;
	short ok = TRUE;
	char *hr_sel;
	
	sscanf(cp,"%2d%2d",&st,&en);

	c = ctim->tm_hour;

	is_odd = c % 2;
	hr_sel = cp + 4;
	
	uc(hr_sel);
	switch(*hr_sel) {
		case 'E':
			ok = (is_odd == 0);
			break;
		case 'O':
			ok = (is_odd == 1);
			break;
		case '3':
		case '4':
		case '6':
		case '8':
			ok = ( c % (*hr_sel - '0') == 0);
			break;
	}

	if (st <= en)
		return (ok && (c >= st) && (c <= en));
	return (ok && ((c >= st) || (c <= en)));
}

/*********************************************************************
 * do_help() - read total help or menu file, or read specific entries
 *********************************************************************/
do_help(argc,argv)
int argc;
char **argv;
{
	FILE	*hfl;
	int		done = FALSE;
	int		found = 0;
	char	tline[LINELEN];
	int		lines;
	
	lines = port->user->lines;
	
	if ((hfl = sysdir_open(helpfile,"rt")) == NULL)
		return (TRUE);

	if (argc == 1) 
		argv[1] = "ALL";

	sendnl();
	while (!done && !eat_line(tline,'!',hfl)) {
		if (wildmatch(argv[1],remnl(tline+2))) {
			while (!done && !rdline(tline,LINELEN,hfl)) {
				if (iseof(tline))
					break;;
				prtx(tline);
				found++;
				done = (abort_dl()	|| 
						paging(&lines, found, (smart_sys == ERROR)));
			}
		} else {
			passlst(hfl);
		}

	}
	if (found == 0) {
		token_lin = argv[1];
		prtx_err(MNOHELP);
	}
    fclose(hfl);
    return 0;
}


/***************************************
 * fatal - printf to console  and exit
 ***************************************/
/* VARARGS1 */
void
fatal(va_alist)
va_dcl
{
	char *fmt;
	char buf[LINELEN];
	int ret;
	va_list arg_ptr;

	va_start(arg_ptr);
	fmt = va_arg(arg_ptr, char *);
	ret = vsprintf(buf,fmt,arg_ptr);
	fputs(buf,stderr);
	log('S','E',' ',buf);
	va_end(arg_ptr);
	exit(6);
}

/********************************************************************
 * fmt_token() - format messages using token variables in the form '$_'
 ********************************************************************/
char *fmt_token(cp)
register char *cp;
{
	static char tline[CMDLEN*3];
	char *q, *s, *ntos(), *ltos(), *tail_ptr(), *bbs_date();
	int	done = FALSE;
	
	USER_RECORD	*log_user;		
 
 	s = tline;
		/* 
			start with NULLCHAR filled buffer so after character insertion  
			there is always a NULLCHAR
		*/
 	fill(s,'\0',CMDLEN*3);

	log_user = port->user;	/* save on pointer math again! */
	 	
	for (; *cp && !done && strlen(tline) < (CMDLEN*3)-2 ; cp++) {
    	if (*cp != '$') {
    		*s	= *cp;
    	} else { 
    		q = NULL;
    		switch (*(++cp)) {
	/* individual message record stuff */
			case 'A' : q = mmhs->bbs;					break;
			case 'G' : q = mmhs->to;					break;
			case 'M' : q = ltos(mmhs->number);			break;
			case 'P' : q = mmhs->from;					break;
			case ']' : q = ltos(mmhs->size);			break;
			case '8' : q = mmhs->msgID;					break;
			case '9' : q = mmhs->route;					break;
			case '*' : *s= mmhs->type;					break;
			case 'Z' : q = mmhs->title;					break;
#ifndef NEEDSPACE
			case 'J' : q = mmhs->date;					break;
			case 'K' : q = mmhs->time;					break;

	/* individual user record stuff */
#endif
			case 'I' : q = log_user->handle;			break;
			case 'N' : q = bbs_date(log_user->cr_date);	break;
			case 'U' : q = log_user->call;				break;
			case 'X' : q = bbs_date(log_user->date);	break;
			case '1' : q = log_user->qth;				break;
			case '2' : q = log_user->zip;				break;
			case '@' : q = log_user->home_bbs;			break;
			case '{' : q = log_user->address;			break;
			case '}' : q = log_user->phone;				break;

	/* port structure stuff 		*/
			case 'Y' : q = port->user->time;			break;
			case '7' : *s= port->id;					break;
#ifndef NEEDSPACE
			case 'E' : q = port->name;   				break;
			case '[' : q = ntos(port->timeout);			break;

	/* mail.dat header record stuff */
			case 'C' : q = ntos(mfhs->next_msg);		break;
#endif

			case 'L' : q = ntos(mfhs->last);			break;

	/* string/character stuff		*/
			case 'B' : *s= '\7';						break;
			case 'H' : done = TRUE;						break;
			case '%' : *s= '\n';						break;
			case 'V' : q = " *** ";						break;

			case 'F' : q = oqth;						break;
			case 'O' : q = ocall;						break;
			case 'W' : q = ohandle;						break;
			case '0' : q = ozip;						break;


	/* general system stuff			*/
			case 'D' : q = l_date;						break;
			case 'Q' :
      			 if (d_s < 0)	q = "0";
      			 else			q = ltos(d_s);
      			 										break;
			case 'R' : q = version;						break;
			case 'S' : q = token_lin;					break;
			case 'T' : q = l_time;						break;
			case '3' : q = arpadate(sys_time);			break;
			case '4' : q = mbdate;						break;
			case '5' : q = strupr(thisHost);			break;
			case '6' : q = ntos(highread);				break;
			case '#' : q = msgtemp;						break;
			case '!' : q = msgtmp2;						break;
			case '>' : q = usrdir;						break;
			case '<' : q = sysdir;						break;
			case '$' :
			default  : *s= *cp;
			}
			if (q) 
				strcat(tline,q);
		}
		s = tail_ptr(tline);
	}
	return(tline);
}




/*
	get_1_char() - get one character only from console or serial port
				   returns UPPER case character(s)
*/
get_1_char(cp)
char *cp;
{
	char tline[LINELEN];

	if (getdat(tline,port->type & (P_CONSOLE|P_MDM) ? 1 : sizeof(tline)-1,
													port->timeout)) {
		return (int) (toupper(*tline));
	} else {
		return (ERROR);
	}
}

/*
	get_byte()
*/
get_byte(cp,tbyte)
char *cp, *tbyte;
{
	int c1;
	char c;
	
	outstr(cp);
	if (port->type & P_TNC)
		sendnl();
	else
		outchar(' ');
	
	if ((c1 = get_1_char()) != ERROR) {
		if (c = (char) c1) {
			if (c != '\r') {
				*tbyte = c;
			}
		}
		return (TRUE);
	}

	return (FALSE);

}

/********************************************************************
 * getcmd() shorthand form of getdat/parse
 ********************************************************************/
getcmd()
{
	if( getdat(line, LINELEN, port->timeout)) {
		parse (cmd, line);
		return (TRUE);
	}
	return (FALSE);
}

/********************************************************************
 * getedit() prompt and input for editing
 ********************************************************************/
getedit(cp)
char *cp;
{
	int ret;
	
	outstr(cp);
	if (port->type & P_TNC)
		sendnl();
	return(getcmd());
}

/*
	getfield(cp,dest,len) - get a field to be entered or blanked
*/
getfield(cp,dest,len,pars)
char *cp, *dest;
int len,pars;
{
	int ret;
	char *p;
	
	if (ret = getedit(cp)) {
		if (flds) {
			if (pars)
				p = fld[0];
			else
				p = line;
			strnxcat(dest,p,len);
		} else {
			if (*line == ' ')
				*dest = '\0';
		}
	}
	return (ret);
}

/********************************************************************
 * getdat() - get a line of data from the current active port
 *	04 Dec 86 |br| - fixed backspace past start of entry on con-
 *                       sole input
 ********************************************************************/
getdat(buf,len,timeout)
char *buf;
int len;
{
	register char *cp;
	register int count = 0;
	int j = 16;
	
	curtim();
	settmr(timeout);
	cp = buf;

	setcolor(port->color);
	while (TRUE) {
		*cp = '\0';
		while(!instat()) {
			if (!(port->type & P_CONSOLE)) {
				switch(kb_abort()) {
				case TRUE:
					if (!(port->mode & (REMOTE|SYSOP)))
						break;

				case ERROR:
					*cp = '\0';
					return (FALSE);

				case RESETIME:
					settmr(timeout);
					break;
				}
			}
			
			/*
				timeout checks, etc - done once every 16 passes to keep from
				cluttering things up with excessive calls to timer and BPQ 
				extended DOS calls
			*/
			
			if (--j == 0) {
				j=16;		/* start counter over again */

				/*
					G8BPQ switch code lets you know if there are UNACKED 
					packets this way we can set the timeout to be more 
					reasonable and not start timing until we have sent 
					the stuff off
				*/
				if (port->type & P_BPQ)
					if (unACKed(port) > 0) 
						settmr(timeout);
					
				if (!(port->mode & IDLE) && usr_gone()) {
					port->mode = DISCON;
					return (FALSE);
				}
					/* if timeout specced as 0 - there is no timeout */
				if (timeout && (chktmr() == 0)){
					port->mode = TIMEOUT;
					return (FALSE);
				}
			}
			giveaway(1);
		}
		*cp = inchar();
				
		if (*cp == '\b') {
			if (cp > buf) {
				cp--;
				count--;
				if (port->type & P_ECHO)
					outstr("\b \b");
			}
		} else {
			if (port->type & P_ECHO)
				outchar(*cp);
			if (( ++count == len ) || (*cp == '\r')) {
				if (len == 1)
					cp++;
				*cp = '\0';
				if (port->type & P_ECHO)
					sendnl();
				/* is conn request start over */
				if (strnicmp(buf,"*** connect request:",20) == 0) {
					count = 0;
					cp = buf;
					continue;
				}
				break;
			}
			cp++;
		}
	}
	if (strncmp(buf,"*** DISCONNECTED",16) == 0) {
		port->mode = DISCON;
		return (FALSE);
	}
	return(TRUE);
}

/*********************************************************************
 * get_yes_no() - gives a prompt and asks for a yes or a no returns T/F
 *********************************************************************/
get_yes_no(cp)
char *cp;
{

	outstr(cp);
	switch (get_1_char()) {
		case 'Y':
			return (TRUE);
		case 0x0d:
			return (DEFAULT);
		case 'Q':
		case ERROR:
			return (ERROR);
	}
	return (FALSE);
}

/***********************************************************
 *  log() - Log an event.
 ***********************************************************/

int logging 	= TRUE;
int logmsgsonly	= FALSE;
int loglocal	= TRUE;


void log(evnt, fn, sfn, text)
char evnt, fn, sfn, *text;
{

	char logline[LINELEN];

	if (logging) {

		if (logmsgsonly) {
			if (evnt != 'M') 
				return;
		} else {
			if (evnt != 'M' && port->mode == SYSOP) 
				if (!loglocal)
					return;
		}
	  	curtim();
  		sprintf(logline, "%c%s%s%c%c %s", 
  				evnt, l_date, l_time, fn, sfn, remnl(text));
 		fappend(logline,lgfile);

	}

}

char *ntos(i)
unsigned int i;
{
	static char tline[8];
	sprintf(tline,"%u",i);
	return(tline);
}
char *ltos(i)
long int i;
{
	static char tline[16];
	sprintf(tline,"%ld",i);
	return(tline);
}

/*********************************************************************
 * outstr() - raw unformatted string output to port
 *********************************************************************/
outstr(cp)
char *cp;
{
	char *p;

	setcolor(col_out);
	for (p = cp; *p; p++)
		outchar(*p);
	setcolor(port->color);
}

/*
	paging() - determines, when, how much paging to do, returns
	TRUE for quit, FALSE for keep going, sets the line count as 
	it goes
*/
paging(lines,line_cnt,sys_st)
int *lines,line_cnt,sys_st;
{
	
	if (sys_st && *lines && ((line_cnt % *lines) == (*lines-1))	){

		getedit("More (Y,n,c)? ");

		switch(*fld[0]) {
		case 'N':
			return(TRUE);
		case '\0':
		case 'Y':
			break;
		case 'C':
			*lines = 0;
			break;
		default:
			if (!not_num(fld[0]))
				*lines = atoi(fld[0]);
			break;
		}

	}
	return (FALSE);
}


/******************************************************************
 * parse() - copy input line to cmd buffer then parse by white
 *  space setting pointers for fld's 0-12 and opt1
 ******************************************************************/

parse(out, in)
char *out, *in;
{
	flds = parse_cpy(fld,out,in);
	
}

/*
	parse_cmd()
*/
parse_cmd(func,cp)
int (*func) ();
char *cp;
{
	char tcmd[CMDLEN];

	parse(tcmd,cp);
	return ((*func) (flds,fld));

}

parse_cpy(argv,buf2,buf1)
char **argv, *buf1, *buf2;
{
	strcpy(buf2,buf1);
	return(parse_line(argv,buf2));
}



/**********************************************************************
 * pcall() - Parse trailing ssid from call.
 * store sid as small number in a character
 **********************************************************************/
char *pcall(cp)
char *cp;
{
	char *p;
	
	p = uc(cp);
	while(*p) {
		if (!isalnum(*p)) {
			*p = '\0';
			break;
		}
		p++;
	}
	return(cp);
}



/********************************************************************
 * prtx() - print messages using token variables in the form '$_'
 ********************************************************************/
prtx(cp)
char *cp;
{

	outstr(fmt_token(cp));

}

/*
	prtx_err() - simplifies the code by doing prtx to an err_string()
*/
prtx_err(rs_erno)
int rs_erno;
{
	outstr(err_string(rs_erno));
}



/**************************************
 * tprintf - printf to the active port
 **************************************/
/* VARARGS1 */
tprintf(va_alist)
va_dcl
{
	char *fmt;
	char buf[BUFLEN];
	int ret;
	va_list arg_ptr;

	va_start(arg_ptr);
	fmt = va_arg(arg_ptr, char *);
	ret = vsprintf(buf,fmt,arg_ptr);
	outstr(buf);
	va_end(arg_ptr);
	return(ret);	/* return what sprintf would have */
}

#ifdef WHENNEEDED
/******************************************************************
 * this is a kludge until all "calls" are null terminated strings
 ******************************************************************/
void
ctos(s,f,len)
char *s, *f;
int len;
{
	register int i;
	for ( i = 0 ; i < len ; i++) {
		if ( f[i] == ' ')
			break;
		s[i] = f[i];
	}
	s[i] = '\0';

}

/*
	proper_args()
*/
proper_args(argc,argv)
int argc;
char **argv;
{
	int i = 0;

	for ( ; i < argc; i++) {
		lc(argv[i]+1);
	}
}

#endif


/*
	rd_parse() - reads a line from file with comment removal and parses
*/
rd_parse(buf,tfil)
char *buf;
FILE *tfil;
{
	char tline[LINELEN];
	
	if (rdline(tline, LINELEN, tfil))
		return (TRUE);
		
	parse(buf,tline);
	return (FALSE);
}

/*
	check_string() - checksfor string in file, if no file or no match
	returns FALSE, if match returns TRUE
*/
check_string(cp,fname)
char *fname, *cp;
{
	FILE *strngfl;
	char tline[LINELEN];
	int ret = FALSE;

	if ((strngfl = fopen(fname,"rt")) != NULL) {
		while (!rd_parse(tline,strngfl)) {
			if (stricmp(cp,fld[0]) == 0) {
				ret = TRUE;
				break;
			}
		}
		fclose(strngfl);
	}
	return (ret);	/* no match or no file to start with */
}

char *getcolor(cp,iscolor)
char *cp;
int iscolor;
{
	static char color_line[16];
	
	if (iscolor) {
		sprintf(color_line,"\033[1;3%c;4%cm",*cp,*(cp+2));
		return (color_line);
	}
	return("");
}

setcolor(cp)
char *cp;
{
		printf("%s",getcolor(cp,color));
}

#ifndef NEEDSPACE
/*
	read2eof()
*/
read2eof(fptr)
FILE *fptr;
{
	char tline[LINELEN];
	
	while (!rdline(tline,LINELEN,fptr) && !abort_dl()) {
		if (iseof(tline))
			return (TRUE);
		prtx(tline);
	}
	return (FALSE);
}
#endif
