/*******************************************************************
 * MODULE - MBMAIL2.C - lower level message specific  handling
 *****************************************************************
 * PRMBS - Packet Radio Mailbox System  Copyright 1987
 *   by  Brian B. Riley (ka2bqe)
 *       Dave Trulli    (nn2z)
 * This code was initially based on a pre-release of the CBBS
 * code by W0RLI and VE3GYQ. It has been re-worked to the point
 * that only some structural resemblance remains. It is for the
 * most part orginal work of the authors, where other code has 
 * been incorporated appropriate credit is given.
 *    This code is hereby freely placed into the public domain
 * for use by any and all with the stipulations that (1) credit
 * line must be retained, both ours and in the case of other
 * code the appropriate authors and (2) no fee may be charged
 * for this code beyond simple expenses in transfer of the code
 * to another person to include postage, phone charges, media 
 * costs, mailers, etc)
 *------------------------------------------------------------------
 * HISTORY- created  from MBMAIL 10 Nov 86
 * 23Aug87 |br| added mail file re-position on create and cleaned up
 *              error messages
 * 01Mar87 |djt| record/file lcoking for multi-user added
 * 23Dec86 |br| many little changes but all mail/file functions appear
 *              clean now
 * 10Nov86 |br| created from MBMAIL.C to split off disk specific
 *		routines from more egenral message handlers
 * 10Nov86 |br| cleaned up kill, list and read messages, restructured
 *		header displays for read and list
 * 08Nov86 |br| modified from one big message file to individual mes-
 *              sages each as a file
 * 06Nov86 |br| modifications begun RATS/MAPRC
 *
 *******************************************************************/


#include "mb.h"

extern char *BIDfile;
extern char *EXstr;
extern void preamble();
extern int pong_max;
extern char *holdFrom;
extern char *holdTo;
extern char *holdAt;
extern char ret_path[LINELEN];

extern char xlat_fil[];
extern char *zipFIL;

int	fldopt			= FALSE;
int fld_no_bid		= FALSE;
int force_traf		= FALSE;
int holdsysopmail 	= TRUE;
int hold_local 		= FALSE;
int hold_mail 		= FALSE;
int bull_exp		= 0;

char	*rply_to = "reply-to.log";


/*******************************************************************
 * msgname() - get name of file given its message number
 *******************************************************************/
char *msgname(nr)
long int nr;
{
	static char buf[80];
	(void) sprintf(buf,"%s\\M_%06ld.MAI",msgdir,nr);
	return (buf);
} /* msg_name */

/*******************************************************************
 * msgIDstr() - create a message ID
 *******************************************************************/
char *msgIDstr()
{
	static char tline[17];
/*	
	sprintf(tline,"%d_%s\0\0\0\0",(int) ((mmhs->number % 0xffff)+1),ocall);
*/
	sprintf(tline,"%05u_%s\0\0\0\0",(unsigned) (mmhs->number & 0xffff),ocall);
	return(tline);
} /* msg_name */


#define APPEND_ID	TRUE
/*******************************************************************
 * cremsg() - create message on disk. It will reposition it self to 
 *            mail header record it was looking at when it started
 *******************************************************************/
cremsg(infile)
char	*infile; 
{
	int		mh, mh_old, mh_new;
	int		i = 0;
	int		to_distrib	= FALSE;

	char	*p, *q, *r;	
	char	*add2date(), *edit_route(), *set_route();
		
	char	mmtype, mstat,	tbuf[64];
	char	callbuf[CALLLEN+1];
	char 	p_msgID[IDLEN+1];
	char	msg_txt_fl[80];
	
	extern	char	*hamcaltab[], *servcaltab[], *sysop, *holdFil;

    mh_old = mmhs->rn;

		/*
			by filling the record with \0's we effectively set
			ALL variables to zero (0), eliminating the need to
			explicitly set them, so do not be alarmed by the 
			seeming paucity of initialization statements
		*/

	fill(mmhs,'\0',MAIL_RECSIZE); 

		/*
			if message has a type the type is used and passed through
			if it has no type the below rules are used. Invalid types
			are filtered to 'no-type' by a kluge in the command 
			processor
		*/

	if (mtyp == '\0' || mtyp == ' ') {
		if (sendtype) {
			if (force_traf) {
				mmtype = 'T';
			} else {
				mmtype = 'B';
				if ( val_call(mto)					||
				     (stricmp (mto,sysop)	== 0)	|| 
				     (stricmp (mto,"wp")	== 0)	||
				     (strnicmp (mto,"rmail",5) == 0)||
				     lookup_usr(mto,tuser)			||
				     (strnicmp(mto,"req",3) == 0)	){

					mmtype = 'P';
				}
			}
		}
	} else {		    
		mmtype	= mtyp;
	}
	mmhs->type	= mmtype;
	mstat		= 'N';
	mmhs->fprty = mfprty;
	
	strcpy(mmhs->from, uc(mfrom));
	remnl(mtitle);
		
	strcpy(mmhs->to, uc(mto));
	strnxcat(mmhs->title, mtitle, MHTITL);

	p_msgID[0] = '\0';

	if (!islocal) 
		rline(infile,NULL,NULL,mmhs->date,p_msgID);
								
	
		/*  if no at bbs is supplied or user matches our system name,
			blank 'mbbs' and look in user file for forwarding information 
			from the home bbs field	
		*/

	p = mbbs;
	if (not_num(mto)) {		/* If TO field is not all-numeric	*/
		if (*p == '\0') {
			if (strnicmp(mto,"RMAIL",5) == 0 || is_sys_file(mto,"DST")) {
				to_distrib = TRUE;
			} else {
				if (lookup_usr(mto,tuser)) {
					if (tuser->home_bbs[0] != '\0') {
/*
					    strcpy(callbuf,edit_route(tuser->home_bbs,rt_edit));
					    if (stricmp(ocall,callbuf) != 0) {
					    	if (stricmp(ocall,mto) != 0 || !holdsysopmail) {
								p 			= tuser->home_bbs;
								if (!islocal && stricmp(mto,callbuf) != 0)
									to_distrib	= TRUE;
							}
						}
*/
					    if (stricmp(ocall,edit_route(tuser->home_bbs,rt_edit)) != 0) {
					    	if (stricmp(ocall,mto) != 0 || !holdsysopmail) {
								p 			= tuser->home_bbs;
								if (!islocal)
									to_distrib	= TRUE;
							}
						}
					}
				} else {
					if (xlat_addr(mto,mbbs,NULL,' ',sys_name(rply_to,"")))
						to_distrib = TRUE;
				}
			}
			
		}
	} else {
		xlat_addr(mto,mbbs,NULL,' ',sys_name(zipFIL,""));
	}
	
	strcpy(tbuf,edit_route(p,rt_edit));
	if (is_flood_route(tbuf)) 
		p = pcall(tbuf);
	
	strcpy(mmhs->bbs,uc(p));

	strcpy(mmhs->route,to_distrib ? "DISTRB" : set_route(mmhs->bbs,rt_edit));
	
	if (mmhs->date[0] == '\0') {
		strcpy(mmhs->date,l_date);
		strcpy(mmhs->time,l_time);
	}
	strcpy(mmhs->arrived,l_date);
	
	mmhs->date[6] = '\0';
	
	if (bull_exp && mmhs->type == 'B') 
		if (strcmp(add2date(mmhs->date,bull_exp),l_date) == ERROR) {
			mstat 	= 'O';
			prtx_err(MOLDBUL);
		}

	if (hold_local && islocal && port->mode == REMOTE) {
		mstat	= 'H';
	} else {
	
 		if (hold_mail) {
 			if (check_for_call(mto,holdTo)		== TRUE	||
				check_for_call(mfrom,holdFrom)	== TRUE	||
				check_for_call(mbbs,holdAt)		== TRUE	)
				mstat	= 'H';
		}
	}
		
	mwlock();	/************ lock mail file HARD ******************/
	resync();
	
	mmhs->number	= mfhs->next_msg++;

	strcpy(msg_txt_fl,msgname(mmhs->number));

	unlink(msg_txt_fl);
	
	fappend(fmt_token("R:$D/$T $M@$5"),msg_txt_fl); 

	p = "";	
			/*
				If there is a message ID on the SEND line start with that
				If an ID was found in the text body and it matches, OK
				if it doesn't and we haven't seen it record it in either
				case mark it suspicious
			*/

	if (*msgID) {
		p = msgID;
		if (*p_msgID && stricmp(p,p_msgID) !=0) {
			if (check_string(p_msgID,BIDfile)) {
				mstat = 'D';
			} else {
				mstat = '?';
				record_msgID(p_msgID);
			}
		}
	} else {
		if (islocal)
			p = "$";
		if (*p_msgID) {
			if (check_string(p_msgID,BIDfile)) 
				mstat = 'D';
			p = p_msgID;
		}
	}
				
	if (strcmp(p,"$") == 0) {
		p = msgIDstr();
			/* 
				a non local message demanding an ID gets ID enter in first
				line of text file - generally will only happen from RMAILER
			*/
		if (!islocal && (smart_sys == ERROR)) {
			token_lin = p;
			fappend(fmt_token("\nMessage-ID: <$S> ($F)"),msg_txt_fl);
		}
	}

	strnxcat(mmhs->msgID,uc(p),IDLEN);


	if ( islocal ) {
		msg_preamble(msg_txt_fl,mmhs->msgID,to_distrib);
	} else {
			/*  'pong' counter - makes message 'H'eld if your own call 
				appears more than 'pongmax' times in the forwarding path
			*/
		r = ret_path;
		i = 1;
		while (r = strstr(r,ocall))	{
			r++;
			i++;
		}
		if (i >= pong_max) {
			mstat	= '?';
			prtx_err(MPONGH);
		}
	
	}

	
	mmhs->stat	= mstat;
	
	if ( infile != NULL )
		copfil(infile,msg_txt_fl,FALSE);
	mmhs->size = fil_xst(msg_txt_fl);	/* how big is it?  */

	log('M','S',mmtype,fmt_token("#$M($]) $G @ $A < $P $$$8$% \"$Z\""));

 
 	if (smart_sys == ERROR)
 		prtx("RCVD $8 $G@$A ($9)\n");
	else
	 	prtx("RCVD $8\n");
	
	if (mmhs->msgID[0])
		record_msgID(mmhs->msgID);
	
	write_newrec();
	resync();
	mulock();	/************ unlock and resync ******************/

	if (mmhs->stat == 'N' && fldopt)
	
		flood_msg(mmhs->bbs);	/*	auto test for flood route and generate
									messages if proper and permitted
								*/

	read_rec(mfl, mh_old, (char *)mmhs); 	/* get back to where we were	*/
	

	disk_full = TRUE;	/* 	to force disk space re-compute	*/

}
/*
	export_msg() - send message to a file simple style
*/

export_msg(export_fl, trlr_str)
char *export_fl, *trlr_str;
{
	char *fwd_send();
	char tline[LINELEN];
	int ret = FALSE;
	
	bid_able = TRUE;
	mid_able = TRUE;
	h_route	 = TRUE;

	if (fappend(fwd_send(),export_fl) && fappend(mmhs->title,export_fl)	){
		
		if (copfil(msgname(mmhs->number), export_fl,TRUE) == FALSE)
			fappend(err_string(MFIND),export_fl);
		else
			ret = fappend(trlr_str,export_fl);

	}

	clear_parms();
	return(ret);

} /* export */


/*
	find_MID() - specifically locate message by BID/MID or FALSE
                while searching backwards and 'passing' the number
                without finding a match, we will exit leaving pointer
                at highest message number less than but not equal,
                FALSE will be returned
*/
find_MID(cp)
char *cp;
{
	int curhdr;

	curhdr = setlast();

	
	while(curhdr = getprev(curhdr)) {
		if (mmhs->fprty != '$') {
			if (stricmp(mmhs->msgID,cp) == 0)
				break;
		}
	}

	return(curhdr);
}
/*
	findmsg() - specifically locate message by number or FALSE
                while searching backwards and 'passing' the number
                without finding a match, we will exit leaving pointer
                at highest message number less than but not equal,
                FALSE will be returned
*/
findmsg(nr)
long int nr;
{
	int curhdr;
	
	curhdr = setlast();

	while(curhdr = getprev(curhdr)) {
		if (mmhs->fprty != '$') {
			if ((mmhs->number == nr) || (mmhs->number < nr))
				return(curhdr);
		}
	}
	return(1);
}



/*
	flood_msg() - so you have a possible flood-able message check for FLD
		file and do it, if @bbs is blank, or no flood file exists, it
		simply returns without doing anything. This is used by cremsg()
		after it creates a new message so that floding is 'on the spot'
*/
flood_msg(cp)
char *cp;
{
	int				i;
	unsigned int	mh_old;
	
	char	*p, *q, *fst;

	char tline[128];
	char tlin2[32];
	char linebuf[128];
	char dstpath[MTOLEN+1];

	FILE *floodfile;


	if (mmhs->fprty		!= '$'					&& 
	    (mmhs->msgID[0] != '\0' )				&&
		((floodfile = fopen(sys_name(cp,"FLD"),"rt")) != NULL)) {

		alter_rec();	/* refreshes record, write locks mail file */
		mmhs->stat 	 	= 	'F';
		mmhs->route[0]	=	'\0';
		mh_old 			= 	mmhs->rn;	/* save where we are */

		write_rec(mfl, mmhs->rn, (char *)mmhs);
		
					/* fills out ret_path[]	*/
		rline(msgname(mmhs->number),NULL,NULL,NULL,NULL);	
		
					/* make records for this file		*/
		mmhs->fprty		=  '$';
		mmhs->stat		=  'N';

		while (!feof(floodfile)) {
				/* do not send to anyone who has seen it already */
			if (((fst = fgets(tline,LINELEN,floodfile)) == NULL)	||
				strstr(uc(ret_path),remnl(uc(tline))) 			||
				(strcmp(mmhs->from,tline) == 0)					){
				continue;
			}
			strnxcat(mmhs->route,tline,6);

			sprintf(tlin2,"  Flood pointer to: %s\n",tline);
			if (port->mode == SYSOP)
				prtx(tlin2);
			else
				printf(tlin2);
				
			write_newrec();
		}
		fclose(floodfile);

		read_rec(mfl, mh_old, (char *)mmhs); /* get back to where we were	*/

		resync();	/* resynch mail file header and remove write lock		*/
		mulock();

	}
}


/*
	close_mail() - close the mail file
*/
close_mail()
{
	if ( close(mfl) < 0 )
		fatal("Error closing Mail file\"%s\"\n",mbfile);

}

/*
	open_mail() - open the mail file
*/
open_mail()
{
	if ((mfl = open(mbfile, O_RDWR|O_BINARY)) < 0 ) {
  		printf("\n\7 *** NO MAIL file present\n");
  		exit (4);
	}
	read_rec(mfl, 0, (char *)mfhs);
}


/*
	record_msgID() - sets message ID into Message BID file
*/
record_msgID(cp)
char *cp;
{
	char tline[LINELEN];
	extern char *BIDfile;
		
	sprintf(tline,"%s %s",cp,l_date);
	fappend(tline,BIDfile);
}


/*
	set_msgstat() - set the status of a message
*/
set_msgstat(c)
char c;
{
	alter_rec();
	mmhs->stat = c;
	wrt_altered();
}


/*
	untmsg() - untangle mail file - system call to standalone routine
*/
untmsg(argc,argv)
int argc;
char **argv;
{
	char tline[128];
	if (isreader()) {
		prtx("$V$B mail file busy $B$V\n");		
	} else {
		sprintf(tline,"mailwork -c %s %s %s", argv[1], mbfile, msgdir);
		mwlock();		/******** write lock mail file  ***********/
		log('M','C',' ',"mail file compression");
		system(tline);
		msginit();
		mulock();		/**********  unlock mail filel ************/
		mmhs->rn	= 1;		
		disk_full	= TRUE;		/* force disk space re-comp	*/
	}
}

/*
	write_newrec() - write the message header to end of linked mail list
*/
write_newrec()
{
	int mh;
	mh = ++mfhs->last;
	mmhs->rn = mh;
	write_rec(mfl,mh,(char *)mmhs);		/* save the new record		*/
	write_rec(mfl,0,(char *)mfhs);		/* save message file header	*/

}
 /* write_hdr */


/* 
	setlast () - set pointers to start at last message from mail file 
*/
int setlast()
{
	resync();
	return(mfhs->last+1);
}


/********************************************************************
 * read_rec() - read a record from an MB file
 ********************************************************************/
read_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
	long lseek();
	long offs;
	int ret=FALSE;

	offs = (long)rec * (long)MAIL_RECSIZE;
	if ( lseek(fid, offs, 0) == ERROR )
		fatal("read_rec: lseek");

	if ((ret = read(fid, buffer, MAIL_RECSIZE)) != MAIL_RECSIZE ) 
		fatal("error read_rec %04x\n",rec);

	return(ret);

}
/********************************************************************
 * write_rec() - write a record to a MB file
 ********************************************************************/
write_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
	long lseek();
	long offs;

	offs = (long)rec * (long)MAIL_RECSIZE;

	if (offs != lseek(fid, offs, 0))
		fatal("\n\n\7WRITE_REC - record [%04x]\n", rec);

	return (write(fid, buffer, MAIL_RECSIZE) == MAIL_RECSIZE);
}




/*
	getnext() - get a specific mail record and check 
				for good, else advance one
*/
int getnext(current)
int current;
{
	if (current > -1 && current < mfhs->last ) {
		read_rec(mfl,++current, (char *)mmhs);
		return(current);
	}
	return(0);
}

/*
	getprev() - get prev message walking backward 
*/
int getprev(current)
int current;
{
	if (current > 1 && current <= mfhs->last+1) {
		read_rec(mfl, --current, (char *)mmhs);
		return(current);
	}
	return(0);
}

/*
	msginit() - check for message file,if not Sayonara!. 
 				Then get headers and start the ball rolling
*/
msginit()
{

	open_mail();	
	
	if (mfhs->last == 0) {
		mmhs->rn = 1;
	}

	close_mail();	

	return(mfhs->last);
}


#include "mbmultim.c"

