/**********************************************************************
 *  MBIBM.C - 11/16/86 - System dependent functions.
 *  For standard IBM PC, under MS-DOS 3.1 or later
 *  ( the above statement appears to be C.Y.A. - runs just fine under
 *    DOS 2.11 - 12/4/86 |br| )
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 **********************************************************************
 *  This module is/can be a can of worms. I need to realy go through it.
 *  I took the routines that were here and that I needed that i was 
 *  aware were DOS specific and threw them together as needed. I will
 *  streamline them when time permits - these all work and work well, but
 * there is some duplication and they need examing against all modules |br|
 **********************************************************************
 * abort_dl()	- looks for ctrl-K from port or keyboard
 * chktmr()	- Return the current value of the hardware timer.
 * curtim()	- Fill the globals with the current date and time
 * diskSpace()	- asm language DOS call to get the available disk
 * doDir()	- this is the DOS directory middle level routine
 * dos_cmd()	- dos escape from command line 
 * do_yapp()	- run YAPPB from within Mailbox, sysop only for now
 * fil_dir()	- wildcard filename lookup
 * kb_abort()	- check to see if sysop has killed the mother. or talk
 * mbDir()	- top level directory command 'W' and 'WF'
 * settmr()	- Start the hardware timer
 * wwait()	- pause, have a beer; gonna be here for 'sec's
 **********************************************************************/

#include "mb.h"
#include <dos.h>

long    fil_dir();

char l_date[7];
char l_time[5];
int l_dayw;
int l_daym;

time_t ibm_timer;
time_t sys_time;

char *col_out;
char *stat_col;

int color = FALSE;

int MultiTasker = NONE;	/* true if multitasker running */
int pid = 0;		/* double dos process id */
struct tm *ctim;

/*******************************************************************
 * abort_dl() - looks for ctrl-K or X-OFF from port or keyboard
 *              or user went bye-bye - via DCD (TNC2s or MDM only)
 *******************************************************************/
abort_dl()
{
	char c = '\0';
	void giveaway();
	
	if (usr_gone())
		return (TRUE);
		
    if (kbstat()) {
	    c = (char) bdos(7,0,0);
	} else {
		if ((port->type & P_MDM) && instat())
			c = inchar();
	}
    switch (c) {
	case ESC:
		return (TRUE);
			
		/* with this - can XOFF remote as well */
	case CTRLS:
		c = CTRLQ;
	case ' ':
		settmr(120);
	    while(chktmr()) {
	    	if (kbstat())
	    		if ((char) bdos(7,0,0) == c)
					break;
			if ((port->type & P_MDM) && instat())
				if (inchar() == c)
					break;
	    	giveaway(5);
		}
		break;
	case CTRLW:
	    dsp_status();
		break;
	}
	return (FALSE);
}

/****************************************************************
 *  chktmr() - Return the current value of the hardware timer.
 *      Note: MUST return zero when timer has finished counting.
 *      this means to return the number of seconds remaining until
 *      the timer expires
 ****************************************************************/

int chktmr()
{
long l;
	time(&sys_time);
	l=ibm_timer-sys_time;
	if (l>0) return ((int) l);
	else return (0);
}
#ifndef NEEDSPACE
/*****************************************************************
 * con_beep() - 'yoo hoo' hey.... Sysopie....!!!!!!!! 
 *****************************************************************/
con_beep()
{
         bdos(2,'\7',0);
}
#endif

/*****************************************************************
 *   curtim() - Fill the globals with the current date and time
 *              by reading the system clock.
 *****************************************************************/

curtim()
{
	time(&sys_time);
	ctim = gmtime(&sys_time);	
	(void) sprintf(l_time,"%02d%02d",ctim->tm_hour,ctim->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",ctim->tm_year,ctim->tm_mon+1,
			ctim->tm_mday);

       		/* month returned by localtime is 0-11 */
}
#ifdef DOORWAY

/************************************************************************/
/*						    Doorway  Driver                             */
/*                          - An Overview -                             */
/*  The idea for "doorways" in the Citadel software belongs totally to  */
/*  Alan Bowen.  If it were not for his experience in the use of the    */
/*  other PC bulletin boards that allow for running applications from   */
/*  within the BBS itself, Doors for Citadel-86 probably would never    */
/*  have come to pass.  The original code was hacked by Alan during the */
/*  last week in August (1988) and quickly taught us that we had a lot  */
/*  to learn about how the PC family of machines handles RS232 during   */
/*  "shell" applications.  The solution we chose may not be the best of */
/*  all possible worlds, but it works.  Later came the desire to more   */
/*  closely emulate the way other BBS programs handle the "layered      */
/*  handoff" to the actual door applications. (VAQ - K2NE)              */
/*----------------------------------------------------------------------*/
/*  I began working with Vince on this code in the fall and quickly     */
/*  its potential for packet radio applications, particularly for public*/
/*  service oriented boards which wanted access to database applications*/
/*  'on-the-fly'. After working with it for some months and getting it  */
/*  run a Roserver cosole to an active TNC from a phone modem port, I   */
/*  felt sufficiently confident to try it the other way around, i.e. let*/
/*  the TNC port run applications and even have phone modem access. this*/
/*  is the results of my efforts.  <br>									*/
/************************************************************************/

/************************************************************************/
/*				History                                                 */
/* 89Jan09 <br> Adapted to DOORWAY v1.43 and to ROSE Code by ka2bqe     */
/* 88Sep15 VAQ  See local [K2NE] increm.xxx files for further history   */
/* 88Aug26 AAB  First work done                                         */
/* 88Aug26 AAB  Door stuff dreamed up                                   */
/************************************************************************/

/**************************************************************************/
/*                  doDoors()                                             */
/*                                                                        */
/**************************************************************************/
doDoors(argc,argv)
int argc;
char **argv;
{
	FILE *fd;
	int portid 	= 0;  /* initialize for LOCAL use = 0 	*/
	int port_lim= 120; /* initialize LOCAL at 120 minutes*/
	char doorname[13];

	if (check_for_call(port->user->call,"doorway.rs") ==  FALSE) {
		prtx_err(MNODOR);
		return (0);
	}
   	log('S','D','E',doorname);		/* log entrance to door		*/

		/* The next file are opened without checking for space. This
		   may be dangerous, but assumption of min-disk space is made
		   and that there will be space ..... we shall see! <br>
		*/

	fd = fopen("door.sys", "wt");
	if (port->id != 'L') {
		port_lim= 30;
		portid	= port->idn + 1;
	}
	fprintf(fd,"%6.6s (USER)\n%d\n%u\n%d\nM\nA\n",
		port->user->call,portid,port->baud,port_lim);
	fclose(fd);

	exit(20);
}
#endif

/*
	do_copy() - sysops copy command - sub-runs DOS COPY
*/
do_copy(argc,argv)
int argc;
char **argv;
{
	char tline[LINELEN];
	char *tofile=".";
	
	if (argc > 2)
		tofile = argv[2];
	sprintf(tline,"copy %s %s >%s",argv[1], tofile, msgtemp);
	dos_cmd(tline);
	read_fil(msgtemp,TRUE);
	unlink(msgtemp);
	
}

/*********************************************************************
 * dos_cmd() - dos escape from command line 
 *********************************************************************/
dos_cmd(cline)
char *cline;
{
	int ret;
	char *p;
	
	if (cline[0] == '\0') { 
		p = getenv("COMSPEC");
		printf("\nType 'EXIT' to return to MailBox\n");
	} else {
		p = cline;
	}
	if (system(p))
		perror(p);

	disk_full = TRUE;
	home_space(GO_HOME);
}


/*********************************************************************
 * dsp_status() - print status line on top of screen 
 *********************************************************************/
dsp_status()
{
	char *getcolor();
	extern char *disp_stat;

	curtim();
	if (*mail_st != 'M') 
		if (cport->user->msg_number < mfhs->next_msg)
			mail_st = "NEW ";

	token_lin = mail_st;
	printf("\n  %s%s",getcolor(stat_col,color),fmt_token(disp_stat));
 	printf("%s\n",getcolor(col_out,color));
}

/*********************************************************************
	diskSpace() - C language DOS call to get the available disk	
	space. DOS returns 3 #'s to be multiplied, which is done in 
	as long integers and divided down to return a value in Kilobytes.
	For public non-commercial use (c)1985 Brian B. Riley (KA2BQE)
 *********************************************************************/

long diskSpace(drv)
int drv;
{
	union REGS regs;
	regs.h.dl = drv;
	regs.h.ah = 0x36;
	int86(0x21,&regs,&regs);
/*
	sectClust	==> regs.x.ax;
	bytesSect	==> regs.x.bx;
	numSect		==> regs.x.cx;
*/
	return(( (long) regs.x.ax * (long) regs.x.bx * (long) regs.x.cx) / 1024);
}

/*
	doDir() - this is the DOS directory routine. It is VERY machine
		dependent. PC or clone only. It is in essence, code from KA9Q NET
		(TCP/IP) directroy routines, heavily modified by me for the new 
		RLI-style Mailbox. Please keep the various credit banners in place
		so credit is placed where it is due.
*/

#define FINDFIRST	0x4e
#define FINDNEXT	0x4f


char *doDir(path,fname)
char *path,*fname;
{
	FILE *fp;
	char *p, filename[81];		/* instance of filename */
	
	int	i = 0;
	int	dirMode = FINDFIRST;
	int	disk_drv= 0;

	p = path;
	
	if (fp = sys_open(fname,"w")) { 

		fprintf(fp, "Directory of %s\n\n",path);

		if (strchr(path,':'))
			disk_drv = (int) (*p & 0x0f);
			
		while (fil_dir(path,dirMode,filename)) {

			if (*filename != '.') 
				fprintf(fp,"%s%s",filename,((++i) % 4) ? "  " : "\n");
/*
				fprintf(fp,"%s\n",filename);
*/

		  	dirMode = FINDNEXT;
		} 

		fprintf(fp, "\n [ %ld Kbytes free ]\n",diskSpace(disk_drv));
		(void) fclose(fp);
		return(fname);
	}
	return(NULL);

}


/************************************************************************
 * fil_dir()  [dirutil.c]
 *	MS-Dos directory reading stuff.
 *	A.D. Barksdale Garbee II, aka Bdale, N3EUA
 *	Copyright 1986 Bdale Garbee, All Rights Reserved.
 *	Permission granted for non-commercial copying and use, provided
 *	this notice is retained.
 ************************************************************************
 *
 * Based on an idea or two from Bob Hartman.
 * display formatting by <br>
 *
 * sends up file size or '<DIR>' in string		|br| 12/15/86
 ************************************************************************/


/************************************************************
 * fil_dir() - wildcard filename lookup
 ************************************************************/
	/* DOS file attribute byte status bits		*/
#define ARC_ST	0x20
#define SUB_DIR	0x10
#define	VOL_LBL	0x08
#define HIDDEN	0x02
#define READ_O	0x01

long fil_dir (namespec, dirmode, ret_str)
char *namespec;
int dirmode;
char *ret_str;
{
	union	REGS	regs;
	char	fsize[12];
	char	*fdesig;
	
	static	struct {
		char rsvd[21];
		char attr;
		long fdate;
/*
		unsigned ftime;
		unsigned fdate;
*/
		long fsize;
		char fname[13];
	} sbuf;

	bdos (0x1a,(unsigned) &sbuf,0);

	regs.h.ah = (char) dirmode;
	regs.x.dx = (unsigned int) namespec;
	regs.x.cx = (unsigned int) ~VOL_LBL;
	intdos(&regs,&regs);
	if (regs.x.cflag) {
		*ret_str = '\0';
		return (FALSE);
	}

	if (sbuf.attr & SUB_DIR)	strcpy(fsize,"<DIR>");
	else if (sbuf.fsize > 99999L) {
		(void) sprintf(fsize,"%4ldK",(sbuf.fsize/1024)+1);
	      } else {
		(void) sprintf(fsize,"%5ld",sbuf.fsize);
              }
	(void) sprintf(ret_str,"%-12.12s %5.5s",sbuf.fname,fsize);

/*
	if (sbuf.attr & SUB_DIR) {
		fdesig = "   <DIR>";
	} else {
		sprintf(fsize,"%8ld",sbuf.fsize);
		fdesig = fsize;
	}
	(void) sprintf(ret_str,"%-12.12s %s %s",
		sbuf.fname,fdesig,arpadate(sbuf.ftime));
	(void) sprintf(ret_str,"%-12.12s date [%04x]   time [%04x]",
		sbuf.fname,fdesig,sbuf.fdate,sbuf.ftime);
*/
	
	return (TRUE);
}


fil_info (argc,argv)
int argc;
char **argv;
{
	char *pname;
	char tline[LINELEN];

	sprintf(tline,"%s\\%s\\FILEDIR.TXT",fildir,(argc > 1) ? argv[1] : "");

	if (fil_xst(tline))
		read_fil(tline,TRUE);
	else
		prtx_err(MNOFINFO);
	return (0);
}


/**********************************************************************
 *  kb_abort() -  check to see if sysop has killed the mother. or talk
***********************************************************************/
kb_abort()
{
    char	c;
    if (kbstat()) {
    	c = bdos(7,0,0);
		switch(toupper(c)) {
		case 'F':
			port->mode = FORCED;
			return (ERROR);
		case ESC:
			break_in = TRUE;
			return (TRUE);
		case 'T':
			return(RESETIME);
		}
    }
    return (FALSE);

}


/*******************************************************************
* mbDir() - top level directory commands 
 *******************************************************************/
mbDir(argc,argv)
int argc;
char **argv;
{
	int ret;
	
	if ((ret = mbDir_func(argv[1], issysop(), msgtemp)) != 0) {
		prtx_err(ret);
	} else {
		read_fil(msgtemp,TRUE);
		unlink(msgtemp);
	}
	return (0);
	
} /* mbDir */


mbDir_func(cp, priv, fname)
int priv;
char *cp, *fname;
{
	struct 	stat stbuf;
	char	path[128];
	char	*p;
	char	*pname;
	
	pname = cp;

	if (*cp == '\0')
		pname = "*.*";


	if ( checkpath(fildir,pname,path,priv)) 
		return(MINVPTH);

		
	p = tail_ptr(path) - 1;
	while (*p == '\\')
		*p-- = '\0';
		
	if ((*p == ':') || (stat(path,&stbuf) == 0 && stbuf.st_mode & S_IFDIR))
		strcat(path,"\\*.*");


	if (doDir(path,fname) == NULL )
		return(MDIRERR);

	return (0);
}



/****************************************************************
 * settmr() - Start the hardware timer
 ****************************************************************/
settmr(cnt)
int cnt;
{
	long l;
	time(&l);		/* secs since 1970 */
	ibm_timer = (long) cnt + l;  /* compute time to expire */
}

/****************************************************************
 * wwait() - pause, have a beer; gonna be here for 'sec's
 ****************************************************************/
wwait(sec)
int sec;
{
	settmr(sec);
	while (chktmr())
		giveaway(2);
}

/*
	home_space() - save and restores home directory and disk. Called with
	SET_HOME should e done immediately to record where HOME is, then sub-
	sequent calls with GO_HOME will always take you there
*/
home_space(func)
int func;
{

	static char homepath[80];

	if (func)	
		(void) getcwd(homepath,80);
	else
		(void) chdir(homepath);
}

#ifndef NEEDSPACE
/*
	save_space() - called with SET_SP it will record current working dir
	called with GET_SP - it will return with pointer to string with saved
	directory name. A call chdir(save_space(GET_SP)) will take you to last
	place you recorded.
*/
char *save_space(func)
int func;
{
	static char savepath[80];

	if (func) {
		(void) getcwd(savepath,80);
		return (NULL);
	}
	
	return (savepath);
		
}			
#endif

/* some multi user stuff */

#include "mbmltibm.c"

