/*****************************************************************
 *  MBHDR.C - 05/11/87 - Definitions for MailBox.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *************************************************************
 *
 * the function rline() is an important function in message creation
 * when responding to another message.
 *
 *  rline(message-file,fromcall,frombbs,tocall,subject,date,msgID)
 *  
 * the variables after the file name will have filled into them the values
 * stated. Most often it is used to find return path so the variable
 * in position two is often a 'TO' variable which may seem wrong, but we
 * are taking the FROM value to be used as the TO of the returned message.
 * If the rline() call has NULL for any field it will not be filled in.
 *
 *************************************************************/ 

#include "mb.h"

char *arpadate();
void preamble();

char ret_path[LINELEN];
int	longiheader = TRUE;
extern time_t sys_time;

#define MAXARGS 16
#define IDLEN	12

/***************************************************************
 * rline - read the header lines to determine reply address
 ***************************************************************/
/*
rline(input,from_c,host_c,to_c,subj,date_c,m_id)
char *input, *from_c, *host_c, *to_c, *subj, *date_c, *m_id;
*/
rline(input,from_c,host_c,date_c,m_id)
char *input, *from_c, *host_c, *date_c, *m_id;
{
	FILE *fp;

	char buf[BUFLEN];
	char user[CALLLEN+1];
	char msg_id[IDLEN+1];
	char msg_id2[IDLEN+1];
	char host[MTOLEN+1];
	char tdate[12];
	char *eat_white(), *chop_at();
	char *cp, *p, *r, *q, *rp, *fst;
	char *partv[MAXARGS];

	int count;
	int haveheader = FALSE;

	rp	= ret_path;
	*rp = '\0';
		
	if ( input == NULL )
		return(0);

	if ((fp = sys_open(input,"rt")) == NULL) 
		return(0);
	
	host[0] 		= '\0';
	user[0] 		= '\0';
	tdate[0] 		= '\0';
	msg_id[0] 		= '\0';
	msg_id2[0] 		= '\0';

	ret_path[0]		= '\0';
	
	while(is_R_hdr(fp,buf, sizeof(buf))) {

		p = remnl(eat_white(buf+2));

		if ( date_c != NULL) 
			strnxcat(date_c,p,11);
				
		if (p = strstr(uc(buf),"$:")) {
			q = chop_at(p+2,' ');
			strnxcat(msg_id2,p+2,IDLEN);
		}
		if (p = strchr(buf,'@')) {	/* found a host */
			if (*++p == ':') 
				p++;
			q = chop_at(p,' ');
			
			strnxcat(host,p,MTOLEN);

			q = chop_at(p,'.');

			sprintf(ret_path,"%s%s!",ret_path,p);
		}
	}

	
	while(!feof(fp)) {		/* scan for a RFC822 Header */
		remnl(buf);
		if (*buf != ' ') { /* space is cont, drop thru get another line */

			if ((p = strchr(buf,':')) == NULL) 
				break;
			
			count = 0;

			if ((*user == '\0' && strnicmp(buf,"From: ",6) == 0) || 
				strnicmp(buf,"Reply-To: ",10) == 0) {

				p = strchr(buf,' ') + 1;
				strnxcat(user,p,CALLLEN);

				if (p = strchr(buf,'@')) {
					p = eat_white(p+1);
					chop_at(p,' ');
					strnxcat(host,p,MTOLEN);
				}
				haveheader = TRUE;
			}			
	
			if ((*msg_id == '\0') 						&& 
				(strnicmp(buf,"Message-ID: <",13) == 0)	&&
				(p = strchr(buf,'>'))					&&
				(strchr(buf,'@') == NULL)				){
				*p = '\0';
				strnxcat(msg_id,buf+13,IDLEN);
			}

			/*
			if ((strnicmp(buf,"To: ",4) == 0) && (to_c != NULL)) {
				strcpy(to_c,buf+4);
			}
			
			if ((strnicmp(buf,"Subject: ",9) == 0) && (subj != NULL)) {
				strcpy(subj,buf+9);
			}
			*/
			
			
		} 	/* check for blank first char */
				
		fst = fgets(buf, sizeof(buf)-1, fp);
	}

	(void) fclose(fp);

	if ( host_c != NULL && host[0] != '\0') {
		uc(host);
		strcpy(host_c,host);
	}

	if ( from_c != NULL && user[0] != '\0') {
		(void) pcall(user);
		strcpy(from_c,user);
	}
	
	if ( m_id != NULL ) {	/* "Message-ID:" takes precedence over "$:" */
		if (*msg_id)
			strcpy(m_id,msg_id);
		else
			if (*msg_id2)
				strcpy(m_id,msg_id2);
			
	}

			
	return(haveheader);
	
}

/*
	is_R_hdr - look for R: line, skips and reads again for blank line
	           return(TRUE) - the line in buf is an R:
	           return(FALSE)- the line in buf is nOT an R:
*/

is_R_hdr(fptr,buf,buffsize)
int		buffsize;
FILE 	*fptr;
char 	*buf;
{
	char *fst, *p;

	while (!feof(fptr)) {

		if ((fst = fgets(buf, buffsize, fptr)) == NULL)
			continue;

		if (strnicmp(buf,"R:",2) == 0)
			return(TRUE);

		p = eat_white(buf);
		if (*p == '\n')
			continue;

		break;

	}
	return(FALSE);		
}


/*************************************************/
/* insert the message header text into a message */
/*************************************************/
void
msg_preamble(mfname,mmsgID,spcl)
char *mfname,*mmsgID;
int spcl;
{
	char *p;
	char from[CALLLEN+1];
	extern int longiheader;
	FILE *fp;

	if (fp = sys_open(mfname,"a+")) {

		if (!spcl) {
			if (longiheader)
				fprintf(fp,"\nDate: %s",arpadate(sys_time));

			fprintf(fp,"\nFrom: %s@%s (%s)\nMessage-ID: <%s> (%s)",
				strlwr(mfrom), strlwr(thisHost), handle, mmsgID, oqth); 
		}
		
		if (reply_to != NULL)
			fprintf(fp,"\nReply-To: %s@%s",mfrom, strlwr(reply_to));

		fprintf(fp,"\nTo: %s",strlwr(tobuf));

		if (longiheader)
			fprintf(fp,"\nSubject: %s",mtitle);

		fprintf(fp,"\n\n");			
		(void) fclose(fp);
	}
}
