#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*--------------------------------------------------------------------------
  ------ Remove all \n from the string -------------------------------------
  ------------------------------------------------------------------------*/
char * FILE_removeN(char * szString)
{
  char * pszPtr;

  while( pszPtr = strchr(szString, '\n') )
    strcpy(pszPtr, pszPtr+1);

  return szString;
}

/*--------------------------------------------------------------------------
  ------ Remove all \r from the string -------------------------------------
  ------------------------------------------------------------------------*/
char * FILE_removeR(char * szString)
{
  char * pszPtr;

  while( pszPtr = strchr(szString, '\r') )
    strcpy(pszPtr, pszPtr+1);

  return szString;
}

/*--------------------------------------------------------------------------
  ------ Remove all \r from the string -------------------------------------
  ------------------------------------------------------------------------*/
char * FILE_removeNR(char * szString)
{
  FILE_removeN (szString);
  FILE_removeR (szString);

  return szString;
}


/*--------------------------------------------------------------------------
  ------ FILE_exist --------------------------------------------------------
  ------------------------------------------------------------------------*/
/*Return TRUE is the file exist*/
int FILE_exist(char * szFileName)
{
  FILE * fPtr;

  fPtr = fopen(szFileName, "rb");

  if( ! fPtr )
    return 0;	/*Don't exist*/

  fclose (fPtr);
  return 1;		/*Does exist*/
}

/*--------------------------------------------------------------------------
  ------ Copy the data file ------------------------------------------------
  ------------------------------------------------------------------------*/
void FILE_copy(char * szOrg, char * szDest, char * szSearchCall)
{
  FILE * fOrg;
  FILE * fDest;
  int    Done = 0;
  char   szBuffer[1024];

  fOrg = fopen(szOrg, "rt");
  if( ! fOrg )
    return;		/*Unable to open file*/

  fDest = fopen(szDest, "wb");
  if( ! fDest )
    return;		/*Unable to open file*/

  /*Do not copy the first lines of the file which are comments about
    the soffware*/

  while( fgets(szBuffer, 1023, fOrg) )
  {
    /*Look for the searched call, wich indicates the begenning of the data*/
    if( strstr(szBuffer, szSearchCall) )
      Done = 1;

    if( Done )
    {
      FILE_removeR (szBuffer);	/*For linux, \r not required*/
      fputs(szBuffer, fDest);
    }
  }

  fclose (fOrg);
  fclose (fDest);
}

/*--------------------------------------------------------------------------
  ------ Get the call to search --------------------------------------------
  ------------------------------------------------------------------------*/
char * FILE_getCall(char * szFileName, char * szCallsign)
{
  FILE * fPtr;

  fPtr = fopen(szFileName, "rt");
  if( ! fPtr )
    return NULL;

  fgets(szCallsign, 20, fPtr);
  FILE_removeNR (szCallsign);

  fclose (fPtr);
  return szCallsign;
}

/*--------------------------------------------------------------------------
  ------ Delete a file -----------------------------------------------------
  ------------------------------------------------------------------------*/
void FILE_delete(char * szFileName)
{
  unlink (szFileName);
}