// Forward.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "fbbWDlg.h"
#include "Forward.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CForward dialog


CForward::CForward(char *szFileName, CWnd* pParent /*=NULL*/)
	: CDialog(CForward::IDD, pParent)
{
	//{{AFX_DATA_INIT(CForward)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	strcpy(m_FileName, szFileName);
	pFbbMain = pParent;
}


void CForward::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CForward)
	DDX_Control(pDX, IDC_LISTFORWARD, m_ListForward);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CForward, CDialog)
	//{{AFX_MSG_MAP(CForward)
	ON_LBN_DBLCLK(IDC_LISTFORWARD, OnDblclkListforward)
	ON_WM_DRAWITEM()
	ON_BN_CLICKED(IDSTOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CForward message handlers

BOOL CForward::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	FILE *fptr;
	int nb;
	int numbbs;
	int nb_priv;
	int nb_bull;
	int nb_kb;
	char buffer[80];
	char bbs[80];

	if (fptr = fopen(m_FileName, "r"))
	{
		m_ListForward.SetColumnWidth(140);
		m_ListForward.SetItemHeight(0, 15);

		while (fgets(buffer, sizeof(buffer), fptr))
		{
			nb = sscanf(buffer, "%d %s %d %d %dK", &numbbs, bbs, &nb_priv, &nb_bull, &nb_kb);
			if (nb == 5)
			{
				char line[80];
				int color;

				if (nb_priv)
					color = 2;
				else if (nb_bull)
					color = 1;
				else
					color = 0;
				sprintf(line, "%d %s\t%d/%d - %dK", color, bbs, nb_priv, nb_bull, nb_kb);

				m_ListForward.AddString(line);
			}
			else
			{
				m_ItemColor = RGB(0,0,0);
				m_ListForward.AddString("0 .");
			}
		}
		fclose(fptr);
		unlink(m_FileName);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CForward::OnOK() 
{
	// TODO: Add extra validation here
	int pos = m_ListForward.GetCurSel();
	if (pos == LB_ERR)
		return;

	char szStr[80];

	sprintf(szStr, "START %d", pos);
	((CFbbWDlg *)GetParent())->RequestService(4, szStr);

	CDialog::OnOK();
}

void CForward::OnStop() 
{
	// TODO: Add extra validation here
	int pos = m_ListForward.GetCurSel();
	if (pos == LB_ERR)
		return;

	char szStr[80];

	sprintf(szStr, "STOP %d", pos);
	((CFbbWDlg *)GetParent())->RequestService(4, szStr);

	CDialog::OnOK();
}

void CForward::OnDblclkListforward() 
{
	// TODO: Add your control notification handler code here
	OnOK();	
}

void CForward::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CForward::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	if (nIDCtl == IDC_LISTFORWARD)
	{
		CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

		char szLine[80];
		m_ListForward.GetText(lpDrawItemStruct->itemID, szLine);
		int x1 = lpDrawItemStruct->rcItem.left;
		int y1 = lpDrawItemStruct->rcItem.top;
		int x2 = lpDrawItemStruct->rcItem.right;
		int y2 = lpDrawItemStruct->rcItem.bottom;
		int len = strlen(szLine);
		COLORREF cr;

		switch(atoi(szLine))
		{
		case 1 :
			cr = RGB(0,0, 255);
			break;
		case 2 :
			cr = RGB(255,0,0);
			break;
		default :
			cr = RGB(0,0,0);
			break;
		}

		if (lpDrawItemStruct->itemState & ODS_SELECTED)
			pDC->FillSolidRect(x1, y1, x2-x1, y2-y1, RGB(192,192,192));
		else
			pDC->FillSolidRect(x1, y1, x2-x1, y2-y1, GetSysColor(COLOR_WINDOW));

		pDC->SetTextColor(cr);
		pDC->SetBkMode(TRANSPARENT);

		int tabs = 55;
		pDC->TabbedTextOut(x1+1, y1+1, szLine+1, len-1, 1, &tabs, x1+1);
		return;
	}
	
	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

