
//	Returns number of free buffers
//	(BPQHOST function 7 (part)).

int APIENTRY GetFreeBuffs();



//	Returns count of packets waiting on stream
//	 (BPQHOST function 7 (part)).

int APIENTRY RXCount(int Stream);




//	Returns number of packets on TX queue for stream
//	 (BPQHOST function 7 (part)).

int APIENTRY TXCount(int Stream);



//	Returns number of monitor frames available
//	 (BPQHOST function 7 (part)).

int APIENTRY MONCount(int Stream);



//	Returns call connecten on stream (BPQHOST function 8 (part)).

int APIENTRY GetCallsign(int stream, char * callsign);



//	Send Session Control command (BPQHOST function 6)
//	Command = 0 Connect using APPL MASK IN param
//	Command = 1 Connect
//	Command = 2 Disconect
//	Command = 3 Return to Node

int APIENTRY SessionControl(int stream, int command, int param);



//	Sets Application Flags and Mask for stream. (BPQHOST function 1)
//	Top bit of flags enables monitoring

int APIENTRY SetAppl(int stream, int flags, int mask);



//	Get current Session State. Any state changed is ACK'ed
//	automatically. See BPQHOST functions 4 and 5.

int APIENTRY SessionState(int stream, int * state, int * change);



//	Send message go stream (BPQHOST Function 2)

int APIENTRY SendMsg(int stream, char * msg, int len);



//	Send Raw (KISS mode) frame to port (BPQHOST function 10)

int APIENTRY SendRaw(int port, char * msg, int len);



//	Get message from stream. Returns length, and count of frames
//	still waiting to be collected. (BPQHOST function 3)

int APIENTRY GetMsg(int stream, char * msg, int * len, int * count );



//	Get Raw (Trace) data (BPQHOST function 11)

int APIENTRY GetRaw(int stream, char * msg, int * len, int * count );



//	This is not an API function. It is a utility to decode a received
//	monitor frame into ascii text.

int APIENTRY DecodeFrame(char * msg, char * buffer, int Stamp);



//	Sets the tracing options for DecodeFrame. Mask is a bit
//	mask of ports to monitor (ie 101 binary will monitor ports
//	1 and 3). MTX enables monitoring on transmitted frames. MCOM
//	enables monitoring of protocol control frames (eg SABM, UA, RR),
//	as well as info frames.

int APIENTRY SetTraceOptions(long mask, int mtxparam, int mcomparam);



//	Returns number of first unused BPQHOST stream. If none available,
//	returns 255. See API function 13.

int APIENTRY FindFreeStream();



//	Allocate stream. If stream is already allocated, return nonzero.
//	Otherwise allocate stream, and return zero

int APIENTRY AllocateStream(int stream);



//	Release stream.

int APIENTRY DeallocateStream(int stream);



//	Enable async operation - new to Win32 version of API

int APIENTRY BPQSetHandle(int Stream, HWND hWnd);


//
//	Constants and equates for async operation
//

char BPQWinMsg[] = "BPQWindowMessage";
UINT BPQMsg;

//
//	Values returned in lParam of Windows Message
//
#define BPQMonitorAvail 1
#define BPQDataAvail 2
#define BPQStateChange 4

