// SingleWnd.cpp : implementation file
//

#include "stdafx.h"
#include "fbbW.h"
#include "SingleWnd.h"
#include "fbbWDlg.h"
#include "Display.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSingleWnd dialog


CSingleWnd::CSingleWnd(CWnd* pParent)
	: CDialog(CSingleWnd::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSingleWnd)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pParentWnd = pParent;
	nXPos = nYPos = 0;
	nWidth = nHeight = 100;
	cWinName = '\0';
}


CSingleWnd::CSingleWnd(int nX, int nY, char cName, CWnd* pParent)
	: CDialog(CSingleWnd::IDD, pParent)
{
	m_pParentWnd = pParent;
	nXPos = nX;
	nYPos = nY;
	cWinName = cName;
}


void CSingleWnd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSingleWnd)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSingleWnd, CDialog)
	//{{AFX_MSG_MAP(CSingleWnd)
	ON_WM_MOVE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSingleWnd message handlers

BOOL CSingleWnd::OnInitDialog() 
{
	CDialog::OnInitDialog();

	HICON hIcon = (HICON)LoadImage(   
		AfxGetApp()->m_hInstance,
		MAKEINTRESOURCE(IDR_MAINFRAME),
		IMAGE_ICON,                           
		GetSystemMetrics(SM_CXSMICON),
		GetSystemMetrics(SM_CYSMICON),
		0);
	if(hIcon)
		SetIcon(hIcon, false);

	char szTitle[80];

	switch (cWinName)
	{
	case 'a':
		strcpy(szTitle, "  All channels");
		break;
	case 'm':
		strcpy(szTitle, "  Monitoring");
		break;
	default:
		sprintf(szTitle, "  Channel %d", nChan);
		break;
	}

	SetWindowText(szTitle);

	MoveWindow(nXPos, nYPos, nWidth, nHeight, FALSE);

	// To size input and output window
	CRect rect;
	GetClientRect(&rect);
	BOOL bRet = m_TerminalCtrl.Create(NULL, "Display", WS_CHILD|WS_VISIBLE|WS_VSCROLL|WS_BORDER, rect, this, 100);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

////////////////////////////////////////////////////////////////////////////
// Add a string to the ouput window
// lpszText : string to add
// crColor  : color of string

void CSingleWnd::AddString(LPCTSTR lpszText, int len, COLORREF crColor)
{
	m_TerminalCtrl.AddString(lpszText, len, crColor);
}

void CSingleWnd::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);
	
	RECT Rect;
	GetWindowRect(&Rect);

	// TODO: Add your message handler code here
	char szName[80];
	if (isalpha(cWinName))
		sprintf(szName, "Position_%c", cWinName);
	else
		sprintf(szName, "Position_o");
	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.left, Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni(szName, szStr);
}

void CSingleWnd::OnSize(UINT nType, int cx, int cy) 
{
	if (m_TerminalCtrl.GetSafeHwnd())
		m_TerminalCtrl.MoveWindow(0, 0, cx, cy);
	
	RECT Rect;
	GetWindowRect(&Rect);

	// TODO: Add your message handler code here
	char szName[80];
	if (isalpha(cWinName))
		sprintf(szName, "Size_%c", cWinName);
	else
		sprintf(szName, "Size_o");
	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.right-Rect.left, Rect.bottom-Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni(szName, szStr);
	
}

void CSingleWnd::SetPosition(int nX, int nY, int nW, int nH)
{
	nXPos = nX;
	nYPos = nY;
	nWidth = nW;
	nHeight = nH;
	if (GetSafeHwnd())
		MoveWindow(nX, nY, nW, nH, FALSE);
}

void CSingleWnd::SetFont(CFont* pFont, BOOL bRedraw)
{
	m_TerminalCtrl.SetFont(pFont, bRedraw);
}

void CSingleWnd::OnCancel() 
{
	switch (cWinName)
	{
	case 'a':
		m_pParentWnd->PostMessage(WM_CLOSEALLCHANNELS);
		break;
	case 'm':
		m_pParentWnd->PostMessage(WM_CLOSEMONITOR);
		break;
	default:
		m_pParentWnd->PostMessage(WM_CLOSEONECHANNEL);
		break;
	}
}

void CSingleWnd::OnOK() 
{
}

void CSingleWnd::SetAnsi(BOOL bAnsi)
{
	m_TerminalCtrl.SetAnsi(bAnsi);
}
