// EditUser.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "fbbWDlg.h"
#include "EditUser.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInput dialog


CInput::CInput(char *szBuf, int nLen, CWnd* pParent /*=NULL*/)
	: CDialog(CInput::IDD, pParent)
{
	szLine = szBuf;
	nLineLen = nLen;
	//{{AFX_DATA_INIT(CInput)
	m_Input = _T("");
	//}}AFX_DATA_INIT
}


void CInput::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInput)
	DDX_Control(pDX, IDC_EDIT1, m_CLine);
	DDX_Text(pDX, IDC_EDIT1, m_Input);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInput, CDialog)
	//{{AFX_MSG_MAP(CInput)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInput message handlers

BOOL CInput::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_CLine.SetFocus();
	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CInput::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData();

	m_Input.MakeUpper();
	CString Check = m_Input.SpanIncluding("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	if (Check.Compare(m_Input) == 0)
	{
		strcpy(szLine, Check);
		CDialog::OnOK();
	}
	else
	{
		Check.Format("Invalid callsign\r\n%s", m_Input);
		MessageBox(Check, "Input", MB_OK|MB_ICONEXCLAMATION);
		UpdateData(FALSE);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CEditUser dialog


CEditUser::CEditUser(CWnd* pParent /*=NULL*/)
	: CDialog(CEditUser::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditUser)
	m_UserName = _T("");
	m_UserPasswd = _T("");
	m_UserHome = _T("");
	m_UserPrivDir = _T("");
	m_UserZip = _T("");
	m_UserPaging = FALSE;
	m_UserBBS = FALSE;
	m_UserExcluded = FALSE;
	m_UserExpert = FALSE;
	m_UserLocal = FALSE;
	m_UserModem = FALSE;
	m_UserPMS = FALSE;
	m_UserPrivMsg = FALSE;
	m_UserReadAll = FALSE;
	m_UserSysop = FALSE;
	m_UserUnproto = FALSE;
	m_UserGuest = FALSE;
	//}}AFX_DATA_INIT
}


void CEditUser::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditUser)
	DDX_Control(pDX, IDC_DELUSER, m_Del);
	DDX_Control(pDX, IDOK, m_Ok);
	DDX_Control(pDX, IDC_USERLANG, m_UserLang);
	DDX_Control(pDX, IDC_USERCALL, m_UserList);
	DDX_Text(pDX, IDC_USERNAME, m_UserName);
	DDX_Text(pDX, IDC_USERPASSWD, m_UserPasswd);
	DDX_Text(pDX, IDC_USERHOME, m_UserHome);
	DDX_Text(pDX, IDC_USERPRIVDIR, m_UserPrivDir);
	DDX_Text(pDX, IDC_USERZIP, m_UserZip);
	DDX_Check(pDX, IDC_PAGING, m_UserPaging);
	DDX_Check(pDX, IDC_USERBBS, m_UserBBS);
	DDX_Check(pDX, IDC_USEREXCLUDED, m_UserExcluded);
	DDX_Check(pDX, IDC_USEREXPERT, m_UserExpert);
	DDX_Check(pDX, IDC_USERLOCAL, m_UserLocal);
	DDX_Check(pDX, IDC_USERMODEM, m_UserModem);
	DDX_Check(pDX, IDC_USERPMS, m_UserPMS);
	DDX_Check(pDX, IDC_USERPRIVATEMSG, m_UserPrivMsg);
	DDX_Check(pDX, IDC_USERREADALL, m_UserReadAll);
	DDX_Check(pDX, IDC_USERSYSOP, m_UserSysop);
	DDX_Check(pDX, IDC_USERUNPROTO, m_UserUnproto);
	DDX_Check(pDX, IDC_USERGUEST, m_UserGuest);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditUser, CDialog)
	//{{AFX_MSG_MAP(CEditUser)
	ON_LBN_SELCHANGE(IDC_USERCALL, OnSelchangeUsercall)
	ON_BN_CLICKED(IDC_DELUSER, OnDeluser)
	ON_BN_CLICKED(IDC_ADDUSER, OnAdduser)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditUser message handlers

BOOL CEditUser::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	int nNb;
	int nPos;
	FILE *fptr;
	char szBuf[80];
	char szLang[80];
	char szNumMsg[80];

	if (fptr = fopen(SERVICE_FILE, "r"))
	{
		while (fgets(szBuf, sizeof(szBuf), fptr))
		{
			nNb = sscanf(szBuf, "%s %s", szNumMsg, szLang);
			if (nNb == 1)
				m_UserList.AddString(szNumMsg);
			else if (nNb == 2)
			{
				nPos = m_UserLang.AddString(szLang);
				m_UserLang.SetItemData(nPos, atoi(szNumMsg));
			}
		}
		fclose(fptr);
		unlink(SERVICE_FILE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditUser::Answer(char *szBuf, int nNb)
{
	char *ptr;
	int nPos;

	ptr = strtok(szBuf, "\n");
	while (ptr)
	{
		int i;
		char *scan;

		nPos = atoi(ptr);
		while (isdigit(*ptr))
			++ptr;
		while (*ptr && isspace(*ptr))
			++ptr;

		switch (nPos)
		{
		case 1 :
			scan = strchr(ptr, '-');
			if (scan)
				*scan = '\0';
			m_UserList.SelectString(-1, ptr);
			break;
		case 14 :
			sscanf(ptr, "%u", &m_uFlags);
			m_UserExcluded = (m_uFlags & 0x1) != 0;
			m_UserLocal    = (m_uFlags & 0x2) != 0;
			m_UserExpert   = (m_uFlags & 0x4) != 0;
			m_UserSysop    = (m_uFlags & 0x8) != 0;
			m_UserBBS      = (m_uFlags & 0x10) != 0;
			m_UserPaging   = (m_uFlags & 0x20) != 0;
			m_UserGuest    = (m_uFlags & 0x40) != 0;
			m_UserModem    = (m_uFlags & 0x80) != 0;
			m_UserReadAll  = (m_uFlags & 0x100) != 0;
			m_UserUnproto  = (m_uFlags & 0x200) != 0;
			m_UserPrivMsg  = (m_uFlags & 0x400) != 0;
			m_UserPMS      = (m_uFlags & 0x800) != 0;
			break;
		case 17 :
			for (i = 0 ; ; i++)
			{
				int NumLang;
				NumLang = m_UserLang.GetItemData(i);
				if (NumLang == LB_ERR)
					break;
				if (NumLang == atoi(ptr))
				{
					m_UserLang.SetCurSel(i);
					break;
				}
			}
			break;
		case 22:
			m_UserName = ptr;
			if (!((CFbbWDlg *)GetParent())->m_bAnsi)
				m_UserName.OemToAnsi();
			break;
		case 27:
			m_UserHome = ptr;
			break;
		case 29:
			m_UserPrivDir = ptr;
			break;
		case 31:
			m_UserPasswd = ptr;
			break;
		case 32:
			m_UserZip = ptr;
			break;
		}
		ptr = strtok(NULL, "\n");
	}
	m_Ok.EnableWindow();
	m_Del.EnableWindow();
	UpdateData(FALSE);
}

void CEditUser::OnSelchangeUsercall() 
{
	// TODO: Add your control notification handler code here
	char szCall[20];
	m_UserList.GetText(m_UserList.GetCurSel(), szCall);

	char szCommand[80];
	wsprintf(szCommand, "GET %s", szCall);
	((CFbbWDlg *)GetParent())->RequestService(6, szCommand);	
	ClearAll();
}

DWORD CEditUser::MakeFlag(DWORD uMask, DWORD uBit, BOOL bVal)
{
	return (bVal) ? uMask | uBit : uMask & ~uBit;
}

void CEditUser::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);

	char szBuffer[256];
	int nPos = 0;

	DWORD uFlags = m_uFlags;
	uFlags = MakeFlag(uFlags, 0x1, m_UserExcluded);
	uFlags = MakeFlag(uFlags, 0x2, m_UserLocal);
	uFlags = MakeFlag(uFlags, 0x4, m_UserExpert);
	uFlags = MakeFlag(uFlags, 0x8, m_UserSysop);
	uFlags = MakeFlag(uFlags, 0x10, m_UserBBS);
	uFlags = MakeFlag(uFlags, 0x20, m_UserPaging);
	uFlags = MakeFlag(uFlags, 0x40, m_UserGuest);
	uFlags = MakeFlag(uFlags, 0x80, m_UserModem);
	uFlags = MakeFlag(uFlags, 0x100, m_UserReadAll);
	uFlags = MakeFlag(uFlags, 0x200, m_UserUnproto);
	uFlags = MakeFlag(uFlags, 0x400, m_UserPrivMsg);
	uFlags = MakeFlag(uFlags, 0x800, m_UserPMS);
	nPos += wsprintf(szBuffer+nPos, "14 %lu\n", uFlags);


	int nNumLang = m_UserLang.GetItemData(m_UserLang.GetCurSel());
	nPos += wsprintf(szBuffer+nPos, "17 %d\n", nNumLang);

	CString sTemp = m_UserName;
	if (!((CFbbWDlg *)GetParent())->m_bAnsi)
		sTemp.AnsiToOem();
	nPos += wsprintf(szBuffer+nPos, "22 %s\n", sTemp);
	nPos += wsprintf(szBuffer+nPos, "27 %s\n", m_UserHome);
	nPos += wsprintf(szBuffer+nPos, "29 %s\n", m_UserPrivDir);
	nPos += wsprintf(szBuffer+nPos, "31 %s\n", m_UserPasswd);
	nPos += wsprintf(szBuffer+nPos, "32 %s\n", m_UserZip);

	char szCall[20];
	m_UserList.GetText(m_UserList.GetCurSel(), szCall);

	char szCommand[256];
	wsprintf(szCommand, "PUT %s %d\n", szCall, nPos);
	strcat(szCommand, szBuffer);
	((CFbbWDlg *)GetParent())->RequestService(6, szCommand);	
	
	// CDialog::OnOK();
}

void CEditUser::OnDeluser() 
{
	// TODO: Add your control notification handler code here
	char szCall[20];
	int nPos = m_UserList.GetCurSel();
	m_UserList.GetText(nPos, szCall);
	m_UserList.DeleteString(nPos);
	ClearAll();

	char szCommand[256];
	wsprintf(szCommand, "DEL %s", szCall);
	((CFbbWDlg *)GetParent())->RequestService(6, szCommand);		
}

void CEditUser::OnAdduser() 
{
	// TODO: Add your control notification handler code here
	int nRet;

	char szCall[20];
	// Messagebox to get the callsign
	CInput Input(szCall, sizeof szCall);
	nRet = Input.DoModal();
	if (nRet == IDOK)
	{
		if (m_UserList.SelectString(-1, szCall) == LB_ERR)
		{
			char szCommand[256];
			m_UserList.AddString(szCall);
			wsprintf(szCommand, "NEW %s", szCall);
			((CFbbWDlg *)GetParent())->RequestService(6, szCommand);		
		}
		else
		{
			CString Str;
			Str.Format("Callsign %s already exists", szCall);
			MessageBox(Str, "Add user", MB_OK|MB_ICONEXCLAMATION);
		}
	}
}

void CEditUser::ClearAll() 
{
	// TODO: Add your control notification handler code here
	m_UserList.SetCurSel(-1);
	m_UserLang.SetCurSel(-1);

	m_UserExcluded = FALSE;
	m_UserLocal    = FALSE;
	m_UserExpert   = FALSE;
	m_UserSysop    = FALSE;
	m_UserBBS      = FALSE;
	m_UserPaging   = FALSE;
	m_UserGuest    = FALSE;
	m_UserModem    = FALSE;
	m_UserReadAll  = FALSE;
	m_UserUnproto  = FALSE;
	m_UserPrivMsg  = FALSE;
	m_UserPMS      = FALSE;
	m_UserName.Empty();
	m_UserHome.Empty();
	m_UserPrivDir.Empty();
	m_UserPasswd.Empty();
	m_UserZip.Empty();

	m_Ok.EnableWindow(FALSE);
	m_Del.EnableWindow(FALSE);

	UpdateData(FALSE);
}
