/*****************************************************************************
 *
 * setpciscc.h
 * Header file for setpciscc configuration tool
 *
 * Authors:	(c) 1999  Jens David <dg1kjd@afthd.tu-darmstadt.de>
 *
 * CVS:		$Id: setpciscc.h,v 0.3 1999/10/03 12:08:51 dg1kjd Exp $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *****************************************************************************/

#ifndef _SETPCISCC_H
#define _SETPCISCC_H

enum mode_t {
	mode_none,
	mode_global,
	mode_device,
	mode_led,
	mode_lbi,
	mode_status,
	mode_cal,
	mode_kick
};

/* prototypes */
static void open_socket(void);
static void set_leds(int argc, char **argv);
static void print_device(struct devcfg_t *cfg);
static void set_device(int argc, char **argv);
static void print_global(struct chipcfg_t *cfg);
static void set_global(int argc, char **argv);
static void get_status(int argc, char **argv);
static void do_cal(int argc, char **argv);
static void do_kick(int argc, char **argv);
static void usage(int error);
static void terminate(int error);

#endif
