
Unit s_UGroup;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm,
     Democmds, Menus;

Type

  PRightsEntry = ^TRightsEntry;
  TRightsEntry = object(TCheckBoxes)
    RightsMask : PRights;
    constructor Init(var Bounds: TRect; Mask: PRights; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PfRightsEntry = ^TfRightsEntry;
  TfRightsEntry = object(TCheckBoxes)
    RightsMask : PfRights;
    constructor Init(var Bounds: TRect; Mask: PfRights; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PUGroups = ^TUGroups;
  TUGroups = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;
    Usr_Timeout : PWordEntry;

    Grp         : Byte;    { Nkyvill oleva grouppi }
    Group       : PGroup;

    NeButton,
    PrButton,
    OKButton,
    CaButton,

    Used        : PButton;
    Name        : PCStr;
    Rights      : PRightsEntry;
    fRights     : PfRightsEntry;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
    procedure Draw; virtual;
    procedure ReInit; virtual;
    procedure ReDone; virtual;
    procedure Refresh; virtual;
  end;

Const
  RUGroups: TStreamRec = (
     ObjType: 10045;
     VmtLink: Ofs(TypeOf(TUGroups)^);
     Load:    @TUGroups.Load;
     Store:   @TUGroups.Store
  );

Procedure RegisterUGroupsForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TRightsEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TRightsEntry.Init(var Bounds: TRect; Mask: PRights; AStrings: PSItem);
Begin

 inherited Init(Bounds, AStrings);

 RightsMask := Mask;
 SetData(RightsMask^);

End;

Destructor TRightsEntry.Done;
Begin

 GetData(RightsMask^);
 inherited Done;

End;

 { *** TfRightsEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TfRightsEntry.Init(var Bounds: TRect; Mask: PfRights; AStrings: PSItem);
Begin

 inherited Init(Bounds, AStrings);

 RightsMask := Mask;
 SetData(RightsMask^);

End;

Destructor TfRightsEntry.Done;
Begin

 GetData(RightsMask^);
 inherited Done;

End;

 { *** TUGroups *** *** *** *** *** *** *** *** *** *** *** *** *** }

Procedure TUGroups.ReInit;
Var
  R : TRect;
  s : String;
Begin

  Group := @Conf^.Groups[Grp];

  R.Assign(14,2,31,3);
  Name := New(PCStr, Init(R,@Group^.Name,15));
  Insert(Name);

  If Group^.Used
    then s := '~E~nabled'
    else s := '~D~isabled';

  R.Assign(32, 2, 44, 4);
  Used := New(PButton, Init(R, s, cmChange, bfNormal));
  Insert(Used);
  Inc(R.A.X, 13); Inc(R.B.X, 10);
  NeButton := New(PButton, Init(R, '~N~ext', cmNext, bfNormal));
  Insert(NeButton);
  Inc(R.A.X, 10); Inc(R.B.X, 14);
  PrButton := New(PButton, Init(R, '~P~revious', cmPrev, bfNormal));
  Insert(PrButton);

  R.Assign(2,4,68,9);
  Rights := New(PRightsEntry, Init(R, @Group^.Rights,
    NewSItem('~L~ogin                        ', NewSItem('Login in ~A~RES mode', NewSItem('~I~nteract',
    NewSItem('~W~ide-area interact',
    NewSItem('A~R~ES command',
    NewSItem('LINK c~o~mmand', NewSItem('HALT and RE~B~OOT commands',
    NewSItem('S~U~ command', NewSItem('All ~c~ommands',
    NewSItem('Never ~e~xpires', nil ))))))))))));
  Rights^.HelpCtx := 1000;
  Rights^.EnableMask := $ffffffff xor (2 or 16);
  Insert(Rights);

  R.Assign(2,10,68,15);
  fRights := New(PfRightsEntry, Init(R, @Group^.fRights,
    NewSItem('~F~ile commands (BPUT/BGET/DIR)',
    NewSItem('Access to all file~s~', NewSItem('Write to inco~m~ing directory',
    NewSItem('Write ~t~o user directory', NewSItem('Write e~v~erywhere',
    NewSItem('Execute public (P~G~)', NewSItem('Execute in user directory',
    NewSItem('Execute ever~y~where', NewSItem('Execute ~D~OS commands', nil
     )))))))))));
  Rights^.HelpCtx := 1000;
  Insert(fRights);

  R.Assign(42, 18, 52, 20);
  OKButton := New(PButton, Init(R, 'O~K~', cmOk, bfDefault));
  Insert(OKButton);
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  CaButton := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
  Insert(CaButton);

End;

Procedure TUGroups.ReDone;
Begin

  Delete(Name);
  Dispose(Name);
  Rights^.Done;
  Dispose(Rights);
  fRights^.Done;
  Dispose(fRights);
  Used^.Done;
  Dispose(Used);
  Delete(NeButton);
  Delete(PrButton);
  Delete(OKButton);
  Delete(CaButton);

End;

Constructor TUGroups.Init;
Var
  R : TRect;
Begin

  R.Assign(0, 0, 71, 21);
  inherited Init(R,'User privilege groups');

  Grp := Conf^.UDefaults.DGroup;

  R.Assign(2, 2, 8, 3);
  Insert(New(PStaticText, Init(R, 'Group:')));

  ReInit;

  SelectNext(True);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TUGroups.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TUGroups.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TUGroups.Draw;
Var
  b : TDrawBuffer;
  s : String;
Begin

 inherited Draw;

 MoveCStr(b, Int2Str(Grp) + '  ', GetColor(19));
 WriteLine(9, 2, 2, 1, B);
 MoveCStr(b, '-', GetColor(1));
 WriteLine(12,2,1,1,B);

End;

Procedure TUGroups.Refresh;
Begin

 TUGroups.ReDone;
 TUGroups.ReInit;
 TUGroups.Draw;

End;

Procedure TUGroups.HandleEvent(var Event: TEvent);

  Procedure NextGrp;
  Begin

   If Grp < GroupsAvail
     then Begin
          Inc(Grp);
          TUGroups.Refresh;
          SelectNext(False);
          SelectNext(False);
          SelectNext(False);
          End;
  End;

  Procedure PrevGrp;
  Begin

   If Grp > 1
     then Begin
          Dec(Grp);
          TUGroups.Refresh;
          SelectNext(True);
          SelectNext(True);
          SelectNext(True);
          End;
  End;

  Procedure ChangeUsed;
  Begin

    Group^.Used := not Group^.Used;
    If (Grp = Conf^.UDefaults.DGroup) and not Group^.Used
      then Begin
           Group^.Used := True;
           MessageBox(^C'This group is currently selected as the default group for new users, and must be enabled!',
             nil, mfError + mfOkButton);
           End
      else If (Grp = 20) and not Group^.Used
            then Begin
                 Group^.Used := True;
                 MessageBox(^C'This is the superuser group, which must be enabled for the SU command to work!',
                    nil, mfError + mfOkButton);
                 End
            else TUGroups.Refresh;
  End;

Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
                 cmNext   : NextGrp;
                 cmPrev   : PrevGrp;
                 cmChange : ChangeUsed;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TUGroups.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterUGroupsForm;
Begin
  RegisterType(RUGroups);
End;

End.
