
 {

  EXECWSWP - Exec Windowed & Swapped

  Copyright (c) 1988,1990 TurboPower Software
  May be used freely as long as due credit is given

 }

{$R-,S-,F-,I-,B-}

Unit ExecWSwp;

 { Execute a program ("dos shell" as they call it... "dos hell" as I
   call it at times). Wish i had fork() & pipe() in DOS. 8-(
   Originally by TurboPower Software, copyrighted by them, and given
   to the public domain. With modifications by me. Can swap most of
   the program core to disk or EMS (dunno if the EMS part actually
   works). }

Interface

 { Windowed DOS EXEC supporting swap to EMS or disk }
Function ExecWinWithSwap(Path ,CmdLine : String; Xlo,Ylo,Xhi,Yhi : Byte;
                         Attr:Byte):Word;

 { Initialize for swapping, returning TRUE if successful }
Function InitExecSwap:Boolean;

 { Deallocate swap area }
Procedure ShutdownExecSwap;

 { ********** ********** ********** ********** ********** ********** }

Implementation
Uses Files;
Var
  EmsHandle   : Word;         { Handle of EMS allocation block }
  FrameSeg    : Word;         { Segment of EMS page frame }
  FileHandle  : Word;         { DOS handle of swap file }
  SwapName    : String[80];   { ASCIIZ name of swap file }
  SaveExit    : Pointer;      { Exit chain pointer }

  WindPos     : Word;
  WindLo      : Word;
  WindHi      : Word;
  WindAttr    : Byte;

  TmpInt21 : Pointer;

Type
  ByteCast    = record
                LoB,
                HiB : Byte;
                end;

Const
  UseEmsIfAvailable : Boolean = True;  { True to use EMS if available }
  BytesSwapped      : LongInt = 0;     { Bytes to swap to EMS/disk }
  EmsAllocated      : Boolean = False; { True when EMS allocated for swap }
  FileAllocated     : Boolean = False; { True when file allocated for swap }
  NewInt21Addr      : Pointer = nil;   { Filled in by InstallInt21 }

 { ********** ********** ********** ********** ********** ********** }
 { execwswp.obj: } {$L EXECWSWP}

function ExecWinWithSwap(Path, CmdLine : String;
                         Xlo, Ylo, Xhi, Yhi : Byte;
                         Attr : Byte) : Word; external;
procedure FirstToSave; external;
function AllocateSwapFile : Boolean; external;
procedure DeallocateSwapFile; external;

{$F+}     {These routines could be interfaced for general use}
function EmsInstalled : Boolean; external;
function EmsPageFrame : Word; external;
function AllocateEmsPages(NumPages : Word) : Word; external;
procedure DeallocateEmsHandle(Handle : Word); external;
function DefaultDrive : Char; external;
function DiskFree(Drive : Byte) : LongInt; external;
{$F-}

 { ********** ********** ********** ********** ********** ********** }

Procedure ShutdownExecSwap;
Begin

if EmsAllocated
  then begin
       DeallocateEmsHandle(EmsHandle);
       EmsAllocated := False;
       end
  else if FileAllocated
         then begin
              DeallocateSwapFile;
              FileAllocated := False;
              end;

end;

 { ********** ********** ********** ********** ********** ********** }

Function PtrDiff(H, L : Pointer) : LongInt;
Type
  OS = record O, S : Word; end;   {Convenient typecast}
Begin
  PtrDiff := (LongInt(OS(H).S) shl 4+OS(H).O)-
             (LongInt(OS(L).S) shl 4+OS(L).O);
End;

 { ********** ********** ********** ********** ********** ********** }

Function InitExecSwap:Boolean;
Const
  EmsPageSize = 16384;            { Bytes in a standard EMS page }
Var
  PagesInEms : Word;              { Pages needed in EMS }
  BytesFree  : LongInt;           { Bytes free on swap file drive }
  DriveChar  : Char;              { Drive letter for swap file }
  LastToSave : Pointer;
Begin

 LastToSave := Ptr(Seg(FreeList^)+$1000, 0);
 InitExecSwap := False;

 If EmsAllocated or FileAllocated then Exit;

 BytesSwapped := PtrDiff(LastToSave, @FirstToSave);

 If BytesSwapped <= 0 then Exit;

 If UseEmsIfAvailable and EmsInstalled
   then begin
        PagesInEms := (BytesSwapped+EmsPageSize-1) div EmsPageSize;
        EmsHandle := AllocateEmsPages(PagesInEms);
        if EmsHandle <> $FFFF
          then begin
               EmsAllocated := True;
               FrameSeg := EmsPageFrame;
               if FrameSeg <> 0
                 then begin
                      InitExecSwap := True;
                      Exit;
                      end;
               end;
        end;

 if Length(SwapFileName) <> 0
   then begin
        SwapName := SwapFileName+#0;
        if Pos(':', SwapFileName) = 2
          then DriveChar := Upcase(SwapFileName[1])
          else DriveChar := DefaultDrive;
        BytesFree := DiskFree(Byte(DriveChar)-$40);
        FileAllocated := (BytesFree > BytesSwapped) and AllocateSwapFile;
        if FileAllocated
          then InitExecSwap := True;
        end;

end;

 { ********** ********** ********** ********** ********** ********** }

End.