r 4
Message #4 
Date: Tue, 13 Feb 1996 21:15:30 +0100
To: Heikki Hannikainen <oh7lzb@zone.pspt.fi>
From: olecam@imaginet.fr (Olivier Le Cam, F5MZN)
Subject: Re: PC Mail protocol

>> I have installed WIN95 this week end, and I am not enjoyed with it. I
>> encoured many crashes when using two DOS windows, one for my C++ compiler
>> and the other for TERM4 (especially when using the debuger). I am out of
>> luck as you see :-)
>
>  Hehe. Yup, some software combinations are always problematic. What
>debugger are you using? Borland's Turbo Debugger? It worked fine for
>me... but haven't used it too much, since the one built in Borland Pascal=

>is OK for me. Delphi debugger worked also OK, but it's a win app... i
>guess Win just needs a bit of tuning to get it running fine 8-)

One built in Borland C++ too. I use BC 3.1 for the developpement (running
under DOS) but the public release of dxnet is compiled with BC 4.5 because I
bought it (and not 3.1...)

There is no more integrated debugger for DOS in BC 4.5 because the EDI is
running under WINDOWS ; and using Turbo Debbuger is not as usefull as the
one built. In BC 4.5 the same WINDOWS EDI is used for DOS, WINDOWS 16/32
bits and only WINDOWS 16 bits source code is supported by the integrated
debugger.

>  How are you running BPQ? Any other TSR-like stuff on the background?

I've installed WIN95 in a special directory, not in place of WINDOWS 3.11.
Then because I have absolutely no DOCS for WIN95, I've try to add
BPQCODE.EXE into autoexec.bat. Does you do the same ?

The special driver for my I/O (wich increase the transfer rate of my HDD) is
not supported too by WIN95. And when I've try to run SYSINFO.EXE (from
NORTON 7) to display the specs of the transfer rate without this driver :
BIG CRASH under WIN95 ... SYSINFO is NOT supported ! :-)

>Win95 has an internal disk cache, don't try to run another from autoexec.=

>I tried to run hyperdisk at first, guess how did it go 8-)

I tried no other disk cache... And I've see autoexec.bat/config.sys is not
the same under DOS or WIN95.

>  Yup, i already included NAme and Qth, but no HOME node yet. I chose WW
>loc, as i guess people use it more (at least in F/U/SHF, and i guess on
>HF too... it's easier to exchange over radio). I'm going to add
>conversion routines (to add as an user command) and also support
>exchanging coordinates over the PC protocol. Hmmm.... which system should=

>we use in the new protocol? Coordinates give better accuracy... it might
>be a better choice, it gives the accuracy if we need it some day?

To have a good accuracy, two floats for the long/lat could be send ... but I
am agree with an earlier message you wrotte me : float are not always well
compatible betweem two language and/or OS.

Another way could be to send 6 BYTES (long DDMMSS / lat DDMMSS). It is
better in term of bandwidth as 2 floats and give the same accuracy.

DD = degres
MM = minutes
SS = secondes

More better : assume DD is always lower than 90, DD & MM lower than 60.
We need 7 bits for DD + 1 for the sign
        6 bits for MM + 6 for SS

Total is (7 + 1 + 6 + 6) = 40, wich can be carry by 5 BYTES.

But there is perhaps more better ? ...

For WW locator, 4 BYTES should be enough. Each letter spends 5 bits and each
number spends 4.

I am not sure we never need more accurary than a WW loc can give. As far as
I know, any common hams application (such 10 GHz tropo, EME, satellite) are
needed that. Yup, a program wich can compute a tropo pass loth as the ground
configuration (asl, obstacles...) does, but we NEVER add a such program,
isnt it ?

>  BTW, do you have any good code for converting long/lat <> WW loc?

I wrotte a couple of lines (included in my logging contest software) for
converting a WW loc to coordonates (but not the opposite) and compute
distance and azimut. Accuracy is not so bad.

I know I have something more about converting somewhere ... Let me look for
them... :-)

Following is a part of the source. Sorry, all comments are in frensh ; I put
some english comments for you just to explain each function.

//------Constantes utilisees par le module=
 ED_CALCU.C------------------------
#define PI 3.141592654
#define P  40076.59
#define K  (PI/180)
#define L  (180/PI)
#define M  (PI/2)

//------Variables=
 globales---------------------------------------------------
double u, v; //Coordonnees latitude et longitude
double d; //Utilise pour le calcul de la distance et de l'azimut
double ad;//Idem mais pour tester l'ambiguite de cadran (calcul azimut)

#include "ed_calcul.h"

//****** converting EU loc -> long/lat
//------Conversion Ancien-loc vers=
 Lat/Long----------------------------------
int anc2ll(char loc[7])
{
  double H[] = { 0,1,2,2,2,1,0,0,0,0,1,0,0,1,2,2,2,1,0,0,0,1 };
  double  b, c, d, e;
  int f;

  //------Verification de la validite du locator
  // A poursuivre !*************************************************

  if(loc[2] < '0' || loc[2] > '9' || loc[3] < '0' || loc[3] > '9')
    return(0);
  if (loc[4] < 'A' || loc[4] > 'J')
    return(0);

  b = loc[0] - 65;
  c = loc[1] - 64;
  d = loc[2] - 48;
  e = loc[3] - 48;
  f = loc[4] - 64;

  if ( b > 18)
    b -= 26;
  if ( c > 21)
    c -= 26;
  if ( e == 0)
  {
    e = 10;
    d--;
  }

  u = ( 40.000000 + c - (d*0.125000) - ( H[f + 10]*0.0416666 ) - 0.020833=
 );
  v = ( (2.000000 * b) + (e*0.200000) + ( H[f]*0.066666) - 0.169000 );

  u *= K; //Conv degres -> radians
  v *= K;

  return(1);

}

//****** Converting WW loc -> long/lat
//------Conversion Nouveau Loc vers Lat/Long--------------------------------
int new2ll(char loc[7])
{
  //------Verification de la validite du locator
  if(loc[0] < 'A' || loc[0] > 'Z' || loc[1] < 'A' || loc[1] > 'Z')
    return(0);
  if(loc[2] < '0' || loc[2] > '9' || loc[3] < '0' || loc[3] > '9')
    return(0);
  if(loc[4] < 'A' || loc[4] > 'X' || loc[5] < 'A' || loc[5] > 'X')
    return(0);

  v = (loc[0] - 65)*20 - 180 + (loc[2] - 48)*2 + (loc[4] -=
 65)*0.0833333333
+ 0.0416666666;
  u = (loc[1] - 65)*10 -  90 + (loc[3] - 48)   + (loc[5] -=
 65)*0.0416666666
+ 0.0208333333;

  v *= K; //Conv degres -> radians
  u *= K;

  return(1); //Locator OK
}

//****** Distance betweem lat1/long1 and lat1/long1
//------Calcul la distance entre coordonnees x;y et u;v---------------------
unsigned int distance(void)
{
  double z;
  double cos_d, cos_ad, distance;

  z = v - y;
  cos_d = cos(z) * cos(x) * cos(u) + ( sin(x) * sin(u) );
  cos_ad = cos(z) * cos(x) * cos(u + 0.000150) + ( sin(x) * sin(u +=
 0.000150) );
  d = acos( cos_d );
  ad= acos( cos_ad );
  distance = d * L; //Conv radians -> degres
  distance *= 111.200000;
  distance = floor( distance + 0.5); //On arrondit
  return( (int) distance );
}

//****** Azimut betweem lat1/long1 and lat2/long2
//------Calcule l'azimut entre coordonn=82es x;y et=
 u;v-----------------------
unsigned int azimut(void)
{
  double z;
  double sin_a, sin_ap;
  double azimut, azimut_p;

  if( d == 0) //Si la distance est nulle (meme locator) Az = 0
    return(0);

  z = v - y;

  sin_a    = sin(z) * cos(u) / sin(d);
  sin_ap   = sin(z) * cos(u + 0.000150) / sin(ad);
  azimut   = asin(sin_a);
  azimut_p = asin(sin_ap);
  azimut   *= L; //Conv radians -> degr=82s
  azimut_p *= L; //Id

  if( fabs(azimut_p) > fabs(azimut)) //Ambiguite de cadran
  {
    if( azimut > 0)
      azimut = 180 - azimut;
    else
      azimut = -(azimut + 180);
  }

  if( (azimut == 0.000000) && (u < x) ) //Si azimut = 180 pile poil
  {
    if( azimut > 0)
      azimut = 180 - azimut;
    else
      azimut = -(azimut + 180);
  }


  if( azimut < 0)
    azimut += 360;

  azimut = floor (azimut + 0.5); //On arrondit et on prend la val. abs.


  return( (int) azimut );
}

------------------------------------------------------
Olivier Le Cam
Email : olecam@imaginet.fr (or f5mzn@imaginet.fr)
AX25  : F5MZN@F6KPF.FBRE.FRA.EU
------------------------------------------------------


