{$F-} {$R-} {$Q-} {$I-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Database;

  { Implements the LOUSY "database" thing. Ugly, bad, slow, inefficient.
    I didn't know just about anything about programming back when wrote
    this. Includes the "find" command, implements the remote
    database stuff, and the special prefix database as well. }

Interface
Uses Protocol, ConfFile;

Type
  ResProc      = Procedure(Const s:String);

Var
  DBConfigMem      : LongInt;   { How much memory does database
                                  configuration occupy (static) }
  RDbJobs          : Word;      { How many remote db queries going on }

 { ** User commands ** }

   { Remote databases }
Procedure Rdb_Response(po:Byte);  { Command during a remote query }
Procedure Rdb_Logout(po:Byte);    { User logged out, clear queries }
Procedure RdbStatus_Cmd(po:Byte); { Show remote query list }

Procedure Find_Cmd(p:Byte);       { Query a database }
Procedure Prefix_Cmd(p:Byte);     { Prefix search }
Procedure DbStatus_Cmd(p:Byte);   { Database statistics }

 { Remote database interface }

Procedure RdbRequest(p:Byte;Proto:Byte;FromPc,FromUser:CallRec;Stream:Word;
                     Qualifier,Key:String); { Remote query to a local db }
Procedure RdbResponse(FromPc:CallRec;Stream:Word;Info:String); { Response to a query }
Procedure RDbResponseEnd(FromPc:CallRec;Stream:Word); { Response end }
Procedure Rdb_DelNode(n:NodeRecP); { Node was deleted, check for queries }
Procedure SecTimer;                { Update timeouts }

 { Other stuff }

Procedure Init;                    { Initialize... }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation

Uses Dos, BPQ, Config, cStrings, cMath, Screen, Files, XMSLib, Buck,
     PCLink, Cluster;

Type
  PrefixRec   = String[10];

  DxccBP    = ^DxccBRec;
  DxccBRec  = Record  { Entry in the prefix database }
              Prefix    : PrefixRec;  { Main prefix for the country }
              Country   : String[26]; { Country name }
              Continent : String[2];  { Continent abbreviation }
              ITUz,                   { ITU zone }
              CQz       : Byte;       { CQ zone }
              TimeZone  : Real;       { Difference from UTC }
              Loc       : CoordRec;   { Coordinates }
              WAEDC     : Boolean;    { Listed on DARC WAEDC? }
              End;

  DxccBIP   = ^DxccBIRec;
  DxccBIRec = Record  { Entry in the prefix database index }
              Prefix : PrefixRec;    { Prefix }
              Pos    : Word;         { Location in the database }
              End;

  IndexXtype = Record
               Handle : Word;        { XMS handle }
               Size   : LongInt;     { Size, in bytes }
               End;

  TDbFormat = (local, remote, hamcall); { Type of a database }

  DbTypeP = ^DbType;
  DbType  = Record { Database list entry }
            Format    : TDbFormat;   { Type of the database }
            Name      : String[10];  { Short name }
            Desc      : String[70];  { Long name / explanation }
            InfoFile  : String[12];  { Information / help file }
            Files     : Array[1..5] of String[12]; { Database files }
            Indexes   : Array[1..5] of String[12]; { Index files }
            IndexXMS  : Boolean;     { Index in XMS }
            IndexX    : Array[1..5] of IndexXType; { Handles }
            FileCount : Byte;        { How many database files }
            IdxLen,                  { Maximum lenght of a keyword
                                       / Timeout }
            IdxRecLen : Word;        { Length of an entry in index file }
            Keywords,                { How many entries in index file }
            Records   : LongInt;     { How many records in database}
            { Statistics }
            Queries,                 { How many queries }
            Hits      : LongInt;     { How many hits }
            { Linked list }
            Next      : DbTypeP;     { Next entry in list }
            End;

  PPrQueryType = ^PRQueryType;  { Remote query list }
  PRQueryType  = ^RQueryType;
  RQueryType   = Record  { If you change this, update it's size at
                           MemStat_Cmd in cluster.pas ! }
                 p           : Byte;         { Local user, who did the query }
                 QueryStream : Word;         { virtual stream number used for PC44 }
                 Node        : CallRec;      { Remote node }
                 dbp         : DbTypeP;      { Database being queried }
                 Timeout,                    { Timeout (!) }
                 Time        : Word;         { Timeout timer, in seconds }
                  { Semi-doubly linked list }
                 PrevP       : PPRQueryType;
                 Next        : PRQueryType;
                 End;

  PResSType   = ^ResSType;
  ResSType    = Record  { Used to return the results of a query }
                Stream : Byte;
                Prefix : String;
                End;

  PDxccType   = ^DxccType;
  DxccType    = Record  { Configuration for the prefix database }
                Bf      : File of DxccBRec;   { Database file }
                BIf     : File of DxccBIRec;  { And the index... }
                BIfp    : DxccBIP;            { Index in memory }
                BIs     : Word;               { Size of the index }
                Bfi     : LongInt;            { How many records }
                BIi     : Word;               { How many index entries }
                Queries : LongInt;            { How many queries }
                Hits    : LongInt;            { How many hits }
                X       : Boolean;            { Is index in XMS? }
                XHandle : Word;               { XMS handle }
                End;
Var

  Dblist      : DbTypeP;      { Database configuration, linked list }
  Dxcc        : PDxccType;    { Prefix database configuration }
  RQueryList  : PRQueryType;  { Remote database query list }
  RDbStr      : Byte;

  ResStream   : PResSType;    { Return CluPath for query results }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Compare strings. For the prefix database. Returns the amount of
   matched characters from the beginning of the strings. }

Function CompStr(Str1:String;Str2:String):Byte;
Var
  b : Byte;
Begin

 b := 1;
 While (Str1[b] = Str2[b])
  do Inc(b);
 Dec(b);

 If (Length(Str1) > b) or (b > Length(Str2))
   then b := 0;

 CompStr := b;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Converts time from UTC to local time }

Function LocalTime(Offset:Real):String;
Var
  TimeH  : Real;
  h, min : Byte;
Begin

 TimeH := Dt.Hour         { Hours }
        + (Dt.min / 60)   { Minutes }
        + Offset;         { Offset from UTC }

  { Fit it into 24 hours }
 If TimeH < 0
   then TimeH := TimeH + 24;
 If TimeH >= 24
   then TimeH := TimeH - 24;

 h   := Trunc(TimeH);
 min := Trunc((TimeH - h) * 60);

 LocalTime := Int2Str(h) + ':' + IntStr(min);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { PacketCluster-type database lookup                                      }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function lookup(dbp:dbTypeP; Const key:String; Res:ResProc):Boolean;
Const
  IdxBufLen  = 16384;
Type
  IdxBufType = Array[1..IdxBufLen] of Byte;
  IdxRecType = Record
               Pos : LongInt;
               Key : String;
               End;
Var
  Rec  : ^IdxRecType;
  Buf  : ^IdxBufType;
  pnt  : Pointer;
  b    : Byte;
  f    : File;
  Red  : Integer;
  w    : Word;
  s    : String;
  XPos : LongInt;
  Fou  : Boolean;
  iEnd : Boolean;

Begin

 Fou := False;

 For b := 1 to dbp^.FileCount
   do Begin
      New(Buf);
      iEnd := False;

      If dbp^.IndexXMS
        then XPos := 0
        else Begin
             Assign(f,DatabasePath + dbp^.Indexes[b]);
             Reset(f,dbp^.IdxRecLen);
             End;

      Assign(BufFile,DatabasePath + dbp^.Files[b]);

      Repeat

        If dbp^.IndexXMS
          then Begin
               If dbp^.IndexX[b].Size - XPos > IdxBufLen
                 then Red := (IdxBufLen div dbp^.IdxRecLen)
                 else Begin
                      Red := (dbp^.IndexX[b].Size - XPos) div dbp^.IdxRecLen;
                      iEnd := True;
                      End;
               xmsCheck(XMBToBase(red * dbp^.IdxRecLen,Buf,dbp^.IndexX[b].Handle, XPos));
               Inc(XPos,red * dbp^.IdxRecLen);
               End
          else Begin
               BlockRead(f,Buf^,(IdxBufLen div dbp^.IdxRecLen), Red);
               iEnd := eof(f);
               End;

        pnt := Buf;
        Rec := pnt;

        For w := 1 to Red
          do Begin
             If Rec^.Key = Key
               then Begin
                    Fou := True;
                    FBufInit(1);
                    Seek(BufFile,Rec^.Pos);
                    s := BReadLine;
                    While (s <> ('&&'))
                      do Begin
                         Res(s);
                         If BufDone
                           then s := '&&'
                           else s := BReadLine;
                         End;
                    FBufClose;
                    End;
             Rec := Ptr(Seg(Rec^),Ofs(Rec^) + dbp^.IdxRecLen);
             End;

      until iEnd;

      If not dbp^.IndexXMS
        then Close(f);

      Dispose(Buf);

      End;

 If Fou
   then LookUp := True
   else Begin
        Res('Not found.');
        LookUp := False;
        End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Query a remote database                                                 }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 Function GetRQP(Stream:Byte):PRQueryType;
 Var qp : PRQueryType;
 Begin
  qp := RQueryList;
  While Assigned(qp) and (qp^.QueryStream <> Stream)
   do qp := qp^.Next;
  GetRQP := qp;
 End;

 Function GetRQPu(po:Byte):PRQueryType;
 Var qp : PRQueryType;
 Begin
  qp := RQueryList;
  While Assigned(qp) and (qp^.p <> po)
   do qp := qp^.Next;
  GetRQPu := qp;
 End;


 Procedure DelRQP(qp:PRQueryType);
 Begin
  qp^.PrevP^ := qp^.Next;
  If Assigned(qp^.Next)
    then qp^.Next^.PrevP := qp^.PrevP;
  Dispose(qp);
  Dec(RDBJobs);
 End;

Function RemoteLookUp(po:Byte; db:dbTypeP; Const key:String):Boolean;
Var
 qp : PRQueryType;
 b  : Word;
 n  : NodeRecP;
Begin

 b := 1;
 n := GetNode(db^.Files[1]);
 If Assigned(n)
   then Begin
        New(qp);
        Inc(RDbJobs);
        Inc(RDbStr);
        If RDbStr = 100
         then RDbStr := 1;

        With qp^
         do Begin
            p := po;
            QueryStream := RDbStr;
            Node := db^.Files[1];
            dbp := db;
            Timeout := db^.IdxLen;
            Time := 0;
            Next := RQueryList;
            RQueryList := qp;
            If Assigned(Next)
              then Next^.PrevP := @Next;
            PrevP := @RQueryList;
            PCLink.RDbRequest(Node, CluCall, LUser[po]^.f^.Call, QueryStream,
                              db^.Files[2], Key);
            End;

        LUser[po]^.M2 := 7;
        Prompted := False;

        End
   else Send(po,'Node cannot be reached right now. Please try again later.' + Cr);

 RemoteLookUp := False;

End;

Procedure RdbResponse(FromPc:CallRec;Stream:Word;Info:String);
Var
  qp : PRQueryType;
Begin

 qp := GetRQP(Stream);
 If Assigned(qp) and (qp^.Node = FromPc)
   then Send(qp^.p,Info + Cr);

End;

Procedure EndRdbQuery(qp:PRQueryType; Reason:String);
Begin

 With qp^
  do Begin
     If not (Length(Reason) = 0)
       then Send(p, 'Remote query failed: ' + Reason + Cr);
     LUser[p]^.M2 := 0;
     Send(p,Prompt(p));
     End;

 DelRQP(qp);

End;

Procedure RDbResponseEnd(FromPc:CallRec;Stream:Word);
Var
  qp : PRQueryType;
Begin

 qp := GetRQP(Stream);
 If Assigned(qp) and (qp^.Node = FromPc)
   then Begin
        Inc(qp^.dbp^.Hits);
        EndRdbQuery(qp,'');
        End;
End;

Procedure Rdb_Response(po:Byte);  { Command during a remote query }
Begin

 If AbortStr
   then Begin
        Send(po,'Aborted.' + Cr);
        DelRQP(GetRQPu(po));
        LUser[po]^.M2 := 0;
        End
   else Prompted := False;

End;

Procedure Rdb_Logout(po:Byte);    { User logged out, clear queries }
Var
  qp : PRQueryType;
Begin

 qp := GetRQPu(po);
 If Assigned(qp)
   then DelRQP(qp);
End;

Procedure Rdb_DelNode(n:NodeRecP); { Node was deleted, check for queries }
Var
  qp, next : PRQueryType;
Begin

 qp := RQueryList;
 While Assigned(qp)
  do Begin
     next := qp^.Next;
     If qp^.Node = n^.Call
       then EndRdbQuery(qp,'Node vanished.');
     qp := Next;
     End;
End;

Procedure SecTimer;                { Update timeouts }
Var
  qp, next : PRQueryType;
Begin

 qp := RQueryList;
 While Assigned(qp)
  do Begin
     next := qp^.Next;
     Inc(qp^.Time);
     If qp^.Time >= qp^.Timeout
       then EndRdbQuery(qp,'timeout.');
     qp := Next;
     End;
End;

Procedure RdbStatus_Cmd(po:Byte); { Show remote query list }
Var qp : PRQueryType;
Begin

 Action(po,'Status - rDb queries');
 Send(po,'Remote database query jobs: ' + Int2Str(RDbJobs) + Cr
       + ' Database   User      vStr On node   Time tOut' + Cr);
 qp := RQueryList;
 While Assigned(qp)
  do With qp^ do
     Begin
     Send(po,' ' + PadLeft(11,dbp^.Name) + PadLeft(10,LUser[p]^.f^.Call)
            + PadLeft(5,Int2Str(QueryStream)) + PadLeft(10,Node)
            + PadLeft(5,Int2Str(Time)) + Int2Str(Timeout) + Cr);
     qp := Next;
     End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { The database lookup command "Find"                                      }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 Procedure UserRes(Const s:String); far;
 Begin
   Send(ResStream^.Stream,s + Cr);
 End;

Procedure Find_Cmd(p:Byte);       { Query a database }
Var
  Key  : String;
  dbp  : DbTypeP;
  Fou  : Boolean;

Begin

 Key := UpCaseStr(Parse(1));
 dbp := Dblist;

 While assigned(dbp) and (dbp^.Name <> Key)
  do dbp := dbp^.Next;

 If assigned(dbp)
  then Begin
       Key := UpCaseStr(Parse(2));
       Action(p,'Database query for ' + dbp^.Name);
       If Key <> ''
        then Begin
             Inc(dbp^.Queries);
             New(ResStream);
             ResStream^.Stream := p;

              Case dbp^.Format of
                Remote  : Send(p,'Querying remote database on node ' + dbp^.Files[1] + '... <CTRL-Z> or /ex aborts.' + Cr);
                else Send(p,'Searching...' + Cr);
              End;
              Kick(p);

             Case dbp^.Format of
               Local   : Fou := LookUp(dbp,Key,UserRes);
               Hamcall : Fou := BuckLookUp(Key,UserRes);
               Remote  : Fou := RemoteLookUp(p,dbp,Key);
             End;

             If fou
               then Inc(dbp^.Hits);
             Dispose(ResStream);
             End
        else If not SendFile(p,DatabasePath + dbp^.InfoFile)
               then Send(p,'No key specified.' + Cr);
       End
  else Begin
       Action(p,'Invalid database query');
       If assigned(dblist)
        then Begin
             Send(p,'Databases available:' + Cr);
             dbp := DbList;
             While assigned(dbp)
              do Begin
                 Send(p,' ' + PadLeft(11,dbp^.Name) + dbp^.Desc + Cr);
                 dbp := dbp^.Next;
                 End;
             Send(p,'Usage: Find (database) (keyword)' + Cr);
             End
        else Send(p,'No databases installed.' + Cr);
       End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Remote database request                                                 }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 Procedure PCRes(Const s:String); far;
 Begin

  Send(ResStream^.Stream,ResStream^.Prefix + s + '^' + Cr);

 End;

Procedure RdbRequest(p:Byte;Proto:Byte;FromPc,FromUser:CallRec;Stream:Word;
                     Qualifier,Key:String);
Var
  dbp  : DbTypeP;
  Fou  : Boolean;
Begin

 New(ResStream);
 ResStream^.Stream := p;
 ResStream^.Prefix := 'PC45^' + FromPC + '^' + CluCall + '^'
                       + Int2Str(Stream) + '^';

 dbp := Dblist;

 While assigned(dbp) and (dbp^.Name <> Qualifier)
  do dbp := dbp^.Next;

 If assigned(dbp)
  then Begin
       Action(73,'Remote db query for ' + dbp^.Name + ' key "' + Key + '" from ' + FromUser);
       {$IFDEF EXTRALOG} Log('RDB query for ' + dbp^.Name + ' key "' + Key + '" from ' + FromUser); {$ENDIF}
       If Key <> ''
        then Begin
             Inc(dbp^.Queries);

             Case dbp^.Format of
               Local   : Fou := LookUp(dbp,Key,PCRes);
               Hamcall : Begin
                         Key := CutStr(9,Key);
                         Fou := BuckLookUp(Key,PCRes);
                         End;
               Remote  : PCRes('Database is remote, on node ' + dbp^.Files[1] + '. Cannot query.');
             End;

             If fou
               then Inc(dbp^.Hits);

             End
        else PCRes('No keyword specified.');
       End
  else Begin
       Action(p,'Invalid remote db query');
       PCRes('Invalid database query, database not found.');
       End;

 Send(p,'PC46^' + FromPC + '^' + CluCall + '^' + Int2Str(Stream) + '^' + Cr);
 Kick(p);
 Dispose(ResStream);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Get information on prefix/callsign                                      }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Prefix_Cmd(p:Byte);     { Prefix search }
Var
 Prefix : PrefixRec;
 Idx    : DxccBIp;
 IdxPos : Word;
 rec    : DxccBRec;
 Best   : Word;
 BestQ  : Byte;
 Q      : Byte;
 ok     : Boolean;
 az     : Real;
Begin

 If Assigned(Dxcc)
  then Begin
       Prefix := UpCaseStr(Parse(1));
       Action(p,'Prefix query for ' + Prefix);
       If Prefix <> ''
        then Begin
             Inc(Dxcc^.Queries);
             BestQ := 0;

             If Dxcc^.X
               then Begin
                    GetMem(Dxcc^.BIfp,Dxcc^.BIs);
                    ok := XMBtoBase(Dxcc^.BIs,Dxcc^.BIfp,Dxcc^.XHandle,0);
                    End;

             Idx := Dxcc^.BIfp;
             IdxPos := 0;

             Repeat
               Inc(IdxPos);
               Q := CompStr(Idx^.Prefix,Prefix);
               If Q > BestQ
                 then Begin
                      Best := Idx^.Pos;
                      BestQ := Q;
                      End;
               Idx := Ptr(Seg(Idx^),Ofs(Idx^) + SizeOf(DxccBIRec));
             until IdxPos = Dxcc^.BIi;

             If Dxcc^.X
               then FreeMem(Dxcc^.BIfp,Dxcc^.BIs);

             If BestQ > 0
               then Begin
                    Inc(Dxcc^.Hits);
                    Reset(Dxcc^.Bf);
                    Seek(Dxcc^.Bf,Best-1);
                    Read(Dxcc^.Bf,rec);
                    Close(Dxcc^.Bf);
                    IOCheck('reading dxcc.cdb');
                    Send(p,Format(True,rec.Prefix + ':',rec.Country + ', ' + rec.Continent + '. ITU zone '
                         + Int2Str(rec.ITUz) + ', CQ zone ' + Int2Str(rec.CQz)
                         + '. Local time is ' + LocalTime(rec.TimeZone) + ' (UTC'
                         + TZ2Str(rec.TimeZone) + ' hours). Coordinates ' + Coord2Str(rec.Loc) + '.' + Cr));
{   + '. Distance ' + Int2Str(DistAz(LUser[p]^.f^.Loc,Rec.Loc,az)) + ', heading ' + Real2Str(az) + '.' ));}
                    End
               else Send(p,'Sorry, ' + Prefix + ' didn''t match any prefix in the DXCC database.' + Cr);
             End
        else Send(p,'Usage: Prefix (prefix or callsign to search)' + Cr);

       End
  else Send(p,'No DXCC database installed.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Database statistics                                                     }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure DbStatus_Cmd(p:Byte);   { Database statistics }
Var
  dbp : DbTypeP;
Begin

 Action(p,'Status - Database');
 Send(p,'Database status:' + Cr
      + 'Database    Keywords Records Queries Hits' + Cr);
 If Assigned(Dxcc)
  then With Dxcc^
         do Send(p,' DXCC       ' + PadLeft(9,Int2Str(BIi)) + PadLeft(8,Int2Str(BFi))
                 + PadLeft(8,Int2Str(Queries)) + PadLeft(6,Int2Str(Hits))
                 + '(' + Percentage(Hits,Queries) + ')' + Cr);
 dbp := DbList;
 While assigned(dbp)
  do Begin
     Send(p, ' ' + PadLeft(11,dbp^.Name)
          + PadLeft(9,Int2Str(dbp^.Keywords)) + PadLeft(8,Int2Str(dbp^.Records))
          + PadLeft(8,Int2Str(dbp^.Queries)) + PadLeft(6,Int2Str(dbp^.Hits))
          + '(' + Percentage(dbp^.Hits,dbp^.Queries) + ')' + Cr);
     dbp := dbp^.Next;
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Read cty.dat and convert to binary format w/index                       }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure ReadRawPrefix;
Var
  Rawf    : Text;                   { cty.dat }
  Fbuf    : Array[1..2048] of Char; { File buffer for cty.dat }
  PR, PR2 : DxccBRec;               { Record in the prefix database }
  PI, PO  : DxccBIRec;              { Record in the index file }
  Over    : Byte;                   { How many changes }
  Override,                         { Changes from the normal }
  PrefL   : Boolean;                { Is this a prefix line, not a change line }
  b,s,e   : Byte;
  str     : String[20];
  st      : String[10];
  ftime   : LongInt;
Begin

 Rewrite(Dxcc^.Bf);
 Rewrite(Dxcc^.BIf);
 PI.Pos := 0;
 PrefL := False;
 Over := 0;

 Assign(Rawf,DataBasePath + 'cty.dat');
 SetTextBuf(Rawf,fbuf);
 Reset(Rawf);
 IOCheck('opening cty.dat');

 While not eof(Rawf)
  do Begin
     ReadLn(RawF,IBuffer);
     IOCheck('reading cty.dat');
     If not (IBuffer[1] = '#') { A comment? }
      then
       If PrefL
        then Begin
             While Pos(',',IBuffer) > 0
               do IBuffer[Pos(',',IBuffer)] := ' ';
             If IBuffer[Length(IBuffer)] = ';'
              then Begin
                   PrefL := False;
                   IBuffer[Length(IBuffer)] := ' ';
                   End;
             IBuffer := CleanStr(IBuffer) + Cr;

             b := 0;
             str := Parse(b);

             Repeat
              PR2 := PR;
              Override := False;
              s := Pos('(',str);
              If s > 0
               then Begin
                    Override := True;
                    e := Pos(')',str);
                    PR2.CQz := Str2Byte(Copy(str,s+1,e-s-1));
                    Delete(str,s,e-s+1);
                    End;
              s := Pos('[',str);
              If s > 0
               then Begin
                    Override := True;
                    e := Pos(']',str);
                    PR2.ITUz := Str2Byte(Copy(str,s+1,e-s-1));
                    Delete(str,s,e-s+1);
                    End;
              s := Pos('{',str);
              If s > 0
               then Begin
                    Override := True;
                    e := Pos('}',str);
                    PR2.Continent := Copy(str,s+1,e-s-1);
                    Delete(str,s,e-s+1);
                    End;
              s := Pos('<',str);
              If s > 0
               then Begin
                    Override := True;
                    e := Pos('>',str);
                    st := Copy(str,s+1,e-s-1);
                    Delete(str,s,e-s+1);
                    s := Pos('/',st);
                    PR2.Loc.Lat := Str2Real(Copy(st,1,s-1));
                    PR2.Loc.Long := Str2Real(Copy(st,s+1,Length(st)-s)) * -1;
                    End;
              If Override
               then Begin
                    Inc(Over);
                    Write(Dxcc^.Bf,PR2);
                    IOCheck('writing dxcc.cdb');
                    PO.Pos := PI.Pos + Over;
                    End
               else PO.Pos := PI.Pos;
              PO.Prefix := str;
              Write(Dxcc^.BIf,PO);
              IOCheck('writing dxcc.idx');
              Inc(b);
              str := Parse(b);
             until str = '';
             End
        else Begin
             PI.Pos := PI.Pos + Over;
             Inc(PI.Pos);
             PR.Country := Copy(IBuffer,1,Pos(':',IBuffer)-1);
             Delete(IBuffer,1,Pos(':',IBuffer));
             While Pos(':',IBuffer) > 0
               do IBuffer[Pos(':',IBuffer)] := ' ';
             IBuffer := CleanStr(IBuffer) + Cr;
             PR.CQz := Str2Byte(Parse(0));
             PR.ITUz := Str2Byte(Parse(1));
             PR.Continent := Parse(2);
             PR.Loc.Lat := Str2Real(Parse(3));
             PR.Loc.Long := Str2Real(Parse(4)) * -1;
             PR.TimeZone := - Str2Real(Parse(5));
             PR.Prefix := Parse(6);
             If PR.Prefix[1] = '*'
               then Begin
                    PR.WAEDC := True;
                    Delete(PR.Prefix,1,1);
                    End
               else PR.WAEDC := False;
             Write(Dxcc^.Bf,PR);
             IOCheck('writing dxcc.cdb');
             Over := 0;
             PrefL := True;
             End;
     End;

 GetFTime(RawF,ftime);
 Close(Rawf);
 IOCheck('closing cty.dat');
 SetFTime(Dxcc^.Bf,ftime);
 SetFTime(Dxcc^.BIf,ftime);

 Write('Done. ');

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Initialize the databases                                                }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Init;
Type
  IdxBufType = Array[1..4096] of Byte;
Var
  f            : File;
  ftime, itime : LongInt;
  dp           : ^DbTypeP;
  dbp          : DbTypeP;
  b            : Word;
  IdxBuf       : ^IdxBufType;
  Int          : Integer;

  Procedure IndexDb(dbp:DbTypeP);
  Var
    s      : String;
    Key    : String;
    KeyPos : LongInt;
    Keys   : LongInt;
    IdxPos : Word;
    p      : Pointer;
    State  : Byte;
  Begin

    Write(' Indexing...               ');
    Rewrite(f,1);
    FBufInit(1);
    New(IdxBuf);
    s := '';
    State := 1;
    p := IdxBuf;
    IdxPos := 0;
    Keys := 0;
    Repeat

     s := BReadLine;

           Case State of
            0 : If s = '&&'
                  then State := 1;
            1 : If (Copy(s,1,3) <> 'UPD') and (Copy(s,1,2) <> '&&') then
                Begin
                Key := UpCaseStr(s);

                If Length(Key) > dbp^.IdxLen
                 then Begin
                      WriteLn(CrLf + '      Keyword ' + Key + ' is longer than the maximum' + CrLf
                                   + '      keyword length for this database.');
                      Halt(1);
                      End;
                Inc(Keys);
                Move(BufFilePos,p^,4);
                p := Ptr(Seg(p^),Ofs(p^) + 4);
                Move(Key,p^,dbp^.IdxLen);
                p := Ptr(Seg(p^),Ofs(p^) + dbp^.IdxLen);
                Inc(IdxPos,dbp^.IdxRecLen);
                If IdxPos + dbp^.IdxRecLen > 4096
                 then Begin
                      Write(BackSpaces(14) + PadRight(14,Int2Str(Keys) + ' ('
                            + IntStr(Round(BufFilePos / BufFileSize * 100)) + ' %)'));
                      BlockWrite(f,IdxBuf^,IdxPos);
                      p := IdxBuf;
                      IdxPos := 0;
                      End;
                State := 0;
                End
                else State := 0;
           End;

    until BufDone;

    BlockWrite(f,IdxBuf^,IdxPos);
    SetFTime(f,ftime);
    Reset(f,1);

    FBufClose;
    Dispose(IdxBuf);
    Write(BackSpaces(14));
  End;


Begin

 { Init variables }
 DBConfigMem := 0;
 RDbJobs := 0;
 RDbStr := 0;

 CWriteLn(' o Mounting databases:');
 dp := @DbList;

 If FileExists(CluPath + 'db.ini')
  then Begin
       AssignConf(CluPath + 'db.ini');
       While NextConfBlock
        do Begin
           New(dp^);
           Inc(DBConfigMem,SizeOf(DbType));
           dbp := dp^;
           b := Str2Byte(GetConfLine);
           Case b of
             0 : dbp^.Format := local;
             1 : dbp^.Format := remote;
             2 : dbp^.Format := HamCall;
           else dbp^.Format := local;
           End;
           dbp^.Name := UpCaseStr(GetConfLine);
           dbp^.Desc := GetConfLine;
           dbp^.InfoFile := GetConfLine;
           NeedConfLine;
           IBuffer := IBuffer + Cr;
           dbp^.FileCount := 0;
           For b := 1 to 5
             do Begin
                dbp^.Files[b] := UpCaseStr(Parse(b - 1));
                If dbp^.Files[b] = ''
                  then b := 5
                  else Inc(dbp^.FileCount);
                End;

           dbp^.IdxLen := Str2Byte(GetConfLine);

           dbp^.Keywords := 0;
           dbp^.Records := 0;

           b := Str2Word(GetConfLine);
           If dbp^.Format = Local
             then Case b of
                    1 : dbp^.IndexXMS := xmsPresent;
                  Else dbp^.IndexXMS := False;
                  End
             else dbp^.IdxLen := b;

           dbp^.Queries := 0;
           dbp^.Hits := 0;
           dbp^.Keywords := 0;
           dbp^.Records := 0;

           dbp^.Next := nil;
           dp := @dbp^.Next;
           End;
       CloseConf;

       dbp := DbList;
       While assigned(dbp)
        do Begin
           CWriteLn('  - ' + dbp^.Name + ':');
           Case dbp^.Format of

             HamCall : Begin { Buckmaster HamCall (TM) }
                       BuckInt := dbp^.IdxLen;
                       BuckDrive := dbp^.Files[1][1];
                       Write('      BuckMaster HamCall on drive ' + BuckDrive + ': ');
                       BuckInit;
                       CWriteLn('Initialized.');
                       End;

             Local   : Begin
                       With dbp^
                         do Begin
                            If Odd(IdxLen)
                              then Inc(IdxLen);
                            IdxRecLen := IdxLen + 4;
                            End;
                       For b := 1 to dbp^.FileCount
                         do Begin
                            Write('      ' + PadLeft(14,dbp^.Files[b] + ':'));

                            Assign(BufFile,DataBasePath + dbp^.Files[b]);
                            Reset(BufFile,1);
                            GetFTime(BufFile,ftime);
                            If IOResult <> 0
                              then Begin
                                   WriteLn('Database file not found!');
                                   Halt(1);
                                   End;

                            dbp^.Indexes[b] := Copy(dbp^.Files[b],1,Pos('.',dbp^.Files[b])-1) + '.idx';
                            Assign(f,DataBasePath + dbp^.Indexes[b]);
                            Reset(f,1);

                            If IOResult <> 0
                              then Begin
                                   Write('New database.');
                                   IndexDb(dbp);
                                   End
                              else Begin
                                   GetFTime(f,itime);
                                   If itime <> ftime
                                     then Begin
                                          Write('Database changed.');
                                          IndexDb(dbp);
                                          End
                                     else Close(BufFile);
                                   End;

                            dbp^.Keywords := dbp^.Keywords + FileSize(f) div dbp^.IdxRecLen;
                            dbp^.Records := dbp^.Keywords; { krhm }

                            CWriteLn(Int2Str(dbp^.Keywords) + ' records.    ');

                            If Dbp^.IndexXMS
                              then Begin
                                   dbp^.IndexX[b].Size := FileSize(f);
                                   XMSCheck(allocateXMB((dbp^.IndexX[b].Size div 1024) + 1,
                                            dbp^.IndexX[b].Handle,'DB ' + dbp^.Indexes[b]));
                                   New(IdxBuf);
                                   itime := 0;
                                   Repeat
                                     BlockRead(f,IdxBuf^,4096,Int);
                                     XMSCheck(BaseToXMB(Int,IdxBuf,dbp^.IndexX[b].Handle,itime));
                                     Inc(itime,Int);
                                   until Int < 4096;
                                   Dispose(IdxBuf);
                                   End;

                            Close(f);
                            End;

                       If dbp^.IndexXMS then CWriteLn('      Index files loaded into XMS.');

                       End;

             remote  : With dbp^ do
                       Begin
                       CWriteLn('      Remote database on node ' + Files[1] + ', named ' + Files[2]
                                + '. Timeout ' + Int2Str(IdxLen) + ' seconds.');
                       End;

           End;

           Assign(f,DatabasePath + dbp^.InfoFile);
           Reset(f,1);
           Close(f);
           If IOResult <> 0
             then Begin
                  WriteLn('Information file ' + dbp^.InfoFile + ' not found!');
                  Halt(1);
                  End;

           dbp := dbp^.Next;

           End;
       End;

 { DXCC tietokanta }

 Write('  - DXCC: ');
 New(Dxcc);
 Assign(Dxcc^.Bf,DataBasePath + 'dxcc.cdb');
 Assign(Dxcc^.BIf,DataBasePath + 'dxcc.idx');

 Reset(Dxcc^.Bf);
 Reset(Dxcc^.BIf);

 If (IOResult = 0)
   then Begin
        If FileExists(DataBasePath + 'cty.dat')
          then Begin
               Assign(f,DataBasePath + 'cty.dat');
               Reset(f);
               IOCheck('opening cty.dat');
               GetFTime(Dxcc^.BIf,ftime);
               GetFTime(f,itime);
               Close(f);
               If ftime <> itime
                 then Begin
                      Write('Updating... ');
                      ReadRawPrefix;
                      End;
               End;
        End
   else If FileExists(DataBasePath + 'cty.dat')
          then Begin
               Write('Installing... ');
               ReadRawPrefix;
               End
          else Begin
               Dispose(Dxcc);
               Dxcc := nil;
               End;

 If Assigned(Dxcc)
   then With Dxcc^
         do Begin
            BIi := FileSize(BIf);
            BIs := BIi * SizeOf(DxccBIrec);
            BFi := FileSize(Bf);
            CWriteLn(Int2Str(BIi) + ' keywords for '
                      + Int2Str(Bfi) + ' targets.');
            Close(Bf);
            Close(BIf);
            IOCheck('closing dxcc databases');
            Assign(f,DatabasePath + 'dxcc.idx');
            Reset(f,1);
            GetMem(BIfp,BIs);
            BlockRead(f,BIfp^,BIs);
            Close(f);
            IOCheck('reading dxcc database');

            { XMS:n }
            Write('          Index file loaded into ');
            If XMSPresent and (XMSLargestBlock > (BIs div 1024 + 1))
              and AllocateXMB(BIs div 1024 + 1,XHandle,'DB dxcc.idx')
              and BaseToXMB(BIs,BIfp,XHandle,0)
              then Begin
                   X := True;
                   CWriteLn('XMS.');
                   FreeMem(BIfp,BIs);
                   End
              else Begin
                   X := False;
                   CWriteLn('memory.');
                   Inc(DBConfigMem,BIs);
                   End;

            Inc(DBConfigMem,SizeOf(DxccType));
            Queries := 0;
            Hits := 0;
            End
   else CWriteLn('Not found.');

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
