{$F-} {$R-} {$Q-} {$I-} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1997

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Convers;

  { Implements the conference mode. Mostly a pascal rewrite of the
    NOS implementation of the conversd. Even implements most of the
    conversd linking protocol, though it was never finished. I tried
    linking it once or twice, but ran in to bandwidth problems on my
    1k2 link to home... with a little work it might be possible to
    get it working. The linking code is completely disabled now. }

Interface
Uses Dos, ConfFile;
Type
  CNameRec    = String[10];
  CLinkP      = ^CLinkRec;
  CLinkRec    = Record
                Name     : CNameRec;    { Vastapn nimi }
                Script   : NameStr;     { Connectiscriptin nimi }
                State    : Byte;        { Linkin tila }
                Sock     : Byte;        { Socket }
                Locked   : Boolean;     { Lukitus }
                Since    : LongInt;     { Mist lhtien }
                TryAfter,               { Kuinka usein yritetn (min) }
                LastTry  : Word;        { Minuutteja viime yrityksest }
                Tries,                  { Montako yrityst }
                Failures : LongInt;     { Montako tipahdusta }
                LTimeOut : Word;        { Linkkerin timeout }
                Timer    : LongInt;     { Inactive/link try timer }
                Tx       : LongInt;     { Lhetetyt tavut }
                Rx       : LongInt;     { Vastaanotetut tavut }
                RttT     : LongInt;     { Round-trip time tlt }
                RttR     : LongInt;     { Round-trip time sielt }
                End;

Var
  ConvUsers,                      { Montako kyttj }
  ConvHosts       : Word;         { Montako hostia }
  CLinks,                         { Montako linkki }
  CLinksC         : Byte;         { Montako linkki configuroitu }

  CLink           : Array[1..10] of CLinkP;  { convers linkit }

Const
  ConvSoft        : String[8] = 'Clu0.28i';
  ConvFeatures    : String[5] = 'admpu';

Function CUserFound(Const Name:CNameRec):Boolean; { Lytyyk kyttj }
Procedure Who_cmd(p:Byte);        { Convers kyttjlista }

Procedure ConvLogin(p:Byte);      { Paikallinen tulee conffiin }
Procedure ConvLogout(p:Byte);     { Paikallinen tipahti conffista }

Procedure EndOfLink(l:Byte);      { Linkkausjopi olis ohi }

Procedure Conffi(p:Byte);         { Paikallinen tahtoo sanoa jotain }
Procedure ConvLnk(p:Byte);        { Linkin vastaanotto }

Procedure Timer;                  { Kerran minuutissa }
Procedure Init;                   { Kynnistettess }

 { ***************************************************************** }

Implementation
Uses BPQ, Config, Crt, CStrings, Screen, Files, Cluster, Protocol, Linker,
     cmd_User;

Type
  InfoRec     = String[50];

  CUserPP     = ^CUserP;
  CUserP      = ^CUserRec;
  CUserRec    = Record
                Name     : CNameRec;    { Kutsu }
                Host     : CNameRec;    { Host }
                Via      : Byte;        { Linkkinumero, 0 = paikallinen }
                Chan     : Word;        { Kanava }
                Flags    : Word;        { Flagit }
                Locked   : Boolean;     { Lukitus }
                Str      : Byte;        { Stream, jos paikallinen }
                Personal : ^InfoRec;    { Lisinfo }
                AwayMsg  : ^InfoRec;    { Poissaoloviesti }
                AwayTime : LongInt;     { Kauanko poissa }
                Since    : LongInt;     { Kauanko kiinni systeemiss }
                Active   : LongInt;     { Viime aktiviteetti }
                { Semi-doubly linked list: }
                PrevP    : CUserPP;
                Next     : CUserP;      { Seuraava jonossa }
                End;

  CHostP      = ^CHostRec;
  CHostRec    = Record
                Name     : CNameRec;    { Host name }
                Via      : Byte;        { Linkki }
                Since    : LongInt;     { Kauanko kiinni }
                Active   : LongInt;     { Viime aktiviteetti }
                Rtt      : LongInt;     { Round-trip time tlt }
                Next     : ChostP;
                End;

  PersFileRec = Record
                Name     : CNameRec;    { Nimi }
                Text     : InfoRec;     { Info }
                End;

Const
  CHPrefix : String[3] = '/' + Chr(255) + Chr(128); { Convers linkin prefixi }
Var
  CUsers      : CUserP;                  { Linkattu lista: convers kyttjt }
  CHosts      : CHostP;                  { Linkattu lista: convers hostit }
  CLinkN      : Array[1..SockMax] of Byte;    { convers linkit streamien mukaan }
  LCUser      : Array[0..SockMax] of CUserP;  { Paikalliset convers kyttjt }
  Locked      : Array[0..SockMax] of Boolean; { Lukitus }
  PersFile    : File of PersFileRec;

 { ***************************************************************** }

{
Procedure Monitor(p:Byte;Str:String);
Var Strinki : String;
Begin
If MonitorAct Then
Begin

 TextAttr := Color.MonConv;
 Strinki := Format(LUser[p]^.Call + '/' + Int2Str(LUser[p]^.Chan) + '>',Str);
 Delete(Strinki,Length(Strinki),1);
 Screen.Monitor(Strinki);

End;
End;
}
 { ***************************************************************** }
 { Sijoittaa uuden kyttjrecordin }

Procedure NewCUser(Uusi:CUserP);
Var
  PrevP : CUserPP;
  Curr  : CUserP;
Begin

 PrevP := @CUsers;
 Curr  := CUsers;

 While Assigned(Curr) and StrOrd(Curr^.Name,Uusi^.Name)
  do Begin
     PrevP := @PrevP^^.Next;
     Curr := Curr^.Next;
     End;

 PrevP^ := Uusi;
 Uusi^.PrevP := PrevP;
 Uusi^.Next := Curr;
 If Assigned(Uusi^.Next)
   then Uusi^.Next^.PrevP := @Uusi^.Next;

 Inc(ConvUsers);

End;

 { ***************************************************************** }
 { Poistaa kyttjn, yhdist ketjun }

Procedure DelCUser(p:CUserP);
Begin

 p^.PrevP^ := p^.Next;
 If assigned(p^.Next)
   then p^.Next^.PrevP := p^.PrevP;

 If Assigned(p^.Personal) then Dispose(p^.Personal);
 If Assigned(p^.AwayMsg) then Dispose(p^.AwayMsg);

 Dispose(p);

 Dec(ConvUsers);

End;

 { ***************************************************************** }
 { Palauttaa pointterin kyttjn, nil jos ei lydy }

Function GetCUser(Const Name:CNameRec):CUserP;
Var Curr : CUserP;
Begin
 Curr := CUsers;
 While Assigned(Curr) and (Curr^.Name <> Name)
   do Curr := Curr^.Next;
 GetCUser := Curr;
End;

Function GetCUserH(Const Name,Host:CNameRec):CUserP;
Var Curr : CUserP;
Begin
 Curr := CUsers;
 While Assigned(Curr) and not ((Curr^.Name = Name) and (Curr^.Host = Host))
   do Curr := Curr^.Next;

 GetCUserH := Curr;
End;

Function GetCUserC(Const Name:CNameRec;Chan:Integer):CUserP;
Var Curr : CUserP;
Begin
 Curr := CUsers;
 While Assigned(Curr) and not ((Curr^.Name = Name) and (Curr^.Chan = Chan))
   do Curr := Curr^.Next;
 GetCUserC := Curr;
End;

Function GetCUserHC(Const Name,Host:CNameRec;Chan:Integer):CUserP;
Var Curr : CUserP;
Begin
 Curr := CUsers;
 While Assigned(Curr) and not ((Curr^.Name = Name) and (Curr^.Host = Host) and (Curr^.Chan = Chan))
   do Curr := Curr^.Next;
 GetCUserHC := Curr;
End;

 { ***************************************************************** }

Function CUserFound(Const Name:CNameRec):Boolean;
Var Curr : CUserP;
Begin
 Curr := CUsers;
 While Assigned(Curr) and (Curr^.Name <> Name)
   do Curr := Curr^.Next;
 If Assigned(Curr)
   then CUserFound := True
   else CUserFound := False;
End;

 { ***************************************************************** }
 { Asettaa Lockit pois }

Procedure Clear_locks;
Var
 p : CUserP;
Begin
 p := CUsers;
 While Assigned(p)
   do Begin
      p^.Locked := False;
      p := p^.Next;
      End;
End;

Procedure Clear_local_locks;
Var
  b : Byte;
Begin
 for b := 0 to SockMax do locked[b] := False;
End;

Procedure Clear_link_locks;
Var
  b : Byte;
Begin
For b := 1 to 10
  do If Assigned(CLink[b])
       then CLink[b]^.Locked := False;
End;

 { ***************************************************************** }
 { Personal file }

Function ReadPersRec(Const Name:CNameRec):InfoRec;
Var
 Info : PersFileRec;
Begin

 Info.Name := '';
 Reset(PersFile);
 While not (eof(PersFile) or (Info.Name = Name))
   do Read(PersFile,Info);

 Close(PersFile);
 IOCheck('reading convpers.clu');

 If Name = Info.Name
   then ReadPersRec := Info.Text
   else ReadPersRec := '@';

End;

Procedure WritePersRec(Const Name:CNameRec;Text:InfoRec);
Var
 Info : PersFileRec;
Begin

 Info.Name := '';
 Reset(PersFile);
 While not (eof(PersFile) or (Info.Name = Name))
  do Read(PersFile,Info);

 If Info.Name = Name
   then Seek(PersFile,FilePos(PersFile)-1)
   else Info.Name := Name;

 Info.Text := Text;

 Write(PersFile,Info);

 Close(PersFile);
 IOCheck('writing convpers.clu');

End;

 { ***************************************************************** }

 { ***************************************************************** }
 { *                                                               * }
 { * L I N K - L E V E L   C O M M A N D S                         * }
 { *                                                               * }
 { ***************************************************************** }

 { ***************************************************************** }
 { Lhett yhdelle linkille }

Procedure SendLink(tol:Byte;Const Str:String);
Begin
 Send(CLink[tol]^.Sock,CHPrefix + Str + Cr);
 Kick(CLink[tol]^.Sock);
End;

 { ***************************************************************** }
 { Lhett kaikille linkeille paitsi tulosuuntaan }

Procedure SendLinks(from:Byte;Const Str:String);
Var
  b : Byte;
Begin
 For b := 1 to 10
   do If Assigned(CLink[b]) and (CLink[b]^.State = 1) and (b <> from)
        then SendLink(b,Str);
End;

 { ***************************************************************** }

Procedure Send_msg_to_user(FromL:Byte;FromName,ToName:CNameRec;Const Text:String);
Var
  ToUser : CUserP;
Begin

 ToUser := CUsers;
 If FromL > 0 then CLink[FromL]^.Locked := True;

 While Assigned(ToUser)
  do Begin
     If ToUser^.Name = ToName
       then If (ToUser^.Via = 0)
              then Begin { Paikallinen kyttj }
                   If not locked[ToUser^.Str]
                     then Begin
                          If FromName = 'conversd'
                            then Send(ToUser^.Str,Text + Cr)
                            else Send(ToUser^.Str,Format(True,FromName + '*>', Text));
                          End;
                   End
              else Begin
                   If not CLink[ToUser^.Via]^.Locked
                     then SendLink(ToUser^.Via,'UMSG ' + FromName + ' ' + ToName + ' ' + Text);
                   CLink[ToUser^.Via]^.Locked := True;
                   End;
     ToUser := ToUser^.Next;
     End;

 Clear_link_locks;

End;

 { ***************************************************************** }

Procedure Send_msg_to_channel(FromL:Byte;FromName:CNameRec;Chan:Word;Const Text:String);
Var
  s   : String;
  b   : Byte;
Begin

 If Chan = 0 then Exit;

 SendLinks(FromL,'CMSG ' + FromName + ' ' + Int2Str(Chan) + ' ' + Text);

 If FromName = 'conversd'
   then s := Text
   else Begin
        s := Format(True,FromName + '>',Text);
        If Length(s) = 255 then s[255] := Cr;
        End;

 For b := 0 to UsrPorts
   do If Assigned(LCUser[b]) and (LCUser[b]^.Chan = Chan) and not locked[b]
        then Begin
             Send(b,s);
             Locked[b] := True;
             End;

 Clear_local_locks;

End;

 { ***************************************************************** }

Procedure Send_invite_msg(FromL:Byte;Const FromName,ToName:CNameRec;Chan:Word);
Var
  b       : Byte;
  Invited : Boolean;
Begin

 Invited := False;
 For b := 0 to UsrPorts
   do Begin
      If Assigned(LUser[b]) and (StripSSID(LUser[b]^.f^.Call) = StripSSID(UpCaseStr(ToName))) and (Sock[b]^.Mode = SM_Clusse)
        then Begin
             If f_Beeps in LUser[b]^.f^.Flags then Send(b,Chr(7));
             Send(b,FromName + ' invites you to convers channel ' + Int2Str(Chan) + '! Type ''conv '
                    + Int2Str(Chan) + ''' to join.' + Cr);
             Invited := True;
             End;
      If Assigned(LCUser[b]) and (LCUser[b]^.Name = ToName) and not LCUser[b]^.Locked
        then Begin
             Send(LCUser[b]^.Str,'>>> ' + FromName + ' invites you to channel ' + Int2Str(Chan) + '!' + Cr);
             Invited := True;
             LCUser[b]^.Locked := True;
             End;
      End;

 Clear_local_locks;

 If Invited
   then Send_msg_to_user(0,'conversd',FromName,'>>> Invited ' + ToName + '@' + Conf^.Conv.ConvHostName + '.');

 SendLinks(FromL,'INVI ' + FromName + ' ' + ToName + ' ' + Int2Str(Chan));

End;

 { ***************************************************************** }

Procedure Send_User_Change(FromL:Byte;Str:Byte;Const Name,Host:CNameRec;
                           Time:LongInt;FromCh,ToCh:Integer;Text:String);
Var
  b    : Byte;
  User : CUserP;
Begin

 If FromCh = -1
   then Begin { Uusi kyttj ! }
        New(User);
        User^.Name := Name;
        User^.Host := Host;
        User^.Via := FromL;
        User^.Chan := ToCh;
        User^.Flags := 0;
        User^.Locked := False;
        User^.Str := Str;
        User^.Personal := nil;
        User^.AwayMsg := nil;
        User^.Awaytime := 0;

        User^.Since := now;  { HUOM! }
        User^.Active := now; { HUOM! }

        If Text = '@' then Text := ReadPersRec(Name);
        If (Text <> '@') and (Length(Text) > 0)
          then Begin { Personal }
               New(User^.Personal);
               User^.Personal^ := Text;
               WritePersRec(Name,Text);
               End;

        NewCUser(User);

        If FromL = 0 then LCUser[Str] := User; { Paikallinen }

        { Tieto paikallisille }
        For b := 0 to UsrPorts
          do If Assigned(LCUser[b]) and (LCUser[b]^.Chan = ToCh) and not locked[b]
            then Send(LCUser[b]^.Str,'>>> ' + Name + '@' + Host + ' logged in.' + Cr);
        End
   else If ToCh = -1
   then Begin { Kyttj hipyi }

        { Tieto paikallisille }
        For b := 0 to UsrPorts
          do If Assigned(LCUser[b]) and (LCUser[b]^.Chan = FromCh) and not locked[b]
            then Send(LCUser[b]^.Str,'>>> ' + Name + '@' + Host + ' logged out.' + Cr);

        If FromL = 0
          then User := LCUser[Str]
          else User := GetCUserHC(Name,Host,FromCh);
        If (User <> nil)
          then Begin
               DelCUser(User);
               LCUser[Str] := nil;
               End;
        End
   else Begin { Kanavanvaihto }
        If FromL = 0
          then User := LCUser[Str]
          else User := GetCUserHC(Name,Host,FromCh);
        If User <> nil
          then User^.Chan := ToCh;

        { Tieto paikallisille }
        For b := 0 to UsrPorts
          do If Assigned(LCUser[b]) and (LCUser[b]^.Chan = FromCh) and not locked[b]
            then Send(LCUser[b]^.Str,'>>> ' + Name + '@' + Host + ' left from channel '
                      + Int2Str(FromCh) + ' to ' + Int2Str(ToCh) + '.' + Cr);

        For b := 0 to UsrPorts
          do If Assigned(LCUser[b]) and (LCUser[b]^.Chan = ToCh) and not locked[b]
            then Send(LCUser[b]^.Str,'>>> ' + Name + '@' + Host + ' joined channel '
                     + Int2Str(ToCh) + ' from ' + Int2Str(FromCh) + '.' + Cr);
        End;

 Clear_local_locks;

 SendLinks(FromL,'USER ' + Name + ' ' + Host + ' ' + Int2Str(Time) + ' '
                 + Int2Str(FromCh) + ' ' + Int2Str(ToCh) + ' ' + Text);

End;

 { ***************************************************************** }

Procedure Send_personal_text(FromL:Byte; Const Name,Host:CNameRec; Const Text:String);
Var
  User : CUserP;
  b    : Byte;
  s    : String;
Begin

 s := '>>> ' + Name + '@' + Host;
 If Text = '@' then s := s + ' removed personal text.' + Cr
               else s := s + ' set personal text:' + Cr + '    ' + Text + Cr;

 User := CUsers;
 While Assigned(User)
  do Begin
     If (User^.Name = Name) and (User^.Host = Host) then
       If ((Text = '@') and Assigned(User^.Personal)) or (Text = '')
          then Begin
               WritePersRec(User^.Name,'@');
               Dispose(User^.Personal);
               User^.Personal := nil;
               For b := 0 to UsrPorts
               do if Assigned(LCUser[b]) and (LCUser[b]^.Chan = User^.Chan) and not locked[b]
                  then Begin
                       Send(LCUser[b]^.Str,s);
                       Locked[b] := True;
                       End;
               End
          else Begin
               If User^.Personal = nil
                 then New(User^.Personal);
               User^.Personal^ := Text;
               WritePersRec(User^.Name,User^.Personal^);
               End;
     User := User^.Next;
     End;

 Clear_local_locks;

 SendLinks(FromL,'UDAT ' + Name + ' ' + Host + ' ' + Text);

End;

 { ***************************************************************** }

Procedure Send_away_text(FromL:Byte; Const Name,Host:CNameRec;Chan:Integer;
                         Time:LongInt; Const Text:String);
Var
  s    : String;
  b    : Byte;
  User : CUserP;
Begin

 s := '>>> ' + Name + '@' + Host;
 If Text = ''
   then s := s + ' is back again.' + Cr
   else s := s + ' went away: ' + Text + Cr;

 User := CUsers;
 While Assigned(User)
  do Begin
     If (User^.Name = Name) and (User^.Host = Host) and (User^.Chan = Chan) then
       If (Text = '') and Assigned(User^.AwayMsg)
          then Begin
               Dispose(User^.AwayMsg);
               User^.AwayMsg := nil;
               For b := 0 to UsrPorts
               do if Assigned(LCUser[b]) and (LCUser[b]^.Chan = User^.Chan) and not locked[b]
                  then Begin
                       Send(LCUser[b]^.Str,s);
                       Locked[b] := True;
                       End;
               End
          else Begin
               If User^.AwayMsg = nil
                 then New(User^.AwayMsg);
               User^.AwayMsg^ := Text;
               End;
     User := User^.Next;
     End;

 Clear_local_locks;

 SendLinks(FromL,'AWAY ' + Name + ' ' + Host + ' ' + Int2Str(Chan) + ' '
                 + Int2Str(Time) + ' ' + Text);

End;

 { ***************************************************************** }

Procedure Ping_rcv(Lnk:Byte);
Begin

 SendLink(Lnk,'PONG -1');

End;

 { ***************************************************************** }
 { Linkkaus }

Procedure StartLink(l:Byte);
Begin

{
 StartConnect(CLink[l]^.Script,6,l,CLink[l]^.LTimeOut);

 CLink[l]^.State := 1;
 CLink[l]^.LastTry := 0;
 Inc(CLink[l]^.Tries);

 Log(L_Link,'Trying to link ' + CLink[l]^.Name + '.');
}

End;

 { ***************************************************************** }

Procedure EndOfLink(l:Byte);
Begin

 Sock[CLink[l]^.Sock]^.Mode := SM_ConvLink;

 SendLink(l,'HOST ' + Conf^.Conv.ConvHostName + ' ' + ConvSoft + ' ' + ConvFeatures);
 Action(66,'Linked to ' + CLink[l]^.Name);
 Log(L_Link,'Linked to ' + CLink[l]^.Name);
 CLink[l]^.State := 2;
 CLink[l]^.Since := now;
 CLink[l]^.Tries := 0;
 EndConnect(CLink[l]^.Sock);
 Inc(CLinks);

End;

 { ***************************************************************** }

 { ***************************************************************** }
 { *                                                               * }
 { * U S E R   C O M M A N D S                                     * }
 { *                                                               * }
 { ***************************************************************** }

 { ***************************************************************** }
 { Pikainen poistuminen clusselta }

Procedure Bye_Cmd(p:Byte);
Begin
 ConvLogout(p); { Ilmoitus conffilaisille }
 Action(p,'Logged out');
 Send(p,'>>> 73!' + CR);
 Kick(p);
 ThrowOut(p);
End;

 { ***************************************************************** }
 { Kanavanvaihdos }

Procedure Chan_Cmd(p:Byte);
Var
 s      : String;
 i      : Longint;
 b      : Byte;
 err    : Integer;
Begin

 s := Parse(1);

 Val(s,i,err);

 If (i > 32767) or (i < 1) or (err <> 0) or (i = LCUser[p]^.Chan)
   then Begin
        Send(p,'>>> Now on channel ' + Int2Str(LCUser[p]^.Chan) + '.' + CR);
        If (i = 0) and (err = 0)
          then Send(p,'    There is no channel 0! 8-)' + Cr);
        End
   else Begin
        Locked[p] := True;
        Send_user_change(0,p,LCUser[p]^.Name,Conf^.Conv.ConvHostName,0,LCUser[p]^.Chan,i,'@');
        Send(p,'>>> Joined channel ' + Int2Str(LCUser[p]^.Chan) + '.' + Cr);
        End;
End;

 { ***************************************************************** }
 { Apuva! }

Procedure Help_Cmd(p:Byte);
Var
 s : String[10];
Begin

 s := Parse(1);
 if s = '' then s := 'help';
 Action(p,'/Help on ' + s);
 If s[1] <> '/' then s := '/' + s;
 Send(p,'>>> ');
 Help(p,s);
 Send(p,'---' + Cr);

End;

 { ***************************************************************** }
 { Kutsuu jonkun kanavalleen }

Procedure Invite_Cmd(p:Byte);
Var
 s    : CNameRec;
 User : CUserP;
Begin

 s := LowCaseStr(Parse(1));
 User := GetCUser(s);
 If (User = nil) and (GetLUser(UpCaseStr(s)) = 255)
   then Send(p,'>>> User ' + s + ' not found.' + Cr)
   else If (GetCUserC(s,LCUser[p]^.Chan) <> nil) and (GetCUserC(s,LCUser[p]^.Chan) <> LCUser[p])
          then Send(p,'>>> User ' + s + ' already on this channel.' + Cr)
          else Begin
               LCUser[p]^.Locked := True;
               Send_invite_msg(0,LCUser[p]^.Name,s,LCUser[p]^.Chan);
               End;

End;

 { ***************************************************************** }
 { Henk. koht. viesti }

Procedure Msg_Cmd(p:Byte);
Var
  MsgTo  : CNameRec;
  st     : String;
  User   : CUserP;
  b      : Byte;
Begin

 MsgTo := LowCaseStr(Parse(1));
 User := GetCUser(MsgTo);

 If User = nil
   then Send(p,'>>> User ' + MsgTo + ' not found.' + Cr)
   else Begin
        b := FindParamStart(2);
        st := Copy(Ibuffer,b,Length(Ibuffer)-b);
        Locked[p] := True;
        Send_msg_to_user(0,LCUser[p]^.Name,MsgTo,st);
        Locked[p] := False;
        End;
End;

 { ***************************************************************** }
 { Conffista clusseen }

Procedure Quit_Cmd(p:Byte);
Begin
 ConvLogout(p); { Ilmoitus conffilaisille }
 Sock[p]^.Mode := SM_Clusse;
 Action(p,'Left Conference');
 Send(p,'>>> Cluster mode.' + Cr + Prompt(p));
End;

 { ***************************************************************** }
 { Keit systeemiss }

Procedure Who_Cmd(p:Byte);
Var
  Chan : Word;
  User : CUserP;
  b    : Byte;
  Done,
  Found : Boolean;

  Rivi : String;
  Ch   : Char;

Begin

 Action(p,'/Who');

 Rivi := Parse(1);
 If Rivi <> '' then Ch := LowCaseCh[Rivi[1]]
               else Ch := ' ';
 Rivi := '';
 Case Ch of

   'l' : Begin { Long list }
         If Sock[p]^.Mode = SM_Convers
           then Send(p,'>>> Users:' + Cr);
         Send(p,' Chan Callsign   @ Host     Personal text' + Cr);
         User := CUsers;
         While Assigned(User)
          do Begin
             Send(p,PadRight(5,Int2Str(User^.Chan)) + ' ' + PadLeft(11,User^.Name)
                  + PadLeft(11,User^.Host));
             If Assigned(User^.Personal)
               then Send(p,User^.Personal^ + Cr)
               else Send(p,Cr);
             User := User^.Next;
             End;
         End;

   'u' : Begin { Info about a specific user }
         Rivi := LowCaseStr(Parse(2));
         If Sock[p]^.Mode = SM_Convers
           then Send(p,'>>> User ' + Rivi + ':')
           else Send(p,'Convers user ' + Rivi + ':');
         User := CUsers;
         Done := True;
         Found := False;

         While Assigned(User)
          do Begin
             If User^.Name = Rivi
               then Begin
                    Found := True;
                    If Done
                      then Begin
                           If Assigned(User^.Personal)
                             then Send(p,' ' + User^.Personal^ + Cr)
                             else Send(p,Cr);
                           If Assigned(User^.AwayMsg)
                             then Send(p,'    Away: ' + User^.AwayMsg^ + Cr);
                           Send(p,' Chan @ Host     Since' + Cr);
                           Done := False;
                           End;
                    Send(p,PadRight(5,Int2Str(User^.Chan)) + ' ' + PadLeft(11,User^.Host) + Cr);
                    End;
             User := User^.Next;
             End;
         If not Found
           then Send(p,' Not found.' + Cr);
         End;

   '*' :
         Begin { Long, default channel only }
         If Sock[p]^.Mode = SM_Convers
           then Begin
                Send(p,'>>> Users on this channel:' + Cr);
                Chan := LCuser[p]^.Chan;
                End
           else Begin
                Chan := Conf^.Conv.DefaultChan;
                Send(p,'Users on channel ' + Int2Str(Chan) + ':' + Cr);
                End;
         Send(p,' Callsign   @ Host     Personal text' + Cr);
         User := CUsers;
         While Assigned(User)
          do Begin
             If User^.Chan = Chan
               then Begin
                    Send(p,' ' + PadLeft(11,User^.Name) + PadLeft(11,User^.Host));
                    If Assigned(User^.Personal)
                      then Send(p,User^.Personal^ + Cr)
                      else Send(p,Cr);
                    End;
             User := User^.Next;
             End;
         End;

 else Begin { Quick, per-channel list }
      If Sock[p]^.Mode = SM_Convers
        then Send(p,'>>> Users:' + Cr);
      Send(p,' Chan Callsigns');
      Repeat

        Done := True;
        Chan := 65535;
        User := CUsers;

        While Assigned(User)
          do Begin
             If not User^.Locked
               then Begin
                    If Chan = 65535
                     then Begin { Uusi kanava }
                          Chan := User^.Chan;
                          Rivi := Cr + PadRight(5,Int2Str(Chan));
                          End;
                    If Chan = User^.Chan
                     then Begin
                          If Length(Rivi) > 65
                           then Begin
                                Send(p,Rivi + Cr);
                                Rivi := '     ';
                                End;
                          Rivi := Rivi + ' ' + User^.Name;
                          If Assigned(User^.AwayMsg)
                            then Rivi := Rivi + '(G)';
                          User^.Locked := True;
                          Done := False;
                          End;
                    End;
             User := User^.Next;
             End;
      Send(p,Rivi);
      Rivi := '';

    until Done;

    Send(p,Cr);
    Clear_locks;

    If Sock[p]^.Mode = SM_Convers then
    For b := 0 to SockMax do
      If Assigned(LCUser[b]) and (Sock[b]^.Mode = SM_Clusse)
        then Begin
             Send(p,' Clu  ');
             For b := b to SockMax do
               If Assigned(LCUser[b]) and (Sock[b]^.Mode = SM_Clusse)
                 then Send(p,' ' + LUser[b]^.f^.Call);
             Send(p,Cr);
             End;
    End;
 End;

 If Sock[p]^.Mode = SM_Convers
   then Send(p,'---' + Cr);

End;

 { ***************************************************************** }
 { Linkkilista }

Procedure Linklist_cmd(p:Byte);
Var b : Byte;
Begin

 Send(p,'>>> Convers links:' + Cr);
 If CLinksC > 0
  then Begin
       Send(p,     ' Hostname ');
        Send(p,CLink[1]^.Name);
       Send(p,Cr + ' State    ');
        Case CLink[1]^.State of
          0 : Send(p,'Disc');
          1 : Send(p,'Linking');
          2 : Send(p,'Linked');
        End;
       Send(p,Cr + ' Since d  ');
        Send(p,DateStr(CLink[1]^.Since));
       Send(p,Cr + ' Since t  ');
        Send(p,TimeStrL(CLink[1]^.Since));
       Send(p,Cr + ' Next try ');
        Send(p,Int2Str(CLink[1]^.TryAfter - CLink[1]^.LastTry));
       Send(p,Cr + ' Tries    ');
        Send(p,Int2Str(CLink[1]^.Tries));
       Send(p,Cr + ' Failures ');
        Send(p,Int2Str(CLink[1]^.Failures));
       Send(p,Cr + ' Rtt t/r  ');
        Send(p,Secs2StrS(CLink[1]^.RttT) + '/' + Secs2StrS(CLink[1]^.RttR));
       Send(p,Cr + ' Tx bytes ');
        Send(p,Int2Str(CLink[1]^.Tx));
       Send(p,Cr + ' Rx bytes ');
        Send(p,Int2Str(CLink[1]^.Rx));
       Send(p,Cr);
       End;
 Send(p,'---' + Cr);

End;

 { ***************************************************************** }
 { Asettaa personal tekstin }

Procedure Set_personal_Cmd(p:Byte);
Var
  s : String;
  b : Byte;
Begin

 If (Parse(1) = '') or ((Parse(1) = '@') and not assigned(LCUser[p]^.Personal))
   then { Nytetn tilanne vain }
        If Assigned(LCUser[p]^.Personal)
          then Send(p,'>>> Your personal text is now:' + Cr
                    + '    ' + LCUser[p]^.Personal^ + Cr)
          else Send(p,'>>> Personal text not set.' + Cr)
   else Begin
        b := FindParamStart(1);
        s := Copy(IBuffer,b,Length(IBuffer)-b);

        If (s = '@')
          then Send(p,'>>> Personal text removed.' + Cr)
          else Send(p,'>>> Personal text set to:' + Cr
                    + '    ' + s + Cr);
        Locked[p] := True;
        Send_personal_text(0,LCUser[p]^.Name,Conf^.Conv.ConvHostName,s);
        End;

End;

 { ***************************************************************** }

Procedure Away_Cmd(p:Byte);
Var
 s : String;
 b : Byte;
Begin

 If Parse(1) = ''
   then Begin { Back... }
        If Assigned(LCUser[p]^.AwayMsg)
          then Begin
               Send(p,'>>> You''re back again.' + Cr);
               Locked[p] := True;
               Send_away_text(0,LCUser[p]^.Name,Conf^.Conv.ConvHostName,LCUser[p]^.Chan,
                             0,'');
               End
          else Send(p,'>>> You were not away.' + Cr);
        End
   else Begin { Away }
        b := FindParamStart(1);
        s := Copy(IBuffer,b,Length(IBuffer)-b);
        Locked[p] := True;
        Send_away_text(0,LCUser[p]^.Name,Conf^.Conv.ConvHostName,LCUser[p]^.Chan,
                       0,s);
        Send(p,'>>> Away text set.' + Cr);
        End;
End;

 { ***************************************************************** }
 { Command MUX }

Procedure Command(p:byte);
Begin

  Case LowCaseCh[IBuffer[2]] of

  'a'      : Begin { Announce }
             If (LowCaseCh[IBuffer[3]] = 'w')
               then Away_Cmd(p)
               else Begin
                    Delete(IBuffer,1,1);
                    Announce_Cmd(p);
                    End;
             End;

  'b'      : Bye_Cmd(p); { Get the hell outta here }
  'c','j'  : Chan_Cmd(p); { Kanavanvaihdos }

  'd'      : Begin { Dx }
             Delete(IBuffer,1,1);
             Dx_Cmd(p);
             End;

  'h','?',Cr : Help_Cmd(p); { Apuva }
  'i'        : Invite_Cmd(p); { Invite }
  'l'        : Linklist_Cmd(p); { Linkkilista }
  'm'        : Msg_Cmd(p); { Viesti kyttjlle tai kanavalle }
  'p'        : Set_personal_Cmd(p);
  'q', 'x'   : Quit_Cmd(p); { To clusse }

  't'        : Begin { Talk }
               Delete(IBuffer,1,1);
               Talk_Cmd(p);
               End;

  'u'        : Begin { Users }
               Delete(IBuffer,1,1);
               Send(p,'>>> ');
               Users_Cmd(p);
               Send(p,'---' + Cr);
               End;

  'v'        : Send(p,'>>> OH7LZB Clusse ' + Versio + ' (' + CompileDate + ') conversd' + Cr);

  'w'        : Who_Cmd(p); { Kyttjlista }

  else Send(p,'>>> Eh?' + Cr); { Vr komento }

  End; { Case }

End;

 { ***************************************************************** }

 { ***************************************************************** }
 { *                                                               * }
 { * E X T E R N A L   E V E N T S                                 * }
 { *                                                               * }
 { ***************************************************************** }

 { ***************************************************************** }
 { Paikallineen sisntulo }

Procedure ConvLogin(p:Byte);
Var
  b    : Byte;
  Chan : Word;
  i    : Integer;
Begin

 Val(Parse(1),Chan,i);
 If (i <> 0) or (Chan = 0)
   then Chan := Conf^.Conv.DefaultChan;

 Sock[p]^.Mode := SM_Convers;
 Send(p,'Entering conference ch ' + Int2Str(Chan) + ' @ ' + Conf^.Conv.ConvHostName + ' - Hit /? for some help' + Cr
      + '---' + Cr);
 locked[p] := true;
 Send_user_change(0,p,LowCaseStr(LUser[p]^.f^.Call),Conf^.Conv.ConvHostName,
                  0,-1,Chan,'@');

End;

 { ***************************************************************** }
 { Paikallinen kyttj otti ja tipahti }

Procedure ConvLogout(p:Byte);
Var
  b : Byte;
Begin

 Locked[p] := True;
 Send_user_change(0,p,LCUser[p]^.Name,Conf^.Conv.ConvHostName,0,LCUser[p]^.Chan,-1,'@');

End;

 { ***************************************************************** }
 { Paikallinen kyttj teki jotain }

Procedure Conffi(p:Byte);
Begin

 Done := False;
 IBuffer := CleanStr(IBuffer);

 If IBuffer = Cr then Exit;

 If IBuffer[1] = '/'
   then Command(p)
   else Begin
        Locked[p] := True;
        Send_msg_to_channel(0,LCUser[p]^.Name,LCUser[p]^.Chan,IBuffer);
        End;

End;

 { ***************************************************************** }

Procedure ConvLnk(p:Byte);
Const
 HCmd : Array[1..14] of String[4]
      = ('AWAY','CMSG','DEST','HOST','INVI','MODE','OPER','PING','PONG',
         'ROUT','TOPI','UDAT','UMSG','USER');
Var
  b   : Byte;
  Cmd : String[4];
  Lnk : Byte;
  i   : Byte;
Begin

{ If Copy(IBuffer,1,3) <> CHPrefix then Exit; }{ Prefixitarkistus }
 { CR pois }
 Delete(IBuffer,Length(IBuffer),1);

 Cmd := Copy(IBuffer,2,4);
 b := 1;

 While (b <= 14) and (Cmd <> HCmd[b]) do Inc(b);

 If (b = 15) then Exit; { Oliko tuttu komento }

 Lnk := CLinkN[p];

 Case b of
  2  : Begin { CMSG }
       i := FindParamStart(3);
       Send_msg_to_channel(Lnk,Parse(1),Str2Word(Parse(2)),Copy(IBuffer,i,Length(IBuffer)-i));
       End;
  5  : Send_invite_msg(Lnk,Parse(1),Parse(2),Str2Word(Parse(3))); { INVI }
  8  : Ping_rcv(Lnk);
  13 : Begin { UMSG }
       i := FindParamStart(3);
       Send_msg_to_user(Lnk,Parse(1),Parse(2),Copy(IBuffer,i,Length(IBuffer)-i));
       End;
  12 : Begin { UDAT }
       i := FindParamStart(3);
       Send_personal_text(Lnk,Parse(1),Parse(2),Copy(IBuffer,i,Length(IBuffer)-1));
       End;
  14 : Begin { USER }
       i := FindParamStart(6);
       Send_user_change(Lnk,0,Parse(1),Parse(2),Str2LInt(Parse(3)),Str2LInt(Parse(4)),
                        Str2LInt(Parse(5)),Copy(IBuffer,i,Length(IBuffer)-1));
       End;
 End;

End;

 { ***************************************************************** }
 { Kerran minuutissa }

Procedure Timer;
Var b : Byte;
Begin
{
 If CLinks < CLinksC
   then For b := 1 to CLinksC
         do if CLink[b]^.State = 0
              then Begin
                   Inc(CLink[b]^.LastTry);
                   If CLink[b]^.LastTry >= CLink[b]^.TryAfter
                     then StartLink(b);
                   End;
}
End;

 { ***************************************************************** }
 { Kynnistettess }

Procedure Init;
Var
 InitLoop : Byte;
Begin

 Clear_local_locks;

 For InitLoop := 1 to SockMax
   do CLinkN[InitLoop] := 0;

 ConvUsers := 0;
 ConvHosts := 0;

 Write(' o Opening convers personal file - ');
 Assign(PersFile,DataPath + 'convpers.clu');
 Reset(PersFile);
 If IOResult <> 0
   then Begin
        Write('not found, creating - ');
        Rewrite(PersFile);
        IOCheck('creating convpers.clu');
        End;

 WriteLn(Int2Str(FileSize(PersFile)) + ' records.');
 Close(PersFile);

 IOCheck('closing convpers.clu');

End;

 { ***************************************************************** }

End.
