{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Cluster;

  { Implements many important parts of the cluster user interface.
    That includes at least the transmission of cluster events (DX, ANN,
    etc etc), the user command parser, and the "cluster submode" multiplexer. }

Interface

Uses Protocol, ConfFile, Files;
Type
  sType                 = Byte;
Var
  Prompted              : Boolean;
  Done                  : Boolean;
  LAwayStrings          : Byte;    { Local away strings allocated }

Function Prompt(p:Byte):String;      { Send the prompt to an user }
Function Permission(p:Byte;Flags:RightItems):Boolean; { Check permissions }
Function PermissionQ(p:Byte;Flags:RightItems):Boolean; { ... do it quietly }
Function fPermission(p:Byte;Flags:fRightItems):Boolean; { ... file permissions }
Function fPermissionQ(p:Byte;Flags:fRightItems):Boolean; { ... quietly }

Procedure ParamError(p:Byte);

Procedure LUserFDefaults(fp:LUserFP); { Set defaults for this local user file record }

Procedure Login(p:integer);
Procedure Logout(p:Byte);

 { Viestit kyttjille } { Send event messages to users }
Procedure SendAll(MsgType:MessageItems;TStamped:Byte;Const s:string);
Procedure Dx(Info:DxInfoP);                       { DX }
Procedure Announce(Info:AnnP);                    { Announce }
Procedure WWV(Info:WWVRec);                       { WWV }
Procedure UserAdd(u:NUserRecP);                   { Kyttj lis }
Procedure UserDelete(u:NUserRecP);                { Kyttj poistui }
Procedure UserHere(u:NUserRecP);                  { Kyttj takaisin }
Procedure UserAway(u:NUserRecP);                  { Kyttj pois }
Procedure NodeAdd(h:NodeRecP);                    { Node lis }
Procedure NodeDelete(Call:CallRec;Const Reason:String); { Node poistui }
Procedure LinkAdd(Call:CallRec);                  { Linkki lis }
Procedure LinkDelete(Call:CallRec;dr:DReasonT);   { Linkki tipahti }


Procedure CluCommand(p:sType); far;               { Komentotulkki, Command parser }
Procedure Clusse(p:Byte);                         { Input mux }

Procedure SecTimer;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses Dos, Crt, Multitsk, XMSLib, cStrings, Screen, BPQ, Convers, Console,
     Config, Database, Autobin, cmd_User, cmd_Sys, Filters;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Prompt(p:Byte):String;
Begin

 Case LUser[p]^.f^.Prompt of
    0 : Prompt := '';
    1 : Prompt := 'c>' + Cr;
    2 : Prompt := TimeStrS(now) + '>' + Cr;
    3 : Prompt := CluCall + '>' + Cr;
    4 : Prompt := Int2Str(NUserCount) + '/' + Int2Str(LUserCount) + '>' + Cr;
    5 : Prompt := Int2Str(NUserCount) + '/' + Int2Str(NodeCount) + '>' + Cr;
    6 : Prompt := DateStrS(now) + ' ' + TimeStrS(now) + '>' + Cr;
    7 : Prompt := CluCall + ' ' + TimeStrS(now) + '>' + Cr;
    8 : Prompt := Secs2Str(UpTime) + '>' + Cr;
 Else Prompt := 'c>' + Cr;
 End;

End;

Function PermissionQ(p:Byte;Flags:RightItems):Boolean;
 Begin
  With Conf^.Groups[LUser[p]^.Group] do
  If (Flags = R_Norights) or (Flags in Rights) or (R_AllCMD in Rights)
    then PermissionQ := True
    else PermissionQ := False;
 End;

Function Permission(p:Byte;Flags:RightItems):Boolean;
 Begin

  If PermissionQ(p,Flags)
    then Permission := True
    else Begin
         Send(p,'Permission denied.' + Cr);
         Permission := False;
         End;
 End;

Function fPermissionQ(p:Byte;Flags:fRightItems):Boolean;
 Begin
  With Conf^.Groups[LUser[p]^.Group] do
  If (Flags = R_NoFRights) or (Flags in fRights) or (R_AllCMD in Rights)
    then fPermissionQ := True
    else fPermissionQ := False;
 End;

Function fPermission(p:Byte;Flags:fRightItems):Boolean;
 Begin
  If fPermissionQ(p,Flags)
    then fPermission := True
    else Begin
         Send(p,'Permission denied.' + Cr);
         fPermission := False;
         End;
 End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure LUserFDefaults(fp:LUserFP);
Begin

 With fp^ do With conf^.udefaults do
  Begin
  Locator := '';
  Loc.Lat := 0;
  Loc.Long := 0;

  Personal := '';
  Logins := 0;

  Group := DGroup;
  Messages := DMessages;
  Beeps := DBeeps;
  Flags := DFlags;
  LoginAct := DLogin;
  CharSet := DefaultCharSet;
  Prompt := DPrompt;

  Language := 0;
  Pagelen := 24;

  Time := now;
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Login(p:integer);
Const
  SetNameText = 'Please set your name using the NAme command.' + Cr;
  SetLocText = 'Please set your QTH locator using the LOCator command.' + Cr;
  DiskFullText = 'Warning: Less than 512 Kb free on the default drive!' + Cr;

Var
 Ca   : CallRec;
 b    : Byte;
 ok   : Boolean;
 nu   : NUserRecP;
 h    : NodeRecP;
 NewUser : Boolean;
 ti      : LongInt;

Begin

 NewUser := False;
 With Sock[p]^ do
   Begin
   Mode := SM_Clusse;
   Usr_InActive := 0;
   Link_InActive := 0;
   End;

 Ca := Get_Callsign(p);
 b := SSID(Ca);
 Ca := StripSSID(Ca);

 If not ((b = 6) or (b = 7))
  then b := 0;

 Inc(LUserCount);
 Inc(LoginCount);
 If LUserCount > MaxLUsers { High water mark }
   then MaxLUsers := LUserCount;

 { Inc(SSID), jos useamman kerran verkosssa, if in the network multiple times }

       Repeat
         nu := Users;
         Ok := True;
         While Assigned(nu) and Ok
           do Begin
              If (StripSSID(nu^.Call) = Ca) and (SSID(nu^.Call) = b)
                then Ok := False;
              nu := nu^.Next;
              End;
         h := Nodes;
         While Assigned(h) and Ok
           do Begin
              If (StripSSID(h^.Call) = Ca) and (SSID(h^.Call) = b)
                then Ok := False;
              h := h^.Next;
              End;
         If not Ok
           then Inc(b);
       until Ok;

 If (b > 0) then Ca := Ca + '-' + Int2Str(b);

 New(LUser[p]);
 With LUser[p]^ do
   Begin
   M2 := 0;
   M3 := 0;
   Str := '';
   LastTalkFrom := '';
   Illegals := 0;
   SUTries := 0;
   Here := True;
   AwayStrP := nil;
   Locked := True;
   f := Readuser(Ca);
   If not Assigned(f)
     then Begin { New user }
          NewUser := True;
          New(f);
          LUserFDefaults(f);
          End;
   With f^
    do Begin
       Call := Ca;
       If StripSSID(Call) = Conf^.Adm.SysopCall
         then Group := Conf^.Adm.OpGroup; { Sysop? }
       Inc(Logins);
       ti := Time;
       Time := now;
       End;
   WriteUser(f);

   group := f^.Group;
   If fPermissionQ(p, R_AllFiles)
     then Path := CluPath
     else Path := UserPath;

   If PermissionQ(p,R_Login)
     then Begin
          New(nu);
          n := nu;
          With nu^
            do Begin
               Next := nil;
               Call := f^.Call;
               PC := LocalNode;
               Time := now;
               Here := True;
               Privileged := False;
               Sysop := (f^.Group = Conf^.Adm.OpGroup);
               AwayStrP := nil;
               AwayTime := now;
               End;
          Protocol.AddUser(nu);
          Locked := False;

          With f^
            do Begin
               { Tarkistetaan CharSetin olemassaolo }
               { Check that the charset exists }
               If (CharSet > 5) or ((CharSet > 0) and (CStrings.CharSet[CharSet] = nil))
                 then CharSet := 0;
               Sock[p]^.CharSet := CharSet;
               Action(p,'Logged in');
               Log(L_LUser,Call + ' login');
               Send(p,'OH7LZB Clusse ' + Versio + ' - DX Cluster node ' + CluCall + ' - '
                    + Int2Str(NUserCount) + '/' + Int2Str(LUserCount) +  ' users, '
                    + Int2Str(NodeCount) + '/' + Int2Str(PCLinks) + ' nodes'
                    + Cr + InfoStr);
               LoginText(p);
               Send(p,Cr);
               LoadFilters(p);

               { Kyttjn haluamat listat }
               { Send the lists the user has requested }
               If LO_Fortune in LoginAct then Fortune(p);
               If LO_LNode in LoginAct
                 then Begin
                      Nodelist_Cmd(p);
                      Send(p,Cr);
                      End;
               If LO_LUser in LoginAct
                 then Begin
                      Userlist_Cmd(p);
                      Send(p,Cr);
                      End;
               If LO_LAnn in LoginAct
                 then Begin
                      ReadAnnLast(p,5);
                      Send(p,Cr);
                      End;
               If LO_LWwv in LoginAct
                 then Begin
                      ReadWWVLast(p,1);
                      Send(p,Cr);
                      End;
               If LO_LDx in LoginAct
                 then Begin
                      ReadDxLast(p,5);
                      Send(p,Cr);
                      End;
               If LO_LLink in LoginAct
                 then Begin
                      LinkList_Cmd(p);
                      Send(p,Cr);
                      End;

               { News tiedosto }
               ReadNewsAfter(p,ti);
               If NewUser and FileExists(TextPath + 'newuser.txt')
                 then If not SendFile(p,TextPath + 'newuser.txt')
                        then Send(p,'Welcome, new user.' + Cr);

               If PermissionQ(p,R_suCmd)
                 then Begin { Sysop checks }
                      If (DiskFree(0) < 524288)
                        then Send(p,DiskFullText);
                      If not (PCLinksH = 0)
                        then Send(p,Int2Str(PCLinksH) + ' link(s) held.' + Cr);
                      End;

               If n^.Name = ''
                 then Send(p,SetNameText);
               If Newuser
                 then Send(p,SetLocText);

               End; { With ....}
         Send(p,Prompt(p));
        End
     else Begin
          Action(p,'Logged in, but excluded.');
          Log(L_LUser,Ca + ' login - excluded.');
          Send(p,'Sorry, you are not allowed to log in.' + Cr);
          Kick(p);
          M2 := 255;
          ThrowOut(p);
          End;
   End;

End;

 { ***************************************************************** }

Procedure Logout(p:Byte);
Begin

 If not Assigned(LUser[p])
   then Exit;

 With LUser[p]^ do Begin

 WriteLast(f^.Call, DateStrSPad(f^.Time) + ' ' + TimeStrS(f^.Time)
    + ' - ' + TimeStrS(now) + ' : ' + Secs2Str(TimeDiff(f^.Time,Now)));

 Dec(LUserCount);

 If M2 = 255
   then Begin { Excluded }
        End
   else Begin
        Action(p,'Logged out');
        f^.Time := Now;
        WriteUser(f);

         { Conferenssilaisille tieto poistumisesta }
         { If some modes require closing of something, do it here }
        If Sock[p]^.Mode = SM_Convers then Convers.ConvLogout(p);
        If LUser[p]^.M2 = 7 then Rdb_Logout(p);

        Log(L_LUser,f^.Call + ' logout');

        If Assigned(AwayStrP)
          then Begin
               Dispose(AwayStrP);
               Dec(LAwayStrings);
               End;
        ClearFilters(p);

        Locked := True;
        Protocol.DeleteUser(nil,f^.Call,LocalNode,now);
        End;

 Dispose(f);
 End; { With.... }

 Dispose(LUser[p]);
 LUser[p] := nil;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 (***********************)
 (*                     *)
 (* Kyttjille viestit *)
 (* Messages to users   *)
 (***********************)

 { Lhett kaikille }

Procedure SendAll(MsgType:MessageItems;TStamped:Byte;Const s:string);
Var
  p : Byte;
Begin

 For p := 0 to UsrPorts
   do With LUser[p]^ do
     If Assigned(LUser[p])
         and ((MsgType in f^.Messages)
         and (not Locked)
         and ((TStamped = 0) or ((TStamped = 1) and (f_Timestamp in f^.Flags))
         or ((TStamped = 2) and not (f_Timestamp in f^.Flags))))
      then Begin
           If (f_Beeps in f^.Flags) and (MsgType in f^.Beeps)
             then Send(p,Chr(7));
           Send(p,s);
           End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Dx(Info:DxInfoP);      { DX }
Var
  p, b : Byte;
  i    : ShortInt;
  s    : String;
  ps   : String;
Begin

  s := Format(False,'DX de ' + PadLeft(10,Info^.FromCall + ':')
     + PadRight(9, Freq2Str(Info^.Freq)) + ' '
     + PadLeft(13, Info^.Call) + TimeStrS(Info^.Time) + 'Z', Info^.Info);

  ps := 'DX de ' + PadLeft(10, Info^.FromCall + ':')
      + PadRight(8, Freq2Str(Info^.Freq)) + '  '
      + PadLeft(13, Info^.Call) + PadLeft(31, Info^.Info)
      + TimeStrS(Info^.Time) + 'Z';

 For p := 0 to UsrPorts
   do With LUser[p]^ do
     If Assigned(LUser[p])
       and (not Locked)
       and (M_Dx in f^.Messages)
      then Begin
           i := Filter(p,Info);
           If (i >= 0)
             then Begin
                  If f_PCCompat in f^.Flags
                    then Send(p, ps)
                    else Send(p, s);
                  If (f_Beeps in f^.Flags)
                    then Begin
                         If (M_Dx in f^.Beeps)
                           then Send(p,Chr(7));
                         For b := 1 to i
                           do Send(p,Chr(7));
                         End;
                  Send(p,Cr);
                  End;
           End;

End;

Procedure Announce(Info:AnnP);   { Announce }
Var s : String;
Begin
 If not Info^.Sysop then
 If Info^.WX then Begin
                  s := Format(True,'WX at ' + Info^.FromCall + ' ' + TimeStrS(Info^.Time)
                       + 'Z :',Info^.Msg);
                  SendAll(M_Wx,1,s);
                  s := Format(True,'WX at ' + Info^.FromCall + ':',Info^.Msg);
                  SendAll(M_Wx,2,s);
                  End
             else Begin
                  s := Info^.FromCall;
                  If Info^.ToPc = '*'
                    then s := s + ' shouts'
                    else s := s + ' says';
                  SendAll(M_Ann,2,Format(True,s + ':',Info^.Msg));
                  s := s + ' ' + TimeStrS(Info^.Time) + 'Z:';
                  SendAll(M_Ann,1,Format(True,s,Info^.Msg));
                  End;
End;

Procedure WWV(Info:WWVRec);        { WWV }
Var
 DayT : DateTime;
Begin
 UnPackTime(Info.Time,DayT);
 If (DayT.Day <> Dt.Day) or (DayT.Month <> Dt.Month) or (DayT.Year <> Dt.Year)
    then SendAll(M_WWV,0,Format(True,'WWV for ' + DateStrS(Info.Time) + ', hour ' + Int2Str(Info.Hour) + ' de ' + Info.FromCall
                   + ': SFI ' + Int2Str(Info.SFI) + ', A ' + Int2Str(Info.A) + ', K ' + Int2Str(Info.K) + ' -',
                   + Info.Forecast))
    else SendAll(M_WWV,0,Format(True,'WWV for hour ' + Int2Str(Info.Hour) + ' de ' + Info.FromCall
                   + ': SFI ' + Int2Str(Info.SFI) + ', A ' + Int2Str(Info.A) + ', K '
                   + Int2Str(Info.K) + ' -', + Info.Forecast));
End;

Procedure UserAdd(u:NUserRecP);
Var
  b   : MessageItems;
  Usr : String[20];
Begin

 Usr := u^.Call;

 If u^.Pc = LocalNode
   then b := M_LocalUser
   else Begin
        b := M_User;
        Usr := Usr + '@' + u^.Pc^.Call;
        End;

 SendAll(b,1,Usr + ' logged in ' + TimeStrS(u^.Time) + 'Z.' + Cr);
 SendAll(b,2,Usr + ' logged in.' + Cr);

End;

Procedure UserDelete(u:NUserRecP);
Var
  b   : MessageItems;
  Usr : String[20];
Begin

 Usr := u^.Call;

 If u^.Pc = LocalNode
   then b := M_LocalUser
   else Begin
        b := M_User;
        Usr := Usr + '@' + u^.Pc^.Call;
        End;

 SendAll(b,1,Usr + ' logged out ' + TimeStrS(u^.Time) + 'Z.' + Cr);
 SendAll(b,2,Usr + ' logged out.' + Cr);

End;

Procedure UserHere(u:NUserRecP);
Var b : MessageItems;
Begin

 If u^.Pc = LocalNode
   then b := M_LocalUser
   else b := M_User;

 SendAll(b,1,u^.Call + '@' + u^.Pc^.Call + ' came back ' + TimeStrS(now) + 'Z.' + Cr);
 SendAll(b,2,u^.Call + '@' + u^.Pc^.Call + ' came back.' + Cr);

End;

Procedure UserAway(u:NUserRecP);
Var
  s1 : String[30];
  s2 : String;
  b  : MessageItems;
Begin

 If u^.Pc = LocalNode
   then b := M_LocalUser
   else b := M_User;

 If assigned(u^.AwayStrP)
   then s2 := ': ' + u^.AwayStrP^
   else s2 := '.';

 s1 := u^.Call + '@' + u^.Pc^.Call + ' went away';

 SendAll(b,1,s1 + ' ' + TimeStrS(now) + 'Z' + s2 + Cr);
 SendAll(b,2,s1 + s2 + Cr);

End;

Procedure NodeAdd(h:NodeRecP);
Var s : String;
Begin
 s := 'New node ' + h^.Call + ' via ' + h^.Via^.Call
      + ', v' + Int2Str(h^.Ver);
 SendAll(M_Node,1,s + ' ' + TimeStrS(h^.Since) + 'Z' + Cr);
 SendAll(M_Node,2,s + Cr);
End;

Procedure NodeDelete(Call:CallRec;Const Reason:String);
Var s : String;
Begin
 s := 'Node ' + Call + ' vanished';
 SendAll(M_Node,1,s + ' ' + TimeStrS(now) + 'Z: ' + Reason + Cr);
 SendAll(M_Node,2,s + ': ' + Reason + Cr);
End;

Procedure LinkAdd(Call:CallRec);
Begin
 SendAll(M_Link,1,'Linked to ' + Call + ' ' + TimeStrS(now) + 'Z.' + Cr);
 SendAll(M_Link,2,'Linked to ' + Call + '.' + Cr);
End;

Procedure LinkDelete(Call:CallRec;dr:DReasonT);       { Linkki tipahti }
Begin
 SendAll(M_Link,1,'Link to ' + Call + ' failed ' + TimeStrS(now) + 'Z (' + drStr(dr) + ').' + Cr);
 SendAll(M_Link,2,'Link to ' + Call + ' failed (' + drStr(dr) + ').' + Cr);
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 (*****************)
 (*               *)
 (* User commands *)
 (*               *)
 (*****************)

 { Tarpeelliset funktiot }

 Procedure ParamError(p:Byte);
 Begin
  Send(p,'Something wrong with parameters.' + Cr);
  Done := True;
 End;

 { *********************************************************************** }

Procedure Talk_Mode(p:Byte);
Begin

 With LUser[p]^ do
 If AbortStr
  then Begin
       M2 := 0;
       Str := '';
       Send(p,'Closing talk mode.' + Cr);
       End
  else Begin
       Prompted := False;
       If IBuffer <> Cr
        then Begin
             IBuffer := 't ' + Str + ' ' + IBuffer;
             If M3 = 1 { timestamped }
              then IBuffer := 't' + IBuffer;
             Talk_Cmd(p);
             End;
       End;

End;

 { *********************************************************************** }
 { I just love this one. Me - BOFH? Nooooooo 8-] }

Procedure Illegal_Cmd(p:Byte);
Const
  IllegalCmd : String[41] = 'Illegal command. Try the "Help" command.' + Cr;
  Nopoint    : String[31] = 'I don''t quite get your point?' + Cr;
  NotUnderst : String[48] = 'Command not understood. Try the "Help" command.' + Cr;
  Nerves     : String[30] = 'You''re getting on my nerves.' + Cr;
  NextDisc   : String[91] = 'Next time, you''ll be disconnected. Use the "Help" command to get a list' + Cr
                          + 'of valid commands.' + Cr;
  UglyFace   : String[42] = 'I didn''t like your face anyway.' + Cr;
Begin

 Inc(LUser[p]^.Illegals);
 Case LUser[p]^.Illegals of
   1     : Send(p,'Uh?' + Cr);
   2     : Send(p,'What?' + Cr);
   3     : Send(p,IllegalCmd);
   4     : Send(p,Nopoint);
   5     : Send(p,NotUnderst);
   6     : Send(p,Nerves);
   7     : Send(p,NextDisc);
   8     : Begin
           Send(p,UglyFace);
           Kick(p);
           Prompted := False;
           ThrowOut(p);
           End;
 End;

End;

 { *********************************************************************** }
 { Sends a remote PacketCluster command. Implemented, and works, but
   commented out... figured that the PacketCluster sysops would NOT have
   liked it if Clusse sysops could send remote commands to their nodes
   but they couldn't send remote commands to Clusse nodes. Political
   correctness is an important thing here, you know... }
{
Procedure Remote_Cmd(p:Byte);
Var
  ToPC : CallRec;
  b    : Byte;
  n    : NodeRecP;
  Cmd  : String[50];
Begin

  ToPC := UpCaseStr(Parse(1));
  n := GetNode(ToPC);
  If Assigned(n)
    then Begin
         b := FindParamStart(2);
         Cmd := Copy(IBuffer,b,Length(IBuffer) - b);
         If Cmd <> ''
          then Begin
               Send(Link[n^.Via]^.Sock,'PC36^' + ToPC + '^' + CluCall + '^' + Cmd + '^~' + Cr);
               Kick(Link[n^.Via]^.Sock);
               End
          else Send(p,'Specify a command.' + Cr);
         End
    else Send(p,'Node ' + ToPC + ' not known.' + Cr);

End;
}
 { *********************************************************************** }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure CluCommand(p:sType);
Var
  b, pos  : Byte;
  Hit,
  Invalid : Boolean;
  Cmd     : String;

Type
  UserCommand    = Procedure(p:Byte);
  CListEntry     = Record
                   Name : String[20];
                   Proc : UserCommand;
                   r    : RightItems;
                   fr   : fRightItems;
                   End;
{
  Not_a_PC = 'You''re not using a PacketCluster (TM). Try the Help command.' + Cr;
}
Const

 { Here is the actual command list. It defines the commands, the procedure
   to call for the handling of the command, and the "rights" bits needed.
   Some commands that i never got working are commented out. }

 Commands      = 80;
 CList : Array[1..Commands] of CListEntry =
  (
   (Name: 'announce';          Proc: Announce_Cmd;    r: R_WideAct; fr: R_NoFRights),
   (Name: 'away';              Proc: Away_Cmd;        r: R_Interact; fr: R_NoFRights),
   (Name: 'bye';               Proc: Bye_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'bands';             Proc: Bands_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'beeps';             Proc: Beeps_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'bput';              Proc: BinPut_Cmd;      r: R_NoRights; fr: R_FileCMD),
   (Name: 'bget';              Proc: BinGet_Cmd;      r: R_NoRights; fr: R_FileCMD),
   (Name: 'converse';          Proc: Convers_Cmd;     r: R_WideAct; fr: R_NoFRights),
   (Name: 'conference';        Proc: Convers_Cmd;     r: R_WideAct; fr: R_NoFRights),
   (Name: 'charset';           Proc: CharSet_Cmd;     r: R_NoRights; fr: R_NoFRights),
   (Name: 'cd';                Proc: CD_Cmd;          r: R_NoRights; fr: R_NoFRights),
{   (Name: 'coordinates';       Proc: Coordinates_Cmd; r: R_NoRights; fr: R_NoFRights),}
   (Name: 'copy';              Proc: Copy_Cmd;        r: R_NoRights; fr: R_FileCmd),
   (Name: 'dx';                Proc: Dx_Cmd;          r: R_Wideact; fr: R_NoFRights),
   (Name: 'del';               Proc: Del_Cmd;         r: R_NoRights; fr: R_FileCmd),
   (Name: 'dos';               Proc: Dos_Cmd;         r: R_NoRights; fr: R_DosExec),
   (Name: 'disconnect';        Proc: Disc_Cmd;        r: R_AllCmd; fr: R_NoFRights),
   (Name: 'directory';         Proc: Dir_Cmd;         r: R_NoRights; fr: R_FileCmd),
   (Name: 'euser';             Proc: EUser_Cmd;       r: R_AllCmd; fr: R_NoFRights),
   (Name: 'egroup';            Proc: EGroup_Cmd;      r: R_AllCmd; fr: R_NoFRights),
   (Name: 'find';              Proc: Find_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'filter';            Proc: Filter_Cmd;      r: R_NoRights; fr: R_NoFRights),
   (Name: 'gpl';               Proc: GPL_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'groups';            Proc: Groups_Cmd;      r: R_NoRights; fr: R_NoFRights),
   (Name: 'get';               Proc: Get_Cmd;         r: R_NoRights; fr: R_FileCMD),
   (Name: 'help';              Proc: Help_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'here';              Proc: Here_Cmd;        r: R_Interact; fr: R_NoFRights),
   (Name: 'info';              Proc: Info_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'list';              Proc: List_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'login';             Proc: Login_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'locator';           Proc: Locator_Cmd;     r: R_NoRights; fr: R_NoFRights),
   (Name: 'lannouncements';    Proc: Lann_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'lastring';          Proc: Lastring_Cmd;    r: R_NoRights; fr: R_NoFRights),
   (Name: 'lafrom';            Proc: Lafrom_Cmd;      r: R_NoRights; fr: R_NoFRights),
   (Name: 'lconnections';      Proc: Lconnections_Cmd; r: R_NoRights; fr: R_NoFRights),
   (Name: 'lerrors';           Proc: LErrors_Cmd;      r: R_NoRights; fr: R_NoFRights),
   (Name: 'lwwv';              Proc: Lwwv_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'links';             Proc: Link_Cmd;         r: R_LinkCmd; fr: R_NoFRights),
   (Name: 'messages';          Proc: Messages_Cmd;     r: R_NoRights; fr: R_NoFRights),
   (Name: 'merge';             Proc: Merge_Cmd;        r: R_LinkCmd; fr: R_NoFRights),
   (Name: 'md';                Proc: md_Cmd;           r: R_NoRights; fr: R_FileCmd),
   (Name: 'move';              Proc: Move_Cmd;         r: R_NoRights; fr: R_FileCmd),
   (Name: 'nodes';             Proc: Nodes_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'name';              Proc: Name_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'news';              Proc: News_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'nlist';             Proc: nList_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'nlversion';         Proc: nList_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'nroutes';           Proc: nRoutes_Cmd;      r: R_NoRights; fr: R_NoFRights),
   (Name: 'prefix';            Proc: Prefix_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'ping';              Proc: Ping_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'pg';                Proc: PG_Cmd;           r: R_NoRights; fr: R_PubExec),
   (Name: 'pstat';             Proc: PStat_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'prompt';            Proc: Prompt_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'privileges';        Proc: Privileges_Cmd;   r: R_NoRights; fr: R_NoFRights),
   (Name: 'put';               Proc: Put_Cmd;          r: R_NoRights; fr: R_FileCMD),
   (Name: 'qth';               Proc: qth_Cmd;          r: R_NoRights; fr: R_NoFRights),
   (Name: 'run';               Proc: Run_Cmd;          r: R_NoRights; fr: R_NoFRights),
   (Name: 'rd';                Proc: rd_Cmd;           r: R_NoRights; fr: R_FileCmd),
   (Name: 'reboot';            Proc: Reboot_Cmd;       r: R_HaltCmd; fr: R_NoFRights),
   (Name: 'say';               Proc: Say_Cmd;          r: R_WideAct; fr: R_NoFRights),
   (Name: 'status';            Proc: Status_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'su';                Proc: su_Cmd;           r: R_suCmd; fr: R_NoFRights),
   (Name: 'shout';             Proc: Shout_Cmd;        r: R_Wideact; fr: R_NoFRights),
   (Name: 'shutdown';          Proc: Shutdown_Cmd;     r: R_HaltCmd; fr: R_NoFRights),
   (Name: 'set/pcmode';        Proc: PCMode_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'talk';              Proc: Talk_Cmd;         r: R_Interact; fr: R_NoFRights),
   (Name: 'ttime';             Proc: Talk_Cmd;         r: R_Interact; fr: R_NoFRights),
   (Name: 'time';              Proc: Time_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: 'treply';            Proc: Talk_Cmd;         r: R_Interact; fr: R_NoFRights),
   (Name: 'timestamp';         Proc: Timestamp_Cmd;    r: R_NoRights; fr: R_NoFRights),
   (Name: 'timereset';         Proc: Timereset_Cmd;    r: R_NoRights; fr: R_NoFRights),
   (Name: 'users';             Proc: Users_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'ulist';             Proc: UList_Cmd;        r: R_NoRights; fr: R_NoFRights),
   (Name: 'unetwork';          Proc: UNetwork_Cmd;     r: R_NoRights; fr: R_NoFRights),
   (Name: 'uptime';            Proc: Uptime_Cmd;       r: R_NoRights; fr: R_NoFRights),
   (Name: 'wx';                Proc: Announce_Cmd;     r: R_Wideact; fr: R_NoFRights),
{   (Name: 'where';             Proc: Where_Cmd;        r: R_NoRights; fr: R_NoFRights),}
   (Name: 'who';               Proc: Who_Cmd;          r: R_NoRights; fr: R_NoFRights),
   (Name: 'wwv';               Proc: wwv_Cmd;          r: R_Wideact; fr: R_NoFRights),
   (Name: '!';                 Proc: Software_Cmd;     r: R_NoRights; fr: R_NoFRights),
   (Name: '?';                 Proc: Help_Cmd;         r: R_NoRights; fr: R_NoFRights),
   (Name: '%';                 Proc: Status_Cmd;       r: R_NoRights; fr: R_NoFRights)
  );

Begin

  { Erotetaan komento }

 IBuffer  := CleanStr(IBuffer);
 Done := False;
 Invalid := True;
 pos := 0;
 Cmd := Parse(0);

 If Cmd = ''
   then Begin
        Invalid := False;
        LUser[p]^.Illegals := 0;
        End
   else
 Repeat

  Inc(pos);

  Hit := True;

  If  Length(Cmd) <= Length(CList[pos].Name)
    then Begin
         For b := 1 to Length(Cmd)
            do If (LowCaseCh[Cmd[b]] <> CList[pos].Name[b])
                 then Hit := False;

         End
    else Hit := False;

  If Hit
    then Begin
         LUser[p]^.Illegals := 0; { Everything which touches the
                                    per-user records in heap MUST
                                    done before executing the procedure! }
         Invalid := False;
         If Permission(p,CList[pos].r) and fPermission(p,Clist[pos].fr)
           then CList[pos].Proc(p);
         End;

 until Hit or (pos = Commands);

 If Invalid
   then Illegal_Cmd(p);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Clusse(p:Byte);
Begin

 Prompted := True;
 Done := False;

 Case LUser[p]^.M2 of
   0  : CluCommand(p);
   1  : Talk_Mode(p);
   2  : SU_Response(p);
   3  : Reboot_Response(p);
   4  : Shutdown_Response(p);
   5  : EUser_Response(p);
   6  : BinPut_Response(p);
   7  : RDb_Response(p);
   8  : EGroup_Response(p);
   9  : PG_Response(p);
   10 : BinGet_Response(p);
   11 : Put_Response(p);
   12 : Get_Response(p);
 End;

 If Prompted
   then Send(p,Prompt(p));

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Things to check every second                                            }

Procedure SecTimer;
Var
  b : Byte;
Begin

  For b := 0 to UsrPorts
   do If Assigned(LUser[b])
        then With LUser[b]^
              do If (Sock[b]^.Mode = SM_Clusse)
                   then Case M2 of
                          10 : BinGet_Timer(b);
                          12 : Get_Timer(b);
                        End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
