
/*
 *  MBTNC.C - 2/20/94 - Deal with the tnc.
 */

#include "mb.h"

static char *tcmds[] =
{
  "cono on\n",
  "cono of\n",
  "m on\n",
  "m of\n"
};

isdis(cp)
char *cp;
{
  if (search(cp, "*** DISC", 8)) return true;
  return false;
}

isreq(cp)
char *cp;
{
  if (matchn(cp, "*** conn", 8)) return true;
  if (matchn(cp, "*** Conn", 8)) return true;
  return false;
}

iscon(cp)
char *cp;
{
  return search(cp, "*** CONN", 8);
}

isretry(cp)
char *cp;
{
  if (matchn(cp, "*** Retry count exceeded", 24)) return true;
  if (matchn(cp, "*** retry count exceeded", 24)) return true;
  return false;
}
alloff()
{
  allcmd(t_coff);  /* Turn off connects */
  allcmd(t_moff);  /* Turn off monitoring */
}

allon()
{
  allcmd(t_mon);  /* Turn on monitoring */
  allcmd(t_con);  /* Turn on connects  */
}

login()
{
  register PORTS *p;
  register char *i;

  readmsg();
  readusr();

  p = port;

  p->lport = cport;
  cport->lport = p;
  p->errors = 0;
  p->msg    = NULL;
  p->cmdcnt = 0;
  p->flags clrbit p_opreq;
  p->ec = p->ecuser;

/*
 *  Prepare to check if this user can indeed connect.
 */

  switch (p->dev)
  {
    case p_console:
      p->mode = local;
      alloff();
      rduser(p->user->call, p->user);
      unbl(p->line, p->user->call, ln_call);
      log('C', 'S', ' ', p->line);
      break;

    case p_tnc:
      p->mode = remote;
      tncstate();   /* Pick up the "... connected to ..." line */
      alloff();
      if (p->tmode) trantnc(); else convtnc();
/*
 *  Remove the "; 1 unacked" that pk-232 puts on status line.
 */
      if ((i = strchr(p->line, ';')) isnt NULL) *i = '\0';
      if ((i = strchr(p->line, '*')) isnt NULL) *i = '\0';
      strcpy(p->line, p->line + 28);

      logina(false);
      log('C', p->id, ' ', p->line);
      break;

    case p_serial:
      p->mode = remote;
      p->flags setbit p_trans;
      alloff();
      strcpy(p->line, p->line + 17);
      logina(false);
      log('C', p->id, ' ', p->line);
      break;

    default: ;
  }
}

/*
 *  The login checking process.
 */

logina(link)
short link;
{
  register char *p, *q;
  register int ssid;
  register short nd;

  char bullfile[11];

  remnl(port->line);

/*
 *  Clear any pending connect request.
 */

  port->flags clrbit p_req;

/*
 *  Get the users call and ssid.
 */

  parse();
  ssid = pcall(tcall, port->fld[0]);

/*
 *  Add the call to J list for port, and for connect.
 */

  addcall(port->fld[0], cport);
  addcall(port->fld[0], port);

/*
 *  Get (or make) this users user record.
 */

  rduser(tcall, port->user);

/*
 *  Update the data in the user record.
 */

  port->user->ssid = ssid;
  port->user->port = port->id;

/*
 *  Get path. Count how many digi in path.
 *  First, fix digi path in case is a PK-232.
 */

  nd = 3;
  while (port->flds > 3)
  {
    strcat(port->fld[2], port->fld[nd]);
    port->flds--;
    nd++;
  }

  nd = 0;

  if (port->flds > 2)
  {
    nd++;
    p = port->user->path;
    for (q = port->fld[2]; *q; q++)
      if (*q isnt ' ') if ((*p++ = *q) is ',') nd++;
    *p = '\0';
  }
  else *port->user->path = '\0';

/*
 *  If this user is excluded, exclude him.
 */

  if (port->user->options & u_exclude) { port->mode = exclude; return; }

/*
 *  At last, decide if this user CAN connect.
 *  If sysop or bbs, can always connect.
 */

  if (port->user->options & (u_sysop | u_bbs)) {
    outstr(vers);
    return;
  }

 /*
 *  If this turkey has illegal call, kick him right off.
 */

  if (port->priv & p_ilcal) if (!iscall(tcall))
  {
    outstr("Invalid Callsign\n");
    wait(4);
    port->mode = exclude;
    return;
  }

/*
 *  This user isn't a bbs. If port is bbs only, bye bye.
 */

  if (port->priv & p_bbs)
  {
    outstr("BBS connects only\n");
    wait(4);
    port->mode = exclude;
    return;
  }

/*
 *  If user connected through too many digi, bye bye.
 */

  if (nd > port->ndigi) { port->mode = exclude; return; }

/*
 *  Well, this user can indeed connect on this port.
 *  Send our "I am a machine message"
 */

  outstr(vers);

  sprintf(bullfile, "BULLETIN.%c",port->id);
  if ((port->fl = fopen(bullfile, "r")) isnt NULL)
  {
    while( fgets(tmp->scr, scrmax, port->fl) isnt NULL)
    {
       if (chkdis()) break;
       prtx(tmp->scr);
    }
    fclose(port->fl);
  }

/*
 *  If not an expert user, give login message and
 *  tell about unread messages.
 */

  if (!(port->user->options & u_expert))
    prtm(motd);
    newmsg();
}

/*
 *  Execute a command to each port:
 *  Connects ok, monitor on, etc.
 */

allcmd(index)
int index;
{
  register PORTS *p, *was;
  byte ec;

  was = port;
  for (p = porthd; p isnt NULL; p = p->next)
  {
    ioport(p);
    if(p->dev is p_tnc)
    {
        p->flags clrbit p_give;
        ec = p->ec;
        p->ec = p->eccmds;
        outstr(tcmds[index]);
        waitcmd(0);
        p->flags setbit p_give;
        p->ec = ec;
    }
  }
  ioport(was);
}

alltnc(cp)
char *cp;
{
  register PORTS *p, *was;
  byte ec;

  was = port;
  for (p = porthd; p isnt NULL; p = p->next) switch(p->dev)
  {
    case p_tnc:
      ioport(p);
      ec = p->ec;
      p->ec = p->eccmds;
      p->flags clrbit p_give;
      outstr(cp);
      waitcmd(0);
      p->flags setbit p_give;
      p->ec = ec;
      break;

    default: ;
  }
  ioport(was);
}

/*
 *  Execute a command to the current port:
 *  Connects ok, monitor on, etc.
 */

onecmd(index)
int index;
{
  register byte ec;

  if(port->dev is p_tnc)
  {
      ec = port->ec;
      port->ec = port->eccmds;
      port->flags clrbit p_give;
      outstr(tcmds[index]);
      waitcmd(0);
      port->ec = ec;
      port->flags setbit p_give;
  }
}

onetnc(cp)
char *cp;
{
  register byte ec;

  if (port->dev is p_tnc)
  {
    ec = port->ec;
    port->ec = port->eccmds;
    port->flags clrbit p_give;
    outstr(cp);
    waitcmd(0);
    port->ec = ec;
    port->flags setbit p_give;
  }
}

/*
 *  Need to distinguish between "disconect in progress", "disconnected",
 *  "connected", "connect in progress".
 */

issta(cp)
char *cp;
{
  register char *p;

  p = cp;
  if (matchn(cp, "cmd:", 4)) p += 4;

  if (!matchn(p, "Link sta", 8)) return false;

  if (matchn(p + 15, "DISC", 4) and (strlen(p) < 30)) port->mode = discon;
  return true;
}

/*
 *  Put tnc in converse mode.
 */

convtnc()
{
  register byte ec;

  if(port->dev is p_tnc)
  {
      ec = port->ec;
      port->ec = port->eccmds;
      outstr("conv\n");
      port->ec = ec;
      wait(2);
  }
}


trantnc()
{
  register byte ec;

  if(port->dev is p_tnc)
  {
      ec = port->ec;
      port->ec = port->eccmds;
      outstr("trans\n");
      port->flags setbit p_trans;
      port->ec = ec;
      wait(1);
  }
}

/*
 *  Put tnc in command mode.
 */

cmdtnc()
{
  register byte ec;

  if(port->dev is p_tnc)
  {
      ec = port->ec;
      port->ec = port->eccmds;
      port->flags clrbit p_give;
      if (port->flags & p_trans) breakport(); else outchar(ctl_c);
      waitcmd(1);
      port->ec = ec;
      port->flags setbit p_give;
      port->flags clrbit p_trans;
  }
}

/*
 *  Discover the state of the device on the current port.
 */

tncstate()
{
  register byte ec;

  if (port->mode & idle) return;

  if (port->dev is p_tnc)
  {
      ec = port->ec;
      port->ec = port->eccmds;
      cmdtnc();
      port->flags clrbit p_give;
      outstr("C\n");
      while (true)
      {
        getdat();
        if (issta(port->line))
        {
          waitcmd(1);
          port->ec = ec;
          port->flags setbit p_give;
          return;
        }
        else
        {
          cmdtnc();
          port->flags clrbit p_give;
          outstr("C\n");
        }
      }
  }
}

/*
 *  Disconnect tnc.
 */

distnc()
{
  register int tsave;
  register short done;
  byte ec;

  tncstate();

  if (port->mode & idle) return;

  ec = port->ec;
  port->ec = port->eccmds;
  switch (port->dev)
  {
    case p_serial:
      if (!(port->mode & discon)) outstr("*** DISCONNECTED\n");
      break;
    case p_tnc:
      if (port->mode & discon) break;
      port->flags clrbit p_give;
      outstr("D\n");  /* This does not eat cmd:, thus dtime not used */
      settmr(&port->expire, port->dtime);
      while (true)
      {
        if (instat())
        {
          tsave = port->ctime;
          port->ctime = port->dtime;
          getdat();
          port->ctime = tsave;
          if (isdis(port->line))
          {
            waitcmd(1);
            port->ec = ec;
            port->flags setbit p_give;
            return;
          }
        }

        if (!chktmr(port->expire))
        {
          outstr("D\n");
          while (!isdis(port->line)) getdat();
          waitcmd(1);
          port->ec = ec;
          port->flags setbit p_give;
          return;
        }
      }
      break;
  }
  port->ec = ec;
  port->mode = discon;
}

/*
 *  Send connect string to tnc.
 */

contnc(p)
char *p;
{
  register byte ec;

  ec = port->ec;
  port->ec = true;
  switch (port->dev)
  {
    case p_tnc:
      outstr(p);
      port->ec = port->eccmds;
      waitcmd(0);
      break;

    case p_serial:
      prtx("*** CONNECTED to $O\n");
  }
  port->ec = ec;
}

/*
 *  Wait for "cmd:" prompt.
 */

waitcmd(x)
int x;
{
  static char *wanted = "cmd:";
  register short i;
  long l;
  int t;
  if (s_flag & s_dv) t = 5; else t = 2;
  if (x) t = x;
  if(port->dev is p_tnc)
  {
      settmr(&l, t);
      for (i = 0; i < 4;)
      {
        if (instat()) if (inchar() is *(wanted + i)) i++; else i = 0;
        if (!chktmr(l))
        {
            if (!(port->eccmds))
            bdos(2,tolower(port->id),0); return;
        }
      }
      if (!(port->eccmds)) bdos(2,port->id,0);
  }
}
