/*
 *  MB.H - 4/14/94 - Definitions for MailBox.
 */

/*
 *  System specific includes.
 *  IBM PC, Microsoft C Compiler Version 5.00
 */

/*
 *  Includes from the C Library.
 */

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <sys\types.h>
#include <sys\stat.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif

typedef unsigned char  byte;
typedef unsigned short word;

/*
 *  Sizes of things.
 */

#define ln_handle 12  /* # chars in users name         */
#define ln_call    6  /* # chars in a callsign         */
#define ln_callp   9  /* # chars in callsign+ssid      */
#define ln_date    6  /* # chars in date               */
#define ln_time    4  /* # chars in time               */
#define ln_zip     6  /* # chars in zip or postal code */
#define ln_bid    12  /* # chars in bulletin ID        */
#define ln_qth    20  /* # chars in qth                */

#define maxflds  16

/*
 *  MailBox includes.
 */

#include "mbmail.h"
#include "mbuser.h"
#include "mbport.h"

/*
 *  Cosmetics.
 */

#define is   ==
#define isnt !=
#define and  &&
#define or   ||
#define not   !

#define setbit  |=
#define clrbit  &= ~
#define flipbit ^=

#define true   1
#define false  0
#define match  !strcmp
#define matchn !strncmp

#define nncmd false /* If true, enable the "NN" command    */

#define RECSIZE 256

#define pmode S_IREAD | S_IWRITE  /* Permissions for creat() */

/*
 *  Some character values.
 */

#define ctl_c  '\03'
#define ctl_g  '\07'
#define ctl_v  '\026'
#define ctl_w  '\027'
#define cpmeof '\032'
#define del     0x7f

/*
 *  Index values for standard TNC commands.
 */

#define t_con  0  /* Connect on */
#define t_coff 1  /* Connect off */
#define t_mon  2  /* Monitor on */
#define t_moff 3  /* Monitor off */

#define cmdlen   80
#define linelen 256

extern char scmd[24];
extern char pt_flag;
extern char fwd_flag;
extern word filesize;

/*
 *  Multi-line messages (message of the day, mostly).
 */

typedef struct MLM_S
{
  char *text;
  struct MLM_S *next;
} MLM;

/*
 *  Directory path stuff.
 */

#define dp_dnload 1  /* Ok to download */
#define dp_upload 2  /* Ok to upload   */

typedef struct DIRPATH_S
{
  char *name;              /* Name of this directory path */
  char *path;              /* The path or device spec */
  struct DIRPATH_S *next;  /* Pointer to next path */
  byte flags;              /* Flag bits */
  char id;                 /* Path identifier */
} DIRPATH;

extern DIRPATH *dphd, *getdir();

/*
 *  Directory entry stuff.
 */

typedef struct
{
  word size;    /* Device size, in k */
  word block;   /* Device block size */
  word free;    /* Device free space, in k */
} DIRDEF;

typedef struct
{
  char name[14];  /* File name */
  short size;     /* File size, in k */
} DIRENT;

/*
 *  Scratch area. Used by directory listing commands,
 *  and by user file and message file backup.
 *  Also used hither, and yon.
 */

typedef union
{
  char scr[1];
  DIRENT dirent[1];
} TMP;

extern int scrmax, dirmax;
extern TMP *tmp;

/*
 *  Date and time stuff.
 */

extern char l_date[ln_date + 1];
extern char l_time[ln_time + 1];
extern int log_mon;
extern byte unt_hr;

/*
 *  File names.
 */

extern char *helpfile, *infofile, *fwdfile, *lgfile, *monfile;

extern char *hrdfile, *bidfile, *stfile;
extern int  hrdmax;

#define bidok   0x01  /* Smart bbs - BID exchange            */
#define hidok   0x02  /* Smart bbs - Hierarchical address    */

extern byte s_mart;

/*
 *  Error / status messages.
 */

extern char *mcant, *mfind,  *mprot, *mexst,  *mtime, *mwhat;
extern char *mdone, *mnport, *mndir, *mnfile, *mnmsg, *minuse;

/*
 *  Misc text.
 */

extern MLM *motd;

extern char *nullstr;
extern char *ver;
extern char *vers;

extern char *talkm1, *talkm2, *talkm3, *talkm4;
extern char *bbmenu, *symenu, *rmenus, *mumsg;
extern char *pausemsg, *fm, *reqmsg;
extern char *qth, *keylst;

extern char achar, rchar, tchar, wchar;

/*
 *  System parameters.
 */

#define s_page     0x0001   /* Page sysop enabled ?            */
#define s_cmd      0x0002   /* Delayed remote sysop cmd to do  */
#define s_unt      0x0004   /* Do an automatic untangle        */
#define s_mchange  0x0008   /* Mail file changed?              */
#define s_kill     0x0010   /* Kill all msgs after forward     */
#define s_fkill    0x0020   /* Kill F msgs after forward       */
#define s_svc      0x0040   /* Generate service message on KT  */
#define s_edtfc    0x0080   /* Edit traffic command enabled?   */

#define s_log_on   0x0100   /* Logging enabled                 */
#define s_log_gate 0x0200   /* Log gateway events              */
#define s_log_file 0x0400   /* Log file events                 */
#define s_log_msg  0x0800   /* Log message events              */
#define s_log_loc  0x1000   /* Log stuff happens local console */
#define s_ping     0x2000   /* Stop ping-pong messages         */
#define s_uhold    0x4000   /* Hold user bulletins             */

extern word s_param;

#define s_p_name   0x01     /* Prompt user to enter name       */
#define s_p_home   0x02     /* Prompt user to enter bbs        */
#define s_p_zip    0x04     /* Prompt user to enter zip        */
#define s_p_qth    0x08     /* Prompt user to enter qth        */

extern byte s_prompt;

#define s_update   0x01     /* List update flag                */
#define s_dv       0x02     /* Desqview active, give slice     */
#define s_bkill    0x04     /* Auto kill stale bulletins       */
#define s_nkill    0x08     /* Auto kill stale traffic         */
#define s_ukill    0x10     /* Auto kill stale user messages   */
#define s_view     0x20     /* Forward view flag               */
#define s_bview    0x40     /* Forward bulletin view flag      */

extern byte s_flag;
