/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.snippet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetReader {
    private static final String EOL = System.getProperty("line.separator");
    private URL source;

    public SnippetReader(URL src) {
        this.source = src;
    }

    public StringBuffer readSnippet(String snippetId) throws IOException {
        List<String> lines = this.readLines(snippetId);
        int minIndent = this.minIndent(lines);
        StringBuffer result = new StringBuffer();
        for (String line : lines) {
            result.append(line.substring(minIndent));
            result.append(EOL);
        }
        return result;
    }

    int minIndent(List<String> lines) {
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            minIndent = Math.min(minIndent, this.indent(line));
        }
        return minIndent;
    }

    int indent(String line) {
        int indent;
        char[] chars = line.toCharArray();
        for (indent = 0; indent < chars.length && chars[indent] == ' '; ++indent) {
        }
        return indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(String snippetId) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.source.openStream()));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            boolean capture = false;
            while ((line = reader.readLine()) != null) {
                if (snippetId == null || "".equals(snippetId.trim())) {
                    lines.add(line);
                    continue;
                }
                if (this.isStart(snippetId, line)) {
                    capture = true;
                    continue;
                }
                if (this.isEnd(snippetId, line)) {
                    break;
                }
                if (!capture) continue;
                lines.add(line);
            }
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return lines;
    }

    protected boolean isStart(String snippetId, String line) {
        return this.isDemarcator(snippetId, "START", line);
    }

    protected boolean isDemarcator(String snippetId, String what, String line) {
        String upper = line.toUpperCase(Locale.ENGLISH);
        return upper.contains(what.toUpperCase(Locale.ENGLISH)) && upper.contains("SNIPPET") && line.contains(snippetId);
    }

    protected boolean isEnd(String snippetId, String line) {
        return this.isDemarcator(snippetId, "END", line);
    }
}

