/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSClass.class)
final class JSClassGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JSClassGen() {
    }

    static {
        LibraryExport.register(JSClass.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSClass.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, DynamicObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSClass.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    return JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                    return JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArrayBufferView(arg0Value)) {
                    return JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArgumentsObject(arg0Value)) {
                    return JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                }
                if (!(JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                    return JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                if (JSGuards.isJSArray(arg0Value)) {
                    return JSClass.GetArraySize.array(arg0Value);
                }
                if (JSGuards.isJSArrayBufferView(arg0Value)) {
                    return JSClass.GetArraySize.typedArray(arg0Value);
                }
                if (JSGuards.isJSArgumentsObject(arg0Value)) {
                    return JSClass.GetArraySize.argumentsObject(arg0Value);
                }
                return JSClass.GetArraySize.unsupported(arg0Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNull((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMembers((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.readMember(arg0Value, arg1Value, this.javaScriptLanguageReference_, JSClass.getUncachedRead(), ((JavaScriptLanguage)this.javaScriptLanguageReference_.get()).bindMemberFunctions(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberReadable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                JSClass.writeMember(arg0Value, arg1Value, arg2Value, KeyInfoNodeGen.getUncached(), JSForeignToJSTypeNodeGen.getUncached(), this.javaScriptLanguageReference_, JSClass.getUncachedWrite());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberModifiable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberInsertable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeMember((DynamicObject)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberRemovable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasArrayElements((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.readArrayElement(arg0Value, arg1Value, this.javaScriptLanguageReference_, JSClass.getUncachedRead(), ExportValueNodeGen.getUncached(), this);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementReadable(arg0Value, arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, KeyInfoNodeGen.getUncached(), JSForeignToJSTypeNodeGen.getUncached(), this.javaScriptLanguageReference_, JSClass.getUncachedWrite());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementModifiable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementInsertable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isArrayElementRemovable((DynamicObject)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeArrayElement((DynamicObject)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.execute(arg0Value, arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isExecutable(arg0Value, IsCallableNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.instantiate(arg0Value, arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropInstantiateNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isInstantiable((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropInvokeNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberInvocable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isString((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asString((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isBoolean((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asBoolean((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNumber((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInByte(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInShort(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInInt(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInFloat(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInDouble(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asByte(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asShort(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asInt(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asFloat(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asDouble(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asInstant((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asDate(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asTime(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asTimeZone(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasLanguage((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getLanguage((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.toDisplayString((DynamicObject)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasSourceLocation((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getSourceLocation((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMetaObject((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObject((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isMetaObject((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObjectName((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObjectName((DynamicObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isMetaInstance((DynamicObject)receiver, instance);
            }
        }

        @GeneratedBy(value=JSClass.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private long state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private JSForeignToJSTypeNode importValue;
            @Node.Child
            private ExportValueNode exportValue;
            @Node.Child
            private InteropLibrary numberLib;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @CompilerDirectives.CompilationFinal
            private GetMembersNonArrayCachedData getMembers_nonArrayCached_cache;
            @Node.Child
            private ReadElementNode readMemberNode__readNode_;
            @CompilerDirectives.CompilationFinal
            private boolean readMemberNode__bindMemberFunctions_;
            @Node.Child
            private ExportValueNode readMemberNode__exportNode_;
            @Node.Child
            private WriteElementNode writeMemberNode__writeNode_;
            @Node.Child
            private ReadElementNode readArrayElementNode__readNode_;
            @Node.Child
            private WriteElementNode writeArrayElementNode__writeNode_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private IsCallableNode isExecutableNode__isCallable_;
            @Node.Child
            private JSInteropInstantiateNode instantiateNode__callNode_;
            @Node.Child
            private JSInteropInvokeNode invokeMemberNode__callNode_;

            Cached(Object originalReceiver) {
                DynamicObject receiver = (DynamicObject)originalReceiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            @ExplodeLoop
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x3FL) != 0L) {
                    if ((state & 1L) != 0L && JSGuards.isJSFastArray(arg0Value)) {
                        return JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                    }
                    if ((state & 2L) != 0L && JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                        return JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                    }
                    if ((state & 4L) != 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                        return JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                    }
                    if ((state & 8L) != 0L && JSGuards.isJSArgumentsObject(arg0Value)) {
                        return JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                    }
                    if ((state & 0x10L) != 0L) {
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        while (s5_ != null) {
                            assert (s5_.cachedJSClass_ != null);
                            if (JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_) {
                                return JSClass.GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if (!((state & 0x20L) == 0L || JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                        return JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersAndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersAndSpecialize(DynamicObject arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (JSGuards.isJSFastArray(arg0Value)) {
                        this.state_ = state |= 1L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                        this.state_ = state |= 2L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArrayBufferView(arg0Value)) {
                        this.state_ = state |= 4L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArgumentsObject(arg0Value)) {
                        this.state_ = state |= 8L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                        return object;
                    }
                    if (exclude == 0) {
                        JSClass cachedJSClass__;
                        int count5_ = 0;
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        if ((state & 0x10L) != 0L) {
                            while (s5_ != null) {
                                assert (s5_.cachedJSClass_ != null);
                                if (JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_) break;
                                s5_ = s5_.next_;
                                ++count5_;
                            }
                        }
                        if (s5_ == null && (cachedJSClass__ = JSClass.GetMembers.getNonArrayJSClass(arg0Value)) != null && JSObject.getJSClass(arg0Value) == cachedJSClass__ && count5_ < 3) {
                            s5_ = new GetMembersNonArrayCachedData(this.getMembers_nonArrayCached_cache);
                            s5_.cachedJSClass_ = cachedJSClass__;
                            this.getMembers_nonArrayCached_cache = s5_;
                            this.state_ = state |= 0x10L;
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = JSClass.GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                            return object;
                        }
                    }
                    if (!(JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                        this.exclude_ = exclude |= 1;
                        this.getMembers_nonArrayCached_cache = null;
                        state &= 0xFFFFFFFFFFFFFFEFL;
                        this.state_ = state |= 0x20L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                GetMembersNonArrayCachedData s5_;
                long state = this.state_;
                if ((state & 0x3FL) == 0L) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 0x3FL & (state & 0x3FL) - 1L) == 0L && ((s5_ = this.getMembers_nonArrayCached_cache) == null || s5_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x3C0L) != 0L) {
                    if ((state & 0x40L) != 0L && JSGuards.isJSArray(arg0Value)) {
                        return JSClass.GetArraySize.array(arg0Value);
                    }
                    if ((state & 0x80L) != 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                        return JSClass.GetArraySize.typedArray(arg0Value);
                    }
                    if ((state & 0x100L) != 0L && JSGuards.isJSArgumentsObject(arg0Value)) {
                        return JSClass.GetArraySize.argumentsObject(arg0Value);
                    }
                    if ((state & 0x200L) != 0L && Cached.getArraySizeFallbackGuard_(state, arg0Value)) {
                        return JSClass.GetArraySize.unsupported(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeAndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (JSGuards.isJSArray(arg0Value)) {
                        this.state_ = state |= 0x40L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.array(arg0Value);
                        return l;
                    }
                    if (JSGuards.isJSArrayBufferView(arg0Value)) {
                        this.state_ = state |= 0x80L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.typedArray(arg0Value);
                        return l;
                    }
                    if (JSGuards.isJSArgumentsObject(arg0Value)) {
                        this.state_ = state |= 0x100L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.argumentsObject(arg0Value);
                        return l;
                    }
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    long l = JSClass.GetArraySize.unsupported(arg0Value);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isNull((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasMembers((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400L) != 0L) {
                    return JSClass.readMember(arg0Value, arg1Value, this.javaScriptLanguageReference_, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.readMemberNode__readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)javaScriptLanguageReference__.get()).getJSContext()));
                    this.readMemberNode__bindMemberFunctions_ = ((JavaScriptLanguage)javaScriptLanguageReference__.get()).bindMemberFunctions();
                    this.readMemberNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    this.state_ = state |= 0x400L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.readMember(arg0Value, arg1Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800L) != 0L) {
                    return JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x800L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000L) != 0L) {
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, this.javaScriptLanguageReference_, this.writeMemberNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__;
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    if (this.importValue == null) {
                        this.importValue = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                    }
                    if ((javaScriptLanguageReference__ = this.javaScriptLanguageReference_) == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.writeMemberNode__writeNode_ = (WriteElementNode)super.insert((Node)WriteElementNode.createCachedInterop(javaScriptLanguageReference__));
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__, this.writeMemberNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000L) != 0L) {
                    return JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000L) != 0L) {
                    return JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInsertableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSClass.removeMember((DynamicObject)this.dynamicDispatch_.cast(receiver), member);
            }

            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000L) != 0L) {
                    return JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberRemovableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x8000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasArrayElements((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000L) != 0L) {
                    return JSClass.readArrayElement(arg0Value, arg1Value, this.javaScriptLanguageReference_, this.readArrayElementNode__readNode_, this.exportValue, this);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.readArrayElementNode__readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)javaScriptLanguageReference__.get()).getJSContext()));
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_ = state |= 0x10000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.readArrayElement(arg0Value, arg1Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__, this.readArrayElementNode__readNode_, this.exportValue, this);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                return JSClass.isArrayElementReadable(arg0Value, arg1Value, this);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000L) != 0L) {
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, this.javaScriptLanguageReference_, this.writeArrayElementNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__;
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    if (this.importValue == null) {
                        this.importValue = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                    }
                    if ((javaScriptLanguageReference__ = this.javaScriptLanguageReference_) == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.writeArrayElementNode__writeNode_ = (WriteElementNode)super.insert((Node)WriteElementNode.createCachedInterop(javaScriptLanguageReference__));
                    this.state_ = state |= 0x20000L;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__, this.writeArrayElementNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000L) != 0L) {
                    return JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x40000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000L) != 0L) {
                    return JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementInsertableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x80000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementRemovable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isArrayElementRemovable((DynamicObject)this.dynamicDispatch_.cast(receiver), index);
            }

            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSClass.removeArrayElement((DynamicObject)this.dynamicDispatch_.cast(receiver), index);
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000L) != 0L) {
                    return JSClass.execute(arg0Value, arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), this.executeNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    if ((javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_) == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.executeNode__callNode_ = (JSInteropExecuteNode)super.insert((Node)JSInteropExecuteNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_ = state |= 0x100000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.execute(arg0Value, arg1Value, (JavaScriptLanguage)javaScriptLanguageReference__.get(), (JSRealm)javaScriptLanguageContextReference__.get(), this.executeNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000L) != 0L) {
                    return JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isExecutableNode__isCallable_ = (IsCallableNode)super.insert((Node)IsCallableNode.create());
                    this.state_ = state |= 0x200000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000L) != 0L) {
                    return JSClass.instantiate(arg0Value, arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), this.instantiateNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    if ((javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_) == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.instantiateNode__callNode_ = (JSInteropInstantiateNode)super.insert((Node)JSInteropInstantiateNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_ = state |= 0x400000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.instantiate(arg0Value, arg1Value, (JavaScriptLanguage)javaScriptLanguageReference__.get(), (JSRealm)javaScriptLanguageContextReference__.get(), this.instantiateNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isInstantiable((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000L) != 0L) {
                    return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), this.invokeMemberNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    if ((javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_) == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.invokeMemberNode__callNode_ = (JSInteropInvokeNode)super.insert((Node)JSInteropInvokeNode.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_ = state |= 0x800000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.invokeMember(arg0Value, arg1Value, arg2Value, (JavaScriptLanguage)javaScriptLanguageReference__.get(), (JSRealm)javaScriptLanguageContextReference__.get(), this.invokeMemberNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000L) != 0L) {
                    return JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x1000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000L) != 0L) {
                    return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberReadSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x2000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000L) != 0L) {
                    return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x4000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isString((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asString((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isBoolean((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asBoolean((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isNumber((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000L) != 0L) {
                    return JSClass.fitsInByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInByteNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x8000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInByte(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000L) != 0L) {
                    return JSClass.fitsInShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInShortNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x10000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInShort(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000L) != 0L) {
                    return JSClass.fitsInInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInIntNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x20000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInInt(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000000L) != 0L) {
                    return JSClass.fitsInLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInLongNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x40000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInLong(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000000L) != 0L) {
                    return JSClass.fitsInFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInFloatNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x80000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInFloat(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000000L) != 0L) {
                    return JSClass.fitsInDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInDoubleNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x100000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInDouble(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000000L) != 0L) {
                    return JSClass.asByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte asByteNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x200000000L;
                    lock.unlock();
                    hasLock = false;
                    byte by = JSClass.asByte(arg0Value, this.numberLib);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000000L) != 0L) {
                    return JSClass.asShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short asShortNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x400000000L;
                    lock.unlock();
                    hasLock = false;
                    short s = JSClass.asShort(arg0Value, this.numberLib);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000000L) != 0L) {
                    return JSClass.asInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int asIntNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x800000000L;
                    lock.unlock();
                    hasLock = false;
                    int n = JSClass.asInt(arg0Value, this.numberLib);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000000L) != 0L) {
                    return JSClass.asLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long asLongNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x1000000000L;
                    lock.unlock();
                    hasLock = false;
                    long l = JSClass.asLong(arg0Value, this.numberLib);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000000L) != 0L) {
                    return JSClass.asFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float asFloatNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x2000000000L;
                    lock.unlock();
                    hasLock = false;
                    float f = JSClass.asFloat(arg0Value, this.numberLib);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000000L) != 0L) {
                    return JSClass.asDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double asDoubleNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x4000000000L;
                    lock.unlock();
                    hasLock = false;
                    double d = JSClass.asDouble(arg0Value, this.numberLib);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asInstant((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000000L) != 0L) {
                    return JSClass.asDate(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDateNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalDate asDateNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state |= 0x8000000000L;
                    lock.unlock();
                    hasLock = false;
                    LocalDate localDate = JSClass.asDate(arg0Value, (TruffleLanguage.ContextReference<JSRealm>)javaScriptLanguageContextReference__);
                    return localDate;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000000L) != 0L) {
                    return JSClass.asTime(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalTime asTimeNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state |= 0x10000000000L;
                    lock.unlock();
                    hasLock = false;
                    LocalTime localTime = JSClass.asTime(arg0Value, (TruffleLanguage.ContextReference<JSRealm>)javaScriptLanguageContextReference__);
                    return localTime;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000000L) != 0L) {
                    return JSClass.asTimeZone(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeZoneNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ZoneId asTimeZoneNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state |= 0x20000000000L;
                    lock.unlock();
                    hasLock = false;
                    ZoneId zoneId = JSClass.asTimeZone(arg0Value, (TruffleLanguage.ContextReference<JSRealm>)javaScriptLanguageContextReference__);
                    return zoneId;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasLanguage((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getLanguage((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.toDisplayString((DynamicObject)this.dynamicDispatch_.cast(receiver), allowSideEffects);
            }

            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasSourceLocation((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getSourceLocation((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObjectName((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObjectName((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isMetaInstance((DynamicObject)this.dynamicDispatch_.cast(receiver), instance);
            }

            private static boolean getArraySizeFallbackGuard_(long state, DynamicObject arg0Value) {
                if ((state & 0x40L) == 0L && JSGuards.isJSArray(arg0Value)) {
                    return false;
                }
                if ((state & 0x80L) == 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                    return false;
                }
                return (state & 0x100L) != 0L || !JSGuards.isJSArgumentsObject(arg0Value);
            }

            @GeneratedBy(value=JSClass.class)
            private static final class GetMembersNonArrayCachedData {
                @CompilerDirectives.CompilationFinal
                GetMembersNonArrayCachedData next_;
                @CompilerDirectives.CompilationFinal
                JSClass cachedJSClass_;

                GetMembersNonArrayCachedData(GetMembersNonArrayCachedData next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

