/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ArrayBufferViewGetByteLengthNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;

public abstract class ArrayBufferViewGetByteLengthNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayBufferViewGetByteLengthNode(JSContext context) {
        this.context = context;
    }

    public abstract int executeInt(DynamicObject var1);

    public static ArrayBufferViewGetByteLengthNode create(JSContext context) {
        return ArrayBufferViewGetByteLengthNodeGen.create(context);
    }

    @Specialization(guards={"isJSArrayBufferView(obj)", "hasDetachedBuffer(obj)"})
    protected int getByteLengthDetached(DynamicObject obj) {
        return 0;
    }

    @Specialization(guards={"isJSArrayBufferView(obj)", "!hasDetachedBuffer(obj)", "cachedArray == getArrayType(obj)"})
    protected int getByteLength(DynamicObject obj, @Cached(value="getArrayType(obj)") TypedArray cachedArray) {
        boolean condition = JSArrayBufferView.isJSArrayBufferView(obj);
        return cachedArray.lengthInt(obj, condition) * cachedArray.bytesPerElement();
    }

    @Specialization(guards={"isJSArrayBufferView(obj)", "!hasDetachedBuffer(obj)"}, replaces={"getByteLength"})
    protected int getByteLengthOverLimit(DynamicObject obj) {
        boolean condition = JSArrayBufferView.isJSArrayBufferView(obj);
        TypedArray typedArray = ArrayBufferViewGetByteLengthNode.getArrayType(obj);
        return typedArray.lengthInt(obj, condition) * typedArray.bytesPerElement();
    }

    @Specialization(guards={"!isJSArrayBufferView(obj)"})
    protected int getByteLengthNoObj(DynamicObject obj) {
        throw Errors.createTypeErrorArrayBufferViewExpected();
    }

    protected static TypedArray getArrayType(DynamicObject obj) {
        return JSArrayBufferView.typedArrayGetArrayType(obj);
    }

    protected boolean hasDetachedBuffer(DynamicObject object) {
        return JSArrayBufferView.hasDetachedBuffer(object, this.context);
    }
}

