/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;

@GenerateUncached
public abstract class JSInteropExecuteNode
extends JSInteropCallNode {
    protected JSInteropExecuteNode() {
    }

    public abstract Object execute(DynamicObject var1, Object var2, Object[] var3) throws UnsupportedMessageException;

    @Specialization
    Object doDefault(DynamicObject function, Object thisArg, Object[] arguments, @Cached IsCallableNode isCallableNode, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached JSForeignToJSTypeNode importValueNode) throws UnsupportedMessageException {
        if (!isCallableNode.executeBoolean(function)) {
            throw UnsupportedMessageException.create();
        }
        Object[] preparedArgs = JSInteropExecuteNode.prepare(arguments, importValueNode);
        if (callNode == null) {
            return JSRuntime.call(function, thisArg, preparedArgs);
        }
        return callNode.executeCall(JSArguments.create(thisArg, function, preparedArgs));
    }
}

