/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;

@ImportStatic(value={JSObject.class})
public abstract class IsJSObjectNode
extends JavaScriptBaseNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_JSCLASS_COUNT = 1;
    private final boolean includeNullUndefined;

    protected IsJSObjectNode(boolean includeNullUndefined) {
        this.includeNullUndefined = includeNullUndefined;
    }

    public abstract boolean executeBoolean(Object var1);

    @Specialization(guards={"cachedShape.check(object)"}, limit="MAX_SHAPE_COUNT")
    protected static boolean isObjectShape(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="guardIsJSObject(object)") boolean cachedResult) {
        return cachedResult;
    }

    @Specialization(guards={"cachedClass != null", "cachedClass.isInstance(object)"}, replaces={"isObjectShape"}, limit="MAX_JSCLASS_COUNT")
    protected static boolean isObjectJSClass(DynamicObject object, @Cached(value="getJSClassChecked(object)") JSClass cachedClass, @Cached(value="guardIsJSObject(object)") boolean cachedResult) {
        return cachedResult;
    }

    @Specialization(replaces={"isObjectShape", "isObjectJSClass"})
    protected static boolean isObject(Object object, @Cached(value="createBinaryProfile()") ConditionProfile resultProfile) {
        return resultProfile.profile(JSRuntime.isObject(object));
    }

    public static IsJSObjectNode create() {
        return IsJSObjectNodeGen.create(false);
    }

    public static IsJSObjectNode createIncludeNullUndefined() {
        return IsJSObjectNodeGen.create(true);
    }

    protected boolean guardIsJSObject(DynamicObject obj) {
        if (this.includeNullUndefined) {
            return JSObject.isJSObject(obj);
        }
        return JSGuards.isJSObject(obj);
    }
}

