/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import java.util.Arrays;

public final class TRegexDFAExecutorNode
extends TRegexExecutorNode {
    public static final int NO_MATCH = -2;
    private final TRegexDFAExecutorProperties props;
    private final int maxNumberOfNFAStates;
    @Node.Children
    private final DFAAbstractStateNode[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DFACaptureGroupLazyTransition[] cgTransitions;
    private final TRegexDFAExecutorDebugRecorder debugRecorder;

    public TRegexDFAExecutorNode(TRegexDFAExecutorProperties props, int maxNumberOfNFAStates, DFAAbstractStateNode[] states, DFACaptureGroupLazyTransition[] cgTransitions, TRegexDFAExecutorDebugRecorder debugRecorder) {
        this.props = props;
        this.maxNumberOfNFAStates = maxNumberOfNFAStates;
        this.states = states;
        this.cgTransitions = cgTransitions;
        this.debugRecorder = debugRecorder;
    }

    public TRegexDFAExecutorNode(TRegexDFAExecutorProperties props, int maxNumberOfNFAStates, DFAAbstractStateNode[] states, DFACaptureGroupLazyTransition[] cgTransitions) {
        this(props, maxNumberOfNFAStates, states, cgTransitions, null);
    }

    private DFAInitialStateNode getInitialState() {
        return (DFAInitialStateNode)this.states[0];
    }

    public int getPrefixLength() {
        return this.getInitialState().getPrefixLength();
    }

    public boolean isAnchored() {
        return !this.getInitialState().hasUnAnchoredEntry();
    }

    public boolean isForward() {
        return this.props.isForward();
    }

    public boolean isBackward() {
        return !this.props.isForward();
    }

    public boolean isSearching() {
        return this.props.isSearching();
    }

    public boolean isSimpleCG() {
        return this.props.isSimpleCG();
    }

    public boolean isGenericCG() {
        return this.props.isGenericCG();
    }

    public boolean isRegressionTestMode() {
        return this.props.isRegressionTestMode();
    }

    public DFACaptureGroupLazyTransition[] getCGTransitions() {
        return this.cgTransitions;
    }

    public int getNumberOfStates() {
        return this.states.length;
    }

    public boolean recordExecution() {
        return this.debugRecorder != null;
    }

    public TRegexDFAExecutorDebugRecorder getDebugRecorder() {
        return this.debugRecorder;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexDFAExecutorLocals(input, fromIndex, index, maxIndex, this.createCGData());
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isSimpleCG();
    }

    private DFACaptureGroupTrackingData createCGData() {
        if (this.isGenericCG() || this.isSimpleCG()) {
            return new DFACaptureGroupTrackingData(this.getMaxNumberOfNFAStates(), this.getNumberOfCaptureGroups(), this.props);
        }
        return null;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexDFAExecutorLocals locals;
        block17: {
            short[] successors;
            locals = (TRegexDFAExecutorLocals)abstractLocals;
            CompilerDirectives.ensureVirtualized((Object)locals);
            CompilerAsserts.compilationConstant((Object)this.states);
            CompilerAsserts.compilationConstant((Object)this.states.length);
            if (!this.validArgs(locals)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("Got illegal args! (fromIndex %d, initialIndex %d, maxIndex %d)", locals.getFromIndex(), locals.getIndex(), locals.getMaxIndex()));
            }
            if (this.isGenericCG()) {
                this.initResultOrder(locals);
                locals.setLastTransition((short)-1);
            } else if (this.isSimpleCG()) {
                CompilerDirectives.ensureVirtualized((Object)locals.getCGData());
                Arrays.fill(locals.getCGData().results, -1);
            }
            if (this.props.getMinResultLength() > 0 && (this.isForward() ? locals.getMaxIndex() - locals.getIndex() : locals.getIndex() - locals.getMaxIndex()) < this.props.getMinResultLength()) {
                return this.isGenericCG() || this.isSimpleCG() ? null : Integer.valueOf(-2);
            }
            if (this.recordExecution()) {
                this.debugRecorder.startRecording(locals);
            }
            if (this.isBackward() && locals.getFromIndex() - 1 > locals.getMaxIndex()) {
                locals.setCurMaxIndex(locals.getFromIndex() - 1);
            } else {
                locals.setCurMaxIndex(locals.getMaxIndex());
            }
            int ip = 0;
            block0: while (true) {
                if (CompilerDirectives.inInterpreter()) {
                    RegexRootNode.checkThreadInterrupted();
                }
                CompilerAsserts.partialEvaluationConstant((int)ip);
                if (ip == -1) break block17;
                DFAAbstractStateNode curState = this.states[ip];
                CompilerAsserts.partialEvaluationConstant((Object)curState);
                successors = curState.getSuccessors();
                CompilerAsserts.partialEvaluationConstant((Object)successors);
                CompilerAsserts.partialEvaluationConstant((int)successors.length);
                int prevIndex = locals.getIndex();
                curState.executeFindSuccessor(locals, this, compactString);
                if (this.recordExecution() && ip != 0) {
                    this.debugRecordTransition(locals, (DFAStateNode)curState, prevIndex);
                }
                for (int i = 0; i < successors.length; ++i) {
                    if (i != locals.getSuccessorIndex()) continue;
                    if (successors[i] != -1 && this.states[successors[i]] instanceof DFAStateNode) {
                        ((DFAStateNode)this.states[successors[i]]).getStateReachedProfile().enter();
                    }
                    ip = successors[i];
                    continue block0;
                }
                break;
            }
            assert (locals.getSuccessorIndex() == -1) : "successorIndex: " + locals.getSuccessorIndex() + ", successors: " + Arrays.toString(successors);
        }
        if (this.recordExecution()) {
            this.debugRecorder.finishRecording();
        }
        if (this.isSimpleCG()) {
            int[] result = this.props.isSimpleCGMustCopy() ? locals.getCGData().currentResult : locals.getCGData().results;
            return (int[])(locals.getResultInt() == 0 ? result : null);
        }
        if (this.isGenericCG()) {
            return locals.getResultInt() == 0 ? locals.getCGData().currentResult : null;
        }
        return locals.getResultInt();
    }

    private void debugRecordTransition(TRegexDFAExecutorLocals locals, DFAStateNode curState, int prevIndex) {
        boolean hasSuccessor;
        short ip = curState.getId();
        boolean bl = hasSuccessor = locals.getSuccessorIndex() != -1;
        if (this.isForward()) {
            for (int i = prevIndex; i < locals.getIndex() - (hasSuccessor ? 1 : 0); ++i) {
                if (!curState.hasLoopToSelf()) continue;
                this.debugRecorder.recordTransition(i, ip, curState.getLoopToSelf());
            }
        } else {
            for (int i = prevIndex; i > locals.getIndex() + (hasSuccessor ? 1 : 0); --i) {
                if (!curState.hasLoopToSelf()) continue;
                this.debugRecorder.recordTransition(i, ip, curState.getLoopToSelf());
            }
        }
        if (hasSuccessor) {
            this.debugRecorder.recordTransition(locals.getIndex() + (this.isForward() ? -1 : 1), ip, locals.getSuccessorIndex());
        }
    }

    public void advance(TRegexDFAExecutorLocals locals) {
        locals.setIndex(this.props.isForward() ? locals.getIndex() + 1 : locals.getIndex() - 1);
    }

    public boolean hasNext(TRegexDFAExecutorLocals locals) {
        return this.props.isForward() ? Integer.compareUnsigned(locals.getIndex(), locals.getCurMaxIndex()) < 0 : locals.getIndex() > locals.getCurMaxIndex();
    }

    public boolean atBegin(TRegexDFAExecutorLocals locals) {
        return locals.getIndex() == (this.props.isForward() ? 0 : this.getInputLength(locals) - 1);
    }

    public boolean atEnd(TRegexDFAExecutorLocals locals) {
        int i = locals.getIndex();
        if (this.props.isForward()) {
            return i == this.getInputLength(locals);
        }
        return i < 0;
    }

    public int rewindUpTo(TRegexDFAExecutorLocals locals, int length) {
        if (this.props.isForward()) {
            int offset = Math.min(locals.getIndex(), length);
            locals.setIndex(locals.getIndex() - offset);
            return offset;
        }
        assert (length == 0);
        return 0;
    }

    private boolean validArgs(TRegexDFAExecutorLocals locals) {
        int initialIndex = locals.getIndex();
        int inputLength = this.getInputLength(locals);
        int fromIndex = locals.getFromIndex();
        int maxIndex = locals.getMaxIndex();
        if (this.props.isForward()) {
            return inputLength >= 0 && inputLength < 2147483627 && fromIndex >= 0 && fromIndex <= inputLength && initialIndex >= 0 && initialIndex <= inputLength && maxIndex >= 0 && maxIndex <= inputLength && initialIndex <= maxIndex;
        }
        return inputLength >= 0 && inputLength < 2147483627 && fromIndex >= 0 && fromIndex <= inputLength && initialIndex >= -1 && initialIndex < inputLength && maxIndex >= -1 && maxIndex < inputLength && initialIndex >= maxIndex;
    }

    @ExplodeLoop
    private void initResultOrder(TRegexDFAExecutorLocals locals) {
        DFACaptureGroupTrackingData cgData = locals.getCGData();
        for (int i = 0; i < this.maxNumberOfNFAStates; ++i) {
            cgData.currentResultOrder[i] = i * this.getNumberOfCaptureGroups() * 2;
        }
    }

    public TRegexDFAExecutorProperties getProperties() {
        return this.props;
    }

    public int getMaxNumberOfNFAStates() {
        return this.maxNumberOfNFAStates;
    }

    public double getCGReorderRatio() {
        if (!this.isGenericCG()) {
            return 0.0;
        }
        int nPT = 0;
        int nReorder = 0;
        for (DFACaptureGroupLazyTransition t : this.cgTransitions) {
            nPT += t.getPartialTransitions().length;
            for (DFACaptureGroupPartialTransition pt : t.getPartialTransitions()) {
                if (!pt.doesReorderResults()) continue;
                ++nReorder;
            }
        }
        if (nPT > 0) {
            return (double)nReorder / (double)nPT;
        }
        return 0.0;
    }

    public double getCGArrayCopyRatio() {
        if (!this.isGenericCG()) {
            return 0.0;
        }
        int nPT = 0;
        int nArrayCopy = 0;
        for (DFACaptureGroupLazyTransition t : this.cgTransitions) {
            nPT += t.getPartialTransitions().length;
            for (DFACaptureGroupPartialTransition pt : t.getPartialTransitions()) {
                nArrayCopy += pt.getArrayCopies().length / 2;
            }
        }
        if (nPT > 0) {
            return (double)nArrayCopy / (double)nPT;
        }
        return 0.0;
    }
}

