/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Set;

public abstract class JSToObjectNode
extends JavaScriptBaseNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_CLASSES = 3;
    private final JSContext context;
    private final boolean checkForNullOrUndefined;
    private final boolean fromWith;
    private final boolean allowForeign;

    protected JSToObjectNode(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        this.context = context;
        this.checkForNullOrUndefined = checkForNullOrUndefined;
        this.fromWith = fromWith;
        this.allowForeign = allowForeign;
    }

    public abstract Object execute(Object var1);

    public static JSToObjectNode createToObject(JSContext context) {
        return JSToObjectNode.createToObject(context, true, false, true);
    }

    public static JSToObjectNode createToObjectNoCheck(JSContext context) {
        return JSToObjectNode.createToObject(context, false, false, true);
    }

    public static JSToObjectNode createToObjectNoCheckNoForeign(JSContext context) {
        return JSToObjectNode.createToObject(context, false, false, false);
    }

    private static JSToObjectNode createToObject(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        return JSToObjectNodeGen.create(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    protected final JSContext getContext() {
        return this.context;
    }

    protected final boolean isCheckForNullOrUndefined() {
        return this.checkForNullOrUndefined;
    }

    protected final boolean isFromWith() {
        return this.fromWith;
    }

    protected final boolean isAllowForeign() {
        return this.allowForeign;
    }

    @CompilerDirectives.TruffleBoundary
    private JSException createTypeError(DynamicObject value) {
        if (this.isFromWith()) {
            return Errors.createTypeError("Cannot apply \"with\" to " + JSRuntime.safeToString(value), this);
        }
        return Errors.createTypeErrorNotObjectCoercible(value, this, this.context);
    }

    @Specialization
    protected DynamicObject doBoolean(boolean value) {
        return JSBoolean.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doJSLazyString(JSLazyString value) {
        return JSString.create(this.getContext(), value);
    }

    @Specialization
    protected DynamicObject doString(String value) {
        return JSString.create(this.getContext(), value);
    }

    @Specialization
    protected DynamicObject doInt(int value) {
        return JSNumber.create(this.getContext(), value);
    }

    @Specialization
    protected DynamicObject doDouble(double value) {
        return JSNumber.create(this.getContext(), value);
    }

    @Specialization
    protected DynamicObject doBigInt(BigInt value) {
        return JSBigInt.create(this.getContext(), value);
    }

    @Specialization(guards={"isJavaNumber(value)"})
    protected DynamicObject doNumber(Object value) {
        return JSNumber.create(this.getContext(), (Number)value);
    }

    @Specialization
    protected DynamicObject doSymbol(Symbol value) {
        return JSSymbol.create(this.getContext(), value);
    }

    @Specialization(guards={"shape.check(object)", "isJSObjectShape(shape)", "!isCheckForNullOrUndefined()"}, limit="MAX_SHAPE_COUNT")
    protected DynamicObject doJSObjectNoCheckShape(DynamicObject object, @Cached(value="object.getShape()") Shape shape) {
        return object;
    }

    @Specialization(guards={"isJSType(object)", "!isCheckForNullOrUndefined()"}, replaces={"doJSObjectNoCheckShape"})
    protected DynamicObject doJSObjectNoCheck(DynamicObject object) {
        return object;
    }

    @Specialization(guards={"shape.check(object)", "isJSObjectShape(shape)", "isNotNullOrUndefined(shape)", "isCheckForNullOrUndefined()"}, limit="MAX_SHAPE_COUNT")
    protected DynamicObject doJSObjectCheckShape(DynamicObject object, @Cached(value="object.getShape()") Shape shape) {
        return object;
    }

    protected static boolean isNotNullOrUndefined(Shape shape) {
        return shape.getObjectType() != Null.NULL_CLASS;
    }

    @Specialization(guards={"isCheckForNullOrUndefined()", "cachedClass != null", "cachedClass.isInstance(object)"}, replaces={"doJSObjectCheckShape"}, limit="1")
    protected DynamicObject doJSObjectCheckJSClass(DynamicObject object, @Cached(value="getJSClassIfObject(object)") JSClass cachedClass) {
        assert (JSGuards.isJSObject(object));
        return object;
    }

    @Specialization(guards={"isJSObject(object)", "isCheckForNullOrUndefined()"}, replaces={"doJSObjectCheckJSClass"})
    protected DynamicObject doJSObjectCheck(DynamicObject object) {
        return object;
    }

    @Specialization(guards={"isNullOrUndefined(object)", "isCheckForNullOrUndefined()"})
    protected DynamicObject doNullOrUndefined(DynamicObject object) {
        throw this.createTypeError(object);
    }

    @Specialization(guards={"isForeignObject(obj)"})
    protected Object doForeignTruffleObject(Object obj) {
        if (this.isAllowForeign()) {
            if (this.isFromWith() && this.context.isOptionNashornCompatibilityMode() && this.context.getRealm().getEnv().isHostObject(obj)) {
                this.throwWithError();
            }
            return obj;
        }
        throw Errors.createTypeError("Foreign TruffleObject not supported", this);
    }

    @Specialization(guards={"!isBoolean(object)", "!isNumber(object)", "!isString(object)", "!isSymbol(object)", "!isJSObject(object)", "!isForeignObject(object)"})
    protected Object doJavaGeneric(Object object) {
        assert (!JSRuntime.isJSNative(object));
        if (this.isFromWith()) {
            this.throwWithError();
        }
        return this.context.getRealm().getEnv().asBoxedGuestValue(object);
    }

    @CompilerDirectives.TruffleBoundary
    private void throwWithError() {
        String message = "Cannot apply \"with\" to non script object";
        if (this.getContext().isOptionNashornCompatibilityMode()) {
            message = message + ". Consider using \"with(Object.bindProperties({}, nonScriptObject))\".";
        }
        throw Errors.createTypeError(message, this);
    }

    public static abstract class JSToObjectWrapperNode
    extends JSUnaryNode {
        @Node.Child
        private JSToObjectNode toObjectNode;

        protected JSToObjectWrapperNode(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            super(operand);
            this.toObjectNode = toObjectNode;
        }

        public abstract DynamicObject executeDynamicObject(Object var1);

        public static JSToObjectWrapperNode createToObject(JSContext context, JavaScriptNode child) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(child, JSToObjectNode.createToObject(context));
        }

        public static JSToObjectWrapperNode createToObjectFromWith(JSContext context, JavaScriptNode child, boolean checkForNullOrUndefined) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(child, JSToObjectNodeGen.create(context, checkForNullOrUndefined, true, true));
        }

        @Specialization
        protected Object doDefault(Object value) {
            return this.toObjectNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            JSToObjectNode clonedToObject = JSToObjectNodeGen.create(this.toObjectNode.getContext(), this.toObjectNode.isCheckForNullOrUndefined(), this.toObjectNode.isFromWith(), this.toObjectNode.isAllowForeign());
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(JSToObjectWrapperNode.cloneUninitialized(this.getOperand(), materializedTags), clonedToObject);
        }
    }
}

