# -*- encoding: utf-8 -*-
# $Id: prime.py,v 1.11 2005/12/04 03:37:08 jwp Exp $
##
# Copyright 2005, PostgresPy Project.
# http://python.projects.postgresql.org
##
# This pure python module is bound to the extension module that it imports.
# Without the extension module, this module is useless, and without this
# module, the extension module is incomplete.
##
'Postgres backend interface'
import sys, os
self = sys.modules[__name__]
mpath = self.__file__
pvpath = os.path.dirname(mpath)
ppath = os.path.dirname(pvpath)
sys.path = [pvpath, ppath] + sys.path
sys.modules['Postgres'] = self
del os, self, ppath, pvpath, mpath
__name__ = 'Postgres'

import postgresql.exception.maiden.prime as exceptions
from _prime import *

_query_cache = {}
def CachedQuery(qstring):
	if qstring in _query_cache:
		return _query_cache[qstring]
	else:
		q = _query_cache[qstring] = Query(qstring)
	return q

INV_READ =	0x00040000
INV_WRITE =	0x00020000
INV_RW = INV_READ | INV_WRITE

_closed_file_error = ValueError("I/O operation on closed LargeObject")
_invalidmode_error = lambda x: IOError("invalid mode '%s'" %(x,))

class LargeObject(object):
	_create = Function(957)
	_unlink = Function(964)
	_open = Function(952)
	_tell = Function(958)
	_seek = Function(956)
	_read = Function(954)
	_write = Function(955)
	_close = Function(953)
	try:
		from cStringIO import StringIO as _strio
	except ImportError:
		from StringIO import StringIO as _strio

	closed = True
	oid = 0
	lod = 0
	mode = ""

	def fileno(self):
		return self.lod

	def __del__(self):
		if not self.closed:
			self.close()

	def __repr__(self):
		return "<%s large object '%d' mode '%s' at %s>" % (
			self.closed and 'closed' or 'open',
			int(self.oid), self.mode, hex(id(self)),
		)

	def __init__(self, oid = None, mode = 'r'):
		if oid is None:
			oid = LargeObject._create(INV_RW)
			mc = INV_RW
			mode = 'rw'
		else:
			mc = 0
			for m in mode:
				if m == 'r':
					mc |= INV_READ
				elif m == 'w':
					mc |= INV_WRITE
				else:
					raise _invalidmode_error(m)
			mode = ""
			if mc & INV_READ:
				mode += 'r'
			if mc & INV_WRITE:
				mode += 'rw'

		self.mode = mode
		self.oid = oid
		self.lod = LargeObject._open(oid, mc)
		self.closed = False

	def read(self, amt = None):
		if self.closed: raise _closed_file_error
		lod = self.lod
		if amt is None:
			string = LargeObject._strio()
			data = LargeObject._read(lod, 1024)
			while len(data) > 0:
				string.write(buffer(data)[:])
				data = LargeObject._read(lod, 1024)
			string.seek(0)
			return string.read()
		return buffer(LargeObject._read(lod, amt))[:]

	def readline(self):
		if self.closed: raise _closed_file_error
		lod = self.lod
		string = LargeObject._strio()
		char = buffer(LargeObject._read(lod, 1))[:]
		string.write(char)
		while char != '' and char != '\n':
			char = LargeObject._read(lod, 1)
			string.write(char)
		string.seek(0)
		return string.read()

	def write(self, data):
		if self.closed: raise _closed_file_error
		LargeObject._write(self.lod, data)

	def tell(self):
		if self.closed: raise _closed_file_error
		return int(LargeObject._tell(self.lod))

	def seek(self, offset, whence = 0):
		if self.closed: raise _closed_file_error
		LargeObject._seek(self.lod, offset, whence)

	def close(self):
		if not self.closed:
			self.closed = True
			LargeObject._close(self.lod)

	def unlink(self):
		if not self.closed:
			self.close()
		LargeObject._unlink(self.oid)
