/* $Id: textual.c,v 1.7 2005/12/28 23:54:29 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interface to "textual" types [Character Sequences]
 */
#include <setjmp.h>
#include <postgres.h>
#include <fmgr.h>
#include <access/heapam.h>
#include <access/htup.h>
#include <access/tupdesc.h>
#include <catalog/pg_proc.h>
#include <catalog/pg_type.h>
#include <catalog/pg_namespace.h>
#include <catalog/pg_conversion.h>
#include <catalog/pg_operator.h>
#include <catalog/pg_opclass.h>
#include <catalog/namespace.h>
#include <nodes/params.h>
#include <parser/parse_func.h>
#include <tcop/dest.h>
#include <tcop/tcopprot.h>
#include <utils/array.h>
#include <utils/datum.h>
#include <utils/elog.h>
#include <utils/palloc.h>
#include <utils/builtins.h>
#include <utils/syscache.h>
#include <utils/typcache.h>
#include <utils/relcache.h>
#include <pypg/environment.h>
#include <pypg/postgres.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/externs.h>
#include <pypg/type.h>
#include <pypg/type/object.h>
#include <pypg/type/textual.h>
#include <pypg/error.h>

PyObj
text_add(PyObj self, PyObj with)
{
	return(PyPgObject_Operate("||", self, with));
}

static PyNumberMethods PyPgTextAsNumber = {
	text_add,		/* nb_add */
	NULL,
};

#ifdef PGTYPE_NAME
PyDoc_STRVAR(PyPg_name_Type_Doc,
	"A fixed size character sequence type"
);

PyPgTypeObject PyPg_name_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"name",										/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	NULL,											/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_name_Type_Doc,						/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* NAME */

#ifdef PGTYPE_TEXT
static int
text_length(PyObj self)
{
	Datum d;
	d = PyPgObject_FetchDatum(self);

	Assert(d != 0);

	PgError_TRAP(d = DirectFunctionCall1(textlen, d));

	if (PyErr_Occurred()) return(-1);
	return((int) d);
}

static PyObj
text_item(PyObj self, int item)
{
	Datum rd = 0, datum = PyPgObject_FetchDatum(self);
	PyObj rob = NULL;

	Assert(datum != 0);

	PgError_TRAP(rd = DirectFunctionCall3(text_substr, datum, item + 1, 1));
	if (PyErr_Occurred()) return(NULL);
	if (rd == 0)
	{
		PyErr_SetString(PyExc_SystemError, "unexpected zero Datum in text_item");
		return(NULL);
	}

	/*
	 * If the octet length is zero, it's an index error.
	 */
	if (VARSIZE(rd) - VARHDRSZ == 0)
	{
		PyErr_SetString(PyExc_IndexError, "text index out of range");
	}
	else
		rob = PyPgObject_New(self->ob_type, rd);

	pfree(DatumGetPointer(rd));

	return(rob);
}

static PyObj
text_slice(PyObj self, int from, int to)
{
	Datum rd = 0, datum = PyPgObject_FetchDatum(self);
	PyObj rob = NULL;

	Assert(datum != 0);

	if (to != 0x7FFFFFFF)
		PgError_TRAP(
			rd = DirectFunctionCall3(text_substr, datum, from + 1, to - from)
		);
	else
		PgError_TRAP(
			rd = DirectFunctionCall2(text_substr_no_len, datum, from + 1)
		);

	if (PyErr_Occurred()) return(NULL);
	if (rd == 0)
	{
		PyErr_SetString(PyExc_SystemError, "unexpected zero Datum in text_item");
		return(NULL);
	}

	rob = PyPgObject_New(self->ob_type, rd);
	pfree(DatumGetPointer(rd));

	return(rob);
}

static int
text_contains(PyObj self, PyObj item)
{
	return(0);
}

static PySequenceMethods text_as_sequence = {
	text_length,		/* sq_length */
	text_add,			/* sq_concat */
	NULL,					/* sq_repeat */
	text_item,			/* sq_item */
	text_slice,			/* sq_slice */
	NULL,					/* sq_ass_item */
	NULL,					/* sq_ass_slice */
	text_contains,		/* sq_contains */
	NULL,					/* sq_inplace_concat */
	NULL,					/* sq_inplace_repeat */
};

PyDoc_STRVAR(PyPg_text_Type_Doc,
	"A variable size character sequence type"
);

PyPgTypeObject PyPg_text_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"text",										/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	&text_as_sequence,						/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_text_Type_Doc,						/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* TEXT */

#ifdef PGTYPE_CHAR
PyDoc_STRVAR(PyPg_char_Type_Doc,
	"A single [small] character"
);

PyPgTypeObject PyPg_char_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"char",										/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	NULL,											/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_char_Type_Doc,						/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* CHAR */

#ifdef PGTYPE_BPCHAR
PyDoc_STRVAR(PyPg_bpchar_Type_Doc,
	"A single character"
);

PyPgTypeObject PyPg_bpchar_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"char",										/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	&text_as_sequence,						/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_bpchar_Type_Doc,					/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* BPCHAR */

#ifdef PGTYPE_VARCHAR
PyDoc_STRVAR(PyPg_varchar_Type_Doc, "varchar type interface");

PyPgTypeObject PyPg_varchar_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"varchar",									/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	&text_as_sequence,						/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_varchar_Type_Doc,					/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* VARCHAR */

#ifdef PGTYPE_UNKNOWN
PyDoc_STRVAR(PyPg_unknown_Type_Doc,
	"An \"unknown\" variable character sequence"
);

PyPgTypeObject PyPg_unknown_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"unknown",									/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	NULL,											/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_unknown_Type_Doc,					/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* UNKNOWN */

#ifdef PGTYPE_CSTRING
PyDoc_STRVAR(PyPg_cstring_Type_Doc,
	"A zero terminated variable character sequence"
);

PyPgTypeObject PyPg_cstring_Type = {{
	PyObject_HEAD_INIT(&PyPgType_Type)
	0,												/* ob_size */
	"cstring",									/* tp_name */
	sizeof(struct PyPgObject),				/* tp_basicsize */
	0,												/* tp_itemsize */
	NULL,											/* tp_dealloc */
	NULL,											/* tp_print */
	NULL,											/* tp_getattr */
	NULL,											/* tp_setattr */
	NULL,											/* tp_compare */
	NULL,											/* tp_repr */
	&PyPgTextAsNumber,						/* tp_as_number */
	NULL,											/* tp_as_sequence */
	NULL,											/* tp_as_mapping */
	NULL,											/* tp_hash */
	NULL,											/* tp_call */
	NULL,											/* tp_str */
	NULL,											/* tp_getattro */
	NULL,											/* tp_setattro */
	NULL,											/* tp_as_buffer */
	PyPg_TPFLAGS_DEFAULT,		   		/* tp_flags */
	PyPg_cstring_Type_Doc,					/* tp_doc */
	NULL,											/* tp_traverse */
	NULL,											/* tp_clear */
	NULL,											/* tp_richcompare */
	0,												/* tp_weaklistoffset */
	NULL,											/* tp_iter */
	NULL,											/* tp_iternext */
	NULL,											/* tp_methods */
	NULL,											/* tp_members */
	NULL,											/* tp_getset */
	(PyTypeObject *) &PyPgObject_Type,	/* tp_base */
	NULL,											/* tp_dict */
	NULL,											/* tp_descr_get */
	NULL,											/* tp_descr_set */
	0,												/* tp_dictoffset */
	NULL,											/* tp_init */
	NULL,											/* tp_alloc */
	PyPgArbitrary_new,						/* tp_new */
},
};
#endif /* CSTRING */

/*
 * vim: ts=3:sw=3:noet:
 */
