# -*- coding: utf-8 -*-
# $Id: ldistutils.py,v 1.9 2005/06/30 02:47:21 jwp Exp $
##
# Copyright 2005, PostgresPy Project.
# http://python.projects.postgresql.org
##
# imp/lib/pgpy_distutils.py,v 1.5 2004/11/18 04:19:33 flaw
# if/lib/pgpy_distutils.py,v 1.4 2004/09/05 08:08:31 flaw
##
# This ugly beast is a creation from not quite necessity. Rather, distutils'
# limitations hurt, so this Thing eases those pains.
##
import sys, os
from distutils import log
from distutils import cmd
from distutils.util import change_root
try:
	import cPickle as pick
except:
	import pickle as pick

from distutils.command.install import install
install.sub_commands.append(('install_so', None))

def process_ac_keywords(items, reader, writer):
	"""Process autoconf style keywords from the given reader and write the
	output to the given writer."""

	# The regex is only used to find the keywords.
	from re import compile
	rep = compile(r'@@([^@]+)@@')
	for line in reader.readlines():
		keys = []
		for key in rep.findall(line):
			if key not in keys:
				keys.append(key)
				line = line.replace('@@%s@@' % (key,), items[key])
		writer.write(line)

from distutils.command.config import config as baseConfig
class config(baseConfig):
	description = "configure build and installation against arguments"
	user_options = baseConfig.user_options + [
		('show', None, 'show configuration'),
		('keywords=', 'K', 'Overrides for keyword expanded files'),
		('debug', 'g', 'Turn on debugging information'),
		('include-dirs=', 'I', 'alternative include directories'),
		('library-dirs=', 'L', 'alternative library directories'),
	]

	boolean_options = ['debug']

	def __init__(self, dist):
		self.configuration = {'dirty':[],}
		self.distribution = dist
		self.path = os.path.join(dist.path, 'setup.cache')
		self.dco = dist.configure_options
		for opt in self.dco:
			self.user_options.append(self.dco[opt][1])
			default = self.dco[opt][0]
			if type(default) == type(True):
				self.boolean_options.append(self.dco[opt][1][0])
		return baseConfig.__init__(self, dist)

	def initialize_options(self):
		self.debug = False
		self.show = False
		for opt in self.dco:
			setattr(self, opt, self.dco[opt][0])
		self.define = []
		self.undef = []
		self.keywords = {}
		self.include_dirs = []
		self.library_dirs = []

	def finalize_options(self):
		if self.define != []:
			self.define = self.define.split(',')
		if self.undef != []:
			self.undef = self.undef.split(',')
		if self.keywords != {}:
			keywords = {}
			for wv in self.keywords.split(','):
				word, value = wv.split('=', 1)
				keywords[word] = value
			self.keywords = keywords
		if self.include_dirs != []:
			self.include_dirs = self.include_dirs.split(os.pathsep)
		if self.library_dirs != []:
			self.library_dirs = self.library_dirs.split(os.pathsep)

	# This must be done post config, but before the next command as other
	# commands may make use of it.
	def fix_ackes(self):
		'Render the AutoConf Keyword Expansion files.'
		from distutils.dep_util import newer
		ackes = self.distribution.ackes
		if not ackes: return []

		if callable(ackes):
			ackes = ackes(self)

		if len(ackes) > 0:
			log.info("expanding autoconf style keywords")
			for acke in ackes:
				if newer(acke[0], acke[1]):
					log.info("%s -> %s", acke[0], acke[1])
					process_ac_keywords(
						self.configuration,
						file(acke[0], 'r'),
						file(acke[1], 'w')
					)
		return [x[1] for x in ackes]

	def load(self):
		try:
			cfg = pick.load(file(self.path, 'r'))
			self.configuration = cfg
		except:
			cfgsrc = self.distribution.configure
			cfg = self.configuration
			if callable(cfgsrc):
				cfg['DEFINES'] = [
					tuple(x.split('=', 1)+[None])
					for x in self.define
				] + [
					(x, None) for x in self.undef
				]
				cfgsrc(self)
			else:
				self.configuration = cfg = cfgsrc
				if not cfg.has_key('dirty'):
					cfg['dirty'] = []

			if cfg.has_key('EXTENSIONS'):
				for x in cfg['EXTENSIONS']:
					x.define_macros += cfg['DEFINES']

			dirt = cfg['dirty']
			for newdirt in self.fix_ackes():
				if not newdirt in dirt:
					dirt.append(newdirt)

			if not cfg.has_key('INCLUDE_DIRS'):
				cfg['INCLUDE_DIRS'] = list()
			if not cfg.has_key('LIBRARY_DIRS'):
				cfg['LIBRARY_DIRS'] = list()
			cfg['INCLUDE_DIRS'] += self.include_dirs
			cfg['LIBRARY_DIRS'] += self.library_dirs
			pick.dump(cfg, file(self.path, 'w'))
		return cfg

	def show_config(self):
		if os.path.exists(self.path):
			from pprint import pprint
			self.load()
			pprint(self.configuration)
		else:
			print "[Not configured]"

	def run(self):
		if self.show:
			self.show_config()
			return
		dist = self.distribution
		self.distribution.config = cfg = self.load()

		if dist.data_files is None: dist.data_files = list()
		if dist.ext_modules is None: dist.ext_modules = list()
		if dist.shared_objects is None: dist.shared_objects = list()
		if cfg.has_key('DATA_FILES'):
			dist.data_files += cfg['DATA_FILES']
		if cfg.has_key('EXTENSIONS'):
			dist.ext_modules += cfg['EXTENSIONS']
		if cfg.has_key('LIBRARIES'):
			dist.shared_objects += cfg['LIBRARIES']
		if cfg.has_key('PACKAGE_DIR'):
			dist.package_dir = cfg['PACKAGE_DIR']
		if cfg.has_key('PACKAGES'):
			dist.packages = cfg['PACKAGES']

from distutils.command.build import build as baseBuild
class build(baseBuild):
	sub_commands = [
		('build_py',		lambda s: s.distribution.has_pure_modules()),
		('build_clib',		lambda s: s.distribution.has_c_libraries()),
		('build_so',		lambda s: len(s.distribution.shared_objects) > 0),
		('build_ext',		lambda s: s.distribution.has_ext_modules()),
		('build_scripts',	lambda s: s.distribution.has_scripts())
	]

	def run(self):
		self.run_command('config')
		return baseBuild.run(self)

from distutils.command.clean import clean as baseClean
class clean(baseClean):
	def run(self):
		from distutils.dir_util import remove_tree
		if self.all:
			sop = os.path.join(self.distribution.path, self.build_base, 'so')
			if os.path.exists(sop):
				remove_tree(sop)

		cf = os.path.join(self.distribution.path, 'setup.cache')
		if os.path.exists(cf):
			self.run_command('config')
			config = self.distribution.config
			for path in config['dirty']:
				log.info("removing '%s'", path)
				os.remove(path)
			log.info("removing '%s'", cf)
			os.remove(cf)

		baseClean.run(self)

def show_compilers():
	from distutils.ccompiler import show_compilers
	show_compilers()

class build_so(cmd.Command):
	description = "build C/C++ shared libraries"
	user_options = [
		('force', 'f',
		 'force build by disregarding file timestamps'),
		('compiler=', 'c',
		 'specify the compiler'),
	]

	boolean_options = ['debug', 'force']
	help_options = [
		('help-compiler', None,
		 'list available compilers', show_compilers)
	]

	def initialize_options(self):
		self.build_base = None
		self.build_so = None
		self.build_temp = None
		self.libraries = []
		self.include_dirs = []
		self.library_dirs = []
		self.define = []
		self.undef = []
		self.debug = None
		self.force = False
		self.compiler = None

	def finalize_options(self):
		self.set_undefined_options('build',
			('build_base', 'build_base'),
			('build_temp', 'build_temp'),
			('compiler', 'compiler'),
			('debug', 'debug'),
			('force', 'force')
		)
		if self.build_so == None:
			self.build_so = os.path.join(self.build_base, 'so')

		if self.include_dirs != []:
			self.include_dirs = self.include_dirs.split(os.pathsep)
		if self.library_dirs != []:
			self.library_dirs = self.library_dirs.split(os.pathsep)

		from distutils.ccompiler import new_compiler
		self.compiler = new_compiler(
			compiler = self.compiler,
			dry_run = self.dry_run,
			force = self.force
		)
		from distutils.sysconfig import customize_compiler
		customize_compiler(self.compiler)
		if len(self.include_dirs) > 0:
			self.compiler.set_include_dirs(self.include_dirs)

		self.libraries = [
			(x[0] + self.compiler.shared_lib_extension, x[1])
			for x in self.distribution.shared_objects
		]
		self.distribution.shared_objects = self.libraries
	#def finalize_options

	def get_library_names(self):
		return [libname for (libname, build_info) in self.libraries]

	def run(self):
		if hasattr(self.distribution, 'config'):
			cfg = self.distribution.config
			incdir = cfg['INCLUDE_DIRS']
			libdir = cfg['LIBRARY_DIRS']
		else:
			incdir = []
			libdir = []

		for (lib, src) in self.libraries:
			sources = src.get('sources')
			if not len(sources) > 0:
				log.info("no sources for '%s', skipping", lib)
				continue
			log.info("building '%s' library", lib)

			objects = self.compiler.compile(
				sources,
				output_dir = self.build_temp,
				include_dirs = (src.get('include_dirs') or []) + incdir,
				extra_postargs = src.get('extra_compile_args') or [],
				debug = self.debug,
				macros = src.get('macros'),
			)
			if sys.platform == 'darwin':
				preargs = []
			else:
				preargs = ['-nostartfiles']
			self.compiler.link_shared_object(
				objects + src.get('objects'), lib,
				output_dir = self.build_so,
				library_dirs = (src.get('library_dirs') or []) + libdir,
				libraries = src.get('libraries'),
				extra_preargs = preargs,
				build_temp = self.build_temp,
				debug = self.debug
			)
# build_so

class install_so(cmd.Command):
	description = "install shared objects"
	user_options = [
		('force', 'f', 'force installation by overwriting existing files'),
	]
	boolean_options = ['force']

	def initialize_options(self):
		self.root = None
		self.build_so = None
		self.force = False

	def finalize_options(self):
		self.set_undefined_options('build_so', ('build_so', 'build_so'))
		self.set_undefined_options('install',
			('force', 'force'),
			('root', 'root'),
		)
		if self.root != None:
			self.root = os.path.abspath(self.root)
	
	def mkpath(self, path):
		if self.root != None:
			path = change_root(self.root, path)
		return cmd.Command.mkpath(self, path)

	def copy_file(self, src, dst):
		if self.root != None:
			dst = change_root(self.root, dst)
		return cmd.Command.copy_file(self, src, dst)

	def run(self):
		for (libname, info) in self.distribution.shared_objects:
			self.mkpath(info['ddir'])
			self.copy_file(os.path.join(self.build_so, libname), info['ddir'])

	def get_inputs(self):
		return [os.path.join(self.build_so, x[0])
			for x in self.distribution.shared_objects
		]

	def get_outputs(self):
		return [x[1]['ddir'] for x in self.distribution.shared_objects]

from distutils.dist import Distribution as baseDist
class Distribution(baseDist):
	def __init__(self, attrs):
		self.path = os.path.abspath(os.path.dirname(sys.argv[0]))
		if attrs.has_key('ackes'):
			self.ackes = attrs['ackes']
			del attrs['ackes']
		else:
			self.ackes = None
		if attrs.has_key('configure'):
			self.configure = attrs['configure']
			del attrs['configure']
		if attrs.has_key('configure_options'):
			copts = self.configure_options = attrs['configure_options']
			del attrs['configure_options']
			for co in copts:
				config.user_options.append(copts[co][1])
		if attrs.has_key('shared_objects'):
			self.shared_objects = attrs['shared_objects']
		else:
			self.shared_objects = []
		baseDist.__init__(self, attrs)
		self.cmdclass['config'] = config
		self.cmdclass['clean'] = clean
		self.cmdclass['build'] = build
		self.cmdclass['build_so'] = build_so
		self.cmdclass['install_so'] = install_so
##
# vim: ts=3:sw=3:noet:
