/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;
import org.postgresql.pljava.sqlj.Loader;

public class Commands {
    private static final Logger s_logger = Logger.getLogger(Commands.class.getName());

    public static void addClassImages(int n, InputStream inputStream) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Object object2;
            int n2 = -1;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            Manifest manifest = jarInputStream.getManifest();
            if (manifest != null) {
                object2 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object2);
                object = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarManifest = ? WHERE jarId = ?");
                try {
                    object.setString(1, new String(((ByteArrayOutputStream)object2).toByteArray(), "UTF8"));
                    object.setInt(2, n);
                    if (object.executeUpdate() != 1) {
                        throw new SQLException("Jar repository update did not update 1 row");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("JVM does not support UTF8!!");
                }
                finally {
                    SQLUtils.close((Statement)object);
                }
            }
            while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                int n3;
                if (((ZipEntry)object2).isDirectory()) continue;
                object = ((ZipEntry)object2).getName();
                Attributes attributes = ((JarEntry)object2).getAttributes();
                boolean bl = false;
                if (attributes != null && (bl = "true".equalsIgnoreCase(attributes.getValue("SQLJDeploymentDescriptor"))) && n2 >= 0) {
                    throw new SQLException("Only one SQLJDeploymentDescriptor allowed");
                }
                byteArrayOutputStream.reset();
                while ((n3 = jarInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                jarInputStream.closeEntry();
                preparedStatement.setString(1, (String)object);
                preparedStatement.setInt(2, n);
                preparedStatement.setBytes(3, byteArrayOutputStream.toByteArray());
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar entry insert did not insert 1 row");
                }
                if (!bl) continue;
                preparedStatement2 = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId = ? AND entryName = ?");
                preparedStatement2.setInt(1, n);
                preparedStatement2.setString(2, (String)object);
                resultSet = preparedStatement2.executeQuery();
                if (!resultSet.next()) {
                    throw new SQLException("Failed to refecth row in sqlj.jar_entry");
                }
                n2 = resultSet.getInt(1);
            }
            if (n2 >= 0) {
                preparedStatement.close();
                preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET deploymentDesc = ? WHERE jarId = ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not insert 1 row");
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new SQLException("I/O exception reading jar file: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement2);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement2);
        SQLUtils.close(preparedStatement);
    }

    public static void addTypeMapping(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            ClassLoader classLoader = Loader.getCurrentLoader();
            Class<?> clazz = classLoader.loadClass(string2);
            if (!SQLData.class.isAssignableFrom(clazz)) {
                throw new SQLException("Class " + string2 + " does not implement java.sql.SQLData");
            }
            string = Commands.getFullSqlName(string);
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.typemap_entry(javaName, sqlName) VALUES(?,?)");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new SQLException("No such class: " + string2);
            }
            catch (Throwable throwable) {
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(preparedStatement);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTypeMapping(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            string = Commands.getFullSqlName(string);
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.typemap_entry WHERE sqlName = ?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(preparedStatement);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassPath(String string) throws SQLException {
        String string2;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            string = string == null || string.length() == 0 ? "public" : string.toLowerCase();
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT r.jarName FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer = null;
            while (resultSet.next()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(':');
                }
                stringBuffer.append(resultSet.getString(1));
            }
            string2 = stringBuffer == null ? null : stringBuffer.toString();
        }
        catch (Throwable throwable) {
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentSchema() throws SQLException {
        Statement statement = SQLUtils.getDefaultConnection().createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT current_schema()");
            if (!resultSet.next()) {
                throw new SQLException("Unable to obtain current schema");
            }
            String string = resultSet.getString(1);
            return string;
        }
        finally {
            SQLUtils.close(resultSet);
            SQLUtils.close(statement);
        }
    }

    public static void installJar(byte[] byArray, String string, boolean bl) throws SQLException {
        Commands.installJar("streamed byte image", string, bl, byArray);
    }

    public static void installJar(String string, String string2, boolean bl) throws SQLException {
        Commands.installJar(string, string2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJar(String string, boolean bl) throws SQLException {
        Commands.assertJarName(string);
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string, aclIdArray);
        if (n < 0) {
            throw new SQLException("No Jar named '" + string + "' is known to the system");
        }
        AclId aclId = AclId.getSessionUser();
        if (!aclId.isSuperuser() && !aclId.equals(aclIdArray[0])) {
            throw new SecurityException("Only super user or owner can remove a jar");
        }
        if (bl) {
            Commands.deployRemove(n, string);
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId = ?");
        try {
            preparedStatement.setInt(1, n);
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        Loader.clearSchemaLoaders();
    }

    public static void replaceJar(byte[] byArray, String string, boolean bl) throws SQLException {
        Commands.replaceJar("streamed byte image", string, bl, byArray);
    }

    public static void replaceJar(String string, String string2, boolean bl) throws SQLException {
        Commands.replaceJar(string, string2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassPath(String string, String string2) throws SQLException {
        int n;
        int n2;
        Object object;
        if (string == null || string.length() == 0) {
            string = "public";
        }
        if ("public".equals(string)) {
            if (!AclId.getSessionUser().isSuperuser()) {
                throw new SQLException("Permission denied. Only a super user can set the classpath of the public schema");
            }
        } else {
            object = Commands.getSchemaId(string = string.toLowerCase());
            if (object == null) {
                throw new SQLException("No such schema: " + string);
            }
            if (!AclId.getSessionUser().hasSchemaCreatePermission((Oid)object)) {
                throw new SQLException("Permission denied. User must have create permission on the target schema in order to set the classpath");
            }
        }
        ArrayList<Integer> arrayList = null;
        if (string2 != null && string2.length() > 0) {
            arrayList = new ArrayList<Integer>();
            object = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
            try {
                do {
                    String string3;
                    if ((n2 = string2.indexOf(58)) >= 0) {
                        string3 = string2.substring(0, n2);
                        string2 = string2.substring(n2 + 1);
                    } else {
                        string3 = string2;
                    }
                    n = Commands.getJarId((PreparedStatement)object, string3, null);
                    if (n < 0) {
                        throw new SQLException("No such jar: " + string3);
                    }
                    arrayList.add(new Integer(n));
                } while (n2 >= 0);
            }
            finally {
                SQLUtils.close((Statement)object);
            }
        }
        object = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName = ?");
        try {
            object.setString(1, string);
            object.executeUpdate();
        }
        finally {
            SQLUtils.close((Statement)object);
        }
        if (arrayList != null) {
            object = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
            try {
                n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    n = (Integer)arrayList.get(i);
                    object.setString(1, string);
                    object.setInt(2, i + 1);
                    object.setInt(3, n);
                    object.executeUpdate();
                }
            }
            finally {
                SQLUtils.close((Statement)object);
            }
        }
        Loader.clearSchemaLoaders();
    }

    private static boolean assertInPath(String string, String[] stringArray) throws SQLException {
        String string2 = Commands.getCurrentSchema();
        String string3 = Commands.getClassPath(string2);
        stringArray[0] = string2;
        stringArray[1] = string3;
        if (string3 == null) {
            Commands.setClassPath(string2, string);
            return true;
        }
        String[] stringArray2 = string3.split(":");
        int n = stringArray2.length;
        boolean bl = false;
        while (--n >= 0) {
            if (!stringArray2[n].equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return false;
        }
        Commands.setClassPath(string2, string + ':' + string3);
        return true;
    }

    private static void assertJarName(String string) throws SQLException {
        int n;
        if (string != null && (n = string.length()) > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            int n2;
            for (n2 = 1; n2 < n && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
            }
            if (n2 == n) {
                return;
            }
        }
        throw new SQLException("The jar name '" + string + "' is not a valid name");
    }

    private static void deployInstall(int n, String string) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(n);
        if (sQLDeploymentDescriptor == null) {
            return;
        }
        String[] stringArray = new String[2];
        boolean bl = Commands.assertInPath(string, stringArray);
        sQLDeploymentDescriptor.install(SQLUtils.getDefaultConnection());
        if (bl) {
            Commands.setClassPath(stringArray[0], stringArray[1]);
        }
    }

    private static void deployRemove(int n, String string) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(n);
        if (sQLDeploymentDescriptor == null) {
            return;
        }
        String[] stringArray = new String[2];
        boolean bl = Commands.assertInPath(string, stringArray);
        sQLDeploymentDescriptor.remove(SQLUtils.getDefaultConnection());
        if (bl) {
            Commands.setClassPath(stringArray[0], stringArray[1]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SQLDeploymentDescriptor getDeploymentDescriptor(int n) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor;
        byte[] byArray;
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block8: {
            block7: {
                resultSet = null;
                preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT e.entryImage FROM sqlj.jar_repository r INNER JOIN sqlj.jar_entry e   ON r.deploymentDesc = e.entryId WHERE r.jarId = ?");
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block7;
                SQLDeploymentDescriptor sQLDeploymentDescriptor2 = null;
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                return sQLDeploymentDescriptor2;
            }
            byArray = resultSet.getBytes(1);
            if (byArray.length != 0) break block8;
            SQLDeploymentDescriptor sQLDeploymentDescriptor3 = null;
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            return sQLDeploymentDescriptor3;
        }
        try {
            sQLDeploymentDescriptor = new SQLDeploymentDescriptor(new String(byArray, "UTF8"), "postgresql");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new SQLException("JVM does not support UTF8!!");
                catch (ParseException parseException) {
                    throw new SQLException(parseException.getMessage() + " at " + parseException.getErrorOffset());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return sQLDeploymentDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFullSqlName(String string) throws SQLException {
        String string2;
        Oid oid = Oid.forTypeName(string);
        s_logger.info("Type id = " + oid.toString());
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT n.nspname, t.typname FROM pg_type t, pg_namespace n WHERE t.oid = ? AND n.oid = t.typnamespace");
        try {
            preparedStatement.setObject(1, oid);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("Unable to obtain type info for " + oid);
            }
            string2 = resultSet.getString(1) + '.' + resultSet.getString(2);
        }
        catch (Throwable throwable) {
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(PreparedStatement preparedStatement, String string, AclId[] aclIdArray) throws SQLException {
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            if (!resultSet.next()) {
                int n = -1;
                return n;
            }
            int n = resultSet.getInt(1);
            if (aclIdArray != null) {
                String string2 = resultSet.getString(2);
                aclIdArray[0] = AclId.fromName(string2);
            }
            int n2 = n;
            return n2;
        }
        finally {
            SQLUtils.close(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(String string, AclId[] aclIdArray) throws SQLException {
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId, jarOwner FROM sqlj.jar_repository WHERE jarName = ?");
        try {
            int n = Commands.getJarId(preparedStatement, string, aclIdArray);
            return n;
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Oid getSchemaId(String string) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block3: {
            Oid oid;
            resultSet = null;
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT oid FROM pg_namespace WHERE nspname = ?");
            try {
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
                oid = null;
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            return oid;
        }
        Oid oid = (Oid)resultSet.getObject(1);
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installJar(String string, String string2, boolean bl, byte[] byArray) throws SQLException {
        Commands.assertJarName(string2);
        if (Commands.getJarId(string2, null) >= 0) {
            throw new SQLException("A jar named '" + string2 + "' already exists");
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin, jarOwner) VALUES(?, ?, ?)");
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, AclId.getSessionUser().getName());
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository insert did not insert 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string2, aclIdArray);
        if (n < 0) {
            throw new SQLException("Unable to obtain id of '" + string2 + "'");
        }
        if (byArray == null) {
            Backend.addClassImages(n, string);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Commands.addClassImages(n, byteArrayInputStream);
        }
        Loader.clearSchemaLoaders();
        if (bl) {
            Commands.deployInstall(n, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceJar(String string, String string2, boolean bl, byte[] byArray) throws SQLException {
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string2, aclIdArray);
        if (n < 0) {
            throw new SQLException("No Jar named '" + string2 + "' is known to the system");
        }
        AclId aclId = AclId.getSessionUser();
        if (!aclId.isSuperuser() && !aclId.equals(aclIdArray[0])) {
            throw new SecurityException("Only super user or owner can replace a jar");
        }
        if (bl) {
            Commands.deployRemove(n, string2);
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, jarOwner = ?, jarManifest = NULL, deploymentDesc = NULL WHERE jarId = ?");
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, aclId.getName());
            preparedStatement.setInt(3, n);
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId = ?");
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        if (byArray == null) {
            Backend.addClassImages(n, string);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Commands.addClassImages(n, byteArrayInputStream);
        }
        Loader.clearSchemaLoaders();
        if (bl) {
            Commands.deployInstall(n, string2);
        }
    }
}

