--
-- PostgreSQL database dump
--


DROP TRIGGER  trig_insert_requiered_courses ON contracts;
DROP FUNCTION contracts_in_progress();
DROP FUNCTION insert_requiered_courses();

DROP TABLE training_courses;
DROP TABLE contract_courses;
DROP TABLE professor;
DROP TABLE courses;
DROP TABLE contracts;
DROP TABLE companies;
DROP TABLE trainees;
DROP TABLE trainings;
DROP TABLE employees;

DROP PROCEDURAL LANGUAGE plpgsql;

SET client_encoding = 'UTF-8';
SET check_function_bodies = false;
SET client_min_messages = warning;


--
-- TOC entry 270 (class 2612 OID 28519)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: 
--

CREATE PROCEDURAL LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1205 (class 1259 OID 28523)
-- Dependencies: 5
-- Name: contracts; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE contracts (
    id_contract serial NOT NULL,
    id_training integer NOT NULL,
    id_company integer NOT NULL,
    id_trainee integer NOT NULL,
    startdate date NOT NULL,
    points integer NOT NULL
);

--
-- TOC entry 17 (class 1255 OID 28526)
-- Dependencies: 5 270 250
-- Name: contracts_in_progress(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION contracts_in_progress() RETURNS SETOF contracts
    AS $$
DECLARE
    res RECORD;
BEGIN
    FOR res IN SELECT c.* FROM contracts c
        INNER JOIN trainings t ON (c.id_training = t.id_training)
        WHERE c.startdate + t.duration > CURRENT_DATE
    LOOP
        RETURN NEXT res;
    END LOOP;
    
    RETURN;
END;
$$
    LANGUAGE plpgsql;

--
-- TOC entry 18 (class 1255 OID 28527)
-- Dependencies: 270 5
-- Name: insert_requiered_courses(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION insert_requiered_courses() RETURNS "trigger"
    AS $$
DECLARE
    res RECORD;
BEGIN
    FOR res IN SELECT id_course FROM training_courses
        WHERE id_training = NEW.id_training AND required = TRUE
    LOOP
        INSERT INTO contract_courses (id_contract, id_course)
            VALUES (NEW.id_contract, res.id_course);
    END LOOP; 
    
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;

--
-- TOC entry 1207 (class 1259 OID 28530)
-- Dependencies: 5
-- Name: companies; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE companies (
    id_company serial NOT NULL,
    company character varying(255) NOT NULL,
    firstname character varying(255) NOT NULL,
    lastname character varying(255) NOT NULL,
    address text NOT NULL,
    email character varying(255),
    telephone character varying(255)
);

--
-- TOC entry 1611 (class 0 OID 0)
-- Dependencies: 1206
-- Name: companies_id_company_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('companies', 'id_company'), 1, true);


--
-- TOC entry 1208 (class 1259 OID 28536)
-- Dependencies: 5
-- Name: contract_courses; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE contract_courses (
    id_contract integer NOT NULL,
    id_course integer NOT NULL,
    mark real
);

--
-- TOC entry 1612 (class 0 OID 0)
-- Dependencies: 1204
-- Name: contracts_id_contract_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('contracts', 'id_contract'), 1, true);


--
-- TOC entry 1210 (class 1259 OID 28540)
-- Dependencies: 5
-- Name: courses; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE courses (
    id_course serial NOT NULL,
    manager integer NOT NULL,
    name character varying(255) NOT NULL,
    credits integer NOT NULL,
    traineesmax integer NOT NULL,
    hours integer NOT NULL,
    cost numeric(13,2) NOT NULL
);

--
-- TOC entry 1613 (class 0 OID 0)
-- Dependencies: 1209
-- Name: courses_id_course_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('courses', 'id_course'), 1, true);


--
-- TOC entry 1212 (class 1259 OID 28545)
-- Dependencies: 5
-- Name: employees; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE employees (
    id_employee serial NOT NULL,
    firstname character varying(255) NOT NULL,
    lastname character varying(255) NOT NULL,
    birthdate date NOT NULL,
    address text NOT NULL,
    telephone character varying(255),
    email character varying(255),
    ssn character(13)
);

--
-- TOC entry 1614 (class 0 OID 0)
-- Dependencies: 1211
-- Name: employees_id_employee_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('employees', 'id_employee'), 1, true);


--
-- TOC entry 1215 (class 1259 OID 28559)
-- Dependencies: 5
-- Name: professor; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE professor (
    id_employee integer NOT NULL,
    id_course integer NOT NULL
);

--
-- TOC entry 1217 (class 1259 OID 28563)
-- Dependencies: 1548 5
-- Name: trainees; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE trainees (
    id_trainee serial NOT NULL,
    firstname character varying(255) NOT NULL,
    lastname character varying(255) NOT NULL,
    birthdate date NOT NULL,
    address text NOT NULL,
    telephone character varying(255),
    email character varying(255),
    skilllevel smallint NOT NULL,
    CONSTRAINT trainees_skilllevel_check CHECK (((skilllevel >= 0) AND (skilllevel <= 8)))
);

--
-- TOC entry 1616 (class 0 OID 0)
-- Dependencies: 1216
-- Name: trainees_id_trainee_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('trainees', 'id_trainee'), 1, true);


--
-- TOC entry 1218 (class 1259 OID 28570)
-- Dependencies: 5
-- Name: training_courses; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE training_courses (
    id_training integer NOT NULL,
    id_course integer NOT NULL,
    required boolean NOT NULL
);

--
-- TOC entry 1220 (class 1259 OID 28574)
-- Dependencies: 1550 5
-- Name: trainings; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE trainings (
    id_training serial NOT NULL,
    manager integer NOT NULL,
    name character varying(255) NOT NULL,
    "level" smallint NOT NULL,
    duration integer NOT NULL,
    price real NOT NULL,
    places integer NOT NULL,
    modules integer NOT NULL,
    CONSTRAINT trainings_level_check CHECK ((("level" >= 0) AND ("level" <= 8)))
);

--
-- TOC entry 1617 (class 0 OID 0)
-- Dependencies: 1219
-- Name: trainings_id_training_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('trainings', 'id_training'), 1, true);


--
-- TOC entry 1559 (class 2606 OID 28579)
-- Dependencies: 1207 1207
-- Name: pk_companies; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY companies
    ADD CONSTRAINT pk_companies PRIMARY KEY (id_company);


--
-- TOC entry 1563 (class 2606 OID 28581)
-- Dependencies: 1208 1208 1208
-- Name: pk_contract_courses; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY contract_courses
    ADD CONSTRAINT pk_contract_courses PRIMARY KEY (id_contract, id_course);


--
-- TOC entry 1555 (class 2606 OID 28583)
-- Dependencies: 1205 1205
-- Name: pk_contracts; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY contracts
    ADD CONSTRAINT pk_contracts PRIMARY KEY (id_contract);


--
-- TOC entry 1566 (class 2606 OID 28585)
-- Dependencies: 1210 1210
-- Name: pk_courses; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT pk_courses PRIMARY KEY (id_course);


--
-- TOC entry 1568 (class 2606 OID 28587)
-- Dependencies: 1212 1212
-- Name: pk_employees; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY employees
    ADD CONSTRAINT pk_employees PRIMARY KEY (id_employee);


--
-- TOC entry 1574 (class 2606 OID 28591)
-- Dependencies: 1215 1215 1215
-- Name: pk_professor; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY professor
    ADD CONSTRAINT pk_professor PRIMARY KEY (id_employee, id_course);


--
-- TOC entry 1576 (class 2606 OID 28593)
-- Dependencies: 1217 1217
-- Name: pk_trainees; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY trainees
    ADD CONSTRAINT pk_trainees PRIMARY KEY (id_trainee);


--
-- TOC entry 1580 (class 2606 OID 28595)
-- Dependencies: 1218 1218 1218
-- Name: pk_training_courses; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY training_courses
    ADD CONSTRAINT pk_training_courses PRIMARY KEY (id_training, id_course);


--
-- TOC entry 1583 (class 2606 OID 28597)
-- Dependencies: 1220 1220
-- Name: pk_trainings; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY trainings
    ADD CONSTRAINT pk_trainings PRIMARY KEY (id_training);


--
-- TOC entry 1557 (class 2606 OID 28599)
-- Dependencies: 1205 1205 1205 1205
-- Name: u_contracts; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY contracts
    ADD CONSTRAINT u_contracts UNIQUE (id_trainee, id_training, id_company);


--
-- TOC entry 1560 (class 1259 OID 28600)
-- Dependencies: 1208
-- Name: i_fk_contract_courses_contract; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_contract_courses_contract ON contract_courses USING btree (id_contract);


--
-- TOC entry 1561 (class 1259 OID 28601)
-- Dependencies: 1208
-- Name: i_fk_contract_courses_courses; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_contract_courses_courses ON contract_courses USING btree (id_course);


--
-- TOC entry 1551 (class 1259 OID 28602)
-- Dependencies: 1205
-- Name: i_fk_contracts_companies; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_contracts_companies ON contracts USING btree (id_company);


--
-- TOC entry 1552 (class 1259 OID 28603)
-- Dependencies: 1205
-- Name: i_fk_contracts_trainees; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_contracts_trainees ON contracts USING btree (id_trainee);


--
-- TOC entry 1553 (class 1259 OID 28604)
-- Dependencies: 1205
-- Name: i_fk_contracts_trainings; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_contracts_trainings ON contracts USING btree (id_training);


--
-- TOC entry 1564 (class 1259 OID 28605)
-- Dependencies: 1210
-- Name: i_fk_courses_employees; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_courses_employees ON courses USING btree (manager);


--
-- TOC entry 1571 (class 1259 OID 28606)
-- Dependencies: 1215
-- Name: i_fk_professor_courses; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_professor_courses ON professor USING btree (id_course);


--
-- TOC entry 1572 (class 1259 OID 28607)
-- Dependencies: 1215
-- Name: i_fk_professor_employees; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_professor_employees ON professor USING btree (id_employee);


--
-- TOC entry 1577 (class 1259 OID 28608)
-- Dependencies: 1218
-- Name: i_fk_training_courses_courses; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_training_courses_courses ON training_courses USING btree (id_course);


--
-- TOC entry 1578 (class 1259 OID 28609)
-- Dependencies: 1218
-- Name: i_fk_training_courses_training; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_training_courses_training ON training_courses USING btree (id_training);


--
-- TOC entry 1581 (class 1259 OID 28610)
-- Dependencies: 1220
-- Name: i_fk_trainings_employees; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX i_fk_trainings_employees ON trainings USING btree (manager);


--
-- TOC entry 1596 (class 2620 OID 28612)
-- Dependencies: 1205 18
-- Name: trig_insert_requiered_courses; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER trig_insert_requiered_courses
    AFTER INSERT ON contracts
    FOR EACH ROW
    EXECUTE PROCEDURE insert_requiered_courses();


--
-- TOC entry 1587 (class 2606 OID 28613)
-- Dependencies: 1554 1205 1208
-- Name: fk_contract_courses_contracts; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY contract_courses
    ADD CONSTRAINT fk_contract_courses_contracts FOREIGN KEY (id_contract) REFERENCES contracts(id_contract) ON DELETE CASCADE;


--
-- TOC entry 1588 (class 2606 OID 28618)
-- Dependencies: 1210 1208 1565
-- Name: fk_contract_courses_courses; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY contract_courses
    ADD CONSTRAINT fk_contract_courses_courses FOREIGN KEY (id_course) REFERENCES courses(id_course) ON DELETE CASCADE;


--
-- TOC entry 1584 (class 2606 OID 28623)
-- Dependencies: 1207 1558 1205
-- Name: fk_contracts_companies; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY contracts
    ADD CONSTRAINT fk_contracts_companies FOREIGN KEY (id_company) REFERENCES companies(id_company) ON DELETE CASCADE;


--
-- TOC entry 1585 (class 2606 OID 28628)
-- Dependencies: 1575 1205 1217
-- Name: fk_contracts_trainees; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY contracts
    ADD CONSTRAINT fk_contracts_trainees FOREIGN KEY (id_trainee) REFERENCES trainees(id_trainee) ON DELETE CASCADE;


--
-- TOC entry 1586 (class 2606 OID 28633)
-- Dependencies: 1205 1220 1582
-- Name: fk_contracts_trainings; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY contracts
    ADD CONSTRAINT fk_contracts_trainings FOREIGN KEY (id_training) REFERENCES trainings(id_training) ON DELETE CASCADE;


--
-- TOC entry 1589 (class 2606 OID 28638)
-- Dependencies: 1212 1210 1567
-- Name: fk_courses_employees; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT fk_courses_employees FOREIGN KEY (manager) REFERENCES employees(id_employee);


--
-- TOC entry 1591 (class 2606 OID 28648)
-- Dependencies: 1210 1215 1565
-- Name: fk_professor_courses; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY professor
    ADD CONSTRAINT fk_professor_courses FOREIGN KEY (id_course) REFERENCES courses(id_course) ON DELETE CASCADE;


--
-- TOC entry 1592 (class 2606 OID 28653)
-- Dependencies: 1215 1212 1567
-- Name: fk_professor_employees; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY professor
    ADD CONSTRAINT fk_professor_employees FOREIGN KEY (id_employee) REFERENCES employees(id_employee) ON DELETE CASCADE;


--
-- TOC entry 1593 (class 2606 OID 28658)
-- Dependencies: 1565 1218 1210
-- Name: fk_training_courses_courses; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY training_courses
    ADD CONSTRAINT fk_training_courses_courses FOREIGN KEY (id_course) REFERENCES courses(id_course) ON DELETE CASCADE;


--
-- TOC entry 1594 (class 2606 OID 28663)
-- Dependencies: 1218 1220 1582
-- Name: fk_training_courses_trainings; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY training_courses
    ADD CONSTRAINT fk_training_courses_trainings FOREIGN KEY (id_training) REFERENCES trainings(id_training) ON DELETE CASCADE;


--
-- TOC entry 1595 (class 2606 OID 28668)
-- Dependencies: 1212 1567 1220
-- Name: fk_trainings_employees; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY trainings
    ADD CONSTRAINT fk_trainings_employees FOREIGN KEY (manager) REFERENCES employees(id_employee);

--
-- PostgreSQL database dump complete
--

