<?xml version="1.0" encoding="utf-8" ?>
<!-- Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION -->

<xsl:stylesheet version="1.0" 
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:html="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:include href="common.xsl" />

  <!-- pretty pre node and text -->
  <xsl:template name="pre">
    <pre>
      <xsl:for-each select="text()">
        <xsl:variable name="n" select="normalize-space(.)"/>
        <xsl:if test="string-length($n) != 0">
          <xsl:value-of select="substring($n, 1, 1)"/>
          <xsl:value-of select="substring-after(., substring($n, 1, 1))"/>
        </xsl:if>
      </xsl:for-each>
    </pre>
  </xsl:template>

  <xsl:template match="html:table[not(./html:tbody) and not(./html:tr)]">
    <table>
      <xsl:apply-templates select="*"/>
      <thead><tr><th>テーブル</th></tr></thead>
      <tbody><tr><td><xsl:call-template name="pre"/></td></tr></tbody>
    </table>
  </xsl:template>

  <xsl:template match="html:tbody[not(./html:tr)]">
    <tbody>
      <tr><th>テーブル</th><td><xsl:call-template name="pre"/></td></tr>
    </tbody>
  </xsl:template>

  <xsl:template match="html:dl[not(html:dt|html:dd)]">
    <dl>
      <dt>定義リスト</dt>
      <dd><xsl:call-template name="pre"/></dd>
    </dl>
  </xsl:template>

  <xsl:template match="html:ul[not(html:li)]">
    <ul>
      <li><xsl:call-template name="pre"/></li>
    </ul>
  </xsl:template>

  <xsl:template match="html:ol[not(html:li)]">
    <ol>
      <li><xsl:call-template name="pre"/></li>
    </ol>
  </xsl:template>

  <xsl:template match="html:span[not(./*) and not(@class)]">
    <span>{<xsl:value-of select="text()"/>}</span>
  </xsl:template>

  <xsl:template match="html:pre[@class='postgres' or @class='mysql' or @class='oracle']">
    <pre class="{@class}"><xsl:call-template name="pre"/></pre>
  </xsl:template>

  <xsl:template match="html:canvas">
    <div class="graph" style="width:{@width}px">
      <table style="width:{@width}px; height:{@height}px">
        <thead><tr><th>グラフ: <xsl:value-of select="@type" /></th></tr></thead>
        <tbody><tr><td>属性<br/><ul><xsl:for-each select="@*"><li><xsl:value-of select="name()"/>:<xsl:value-of select="."/></li></xsl:for-each></ul></td></tr>
        <tr><td><xsl:call-template name="pre"/></td></tr></tbody>
      </table>
      <xsl:for-each select="html:caption">
        <div class="caption"><xsl:value-of select="."/></div>
      </xsl:for-each>
    </div>
  </xsl:template>

</xsl:stylesheet>
