<?xml version="1.0" encoding="utf-8" ?>
<!-- Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<xsl:include href="common.xsl"/>

<xsl:template match="/"> 
  <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <title>List of Repository Databases</title>
      <link rel="stylesheet" type="text/css" href="../css/style.css" />
    </head>
    <body>
      <h1>リポジトリ データベース選択</h1>
      <h2>リポジトリ データベース リスト</h2>
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>ホスト名</th>
            <th>接続ポート番号</th>
            <th>リポジトリDB名</th>
			<th>リポジトリDBクラスタ情報</th>
			<th>レポート作成</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="dbnames/*" />
        </tbody>
      </table>

      <p>※ リストにデータベースを追加したい場合は、'pg_reporter.conf' に追加してください。</p>
    </body>
  </html>
</xsl:template>

<xsl:template match="dbname">
  <tr>
    <td><xsl:value-of select="id" /></td>
    <td><xsl:value-of select="host" /></td>
    <td align="right"><xsl:value-of select="port" /></td>
    <td><xsl:value-of select="database" /></td>
	<td><xsl:element name="a">
      <xsl:attribute name="href">pg_reporter?id=<xsl:value-of select="id"/>&amp;template=schema&amp;database=<xsl:value-of select="database"/></xsl:attribute>DBクラスタ情報画面へ</xsl:element></td>
	<td><xsl:element name="a">
	  <xsl:attribute name="href">pg_reporter?id=<xsl:value-of select="id"/>&amp;template=statistics</xsl:attribute>監視対象DB選択画面へ</xsl:element></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
