//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsCopiedPtr.h,v 1.1 2008/06/27 18:19:17 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#ifndef PGSCOPIEDPTR_H_
#define PGSCOPIEDPTR_H_

#include <algorithm>

template <typename T> class pgsCopiedPtr
{

private:

	T * p;

public:

	pgsCopiedPtr(T * p) :
		p(p)
	{
		
	}

	pgsCopiedPtr() :
		p(0)
	{
		
	}

	pgsCopiedPtr(const pgsCopiedPtr & that) :
		p(that.p == 0 ? 0 : that.p->clone())
	{
		
	}

	~pgsCopiedPtr()
	{
		pdelete(p);
	}

	pgsCopiedPtr & operator =(pgsCopiedPtr that)
	{
		std::swap(p, that.p);
		return (*this);
	}

	T & operator *()
	{
		return *p;
	}

	const T & operator *() const
	{
		return *p;
	}

	T * operator ->()
	{
		return p;
	}

	const T * operator ->() const
	{
		return p;
	}

	const T * get() const
	{
		return p;
	}
};

#endif /*PGSCOPIEDPTR_H_*/
